/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect.pluginsinc.liveheader.validate;

import java.net.URLEncoder;
import org.appwork.utils.StringUtils;
import org.appwork.utils.encoding.URLEncode;

public class RetryWithReplacedScript
extends Exception {
    private String newScript;
    private String description;

    public String getNewScript() {
        return this.newScript;
    }

    public RetryWithReplacedScript(String description, String replace) {
        this.newScript = replace;
        this.description = description;
    }

    @Override
    public String toString() {
        return this.description;
    }

    public String getDescription() {
        return this.description;
    }

    public RetryWithReplacedScript(String script, String key, String value, String replace) throws Exception {
        this("replace(\"" + value.replace("\"", "\\\"") + "\",\"" + replace.replace("\"", "\\\"") + "\")", RetryWithReplacedScript.replace(script, key, value, replace));
    }

    public RetryWithReplacedScript(String script, String value, String replace) throws Exception {
        this("replace(\"" + value.replace("\"", "\\\"") + "\",\"" + replace.replace("\"", "\\\"") + "\")", RetryWithReplacedScript.replace(script, null, value, replace));
    }

    private static String replace(String script, String key, String value, String replace) throws Exception {
        String newS = script;
        String s = null;
        if (key != null) {
            newS = script.replace(key + "=" + value, key + "=" + replace);
            s = key + "=" + URLEncode.encodeRFC2396((String)value);
            newS = script.replace(s, key + "=" + replace);
            s = URLEncode.encodeRFC2396((String)key) + "=" + URLEncode.encodeRFC2396((String)value);
            newS = script.replace(s, URLEncode.encodeRFC2396((String)key) + "=" + replace);
            s = key + "=" + URLEncoder.encode(value, "ASCII");
            newS = script.replace(s, key + "=" + replace);
            s = URLEncoder.encode(key, "ASCII") + "=" + URLEncoder.encode(value, "ASCII");
            newS = script.replace(s, URLEncode.encodeRFC2396((String)key) + "=" + replace);
        }
        if (StringUtils.equals((String)newS, (String)script)) {
            newS = script.replace(value, replace);
        }
        if (StringUtils.equals((String)newS, (String)script)) {
            newS = script.replace(URLEncode.encodeRFC2396((String)value), replace);
        }
        if (StringUtils.equals((String)newS, (String)script)) {
            newS = script.replace(URLEncoder.encode(value, "ASCII"), replace);
        }
        if (StringUtils.equals((String)newS, (String)script)) {
            throw new Exception("Could not replace " + replace);
        }
        return newS;
    }
}

