/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect.pluginsinc.liveheader.validate;

import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jd.controlling.reconnect.pluginsinc.liveheader.LiveHeaderReconnectSettings;
import jd.controlling.reconnect.pluginsinc.liveheader.remotecall.RouterData;
import jd.controlling.reconnect.pluginsinc.liveheader.validate.RetryWithReplacedScript;
import jd.nutils.Formatter;
import jd.nutils.encoding.Base64;
import org.appwork.remoteapi.exceptions.InternalApiException;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.XML;
import org.appwork.utils.encoding.URLEncode;
import org.appwork.utils.formatter.TimeFormatter;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.net.httpserver.HttpConnection;
import org.appwork.utils.net.httpserver.requests.KeyValuePair;
import org.jdownloader.logging.LogController;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Scriptvalidator {
    protected RouterData rd;
    private LogSource logger;
    protected HashSet<String> exceptionsParameterKeys = new HashSet();
    protected HashSet<String> defaultPasswords;
    protected HashSet<String> defaultUsernames;
    protected HashSet<String> whitelistValues;
    protected HashSet<String> replacedDefaultPasswords;
    protected HashSet<String> replacedDefaultUsernames;
    protected HashSet<String> replacedDefaulAuth;
    private Map<String, String> internalVariables;
    private Map<String, String> parsedVariables;
    protected ArrayList<Exception> changes;

    public Scriptvalidator(RouterData rd) {
        this.exceptionsParameterKeys.add("var:pagename".toLowerCase(Locale.ENGLISH));
        this.exceptionsParameterKeys.add("var:errorpagename".toLowerCase(Locale.ENGLISH));
        this.exceptionsParameterKeys.add("pppName".toLowerCase(Locale.ENGLISH));
        this.exceptionsParameterKeys.add("serviceName".toLowerCase(Locale.ENGLISH));
        this.exceptionsParameterKeys.add("wanName".toLowerCase(Locale.ENGLISH));
        this.exceptionsParameterKeys.add("ifname".toLowerCase(Locale.ENGLISH));
        this.exceptionsParameterKeys.add("device_name".toLowerCase(Locale.ENGLISH));
        this.exceptionsParameterKeys.add("logger:settings/facility/user".toLowerCase(Locale.ENGLISH));
        this.exceptionsParameterKeys.add("EmWeb_ns:vim:3.passthrough".toLowerCase(Locale.ENGLISH));
        this.exceptionsParameterKeys.add("wan_login".toLowerCase(Locale.ENGLISH));
        this.exceptionsParameterKeys.add("hostName".toLowerCase(Locale.ENGLISH));
        this.exceptionsParameterKeys.add("encaps0:pppoa:settings/auth_type".toLowerCase(Locale.ENGLISH));
        this.exceptionsParameterKeys.add("EmWeb_ns:vim:4.ImServices.ipwan0.1:webcontrol".toLowerCase(Locale.ENGLISH));
        this.exceptionsParameterKeys.add("mbg_webname".toLowerCase(Locale.ENGLISH));
        this.exceptionsParameterKeys.add("intfName".toLowerCase(Locale.ENGLISH));
        this.defaultPasswords = new HashSet();
        this.defaultPasswords.add("administrator");
        this.defaultPasswords.add("admin");
        this.defaultPasswords.add("123456");
        this.defaultPasswords.add("1111");
        this.defaultPasswords.add("1234");
        this.defaultPasswords.add("0000");
        this.defaultPasswords.add("password");
        this.defaultPasswords.add("pass");
        this.defaultUsernames = new HashSet();
        this.defaultUsernames.add("admin");
        this.defaultUsernames.add("user");
        this.defaultUsernames.add("name");
        this.defaultUsernames.add("username");
        this.defaultUsernames.add("root");
        this.defaultUsernames.add("0000");
        this.defaultUsernames.add("123456");
        this.defaultUsernames.add("1234");
        this.defaultUsernames.add("administrator");
        this.whitelistValues = new HashSet();
        this.whitelistValues.add("true");
        this.whitelistValues.add("false");
        this.whitelistValues.add("0");
        this.whitelistValues.add("1");
        this.whitelistValues.add("2");
        this.whitelistValues.add("3");
        this.whitelistValues.add("4");
        this.whitelistValues.add("5");
        this.whitelistValues.add("6");
        this.whitelistValues.add("7");
        this.whitelistValues.add("8");
        this.whitelistValues.add("9");
        this.whitelistValues.add("Internet");
        this.whitelistValues.add("");
        this.whitelistValues.add("");
        this.whitelistValues.add("");
        this.whitelistValues.add("");
        this.whitelistValues.add("");
        this.whitelistValues.add("");
        this.replacedDefaultPasswords = new HashSet();
        this.replacedDefaultUsernames = new HashSet();
        this.replacedDefaulAuth = new HashSet();
        this.internalVariables = null;
        this.parsedVariables = null;
        this.changes = new ArrayList();
        this.rd = rd;
        this.logger = LogController.getInstance().getLogger("Scriptvalidator");
        this.logger.info("Validate:\r\n" + JSonStorage.serializeToJson((Object)rd));
    }

    private static String[] splitLines(String source) {
        return source.split("\r\n|\r|\n");
    }

    public static Document parseXmlString(String xmlString) throws SAXException, IOException, ParserConfigurationException {
        if (xmlString == null) {
            return null;
        }
        DocumentBuilderFactory factory = XML.newSecureFactory();
        InputSource inSource = new InputSource(new StringReader(xmlString));
        Document doc = factory.newDocumentBuilder().parse(inSource);
        return doc;
    }

    public String toOverView(String script) throws Exception {
        if (StringUtils.isEmpty((String)script)) {
            return "";
        }
        String lc = script.toLowerCase(Locale.ENGLISH);
        if (!lc.contains("[[[request")) {
            throw new Exception("No Request Tag");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ip", "your.router.ip");
        map.put("routerip", "your.router.ip");
        map.put("host", "your.router.ip");
        this.internalVariables = Collections.unmodifiableMap(map);
        this.parsedVariables = new HashMap<String, String>();
        if (script != null) {
            script = script.replaceAll("\\[\\[\\[", "<");
            script = script.replaceAll("\\]\\]\\]", ">");
            script = script.replaceAll("<REQUEST(.*?)>", "<REQUEST$1><![CDATA[");
            script = script.replaceAll("</REQUEST>", "]]></REQUEST>");
            script = script.replaceAll("<RESPONSE(.*?)>", "<RESPONSE$1><![CDATA[");
            script = script.replaceAll("</RESPONSE.*>", "]]></RESPONSE>");
        }
        StringBuilder sb = new StringBuilder();
        Document xmlScript = Scriptvalidator.parseXmlString(script);
        if (xmlScript == null) {
            throw new Exception("Error while parsing the xml string");
        }
        Node root = xmlScript.getChildNodes().item(0);
        if (root == null || !root.getNodeName().equalsIgnoreCase("HSRC")) {
            throw new Exception("Error while parsing the xml string. Root Node must be [[[HSRC]]]*[/HSRC]");
        }
        NodeList steps = root.getChildNodes();
        for (int step = 0; step < steps.getLength(); ++step) {
            Node current = steps.item(step);
            if (current.getNodeType() == 3) continue;
            if (!current.getNodeName().equalsIgnoreCase("STEP")) {
                throw new Exception("Root Node should only contain [[[STEP]]]*[[[/STEP]]] ChildTag: " + current.getNodeName());
            }
            NodeList toDos = current.getChildNodes();
            int toDosLength = toDos.getLength();
            for (int toDoStep = 0; toDoStep < toDosLength; ++toDoStep) {
                NamedNodeMap attributes;
                Node toDo;
                block27: {
                    toDo = toDos.item(toDoStep);
                    if (toDo.getNodeName().equalsIgnoreCase("DEFINE")) {
                        attributes = toDo.getAttributes();
                        for (int attribute = 0; attribute < attributes.getLength(); ++attribute) {
                            String key = attributes.item(attribute).getNodeName();
                            if (key.toLowerCase().equals("router") || key.toLowerCase().equals("routername")) continue;
                            String value = attributes.item(attribute).getNodeValue();
                            if (key.matches("ip\\d+") && !value.contains("%%%")) {
                                throw new RetryWithReplacedScript(this.rd.getScript(), key, "\"" + value + "\"", "\"%%%routerip%%%\"");
                            }
                            String[] tmp = value.split("\\%\\%\\%(.*?)\\%\\%\\%", -1);
                            String[] params = new Regex(value, "%%%(.*?)%%%").getColumn(-1);
                            if (params.length > 0) {
                                StringBuilder newValue = new StringBuilder(tmp[0]);
                                int tmpLength = tmp.length;
                                for (int i = 1; i <= tmpLength; ++i) {
                                    if (i > params.length) continue;
                                    newValue.append(this.getModifiedVariable(params[i - 1]));
                                    if (i >= tmpLength) continue;
                                    newValue.append(tmp[i]);
                                }
                                value = newValue.toString();
                            }
                            this.append(sb, "Define Variable " + key + "\t=\t" + value);
                            this.putVariable(key, value);
                        }
                    }
                    if (toDo.getNodeName().equalsIgnoreCase("PARSE")) {
                        String[] parseLines;
                        for (String parseLine : parseLines = Scriptvalidator.splitLines(toDo.getChildNodes().item(0).getNodeValue().trim())) {
                            String varname = new Regex(parseLine, "(.*?):").getMatch(0);
                            String pattern = new Regex(parseLine, ".*?:(.+)").getMatch(0);
                            if (varname == null || pattern == null) continue;
                            varname = varname.trim();
                            pattern = pattern.trim();
                            this.putVariable(varname, URLEncoder.encode("<Variable: " + varname + ">", "ASCII"));
                            this.append(sb, "\t-> Search in HTML Response:  " + varname + " = Regex:" + pattern);
                        }
                    }
                    if (toDo.getNodeName().equalsIgnoreCase("REQUEST")) {
                        if (toDo.getChildNodes().getLength() != 1) {
                            throw new Exception("A REQUEST Tag is not allowed to have childTags.");
                        }
                        attributes = toDo.getAttributes();
                        try {
                            this.doRequest(toDo.getChildNodes().item(0).getNodeValue().trim(), sb, attributes.getNamedItem("https") != null, attributes.getNamedItem("raw") != null);
                        }
                        catch (Exception e) {
                            if (!(e instanceof Exception)) break block27;
                            throw e;
                        }
                    }
                }
                if (StringUtils.equalsIgnoreCase((String)toDo.getNodeName(), (String)"RESPONSE")) {
                    String[] keys;
                    if (toDo.getChildNodes().getLength() != 1) {
                        throw new Exception("A RESPONSE Tag is not allowed to have childTags.");
                    }
                    attributes = toDo.getAttributes();
                    if (attributes.getNamedItem("keys") == null) {
                        throw new Exception("A RESPONSE Node needs a Keys Attribute: " + toDo);
                    }
                    for (String s : keys = attributes.getNamedItem("keys").getNodeValue().split("\\;")) {
                        this.append(sb, "\t-> Search Variable in HTML Response:  " + s);
                    }
                }
                if (StringUtils.equalsIgnoreCase((String)toDo.getNodeName(), (String)"WAIT")) {
                    attributes = toDo.getAttributes();
                    Node item = attributes.getNamedItem("seconds");
                    if (item == null) {
                        throw new Exception("A Wait Step needs a Waittimeattribute: e.g.: <WAIT seconds=\"15\"/>");
                    }
                    int seconds = Formatter.filterInt((String)item.getNodeValue());
                    if (seconds > 0) {
                        this.append(sb, "Wait " + TimeFormatter.formatMilliSeconds((long)(seconds * 1000), (int)0));
                    }
                }
                if (!StringUtils.equalsIgnoreCase((String)toDo.getNodeName(), (String)"TIMEOUT")) continue;
                attributes = toDo.getAttributes();
                Node item = attributes.getNamedItem("seconds");
                if (item == null) {
                    throw new Exception("A valid timeout must be set: e.g.: <TIMEOUT seconds=\"15\"/>");
                }
                int seconds = Formatter.filterInt((String)item.getNodeValue());
                if (seconds <= 0) continue;
                this.append(sb, "Set HTTP Timeout to " + TimeFormatter.formatMilliSeconds((long)(seconds * 1000), (int)0));
            }
        }
        return sb.toString();
    }

    private void doRequest(String request, StringBuilder sb, boolean ishttps, boolean israw) throws Exception, IOException {
        String protocoll;
        String[] requestLines;
        StringBuilder post = new StringBuilder();
        HashMap<String, String> requestProperties = new HashMap<String, String>();
        if (israw) {
            // empty if block
        }
        String[] tmp = request.split("\\%\\%\\%(.*?)\\%\\%\\%");
        String[] params = new Regex(request, "%%%(.*?)%%%").getColumn(0);
        if (params.length > 0) {
            String modifiedVariable;
            String key;
            int i;
            int tmpLength;
            StringBuilder req;
            if (request.startsWith(params[0])) {
                req = new StringBuilder();
                tmpLength = tmp.length;
                for (i = 0; i <= tmpLength; ++i) {
                    key = params[i - 1];
                    modifiedVariable = this.getModifiedVariable(key);
                    req.append(URLEncode.encodeRFC2396((String)modifiedVariable));
                    if (i >= tmpLength) continue;
                    req.append(tmp[i]);
                }
            } else {
                req = new StringBuilder(tmp[0]);
                tmpLength = tmp.length;
                for (i = 1; i <= tmpLength; ++i) {
                    if (i > params.length) continue;
                    key = params[i - 1];
                    modifiedVariable = this.getModifiedVariable(key);
                    req.append(URLEncode.encodeRFC2396((String)modifiedVariable));
                    if (i >= tmpLength) continue;
                    req.append(tmp[i]);
                }
            }
            request = req.toString();
        }
        if ((requestLines = Scriptvalidator.splitLines(request)).length == 0) {
            throw new Exception("Parse Fehler:" + request);
        }
        tmp = requestLines[0].split(" ");
        if (tmp.length < 2) {
            throw new Exception("Bad Request Type: " + requestLines[0] + "\r\n" + request);
        }
        String requestType = tmp[0];
        String path = tmp[1];
        boolean headersEnd = false;
        String host = null;
        int requestLinesLength = requestLines.length;
        for (int li = 1; li < requestLinesLength; ++li) {
            if (headersEnd) {
                post.append(requestLines[li]);
                post.append(new char[]{'\r', '\n'});
                continue;
            }
            if (requestLines[li].trim().length() == 0) {
                headersEnd = true;
                continue;
            }
            String[] p = requestLines[li].split("\\:");
            if (p.length < 2) {
                headersEnd = true;
                --li;
                continue;
            }
            requestProperties.put(p[0].trim(), URLDecoder.decode(requestLines[li].substring(p[0].length() + 1).trim(), "ASCII"));
            if (StringUtils.equalsIgnoreCase((String)p[0].trim(), (String)"Referer") || StringUtils.equalsIgnoreCase((String)p[0].trim(), (String)"Referrer")) {
                this.onHost(new URL((String)requestProperties.get(p[0].trim())).getHost());
            }
            if (!p[0].trim().equalsIgnoreCase("HOST")) continue;
            host = requestLines[li].substring(p[0].length() + 1).trim();
        }
        if (host == null) {
            throw new Exception("Host not available: " + request);
        }
        if (requestProperties != null) {
            // empty if block
        }
        String string = protocoll = ishttps ? "https://" : "http://";
        if (StringUtils.equalsIgnoreCase((String)requestType, (String)"AUTH")) {
            // empty if block
        }
        this.onHost(host);
        if (StringUtils.equalsIgnoreCase((String)requestType, (String)"GET") || StringUtils.equalsIgnoreCase((String)requestType, (String)"AUTH")) {
            String authorization;
            URL url = new URL(protocoll + host + path);
            this.append(sb, "HTTP Request " + requestType + " " + protocoll + host + url.getPath());
            String cookie = (String)requestProperties.get("Cookie");
            if (StringUtils.isNotEmpty((String)cookie)) {
                this.onCookie(cookie);
                this.append(sb, "\tCookie:\t\t" + cookie);
            }
            if (StringUtils.isNotEmpty((String)(authorization = (String)requestProperties.get("Authorization")))) {
                this.onAuth(authorization);
                this.append(sb, "\tAuthorization:\t\t" + authorization);
            }
            int i = 1;
            for (KeyValuePair pa : HttpConnection.parseParameterList((String)url.getQuery())) {
                this.append(sb, "\tParameter #" + i++ + ": \t" + pa.key + "\t=\t" + URLDecoder.decode(pa.value, "ASCII"));
                this.onParameter(pa.key, pa.value);
            }
        } else if (StringUtils.equalsIgnoreCase((String)requestType, (String)"POST") || StringUtils.equalsIgnoreCase((String)requestType, (String)"PUT")) {
            String authorization;
            String poster = post.toString().trim();
            URL url = new URL(protocoll + host + path);
            this.append(sb, "HTTP Request " + requestType + " " + protocoll + host + path);
            String cookie = (String)requestProperties.get("Cookie");
            if (StringUtils.isNotEmpty((String)cookie)) {
                this.onCookie(cookie);
                this.append(sb, "\tCookie:\t\t" + cookie);
            }
            if (StringUtils.isNotEmpty((String)(authorization = (String)requestProperties.get("Authorization")))) {
                this.onAuth(authorization);
                this.append(sb, "\tAuthorization:\t\t" + authorization);
            }
            int i = 1;
            for (KeyValuePair pa : HttpConnection.parseParameterList((String)url.getQuery())) {
                this.append(sb, "\tParameter #" + i++ + ": \t" + pa.key + "\t=\t" + URLDecoder.decode(pa.value, "ASCII"));
                this.onParameter(pa.key, pa.value);
            }
            for (KeyValuePair pa : HttpConnection.parseParameterList((String)poster)) {
                this.append(sb, "\tParameter #" + i++ + ": \t" + pa.key + "\t=\t" + URLDecoder.decode(pa.value, "ASCII"));
                this.onParameter(pa.key, pa.value);
            }
        } else {
            throw new Exception("Unknown/Unsupported requestType: " + requestType);
        }
    }

    protected void onHost(String host) throws Exception {
        if (((LiveHeaderReconnectSettings)JsonConfig.create(LiveHeaderReconnectSettings.class)).isAutoReplaceIPEnabled() && !host.startsWith("your.router.ip")) {
            throw new RetryWithReplacedScript(this.rd.getScript(), host, "%%%routerip%%%");
        }
    }

    private void onParameter(String key, String value) throws Exception {
        if (key == null || value == null) {
            return;
        }
        if (this.exceptionsParameterKeys.contains(key.toLowerCase(Locale.ENGLISH))) {
            return;
        }
        if (this.whitelistValues.contains(value.toLowerCase(Locale.ENGLISH))) {
            return;
        }
        if (StringUtils.isEmpty((String)value) || value.length() < 3) {
            return;
        }
        if (value.contains("<Variable:") && value.contains(">")) {
            return;
        }
        if (value.contains(URLEncoder.encode("<Variable:", "ASCII")) && value.contains(URLEncoder.encode(">", "ASCII"))) {
            return;
        }
        if (this.isPasswordParameter(key, value)) {
            System.out.println(key + "=" + value);
            this.replacePasswordParameter(key, value);
        }
        if (this.isUsernameParameter(key, value)) {
            this.replaceUsernameParameter(key, value);
        }
    }

    protected void replaceUsernameParameter(String key, String value) throws RetryWithReplacedScript, Exception {
        System.out.println(key + "=" + value);
        if (this.defaultUsernames.contains(value.toLowerCase(Locale.ENGLISH))) {
            this.replacedDefaultUsernames.add(value);
        }
        throw new RetryWithReplacedScript(this.rd.getScript(), key, value, "%%%username%%%");
    }

    protected void replacePasswordParameter(String key, String value) throws RetryWithReplacedScript, Exception {
        if (this.defaultPasswords.contains(value.toLowerCase(Locale.ENGLISH))) {
            this.replacedDefaultPasswords.add(value);
        }
        throw new RetryWithReplacedScript(this.rd.getScript(), key, value, "%%%password%%%");
    }

    private boolean isUsernameParameter(String key, String value) {
        if (key.toLowerCase().contains("usr")) {
            return true;
        }
        if (key.toLowerCase().contains("use")) {
            return true;
        }
        return key.toLowerCase().contains("name");
    }

    private boolean isPasswordParameter(String key, String value) {
        if (key.toLowerCase().contains("pw")) {
            return true;
        }
        if (key.toLowerCase().contains("pas")) {
            return true;
        }
        if (key.toLowerCase().contains("auth")) {
            return true;
        }
        return key.toLowerCase().contains("crede");
    }

    private void onAuth(String authorization) throws RetryWithReplacedScript, Exception {
        if (!"Basic <Variable:basicauth>".equals(authorization)) {
            if (authorization.startsWith("Basic ")) {
                String dec = new String(Base64.decode((String)authorization.substring("Basic ".length())));
                int first = dec.indexOf(":");
                String username = dec.substring(0, first);
                String password = dec.substring(first + 1);
                this.replaceAuthHeader(authorization, username, password);
            }
            System.out.println(authorization);
        }
    }

    protected void replaceAuthHeader(String authorization, String username, String password) throws RetryWithReplacedScript, Exception {
        if (this.defaultPasswords.contains(password.toLowerCase(Locale.ENGLISH)) && this.defaultUsernames.contains(username.toLowerCase(Locale.ENGLISH))) {
            this.replacedDefaulAuth.add(authorization.substring("Basic ".length()));
        }
        throw new RetryWithReplacedScript(this.rd.getScript(), authorization.substring("Basic ".length()), "%%%basicauth%%%");
    }

    private void onCookie(String cookie) throws RetryWithReplacedScript, Exception {
        String encd = URLEncoder.encode("<Variable:", "ASCII");
        if (!cookie.contains("<Variable:") && !cookie.contains(encd)) {
            System.out.println(cookie);
            throw new RetryWithReplacedScript(this.rd.getScript(), null, cookie, "%%%Set-Cookie%%%");
        }
    }

    private void append(StringBuilder sb, String string) {
        if (sb.length() > 0) {
            sb.append("\r\n");
        }
        sb.append(string);
    }

    private void putVariable(String key, String value) throws Exception {
        if (key != null) {
            String lowerKey = key.toLowerCase(Locale.ENGLISH);
            if (this.internalVariables.containsKey(lowerKey)) {
                throw new Exception("Cannot change internal varbiable:" + lowerKey);
            }
            if (value != null) {
                this.parsedVariables.put(lowerKey, value);
            }
        }
    }

    private String getVariable(String key) throws Exception {
        if (key != null) {
            String lowerKey = key.toLowerCase(Locale.ENGLISH);
            if (this.internalVariables.containsKey(lowerKey)) {
                return this.internalVariables.get(lowerKey);
            }
            if (this.parsedVariables.containsKey(lowerKey)) {
                return this.parsedVariables.get(lowerKey);
            }
        }
        return null;
    }

    private String getModifiedVariable(String key) throws Exception {
        if (StringUtils.equalsIgnoreCase((String)"timestamp", (String)key)) {
            return "<Variable: CurrentTime>";
        }
        if (StringUtils.containsIgnoreCase((String)key, (String)"random:")) {
            return "<Variable: " + key + ">";
        }
        int index = key.indexOf(":::");
        String value = null;
        if (index == -1) {
            value = this.getVariable(key);
            return value == null ? "<Variable:" + key + ">" : value;
        }
        while ((index = key.indexOf(":::")) >= 0) {
            String method = key.substring(0, index);
            key = key.substring(index + 3);
            if (StringUtils.equalsIgnoreCase((String)method, (String)"URLENCODE")) {
                value = "<Variable: UrlEncode(\"" + key + "\")>";
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)method, (String)"URLDECODE")) {
                value = "<Variable: UrlDecode(\"" + key + "\")>";
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)method, (String)"UTF8DECODE")) {
                value = "<Variable: UTF8Decode(\"" + key + "\")>";
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)method, (String)"UTF8ENCODE")) {
                value = "<Variable: UTF8Encode(\"" + key + "\")>";
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)method, (String)"MD5")) {
                value = "<Variable: MD5(\"" + key + "\")>";
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)method, (String)"SHA256")) {
                value = "<Variable: SHA256(\"" + key + "\")>";
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)method, (String)"BASE64_SHA256")) {
                value = "<Variable: Base64(SHA256(\"" + key + "\"))>";
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)method, (String)"BASE64")) {
                value = "<Variable: Base64(\"" + key + "\")>";
                continue;
            }
            throw new Exception("Unsupported Type: " + method);
        }
        return value;
    }

    public void run() throws Exception {
        String oldScriptID = this.rd.getScriptID();
        String oldScript = this.rd.getScript();
        while (true) {
            try {
                this.toOverView(this.rd.getScript());
                if (this.changes.size() == 0) {
                    return;
                }
                this.rd.setScriptID(null);
                this.setScript(oldScriptID);
                this.setChanges(this.rd.getScriptID());
                if (this.replacedDefaultPasswords.size() > 0 || this.replacedDefaultUsernames.size() > 0 || this.replacedDefaulAuth.size() > 0) {
                    String s = this.rd.getScript();
                    for (String e : this.replacedDefaultPasswords) {
                        s = s.replace("%%%password%%%", e);
                    }
                    for (String e : this.replacedDefaultUsernames) {
                        s = s.replace("%%%username%%%", e);
                    }
                    for (String e : this.replacedDefaulAuth) {
                        s = s.replace("%%%basicauth%%%", e);
                    }
                    RouterData copy = (RouterData)JSonStorage.restoreFromString((String)JSonStorage.serializeToJson((Object)this.rd), RouterData.TYPE_REF);
                    copy.setScript(s);
                    copy.setScriptID(null);
                    String id = copy.getScriptID();
                    this.addCopy(copy);
                }
                return;
            }
            catch (RetryWithReplacedScript e) {
                if (this.rd.getScript().equals(e.getNewScript())) {
                    return;
                }
                this.changes.add(e);
                this.rd.setScript(e.getNewScript());
                this.rd.setScriptID(null);
                continue;
            }
            break;
        }
    }

    protected void addCopy(RouterData copy) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, InternalApiException {
    }

    protected void setChanges(String scriptID) throws InternalApiException {
    }

    protected void setScript(String oldScriptID) throws InternalApiException {
    }
}

