/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect.pluginsinc.upnp;

import java.awt.Component;
import java.awt.LayoutManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jd.controlling.reconnect.ProcessCallBack;
import jd.controlling.reconnect.ReconnectConfig;
import jd.controlling.reconnect.ReconnectException;
import jd.controlling.reconnect.ReconnectInvoker;
import jd.controlling.reconnect.ReconnectResult;
import jd.controlling.reconnect.RouterPlugin;
import jd.controlling.reconnect.ipcheck.IP;
import jd.controlling.reconnect.ipcheck.IPCheckException;
import jd.controlling.reconnect.ipcheck.IPCheckProvider;
import jd.controlling.reconnect.ipcheck.InvalidIPRangeException;
import jd.controlling.reconnect.ipcheck.InvalidProviderException;
import jd.controlling.reconnect.pluginsinc.upnp.AutoDetectUpnpAction;
import jd.controlling.reconnect.pluginsinc.upnp.UPNPReconnectInvoker;
import jd.controlling.reconnect.pluginsinc.upnp.UPNPReconnectResult;
import jd.controlling.reconnect.pluginsinc.upnp.UPNPScannerAction;
import jd.controlling.reconnect.pluginsinc.upnp.UPUPReconnectSettings;
import jd.controlling.reconnect.pluginsinc.upnp.cling.UPNPDeviceScanner;
import jd.controlling.reconnect.pluginsinc.upnp.cling.UpnpRouterDevice;
import jd.controlling.reconnect.pluginsinc.upnp.translate.T;
import net.miginfocom.swing.MigLayout;
import org.appwork.storage.config.JsonConfig;
import org.appwork.swing.components.ExtButton;
import org.appwork.swing.components.ExtTextField;
import org.appwork.uio.CloseReason;
import org.appwork.uio.ConfirmDialogInterface;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.StringUtils;
import org.appwork.utils.formatter.TimeFormatter;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.dialog.ConfirmDialog;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.logging.LogController;
import org.jdownloader.settings.advanced.AdvancedConfigManager;
import org.jdownloader.settings.staticreferences.CFG_RECONNECT;

public class UPNPRouterPlugin
extends RouterPlugin
implements IPCheckProvider {
    public static final String ID = "SIMPLEUPNP";
    private ExtTextField serviceTypeTxt;
    private ExtTextField controlURLTxt;
    private JLabel wanType;
    protected List<UpnpRouterDevice> devices = null;
    private Icon icon = new AbstractIcon("logo/upnp", 16);
    private UPUPReconnectSettings settings = (UPUPReconnectSettings)JsonConfig.create(UPUPReconnectSettings.class);

    public UPNPRouterPlugin() {
        AdvancedConfigManager.getInstance().register(this.settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ReconnectResult> runDetectionWizard(ProcessCallBack processCallBack) throws InterruptedException {
        LogSource logger = LogController.getInstance().getLogger("UPNPReconnect");
        try {
            ArrayList<ReconnectResult> ret = new ArrayList<ReconnectResult>();
            List<UpnpRouterDevice> devices = this.getDevices();
            logger.info("Found devices: " + devices);
            for (int i = 0; i < devices.size(); ++i) {
                UpnpRouterDevice device = devices.get(i);
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                try {
                    processCallBack.setStatusString(this, T.T.try_reconnect(device.getModelname()));
                    logger.info("Try " + device);
                    if (processCallBack.isMethodConfirmEnabled()) {
                        ConfirmDialog d = new ConfirmDialog(32, _GUI.T.runDetectionWizard_confirm_title(), _GUI.T.UPNPRouterPlugin_runDetectionWizard_confirm_msg(device.getServiceType(), device.getControlURL()), new AbstractIcon("upnp", 32), _GUI.T.lit_continue(), _GUI.T.lit_skip()){

                            protected String getDontShowAgainLabelText() {
                                return _GUI.T.UPNPRouterPlugin_accept_all();
                            }

                            public String getDontShowAgainKey() {
                                return null;
                            }
                        };
                        ConfirmDialogInterface answer = (ConfirmDialogInterface)UIOManager.I().show(ConfirmDialogInterface.class, (UserIODefinition)d);
                        if (answer.getCloseReason() != CloseReason.OK) continue;
                        if (answer.isDontShowAgainSelected()) {
                            processCallBack.setMethodConfirmEnabled(false);
                        }
                    }
                    ReconnectResult res = new UPNPReconnectInvoker(this, device.getServiceType(), device.getControlURL()).validate();
                    logger.info("REsult " + res);
                    if (res == null || !res.isSuccess()) continue;
                    ret.add(res);
                    processCallBack.setStatus(this, ret);
                    if (i >= devices.size() - 1 || ret.size() != 1) continue;
                    Dialog.getInstance().showConfirmDialog(0, _GUI.T.LiveHeaderDetectionWizard_testList_firstSuccess_title(), _GUI.T.LiveHeaderDetectionWizard_testList_firstsuccess_msg(TimeFormatter.formatMilliSeconds((long)res.getSuccessDuration(), (int)0)), (Icon)new AbstractIcon("ok", 32), _GUI.T.LiveHeaderDetectionWizard_testList_ok(), _GUI.T.LiveHeaderDetectionWizard_testList_use());
                    continue;
                }
                catch (ReconnectException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (DialogClosedException e) {
                    continue;
                }
                catch (DialogCanceledException e) {
                    ArrayList<ReconnectResult> arrayList = ret;
                    logger.close();
                    return arrayList;
                }
            }
            ArrayList<ReconnectResult> arrayList = ret;
            return arrayList;
        }
        finally {
            logger.close();
        }
    }

    @Override
    public IP getExternalIP() throws IPCheckException {
        String ipxml;
        LogSource logger = LogController.getInstance().getLogger("UPNPReconnect");
        try {
            ipxml = UPNPReconnectInvoker.sendRequest((Logger)logger, this.settings.getServiceType(), this.settings.getControlURL(), "GetExternalIPAddress");
            logger.clear();
        }
        catch (Exception e) {
            this.setCanCheckIP(false);
            throw new InvalidProviderException("UPNP Command Error");
        }
        finally {
            logger.close();
        }
        try {
            Matcher ipm = Pattern.compile("<\\s*NewExternalIPAddress\\s*>\\s*(.*)\\s*<\\s*/\\s*NewExternalIPAddress\\s*>", 2).matcher(ipxml);
            if (ipm.find()) {
                return IP.getInstance(ipm.group(1));
            }
        }
        catch (InvalidIPRangeException e2) {
            throw new InvalidProviderException(e2);
        }
        this.setCanCheckIP(false);
        throw new InvalidProviderException("Unknown UPNP Response Error");
    }

    @Override
    public Icon getIcon16() {
        return this.icon;
    }

    @Override
    public void setSetup(ReconnectResult reconnectResult) {
        UPNPReconnectResult r = (UPNPReconnectResult)reconnectResult;
        UPNPReconnectInvoker i = (UPNPReconnectInvoker)r.getInvoker();
        this.settings.setControlURL(i.getControlURL());
        this.settings.setModelName(i.getName());
        this.settings.setServiceType(i.getServiceType());
        ((ReconnectConfig)JsonConfig.create(ReconnectConfig.class)).setSecondsBeforeFirstIPCheck((int)reconnectResult.getOfflineDuration() / 1000);
        ((ReconnectConfig)JsonConfig.create(ReconnectConfig.class)).setSecondsToWaitForIPChange((int)reconnectResult.getMaxSuccessDuration() / 1000);
        ((ReconnectConfig)JsonConfig.create(ReconnectConfig.class)).setSecondsToWaitForOffline((int)reconnectResult.getMaxOfflineDuration() / 1000);
        this.updateGUI();
    }

    @Override
    public JComponent getGUI() {
        JPanel p = new JPanel((LayoutManager)new MigLayout("ins 0 0 0 0,wrap 3", "[][][grow,fill]", "[fill]"));
        p.setOpaque(false);
        ExtButton find = new ExtButton((AbstractAction)((Object)new UPNPScannerAction(this))).setTooltipsEnabled(true);
        find.setHorizontalAlignment(2);
        ExtButton auto = new ExtButton((AbstractAction)((Object)new AutoDetectUpnpAction(this))).setTooltipsEnabled(true);
        auto.setHorizontalAlignment(2);
        this.serviceTypeTxt = new ExtTextField(){

            public void onChanged() {
                String serviceType = UPNPRouterPlugin.this.serviceTypeTxt.getText();
                try {
                    if (StringUtils.isNotEmpty((String)serviceType) && serviceType.toLowerCase(Locale.ENGLISH).startsWith("urn:schemas-upnp-org:service:")) {
                        UPNPRouterPlugin.this.settings.setServiceType(serviceType);
                        UPNPRouterPlugin.this.setCanCheckIP(true);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        this.controlURLTxt = new ExtTextField(){

            public void onChanged() {
                String controlURL = UPNPRouterPlugin.this.controlURLTxt.getText();
                try {
                    if (StringUtils.isNotEmpty((String)controlURL) && new URL(controlURL).getHost() != null) {
                        UPNPRouterPlugin.this.settings.setControlURL(controlURL);
                        UPNPRouterPlugin.this.setCanCheckIP(true);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        this.serviceTypeTxt.setHelpText(T.T.servicetype_help());
        this.controlURLTxt.setHelpText(T.T.controlURLTxt_help());
        this.wanType = new JLabel();
        p.add((Component)auto, "aligny top,gapright 15,sg buttons");
        p.add((Component)new JLabel(T.T.literally_router()), "");
        p.add((Component)this.wanType, "spanx");
        p.add((Component)find, "aligny top,gapright 15,newline,sg buttons");
        p.add((Component)new JLabel(T.T.literally_service_type()), "");
        p.add((Component)this.serviceTypeTxt);
        p.add((Component)new JLabel(T.T.literally_control_url()), "newline,skip");
        p.add((Component)this.controlURLTxt);
        this.updateGUI();
        return p;
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public int getIpCheckInterval() {
        return 1;
    }

    @Override
    public IPCheckProvider getIPCheckProvider() {
        if (!this.isIPCheckEnabled() || !CFG_RECONNECT.CFG.isIPCheckAllowLocalUpnpIpCheckEnabled()) {
            return null;
        }
        return this;
    }

    @Override
    public String getName() {
        return "UPNP - Universal Plug & Play (Fritzbox,...)";
    }

    @Override
    public int getWaittimeBeforeFirstIPCheck() {
        return 0;
    }

    public boolean isIPCheckEnabled() {
        return this.settings.isIPCheckEnabled();
    }

    public void setCanCheckIP(boolean b) {
        this.settings.setIPCheckEnabled(b);
    }

    void setDevice(UpnpRouterDevice upnpRouterDevice) {
        if (upnpRouterDevice == null) {
            this.settings.setControlURL(null);
            this.settings.setModelName(null);
            this.settings.setIPCheckEnabled(false);
            this.settings.setServiceType(null);
            this.settings.setWANService(null);
        } else {
            LogController.CL().info(upnpRouterDevice + "");
            this.settings.setControlURL(upnpRouterDevice.getControlURL());
            this.settings.setModelName(upnpRouterDevice.getModelname());
            this.settings.setServiceType(upnpRouterDevice.getServiceType());
            this.settings.setWANService(upnpRouterDevice.getWanservice());
            this.setCanCheckIP(true);
            this.updateGUI();
        }
    }

    private void updateGUI() {
        new EDTRunner(){

            protected void runInEDT() {
                if (UPNPRouterPlugin.this.wanType != null) {
                    try {
                        UPNPRouterPlugin.this.wanType.setText(UPNPRouterPlugin.this.settings.getModelName() + (UPNPRouterPlugin.this.settings.getWANService().length() > 0 ? " (" + UPNPRouterPlugin.this.settings.getWANService() + ")" : ""));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        UPNPRouterPlugin.this.serviceTypeTxt.setText(UPNPRouterPlugin.this.settings.getServiceType());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        UPNPRouterPlugin.this.controlURLTxt.setText(UPNPRouterPlugin.this.settings.getControlURL());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        };
    }

    @Override
    public ReconnectInvoker getReconnectInvoker() {
        return new UPNPReconnectInvoker(this, this.settings.getServiceType(), this.settings.getControlURL());
    }

    public synchronized List<UpnpRouterDevice> getCachedDevices() throws InterruptedException {
        return this.devices;
    }

    public synchronized List<UpnpRouterDevice> getDevices() throws InterruptedException {
        this.devices = new UPNPDeviceScanner().scan();
        return this.devices;
    }
}

