/*
 * Decompiled with CFR 0.152.
 */
package jd.crypt;

public class AEStables {
    private byte[] E = new byte[256];
    private byte[] inv = new byte[256];
    private byte[] invS = new byte[256];
    private byte[] L = new byte[256];
    private byte[] powX = new byte[15];
    private byte[] S = new byte[256];

    public AEStables() {
        this.loadE();
        this.loadL();
        this.loadInv();
        this.loadS();
        this.loadInvS();
        this.loadPowX();
    }

    public byte FFInv(byte b) {
        byte e = this.L[b & 0xFF];
        return this.E[255 - (e & 0xFF)];
    }

    public byte FFMul(byte a, byte b) {
        byte aa = a;
        byte bb = b;
        byte r = 0;
        while (aa != 0) {
            if ((aa & 1) != 0) {
                r = (byte)(r ^ bb);
            }
            byte t = (byte)(bb & 0x80);
            bb = (byte)(bb << 1);
            if (t != 0) {
                bb = (byte)(bb ^ 0x1B);
            }
            aa = (byte)((aa & 0xFF) >> 1);
        }
        return r;
    }

    public byte FFMulFast(byte a, byte b) {
        int t = 0;
        if (a == 0 || b == 0) {
            return 0;
        }
        t = (this.L[a & 0xFF] & 0xFF) + (this.L[b & 0xFF] & 0xFF);
        if (t > 255) {
            t -= 255;
        }
        return this.E[t & 0xFF];
    }

    public byte invSBox(byte b) {
        return this.invS[b & 0xFF];
    }

    public int ithBit(byte b, int i) {
        int[] m = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
        return (b & m[i]) >> i;
    }

    private void loadE() {
        byte x = 1;
        int index = 0;
        this.E[index++] = 1;
        for (int i = 0; i < 255; ++i) {
            byte y = this.FFMul(x, (byte)3);
            this.E[index++] = y;
            x = y;
        }
    }

    private void loadInv() {
        for (int i = 0; i < 256; ++i) {
            this.inv[i] = (byte)(this.FFInv((byte)(i & 0xFF)) & 0xFF);
        }
    }

    private void loadInvS() {
        for (int i = 0; i < 256; ++i) {
            this.invS[this.S[i] & 0xFF] = (byte)i;
        }
    }

    private void loadL() {
        for (int i = 0; i < 255; ++i) {
            this.L[this.E[i] & 0xFF] = (byte)i;
        }
    }

    private void loadPowX() {
        byte x;
        byte xp = x = 2;
        this.powX[0] = 1;
        this.powX[1] = x;
        for (int i = 2; i < 15; ++i) {
            this.powX[i] = xp = this.FFMul(xp, x);
        }
    }

    private void loadS() {
        for (int i = 0; i < 256; ++i) {
            this.S[i] = (byte)(this.subBytes((byte)(i & 0xFF)) & 0xFF);
        }
    }

    public byte Rcon(int i) {
        return this.powX[i - 1];
    }

    public byte SBox(byte b) {
        return this.S[b & 0xFF];
    }

    public int subBytes(byte b) {
        int res = 0;
        if (b != 0) {
            b = (byte)(this.FFInv(b) & 0xFF);
        }
        byte c = 99;
        for (int i = 0; i < 8; ++i) {
            int temp = 0;
            temp = this.ithBit(b, i) ^ this.ithBit(b, (i + 4) % 8) ^ this.ithBit(b, (i + 5) % 8) ^ this.ithBit(b, (i + 6) % 8) ^ this.ithBit(b, (i + 7) % 8) ^ this.ithBit(c, i);
            res |= temp << i;
        }
        return res;
    }
}

