/*
 * Decompiled with CFR 0.152.
 */
package jd.crypt;

public class BaseDecoder {
    private boolean _finalized;
    private int bitsPerChar;
    private byte[] bytes = new byte[94];
    private int bytesPerWord;
    private int charsPerWord;
    private char[] remainedChars;

    public BaseDecoder(char[] alphabet) {
        int i;
        for (i = 0; i < this.bytes.length; ++i) {
            this.bytes[i] = -1;
        }
        for (i = 0; i < alphabet.length; i = (int)((byte)(i + 1))) {
            int index = alphabet[i] - 33;
            try {
                if (this.bytes[index] != -1) {
                    throw new IllegalArgumentException("Duplicated alphabet: '" + alphabet[i] + "'");
                }
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                throw new IllegalArgumentException("Illegal alphabet: '" + alphabet[i] + "'");
            }
            this.bytes[index] = i;
        }
        this.bitsPerChar = (int)(Math.log(alphabet.length) / Math.log(2.0));
        this.bytesPerWord = this.lcm(8, this.bitsPerChar) / 8;
        this.charsPerWord = this.lcm(8, this.bitsPerChar) / this.bitsPerChar;
        this.remainedChars = new char[0];
        this._finalized = false;
    }

    private void _decode(char[] in, int inoff, byte[] out, int outoff, boolean padAllowed) throws IllegalAlphabetException {
        int intValue = 0;
        int bitsInInt = 0;
        int byteIndex = this.bytesPerWord - 1;
        for (int i = this.charsPerWord - 1; i >= 0; --i) {
            char ch = in[inoff + i];
            intValue |= this.getByte(ch, padAllowed) << bitsInInt;
            int byteCount = (bitsInInt += this.bitsPerChar) / 8;
            for (int j = 0; j < byteCount; ++j) {
                out[outoff + byteIndex--] = (byte)(intValue & 0xFF);
                intValue >>= 8;
                bitsInInt -= 8;
            }
        }
    }

    private byte[] _decode(char[] in, int off, int len) throws IllegalAlphabetException {
        int all = this.remainedChars.length + len;
        int rem = all % this.charsPerWord;
        char[] abuf = new char[all];
        System.arraycopy(this.remainedChars, 0, abuf, 0, this.remainedChars.length);
        System.arraycopy(in, off, abuf, this.remainedChars.length, len);
        if (all / this.charsPerWord > 0) {
            rem += this.charsPerWord;
            all -= this.charsPerWord;
        }
        this.remainedChars = new char[rem];
        System.arraycopy(abuf, abuf.length - this.remainedChars.length, this.remainedChars, 0, this.remainedChars.length);
        char[] cbuf = new char[all];
        System.arraycopy(abuf, 0, cbuf, 0, cbuf.length);
        int words = cbuf.length / this.charsPerWord;
        if (words == 0) {
            return new byte[0];
        }
        byte[] bbuf = new byte[words * this.bytesPerWord];
        for (int i = 0; i < words; ++i) {
            int coff = i * this.charsPerWord;
            int boff = i * this.bytesPerWord;
            this._decode(cbuf, coff, bbuf, boff, false);
        }
        return bbuf;
    }

    private byte[] _decodeFinal(char[] in, int off, int len) throws IllegalAlphabetException, BadPaddingException {
        if (this._finalized) {
            throw new IllegalStateException("Hasn't been reset");
        }
        this._decode(in, off, len);
        this._finalized = true;
        if (this.remainedChars.length == 0) {
            return new byte[0];
        }
        if (this.remainedChars.length % this.charsPerWord > 0) {
            throw new BadPaddingException("Not aligned to " + this.charsPerWord);
        }
        char[] cbuf = this.remainedChars;
        int words = cbuf.length / this.charsPerWord;
        byte[] bbuf = new byte[words * this.bytesPerWord];
        --words;
        for (int i = 0; i < words; ++i) {
            int coff = i * this.charsPerWord;
            int boff = i * this.bytesPerWord;
            this._decode(cbuf, coff, bbuf, boff, false);
        }
        int coff = words * this.charsPerWord;
        int boff = words * this.bytesPerWord;
        this._decode(cbuf, coff, bbuf, boff, true);
        int ipad = -1;
        for (int i = 0; i < this.charsPerWord; ++i) {
            if (cbuf[cbuf.length - this.charsPerWord + i] != '=') continue;
            ipad = i;
            break;
        }
        if (ipad != -1) {
            int min = 8 / this.bitsPerChar;
            if (ipad <= min) {
                throw new BadPaddingException();
            }
            if (ipad * this.bitsPerChar / 8 == (ipad - 1) * this.bitsPerChar / 8) {
                throw new BadPaddingException();
            }
            int vali = ipad * this.bitsPerChar / 8;
            int inva = this.bytesPerWord - vali;
            byte[] bbuf2 = new byte[bbuf.length - inva];
            System.arraycopy(bbuf, 0, bbuf2, 0, bbuf2.length);
            return bbuf2;
        }
        return bbuf;
    }

    public byte[] decode(char[] in) throws IllegalAlphabetException {
        return this.decode(in, 0, in.length);
    }

    public byte[] decode(char[] in, int off, int len) throws IllegalAlphabetException {
        return this._decode(in, off, len);
    }

    public byte[] decodeFinal() throws IllegalAlphabetException, BadPaddingException {
        return this.decodeFinal(new char[0]);
    }

    public byte[] decodeFinal(char[] in) throws IllegalAlphabetException, BadPaddingException {
        return this.decodeFinal(in, 0, in.length);
    }

    public byte[] decodeFinal(char[] in, int off, int len) throws IllegalAlphabetException, BadPaddingException {
        return this._decodeFinal(in, off, len);
    }

    private int gcd(int a, int b) {
        return b == 0 ? a : this.gcd(b, a % b);
    }

    private byte getByte(char ch, boolean padAllowed) throws IllegalAlphabetException {
        if (ch == '=') {
            if (padAllowed) {
                return 0;
            }
            throw new IllegalAlphabetException(ch);
        }
        int index = ch - 33;
        if (index < 0 || index >= this.bytes.length) {
            throw new IllegalArgumentException("Unknown char: " + ch + "(" + index);
        }
        byte b = this.bytes[index];
        if (b == -1) {
            throw new IllegalArgumentException("Unknown char?: " + ch);
        }
        return b;
    }

    public boolean isValidCharacter(char ch) {
        try {
            return this.bytes[ch - 33] != -1;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            return false;
        }
    }

    private int lcm(int a, int b) {
        return a * b / this.gcd(a, b);
    }

    public BaseDecoder reset() {
        this.remainedChars = new char[0];
        this._finalized = false;
        return this;
    }

    public static class IllegalAlphabetException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public IllegalAlphabetException() {
        }

        public IllegalAlphabetException(char ch) {
            this("Illegal alphabet: " + ch);
        }

        public IllegalAlphabetException(String message) {
            super(message);
        }
    }

    public static class BadPaddingException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public BadPaddingException() {
            super("Bad padding");
        }

        public BadPaddingException(String message) {
            super(message);
        }
    }
}

