/*
 * Decompiled with CFR 0.152.
 */
package jd.crypt;

import jd.crypt.AEStables;
import jd.crypt.Copy;

public class Enc {
    private static final int Nb = 4;
    private int Nk;
    private int Nr;
    private AEStables tab;
    private byte[] w;
    private int wCount;

    public Enc(byte[] key, int NkIn) {
        this.Nk = NkIn;
        this.Nr = this.Nk + 6;
        this.tab = new AEStables();
        this.w = new byte[16 * (this.Nr + 1)];
        this.KeyExpansion(key, this.w);
    }

    private void AddRoundKey(byte[][] state) {
        for (int c = 0; c < 4; ++c) {
            for (int r = 0; r < 4; ++r) {
                state[r][c] = (byte)(state[r][c] ^ this.w[this.wCount++]);
            }
        }
    }

    public void Cipher(byte[] in, byte[] out) {
        this.wCount = 0;
        byte[][] state = new byte[4][4];
        Copy.copy(state, in);
        this.AddRoundKey(state);
        for (int round = 1; round < this.Nr; ++round) {
            this.SubBytes(state);
            this.ShiftRows(state);
            this.MixColumns(state);
            this.AddRoundKey(state);
        }
        this.SubBytes(state);
        this.ShiftRows(state);
        this.AddRoundKey(state);
        Copy.copy(out, state);
    }

    private void KeyExpansion(byte[] key, byte[] w) {
        int j;
        byte[] temp = new byte[4];
        for (j = 0; j < 4 * this.Nk; ++j) {
            w[j] = (byte)(key[j] + (byte)j);
        }
        while (j < 16 * (this.Nr + 1)) {
            int iTemp;
            int i = j / 4;
            for (iTemp = 0; iTemp < 4; ++iTemp) {
                temp[iTemp] = w[j - 4 + iTemp];
            }
            if (i % this.Nk == 0) {
                byte oldtemp0 = temp[0];
                for (int iTemp2 = 0; iTemp2 < 4; ++iTemp2) {
                    byte ttemp = iTemp2 == 3 ? oldtemp0 : temp[iTemp2 + 1];
                    byte tRcon = iTemp2 == 0 ? this.tab.Rcon(i / this.Nk) : (byte)0;
                    temp[iTemp2] = (byte)(this.tab.SBox(ttemp) ^ tRcon);
                }
            } else if (this.Nk > 6 && i % this.Nk == 4) {
                for (iTemp = 0; iTemp < 4; ++iTemp) {
                    temp[iTemp] = this.tab.SBox(temp[iTemp]);
                }
            }
            for (iTemp = 0; iTemp < 4; ++iTemp) {
                w[j + iTemp] = (byte)(w[j - 4 * this.Nk + iTemp] ^ temp[iTemp]);
            }
            j += 4;
        }
    }

    private void MixColumns(byte[][] s) {
        int[] sp = new int[4];
        byte b02 = 2;
        byte b03 = 3;
        for (int c = 0; c < 4; ++c) {
            sp[0] = this.tab.FFMul(b02, s[0][c]) ^ this.tab.FFMul(b03, s[1][c]) ^ s[2][c] ^ s[3][c];
            sp[1] = s[0][c] ^ this.tab.FFMul(b02, s[1][c]) ^ this.tab.FFMul(b03, s[2][c]) ^ s[3][c];
            sp[2] = s[0][c] ^ s[1][c] ^ this.tab.FFMul(b02, s[2][c]) ^ this.tab.FFMul(b03, s[3][c]);
            sp[3] = this.tab.FFMul(b03, s[0][c]) ^ s[1][c] ^ s[2][c] ^ this.tab.FFMul(b02, s[3][c]);
            for (int i = 0; i < 4; ++i) {
                s[i][c] = (byte)sp[i];
            }
        }
    }

    private void ShiftRows(byte[][] state) {
        byte[] t = new byte[4];
        for (int r = 1; r < 4; ++r) {
            int c;
            for (c = 0; c < 4; ++c) {
                t[c] = state[r][(c + r) % 4];
            }
            for (c = 0; c < 4; ++c) {
                state[r][c] = t[c];
            }
        }
    }

    private void SubBytes(byte[][] state) {
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 4; ++col) {
                state[row][col] = this.tab.SBox(state[row][col]);
            }
        }
    }
}

