/*
 * Decompiled with CFR 0.152.
 */
package jd.parser.html;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jd.http.requests.FormData;
import jd.nutils.encoding.HTMLEntities;
import jd.parser.Regex;
import jd.parser.html.InputField;
import jd.utils.EditDistance;
import org.appwork.utils.StringUtils;
import org.appwork.utils.net.URLHelper;

public class Form {
    private String action;
    private final List<InputField> inputfields = new ArrayList<InputField>();
    private String htmlcode = null;
    private MethodType method = MethodType.GET;
    private String encoding = "application/x-www-form-urlencoded";
    private InputField preferredSubmit;
    private final HashMap<String, String> keyValueMap = new HashMap();
    public static final String ATTRIBUTE_NAME_PATTERN = "[^\t\n\f />\"'=\\p{Cntrl}]+";

    public static Form[] getForms(Object requestInfo) {
        LinkedList<Form> forms = new LinkedList<Form>();
        Pattern pattern = Pattern.compile("<\\s*form\\s+([^>]*)/\\s*>|<\\s*form(?:>|\\s+[^>]*>)(.*?)<\\s*/\\s*form\\s*>|<\\s*form(?:>|\\s+[^>]*>)(.+)", 34);
        String requestHtml = requestInfo.toString().replaceAll("(?s)<!--.*?-->", "");
        Matcher formmatcher = pattern.matcher(requestHtml);
        while (formmatcher.find()) {
            String total = formmatcher.group(0);
            Form form = new Form(total);
            forms.add(form);
        }
        return forms.toArray(new Form[forms.size()]);
    }

    public Form() {
    }

    public Form(String html) {
        this();
        this.parse(html);
    }

    public void addInputField(InputField nv) {
        this.addInputFieldAt(nv, -1);
    }

    public void addInputFieldAt(InputField nv, int index) {
        if (nv != null) {
            List<InputField> inputFields = this.getInputFields();
            if (index < 0 || index > inputFields.size()) {
                inputFields.add(nv);
            } else {
                inputFields.add(index, nv);
            }
        }
    }

    public boolean containsHTML(String needle) {
        return new Regex(this.getHtmlCode(), needle).matches();
    }

    public boolean equalsIgnoreCase(Form f) {
        return this.toString().equalsIgnoreCase(f.toString());
    }

    public String getAction() {
        return this.action;
    }

    public String getAction(URL base) {
        boolean actionIsHTTP;
        String formAction = this.getAction();
        if ("".equals(formAction) && base != null) {
            return base.toString();
        }
        boolean baseIsHTTPs = base != null && "https".equalsIgnoreCase(base.getProtocol());
        boolean actionIsHTTPs = formAction != null && formAction.startsWith("https://");
        boolean bl = actionIsHTTP = formAction != null && formAction.startsWith("http://");
        String ret = base != null && StringUtils.isNotEmpty((String)this.action) ? URLHelper.parseLocation((URL)base, (String)this.action) : (StringUtils.isNotEmpty((String)this.action) && this.action.matches("^https?://.+") ? this.action.replaceAll(" ", "%20") : (base != null && StringUtils.isEmpty((String)this.action) ? base.toString() : null));
        if (ret != null && baseIsHTTPs && (actionIsHTTPs || !actionIsHTTP)) {
            return ret.replaceFirst("http://", "https://");
        }
        try {
            return URLHelper.fixPathTraversal((URL)new URL(ret)).toString();
        }
        catch (MalformedURLException e) {
            return ret;
        }
    }

    public String getBestVariable(String varname) {
        String best = null;
        int bestDist = Integer.MAX_VALUE;
        for (InputField ipf : this.getInputFields()) {
            int dist = EditDistance.getLevenshteinDistance(varname, ipf.getKey());
            if (dist >= bestDist) continue;
            best = ipf.getKey();
            bestDist = dist;
        }
        return best;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getHtmlCode() {
        return this.htmlcode;
    }

    @Deprecated
    public InputField getInputField(String key) {
        return this.getInputFieldByName(key);
    }

    public InputField getInputFieldByName(String name) {
        List<InputField> ret = this.getInputFields("(?i)" + Pattern.quote(name), null, new InputField.ElementType[0]);
        if (ret.size() > 0) {
            return ret.get(0);
        }
        return null;
    }

    @Deprecated
    public InputField getInputFieldByNameRegex(String keyPattern) {
        List<InputField> ret = this.getInputFields(keyPattern, null, new InputField.ElementType[0]);
        if (ret.size() > 0) {
            return ret.get(0);
        }
        return null;
    }

    @Deprecated
    public InputField getInputFieldByType(String type) {
        for (InputField ipf : this.getInputFields()) {
            if (!StringUtils.equalsIgnoreCase((String)ipf.getElementType().type(), (String)type)) continue;
            return ipf;
        }
        return null;
    }

    public List<InputField> getInputFields() {
        return this.inputfields;
    }

    public List<InputField> getInputFields(String keyPattern, String valuePattern, InputField.ElementType ... types) {
        Pattern pattern;
        InputField next;
        Iterator it;
        ArrayList<InputField> ret = new ArrayList<InputField>(this.getInputFields());
        if (types != null && types.length > 0 && ret.size() > 0) {
            HashSet<InputField.ElementType> typesSet = new HashSet<InputField.ElementType>(Arrays.asList(types));
            it = ret.iterator();
            while (it.hasNext()) {
                next = (InputField)it.next();
                if (typesSet.contains(next.getElementType())) continue;
                it.remove();
            }
        }
        if (keyPattern != null && ret.size() > 0) {
            pattern = Pattern.compile(keyPattern);
            it = ret.iterator();
            while (it.hasNext()) {
                next = (InputField)it.next();
                String key = StringUtils.valueOrEmpty((String)next.getKey());
                if (pattern.matcher(key).matches()) continue;
                it.remove();
            }
        }
        if (valuePattern != null && ret.size() > 0) {
            pattern = Pattern.compile(valuePattern);
            it = ret.iterator();
            while (it.hasNext()) {
                next = (InputField)it.next();
                String value = StringUtils.valueOrEmpty((String)next.getValue());
                if (pattern.matcher(value).matches()) continue;
                it.remove();
            }
        }
        return ret;
    }

    @Deprecated
    public List<InputField> getInputFieldsByType(String type) {
        ArrayList<InputField> ret = new ArrayList<InputField>();
        for (InputField ipf : this.getInputFields()) {
            if (!org.appwork.utils.Regex.matches((Object)ipf.getElementType().type(), (String)type)) continue;
            ret.add(ipf);
        }
        return ret;
    }

    public MethodType getMethod() {
        return this.method;
    }

    public InputField getPreferredSubmit() {
        InputField preferredSubmit = this.preferredSubmit;
        if (preferredSubmit != null && !preferredSubmit.isDisabled() && this.getInputFields().contains(preferredSubmit)) {
            return preferredSubmit;
        }
        InputField bestSubmit = null;
        for (InputField inputField : this.getInputFields()) {
            if (!inputField.isSubmitType() || inputField.isDisabled()) continue;
            if (bestSubmit == null) {
                bestSubmit = inputField;
                continue;
            }
            if (bestSubmit.getKey() == null && inputField.getKey() != null) {
                bestSubmit = inputField;
                continue;
            }
            if (bestSubmit.getValue() != null || inputField.getValue() == null) continue;
            bestSubmit = inputField;
        }
        return bestSubmit;
    }

    @Deprecated
    public String getPropertyString() {
        StringBuilder stbuffer = new StringBuilder();
        for (InputField ipf : this.getInputFields()) {
            if (ipf.getKey() == null || ipf.isDisabled()) continue;
            if (stbuffer.length() > 0) {
                stbuffer.append("&");
            }
            stbuffer.append(ipf.getKey());
            stbuffer.append("=");
            stbuffer.append(ipf.getValue());
        }
        return stbuffer.toString();
    }

    public Regex getRegex(Pattern compile) {
        return new Regex((Object)this.getHtmlCode(), compile);
    }

    public Regex getRegex(String string) {
        return new Regex(this.getHtmlCode(), string);
    }

    public List<FormData> getFormData() {
        InputField preferredSubmit = this.getPreferredSubmit();
        ArrayList<FormData> ret = new ArrayList<FormData>();
        for (InputField entry : this.getInputFields()) {
            String key = entry.getKey();
            if (preferredSubmit != null && entry.isSubmitType() && preferredSubmit != entry || entry.isDisabled() || key == null) continue;
            if (entry.isType(InputField.InputType.IMAGE)) {
                String yValue;
                String yKey;
                String xValue;
                String xKey = key + ".x";
                if (this.getInputField(xKey) == null && (xValue = entry.getProperty("x", null)) != null) {
                    ret.add(new FormData(xKey, xValue));
                }
                if (this.getInputField(yKey = key + ".y") != null || (yValue = entry.getProperty("y", null)) == null) continue;
                ret.add(new FormData(yKey, yValue));
                continue;
            }
            if (entry.isType(InputField.InputType.FILE)) {
                File postFile = entry.getFileToPost();
                if (postFile == null) continue;
                ret.add(new FormData(key, postFile.getName(), postFile));
                continue;
            }
            ret.add(new FormData(key, entry.getValue()));
        }
        return ret;
    }

    public String getStringProperty(String property) {
        return this.keyValueMap.get(property);
    }

    public HashMap<String, String> getVarsMap() {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (InputField ipf : this.getInputFields()) {
            if (ipf.getKey() == null || ipf.isDisabled()) continue;
            ret.put(ipf.getKey(), ipf.getValue());
        }
        return ret;
    }

    public boolean hasInputFieldByName(String name) {
        return this.getInputFieldByName(name) != null;
    }

    /*
     * Unable to fully structure code
     */
    private void parse(String html) {
        this.htmlcode = html;
        header = new Regex(html, "<\\s*form(.*?)>").getMatch(0);
        headerEntries = new ArrayList<String[]>();
        block0: while (true) lbl-1000:
        // 3 sources

        {
            block3: {
                quotedAttributes = new Regex(header, "(([^\t\n\f />\"'=\\p{Cntrl}]+)\\s*=\\s*('|\")(.*?)\\3)").getMatches();
                unQuotedAttributes = new Regex(header, "(([^\t\n\f />\"'=\\p{Cntrl}]+)\\s*=\\s*(.*?)( |$))").getMatches();
                if (quotedAttributes == null || quotedAttributes.length <= 0) break block3;
                var6_6 = quotedAttributes;
                var7_7 = var6_6.length;
                var8_8 = 0;
                while (true) {
                    if (var8_8 >= var7_7) ** GOTO lbl-1000
                    quotedAttribute = var6_6[var8_8];
                    headerEntries.add(new String[]{quotedAttribute[1], quotedAttribute[3]});
                    header = header.replaceFirst(Pattern.quote(quotedAttribute[0]), " ");
                    ++var8_8;
                }
            }
            if (unQuotedAttributes == null || unQuotedAttributes.length <= 0) break;
            var6_6 = unQuotedAttributes;
            var7_7 = var6_6.length;
            var8_8 = 0;
            while (true) {
                if (var8_8 >= var7_7) continue block0;
                unQuotedAttribute = var6_6[var8_8];
                headerEntries.add(new String[]{unQuotedAttribute[1], unQuotedAttribute[2]});
                header = header.replaceFirst(Pattern.quote(unQuotedAttribute[0]), " ");
                ++var8_8;
            }
            break;
        }
        this.parseHeader((String[][])headerEntries.toArray((T[])new String[0][]));
        this.inputfields.addAll(Form.parseInputFields(html));
    }

    private void parseHeader(String[][] headerEntries) {
        if (headerEntries != null) {
            for (String[] entry : headerEntries) {
                String value;
                String key;
                if (entry.length == 3) {
                    key = entry[0];
                    value = entry[2];
                } else {
                    key = entry[0];
                    value = entry[1];
                }
                String lowvalue = value.toLowerCase(Locale.ENGLISH);
                if (key.equalsIgnoreCase("action")) {
                    this.setAction(HTMLEntities.unhtmlentities((String)value));
                    continue;
                }
                if (key.equalsIgnoreCase("enctype")) {
                    this.setEncoding(value);
                    continue;
                }
                if (key.equalsIgnoreCase("method")) {
                    if (lowvalue.matches(".*post.*")) {
                        this.setMethod(MethodType.POST);
                        continue;
                    }
                    if (lowvalue.matches(".*get.*")) {
                        this.setMethod(MethodType.GET);
                        continue;
                    }
                    this.setMethod(MethodType.POST);
                    continue;
                }
                this.setProperty(key, value);
            }
        }
    }

    public static final ArrayList<InputField> parseInputFields(String htmlCode) {
        ArrayList<InputField> inputfields = new ArrayList<InputField>();
        String escapedHtmlCode = htmlCode;
        escapedHtmlCode = escapedHtmlCode.replaceAll("(?s)<!--.*?-->", "");
        escapedHtmlCode = escapedHtmlCode.replaceAll("(?s)<script[^>]*>.*?</script>", "");
        ArrayList<String> values = new ArrayList<String>();
        long random = System.nanoTime();
        for (Pattern valuePattern : new Pattern[]{Pattern.compile("(?s)(?<!\\\\)\"(((?!VALUE-" + random + "-).)*?)(?<!\\\\)\""), Pattern.compile("(?s)(?<!\\\\)'(((?!VALUE-" + random + "-).)*?)(?<!\\\\)'")}) {
            StringBuffer sb = new StringBuffer();
            Matcher matcher = valuePattern.matcher(escapedHtmlCode);
            while (matcher.find()) {
                String value = matcher.group(1);
                if (value == null) continue;
                int index = values.indexOf(value);
                if (index == -1) {
                    index = values.size();
                    values.add(value);
                }
                matcher.appendReplacement(sb, "VALUE-" + random + "-" + index + " ");
            }
            if (sb.length() <= 0) continue;
            matcher.appendTail(sb);
            escapedHtmlCode = sb.toString();
        }
        Matcher matcher = Pattern.compile("(?s)(<\\s*(input|textarea|button).*?>)", 2).matcher(escapedHtmlCode);
        while (matcher.find()) {
            InputField nv = InputField.parse(matcher.group(1), random, values);
            if (nv == null) continue;
            inputfields.add(nv);
        }
        matcher = Pattern.compile("(?s)(<\\s*select.*?</select>)", 2).matcher(escapedHtmlCode);
        while (matcher.find()) {
            InputField nv = InputField.parse(matcher.group(1), random, values);
            if (nv == null) continue;
            inputfields.add(nv);
        }
        return inputfields;
    }

    public void put(String key, String value) {
        InputField ipf = this.getInputField(key);
        if (ipf != null) {
            ipf.setValue(value);
        } else {
            this.addInputField(new InputField(key, value));
        }
    }

    public void remove(String key) {
        Iterator<InputField> it = this.getInputFields().iterator();
        while (it.hasNext()) {
            InputField ipf = it.next();
            if (ipf.getKey() == null && key == null) {
                it.remove();
                return;
            }
            if (ipf.getKey() == null || !ipf.getKey().equalsIgnoreCase(key)) continue;
            it.remove();
            return;
        }
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setMethod(MethodType method) {
        this.method = method;
    }

    public void setPreferredSubmit(String preferredSubmit) {
        this.preferredSubmit = null;
        for (InputField ipf : this.getInputFields()) {
            if (!ipf.isSubmitType() || !StringUtils.equalsIgnoreCase((String)ipf.getValue(), (String)preferredSubmit) || !this.setPreferredSubmit(ipf)) continue;
            return;
        }
        for (InputField ipf : this.getInputFields()) {
            if (!ipf.isSubmitType() || !StringUtils.containsIgnoreCase((String)ipf.getValue(), (String)preferredSubmit) || !this.setPreferredSubmit(ipf)) continue;
            return;
        }
        throw new IllegalArgumentException("No such Submitfield: " + preferredSubmit);
    }

    public boolean setPreferredSubmit(InputField preferredSubmit) {
        if (preferredSubmit == null || preferredSubmit.isSubmitType() && !preferredSubmit.isDisabled() && this.getInputFields().contains(preferredSubmit)) {
            this.preferredSubmit = preferredSubmit;
            return true;
        }
        return true;
    }

    public void setProperty(String key, String value) {
        this.keyValueMap.put(key, value);
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("Action: ");
        ret.append(this.getAction());
        ret.append('\n');
        if (this.method == MethodType.POST) {
            ret.append("Method: POST\n");
        } else if (this.method == MethodType.GET) {
            ret.append("Method: GET\n");
        }
        InputField preferred = this.getPreferredSubmit();
        for (InputField ipf : this.getInputFields()) {
            if (preferred == ipf) {
                ret.append("PreferredSubmit:");
            }
            ret.append(ipf.toString());
            ret.append('\n');
        }
        ret.append(this.keyValueMap.toString());
        ret.append('\n');
        ret.append("FormData:");
        ret.append(this.getFormData());
        return ret.toString();
    }

    public boolean removeInputField(InputField f) {
        return f != null && this.getInputFields().remove(f);
    }

    public static enum MethodType {
        GET,
        POST;

    }
}

