/*
 * Decompiled with CFR 0.152.
 */
package jd.parser.html;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jd.parser.Regex;
import org.appwork.utils.DebugMode;
import org.appwork.utils.StringUtils;

public class InputField {
    private String key;
    private String value = null;
    private Map<String, String> properties = null;
    private final ElementType elementType;
    private Boolean disabledFlag = null;

    public static InputField parse(String data) {
        return InputField.parse(data, -1L, null);
    }

    protected static InputField parse(String data, long random, List<String> values) {
        String element = new Regex(data, "\\s*<\\s*(button|input|select|textarea)").getMatch(0);
        if (element == null && DebugMode.TRUE_IN_IDE_ELSE_FALSE) {
            new Exception("update element parser/support:" + data).printStackTrace();
        }
        ArrayList<String> cleanupRegex = new ArrayList<String>();
        cleanupRegex.add("([^\t\n\f />\"'=\\p{Cntrl}]+\\s*=\\s*\"[^\"]*\")");
        cleanupRegex.add("([^\t\n\f />\"'=\\p{Cntrl}]+\\s*=\\s*'[^']*')");
        for (String reg : cleanupRegex) {
            String[] results = new Regex(data, reg).getColumn(0);
            if (results == null) continue;
            String quote = new Regex(reg, "(\"|')").getMatch(0);
            for (String result : results) {
                String cleanedResult = result.replaceFirst(quote, "\\\"").replaceFirst(quote + "$", "\\\"");
                data = data.replace(result, cleanedResult);
            }
        }
        boolean cbr = false;
        boolean checked = false;
        boolean disabled = false;
        ArrayList<String> matches = new ArrayList<String>();
        matches.add("\\s?+type\\s?+=\\s?+\"?(checkbox|radio)?\"");
        matches.add("\\s+(checked)\\s?+");
        matches.add("\\s+(disabled)\\s?+");
        for (String reg : matches) {
            String result = new Regex(data, reg).getMatch(0);
            if (result == null) continue;
            if (result.matches("(?i)disabled")) {
                disabled = true;
                continue;
            }
            if (result.matches("(?i)checked")) {
                checked = true;
                continue;
            }
            if (!result.matches("(?i)checkbox|radio")) continue;
            cbr = true;
        }
        ArrayList<String> input = new ArrayList<String>();
        input.add("[\"']{0,1}\\s*(\\w+)\\s*=\\s*\"(.*?)\"");
        input.add("(?!(?:https?://)?[^\\s]+[/\\w\\-\\.\\?&=]+)[\"']{0,1}\\s*(\\w+)\\s*=\\s*([^\\s\"'>]+)");
        String type = null;
        String key = null;
        String value = null;
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        int selectValues = 0;
        String valueReplacement = "VALUE-" + random + "-";
        for (String reg : input) {
            String[][] results;
            for (String[] match : results = new Regex(data, reg).getMatches()) {
                int index;
                if (values != null && match[1].matches("^" + valueReplacement + "\\d+$") && (index = Integer.parseInt(match[1].substring(valueReplacement.length()))) >= 0 && index < values.size()) {
                    match[1] = values.get(index);
                }
                if (match[0].equalsIgnoreCase("type") && type == null) {
                    type = match[1];
                    continue;
                }
                if (match[0].equalsIgnoreCase("name") && key == null) {
                    key = InputField.formEncoding(match[1]);
                    continue;
                }
                if (match[0].equalsIgnoreCase("value") && value == null) {
                    value = InputField.formEncoding(match[1]);
                    properties.put("<INPUTFIELD:TYPEVALUE>", value);
                    if (!cbr || checked) continue;
                    properties.put("<INPUTFIELD:CHECKED>", "false");
                    value = InputField.formEncoding(null);
                    continue;
                }
                if (match[0].equalsIgnoreCase("value") && value != null && "select".equalsIgnoreCase(element)) {
                    if (selectValues == 0) {
                        properties.put("<SELECT:VALUE:0>", value);
                    }
                    int n = ++selectValues;
                    ++selectValues;
                    properties.put("<SELECT:VALUE:" + n + ">", InputField.formEncoding(match[1]));
                    continue;
                }
                properties.put(InputField.formEncoding(match[0]), InputField.formEncoding(match[1]));
            }
        }
        if (disabled) {
            properties.put("<INPUTFIELD:DISABLED>", "true");
        }
        InputField ret = new InputField(key, value, type, element);
        if (properties.size() > 0) {
            ret.setProperties(properties);
        }
        return ret;
    }

    public boolean isDisabled() {
        Boolean disabledFlag = this.disabledFlag;
        if (disabledFlag != null) {
            return disabledFlag;
        }
        Map<String, String> properties = this.properties;
        return properties != null && "true".equals(properties.get("<INPUTFIELD:DISABLED>"));
    }

    public void setDisabled(boolean disabledFlag) {
        this.disabledFlag = disabledFlag;
        if (!disabledFlag && this.properties != null) {
            this.putProperty("<INPUTFIELD:DISABLED>", "false");
        } else if (disabledFlag) {
            this.putProperty("<INPUTFIELD:DISABLED>", "true");
        }
    }

    private static String formEncoding(String str) {
        if (str == null) {
            return null;
        }
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    private void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public InputField(String key, String value) {
        this(key, value, InputType.HIDDEN);
    }

    public InputField(String key, String value, ElementType type) {
        this.elementType = type;
        this.key = key;
        this.value = this.isSubmitType() && value == null ? "" : value;
        if (this.isType(InputType.FILE)) {
            this.setDisabled(true);
        }
    }

    protected InputField(String key, String value, String type, String element) {
        this(key, value, Element.parse(element, type));
    }

    public File getFileToPost() {
        if (!this.isType(InputType.FILE)) {
            throw new IllegalStateException("No file post field:" + this.getElementType());
        }
        if (this.value == null) {
            return null;
        }
        return new File(this.value);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        if (key != null) {
            this.key = key;
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj instanceof InputField) {
            InputField o = (InputField)obj;
            return StringUtils.equals((String)this.getKey(), (String)o.getKey()) && StringUtils.equals((String)this.getValue(), (String)o.getValue()) && this.getElementType().equals(o.getElementType());
        }
        return false;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String getProperty(String key, String defValue) {
        Map<String, String> properties = this.properties;
        String ret = properties != null ? properties.get(key) : null;
        return ret != null ? ret : defValue;
    }

    public ElementType getElementType() {
        return this.elementType;
    }

    public boolean isType(ElementType type) {
        return type != null && type.equals(this.getElementType());
    }

    public boolean isSubmitType() {
        return InputType.SUBMIT.equals(this.getElementType()) || ButtonType.SUBMIT.equals(this.getElementType());
    }

    public String getValue() {
        return this.value;
    }

    public void setFileToPost(File file) {
        if (!this.isType(InputType.FILE)) {
            throw new IllegalStateException("No file post field:" + this.getElementType());
        }
        this.value = file == null ? null : file.getAbsolutePath();
    }

    public String toString() {
        Map<String, String> properties = this.properties;
        if (properties != null) {
            return "Field: " + this.getKey() + "(" + this.getElementType() + ") = " + this.getValue() + " [" + properties.toString() + "]";
        }
        return "Field: " + this.getKey() + "(" + this.getElementType() + ") = " + this.getValue() + " []";
    }

    public void setValue(String value2) {
        this.value = value2 != null ? value2.trim() : null;
    }

    public boolean containsProperty(String key) {
        Map<String, String> properties = this.properties;
        return properties != null && properties.containsKey(key);
    }

    public boolean containsPropertyKeyValue(String key, String value) {
        Map<String, String> properties = this.properties;
        return properties != null && this.containsProperty(key) && value.equals(properties.get(key));
    }

    public void putProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, String>();
        }
        this.properties.put(key, value);
    }

    public static enum InputType implements ElementType
    {
        BUTTON,
        CHECKBOX,
        COLOR,
        DATE,
        EMAIL,
        FILE,
        HIDDEN,
        IMAGE,
        MONTH,
        NUMBER,
        PASSWORD,
        RADIO,
        RANGE,
        RESET,
        SEARCH,
        SUBMIT,
        TEL,
        TEXT,
        TIME,
        URL,
        WEEK;


        private static InputType parse(String element, String type) {
            if (StringUtils.equalsIgnoreCase((String)element, (String)"input")) {
                String typeString = StringUtils.toUpperCaseOrNull((String)type, (Locale)Locale.ENGLISH);
                try {
                    return typeString != null ? InputType.valueOf(typeString) : null;
                }
                catch (IllegalArgumentException ignore) {
                    return null;
                }
            }
            return null;
        }

        public String toString() {
            return (Object)((Object)this.getElementType()) + ":" + this.type();
        }

        @Override
        public Element getElementType() {
            return Element.INPUTFIELD;
        }

        @Override
        public String type() {
            return this.name();
        }

        @Override
        public String element() {
            return this.getElementType().name();
        }
    }

    public static enum SelectType implements ElementType
    {
        SELECT;


        private static SelectType parse(String element, String type) {
            if (StringUtils.equalsIgnoreCase((String)element, (String)"select")) {
                return SELECT;
            }
            return null;
        }

        public String toString() {
            return (Object)((Object)this.getElementType()) + ":" + this.type();
        }

        @Override
        public Element getElementType() {
            return Element.SELECT;
        }

        @Override
        public String type() {
            return this.name();
        }

        @Override
        public String element() {
            return this.getElementType().name();
        }
    }

    public static enum TextAreaType implements ElementType
    {
        TEXTAREA;


        private static TextAreaType parse(String element, String type) {
            if (StringUtils.equalsIgnoreCase((String)element, (String)"textarea")) {
                return TEXTAREA;
            }
            return null;
        }

        public String toString() {
            return (Object)((Object)this.getElementType()) + ":" + this.type();
        }

        @Override
        public Element getElementType() {
            return Element.TEXTAREA;
        }

        @Override
        public String type() {
            return this.name();
        }

        @Override
        public String element() {
            return this.getElementType().name();
        }
    }

    public static enum ButtonType implements ElementType
    {
        SUBMIT,
        RESET,
        BUTTON;


        private static ButtonType parse(String element, String type) {
            if (StringUtils.equalsIgnoreCase((String)element, (String)"button")) {
                String typeString = StringUtils.toUpperCaseOrNull((String)type, (Locale)Locale.ENGLISH);
                try {
                    return typeString != null ? ButtonType.valueOf(typeString) : SUBMIT;
                }
                catch (IllegalArgumentException ignore) {
                    return SUBMIT;
                }
            }
            return null;
        }

        public String toString() {
            return (Object)((Object)this.getElementType()) + ":" + this.type();
        }

        @Override
        public Element getElementType() {
            return Element.BUTTON;
        }

        @Override
        public String type() {
            return this.name();
        }

        @Override
        public String element() {
            return this.getElementType().name();
        }
    }

    public static interface ElementType {
        public Element getElementType();

        public String type();

        public String element();
    }

    public static class UnknownType
    implements ElementType {
        private final String element;
        private final String type;

        public UnknownType(String element, String type) {
            this.element = element;
            this.type = type;
        }

        @Override
        public String type() {
            return this.type;
        }

        @Override
        public Element getElementType() {
            return Element.UNKNOWN;
        }

        @Override
        public String element() {
            return this.element;
        }

        public String toString() {
            return (Object)((Object)this.getElementType()) + ":" + this.element() + "=" + this.type;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj instanceof ElementType) {
                ElementType o = (ElementType)obj;
                return this.getElementType().equals((Object)o.getElementType()) && StringUtils.equalsIgnoreCase((String)this.type(), (String)o.type()) && StringUtils.equalsIgnoreCase((String)this.element(), (String)o.element());
            }
            return false;
        }
    }

    public static enum Element {
        BUTTON,
        INPUTFIELD,
        SELECT,
        TEXTAREA,
        UNKNOWN;


        private static ElementType parse(String element, String type) {
            ElementType ret = ButtonType.parse(element, type);
            if (ret == null) {
                ret = InputType.parse(element, type);
            }
            if (ret == null) {
                ret = SelectType.parse(element, type);
            }
            if (ret == null) {
                ret = TextAreaType.parse(element, type);
            }
            if (ret == null) {
                ret = new UnknownType(element, type);
            }
            return ret;
        }
    }
}

