/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins;

import java.io.File;
import java.lang.reflect.Field;
import org.appwork.utils.formatter.StringFormatter;
import org.jdownloader.logging.LogController;

public class ContainerStatus {
    public static final int STATUS_INVALID_PASSWORD = 16;
    public static final int STATUS_ABORT = 8;
    public static final int STATUS_FAILED = 4;
    public static final int STATUS_FINISHED = 2;
    public static final int TODO = 1;
    private File container;
    private int status = 1;
    private String statusText;
    private int latestStatus;

    public ContainerStatus() {
    }

    public ContainerStatus(File lc) {
        this.container = lc;
    }

    public File getContainer() {
        return this.container;
    }

    public boolean hasStatus(int status) {
        return (this.status & status) > 0;
    }

    public boolean isStatus(int status) {
        return this.status == status;
    }

    public void removeStatus(int status) {
        this.status ^= status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setStatusText(String l) {
        this.statusText = l;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public String toString() {
        Class<?> cl = this.getClass();
        Field[] fields = cl.getDeclaredFields();
        StringBuilder sb = new StringBuilder();
        sb.append(StringFormatter.fillString((String)Integer.toBinaryString(this.status), (String)"0", (String)"", (int)32) + " <Statuscode\r\n");
        String latest = "";
        for (Field field : fields) {
            if (field.getModifiers() != 25) continue;
            try {
                int value = field.getInt(this);
                if (!this.hasStatus(value)) continue;
                if (value == this.latestStatus) {
                    latest = "latest:" + field.getName() + "\r\n";
                    sb.append(StringFormatter.fillString((String)Integer.toBinaryString(value), (String)"0", (String)"", (int)32) + " |" + field.getName() + "\r\n");
                    continue;
                }
                sb.append(StringFormatter.fillString((String)Integer.toBinaryString(value), (String)"0", (String)"", (int)32) + " |" + field.getName() + "\r\n");
            }
            catch (IllegalArgumentException e) {
                LogController.CL().log((Throwable)e);
            }
            catch (IllegalAccessException e) {
                LogController.CL().log((Throwable)e);
            }
        }
        String ret = latest + sb;
        if (this.statusText != null) {
            ret = ret + "StatusText: " + this.statusText + "\r\n";
        }
        return ret;
    }
}

