/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins;

import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.plugins.DownloadLink;
import jd.plugins.PluginProgress;
import org.appwork.timetracker.TrackerJob;
import org.jdownloader.captcha.v2.WaitForTrackerSlotPluginProcess;

public class DownloadLinkCaptchaTracker
extends TrackerJob {
    private final DownloadLink downloadLink;

    public DownloadLinkCaptchaTracker(String id, DownloadLink link) {
        super(1);
        this.downloadLink = link;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForNextSlot(long waitFor) throws InterruptedException {
        if (this.downloadLink == null) {
            while (waitFor > 0L) {
                DownloadLinkCaptchaTracker downloadLinkCaptchaTracker = this;
                synchronized (downloadLinkCaptchaTracker) {
                    if (waitFor <= 0L) {
                        return;
                    }
                    if (waitFor > 1000L) {
                        ((Object)((Object)this)).wait(1000L);
                    } else {
                        ((Object)((Object)this)).wait(waitFor);
                    }
                    waitFor -= 1000L;
                }
            }
        } else {
            SingleDownloadController controller = this.downloadLink.getDownloadLinkController();
            if (controller != null && controller.isAborting()) {
                throw new InterruptedException("DownloadLink is aborting");
            }
            WaitForTrackerSlotPluginProcess progress = new WaitForTrackerSlotPluginProcess(waitFor, "Captcha-Slot");
            progress.setProgressSource((Object)this);
            progress.setDisplayInProgressColumnEnabled(false);
            try {
                this.downloadLink.addPluginProgress(progress);
                while (!(waitFor <= 0L || controller != null && controller.isAborting())) {
                    ((PluginProgress)progress).setCurrent(waitFor);
                    DownloadLinkCaptchaTracker downloadLinkCaptchaTracker = this;
                    synchronized (downloadLinkCaptchaTracker) {
                        ((Object)((Object)this)).wait(Math.min(1000L, Math.max(0L, waitFor)));
                    }
                    waitFor -= 1000L;
                }
            }
            finally {
                this.downloadLink.removePluginProgress(progress);
            }
            if (controller != null && controller.isAborting()) {
                throw new InterruptedException("DownloadLink is aborting");
            }
        }
    }
}

