/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import jd.config.Property;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.packagecontroller.AbstractNodeNotifier;
import jd.controlling.packagecontroller.AbstractPackageChildrenNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import jd.controlling.packagecontroller.ChildrenView;
import jd.controlling.packagecontroller.PackageController;
import jd.controlling.packagecontroller.PackageControllerComparator;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackageProperty;
import jd.plugins.FilePackageView;
import jd.plugins.PluginStateCollection;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.ModifyLock;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.DomainInfo;
import org.jdownloader.controlling.Priority;
import org.jdownloader.controlling.UniqueAlltimeID;
import org.jdownloader.settings.GeneralSettings;
import org.jdownloader.translate._JDT;

public class FilePackage
extends Property
implements Serializable,
AbstractPackageNode<DownloadLink, FilePackage> {
    private static final GeneralSettings GENERALSETTINGS = (GeneralSettings)JsonConfig.create(GeneralSettings.class);
    private static final long serialVersionUID = -8859842964299890820L;
    private String downloadDirectory = GENERALSETTINGS.getDefaultDownloadFolder();
    private ArrayList<DownloadLink> downloadLinkList;
    private static FilePackage FP = null;
    private String name = null;
    private long created = -1L;
    private long modified = this.created = System.currentTimeMillis();
    private Boolean isExpanded = null;
    private PackageController<FilePackage, DownloadLink> controlledby = null;
    private UniqueAlltimeID uniqueID = null;
    private ModifyLock lock = null;
    public static final String PROPERTY_EXPANDED = "EXPANDED";
    private static final String PROPERTY_COMMENT = "COMMENT";
    private static final String PROPERTY_PRIORITY = "PRIORITY";
    public static final String PROPERTY_PACKAGE_KEY = "PACKAGE_KEY";
    private FilePackageView fpInfo = null;
    private PackageControllerComparator<AbstractNode> sorter;

    public static FilePackage getDefaultFilePackage() {
        return FP;
    }

    public static boolean isDefaultFilePackage(AbstractPackageNode<?, ?> fp) {
        return FP == fp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UniqueAlltimeID getUniqueID() {
        if (this.uniqueID == null) {
            FilePackage filePackage = this;
            synchronized (filePackage) {
                if (this.uniqueID == null) {
                    this.uniqueID = new UniqueAlltimeID();
                }
            }
        }
        return this.uniqueID;
    }

    public int hashCode() {
        return this.getUniqueID().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FilePackage)) {
            return false;
        }
        if (this.uniqueID != null) {
            return ((FilePackage)obj).uniqueID == this.uniqueID;
        }
        return false;
    }

    public static FilePackage getInstance() {
        return new FilePackage();
    }

    private FilePackage() {
        this.downloadLinkList = new ArrayList();
        this.setName(null);
        if (GENERALSETTINGS.isAutoSortChildrenEnabled()) {
            this.sorter = PackageControllerComparator.SORTER_ASC;
        }
    }

    @Override
    public long getCreated() {
        return this.created;
    }

    public void setCreated(long created) {
        this.created = created;
    }

    public void add(DownloadLink link) {
        this._add(link);
    }

    public void addLinks(ArrayList<DownloadLink> links) {
        if (links == null || links.size() == 0) {
            return;
        }
        this._add(links.toArray(new DownloadLink[links.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _add(DownloadLink ... links) {
        if (links == null || links.length == 0) {
            return;
        }
        if (this.controlledby == null) {
            this.getModifyLock().writeLock();
            boolean notifyStructureChanges = false;
            try {
                for (DownloadLink link : links) {
                    if (this.downloadLinkList.contains(link)) continue;
                    notifyStructureChanges = true;
                    link.setParentNode(this);
                    this.downloadLinkList.add(link);
                }
            }
            finally {
                this.getModifyLock().writeUnlock();
                if (notifyStructureChanges) {
                    this.nodeUpdated(this, AbstractNodeNotifier.NOTIFY.STRUCTURE_CHANGE, null);
                }
            }
        } else {
            this.controlledby.moveOrAddAt(this, Arrays.asList(links), -1);
        }
    }

    @Override
    public void setCurrentSorter(PackageControllerComparator<AbstractNode> comparator) {
        this.sorter = comparator;
    }

    @Override
    public String getDownloadDirectory() {
        return this.downloadDirectory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(DownloadLink ... links) {
        if (links == null || links.length == 0) {
            return;
        }
        if (this.controlledby == null) {
            this.getModifyLock().writeLock();
            boolean notifyStructureChanges = false;
            try {
                for (DownloadLink link : links) {
                    if (!this.downloadLinkList.remove(link)) continue;
                    notifyStructureChanges = true;
                    if (link.getFilePackage() != this) continue;
                    link.setParentNode(null);
                }
            }
            finally {
                this.getModifyLock().writeUnlock();
                if (notifyStructureChanges) {
                    this.nodeUpdated(this, AbstractNodeNotifier.NOTIFY.STRUCTURE_CHANGE, null);
                }
            }
        } else {
            this.controlledby.removeChildren(this, Arrays.asList(links), true);
        }
    }

    @Override
    public void setComment(String comment) {
        boolean changed = comment == null || comment.length() == 0 ? this.setProperty(PROPERTY_COMMENT, Property.NULL) : this.setProperty(PROPERTY_COMMENT, comment);
        if (changed && this.hasNotificationListener()) {
            this.nodeUpdated(this, AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new FilePackageProperty(this, FilePackageProperty.Property.COMMENT, this.getComment()));
        }
    }

    @Override
    public String getComment() {
        return this.getStringProperty(PROPERTY_COMMENT, null);
    }

    public void setDownloadDirectory(String folder) {
        if (StringUtils.isEmpty((String)folder)) {
            folder = GENERALSETTINGS.getDefaultDownloadFolder();
        } else if (!CrossSystem.isAbsolutePath((String)folder)) {
            LoggerFactory.I();
            LoggerFactory.getDefaultLogger().severe("FilePackage: setDownloadDirectory only allows absolute paths(" + folder + ")! Using default one!");
            folder = GENERALSETTINGS.getDefaultDownloadFolder();
        }
        String lFolder = this.getDownloadDirectory();
        if (lFolder != null && lFolder.equals(folder)) {
            return;
        }
        this.downloadDirectory = FilePackage.dedupeString(folder.trim());
        if (this.hasNotificationListener()) {
            this.nodeUpdated(this, AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new FilePackageProperty(this, FilePackageProperty.Property.FOLDER, this.getDownloadDirectory()));
        }
    }

    @Override
    public void setName(String name) {
        String lName = this.getName();
        if (StringUtils.isEmpty((String)name)) {
            name = _JDT.T.controller_packages_defaultname();
        }
        if (lName != null && lName.equals(name)) {
            return;
        }
        this.name = name.trim();
        if (this.hasNotificationListener()) {
            this.nodeUpdated(this, AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new FilePackageProperty(this, FilePackageProperty.Property.NAME, this.getName()));
        }
    }

    public void setAllowMerge(Boolean merge) {
        this.setProperty("ALLOW_MERGE", merge);
    }

    public Boolean isAllowMerge() {
        return this.getBooleanProperty("ALLOW_MERGE", null);
    }

    public void setAllowInheritance(Boolean inheritance) {
        this.setProperty("ALLOW_INHERITANCE", inheritance);
    }

    public Boolean isAllowInheritance() {
        return this.getBooleanProperty("ALLOW_INHERITANCE", null);
    }

    public void setCleanupPackageName(Boolean cleanup) {
        this.setProperty("CLEANUP_NAME", cleanup);
    }

    public boolean isCleanupPackageName() {
        return this.getBooleanProperty("CLEANUP_NAME", true);
    }

    public void setIgnoreVarious(Boolean ignorevarious) {
        this.setProperty("PACKAGE_IGNORE_VARIOUS", ignorevarious);
    }

    public Boolean isIgnoreVarious() {
        return this.getBooleanProperty("PACKAGE_IGNORE_VARIOUS", null);
    }

    public void setPackageKey(String key) {
        if (key == null) {
            this.removeProperty(PROPERTY_PACKAGE_KEY);
        } else {
            this.setProperty(PROPERTY_PACKAGE_KEY, key);
        }
    }

    public String getPackageKey() {
        return this.getStringProperty(PROPERTY_PACKAGE_KEY);
    }

    @Override
    public int size() {
        boolean readL = this.getModifyLock().readLock();
        try {
            int n = this.downloadLinkList.size();
            return n;
        }
        finally {
            if (readL) {
                this.getModifyLock().readUnlock(readL);
            }
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public boolean isExpanded() {
        if (this.isExpanded != null) {
            return this.isExpanded;
        }
        this.isExpanded = this.getBooleanProperty(PROPERTY_EXPANDED, false);
        return this.isExpanded;
    }

    @Override
    public void setExpanded(boolean b) {
        if (this.isExpanded != null && this.isExpanded == b) {
            return;
        }
        this.isExpanded = b;
        if (!b) {
            this.setProperty(PROPERTY_EXPANDED, Property.NULL);
        } else {
            this.setProperty(PROPERTY_EXPANDED, b);
        }
    }

    public void setPriorityEnum(Priority priority) {
        if (priority == null) {
            priority = Priority.DEFAULT;
        }
        if (this.getPriorityEnum() != priority) {
            if (Priority.DEFAULT.equals((Object)priority)) {
                this.setProperty(PROPERTY_PRIORITY, Property.NULL);
            } else {
                this.setProperty(PROPERTY_PRIORITY, priority.name());
            }
            if (this.hasNotificationListener()) {
                this.nodeUpdated(this, AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new FilePackageProperty(this, FilePackageProperty.Property.PRIORITY, (Object)priority));
            }
        }
    }

    public Priority getPriorityEnum() {
        try {
            String priority = this.getStringProperty(PROPERTY_PRIORITY, null);
            if (priority == null) {
                return Priority.DEFAULT;
            }
            return Priority.valueOf(priority);
        }
        catch (Throwable e) {
            return Priority.DEFAULT;
        }
    }

    @Override
    public boolean isEnabled() {
        return this.getView().isEnabled();
    }

    @Override
    public List<DownloadLink> getChildren() {
        return this.downloadLinkList;
    }

    @Override
    public PackageController<FilePackage, DownloadLink> getControlledBy() {
        return this.controlledby;
    }

    @Override
    public void setControlledBy(PackageController<FilePackage, DownloadLink> controller) {
        this.controlledby = controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEnabled(boolean b) {
        ArrayList<DownloadLink> links;
        boolean readL = this.getModifyLock().readLock();
        try {
            links = new ArrayList<DownloadLink>(this.getChildren());
        }
        finally {
            if (readL) {
                this.getModifyLock().readUnlock(readL);
            }
        }
        for (DownloadLink link : links) {
            link.setEnabled(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOf(DownloadLink child) {
        boolean readL = this.getModifyLock().readLock();
        try {
            int n = this.downloadLinkList.indexOf(child);
            return n;
        }
        finally {
            if (readL) {
                this.getModifyLock().readUnlock(readL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilePackageView getView() {
        if (this.fpInfo == null) {
            FilePackage filePackage = this;
            synchronized (filePackage) {
                if (this.fpInfo == null) {
                    FilePackageView lfpInfo;
                    this.fpInfo = lfpInfo = new FilePackageView(this);
                }
            }
        }
        return this.fpInfo;
    }

    public void setModified(long modified) {
        this.modified = modified;
    }

    @Override
    public long getModified() {
        return this.modified;
    }

    @Override
    public long getFinishedDate() {
        return this.getView().getFinishedDate();
    }

    @Override
    public PackageControllerComparator<AbstractNode> getCurrentSorter() {
        return this.sorter;
    }

    @Override
    public void nodeUpdated(AbstractNode source, AbstractNodeNotifier.NOTIFY notify, Object param) {
        if (source == this && AbstractNodeNotifier.NOTIFY.STRUCTURE_CHANGE.equals((Object)notify)) {
            this.setModified(System.currentTimeMillis());
        } else {
            FilePackageView lfpInfo;
            PackageController<FilePackage, DownloadLink> n = this.getControlledBy();
            if (n == null) {
                return;
            }
            AbstractNode lsource = source == null ? this : source;
            if (lsource instanceof AbstractPackageChildrenNode && (lfpInfo = this.fpInfo) != null) {
                lfpInfo.requestUpdate();
            }
            n.nodeUpdated(lsource, notify, param);
        }
    }

    @Override
    public boolean hasNotificationListener() {
        PackageController<FilePackage, DownloadLink> n = this.getControlledBy();
        return n != null && n.hasNotificationListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyLock getModifyLock() {
        if (this.lock == null) {
            FilePackage filePackage = this;
            synchronized (filePackage) {
                if (this.lock == null) {
                    this.lock = new ModifyLock();
                }
            }
        }
        return this.lock;
    }

    @Override
    public void copyPropertiesTo(FilePackage dest) {
        if (dest != null && dest != this) {
            dest.name = this.name;
            dest.setComment(this.getComment());
            dest.setDownloadDirectory(this.getView().getDownloadDirectory());
            dest.setPriorityEnum(this.getPriorityEnum());
            return;
        }
    }

    @Override
    public void setDownloadFolder(String directory) {
        this.setDownloadDirectory(directory);
    }

    static {
        FP = new FilePackage(){
            private final FilePackageView view = new FilePackageView(this){

                @Override
                public boolean isEnabled() {
                    return false;
                }

                @Override
                public int size() {
                    return 0;
                }

                @Override
                public PluginStateCollection getPluginStates() {
                    return super.getPluginStates();
                }

                @Override
                public DomainInfo[] getDomainInfos() {
                    return new DomainInfo[0];
                }

                @Override
                public long getSize() {
                    return -1L;
                }

                @Override
                public long getDone() {
                    return -1L;
                }

                @Override
                public long getETA() {
                    return -1L;
                }

                @Override
                public boolean isFinished() {
                    return false;
                }

                @Override
                public int getDisabledCount() {
                    return 0;
                }

                @Override
                public long getFinishedDate() {
                    return -1L;
                }

                @Override
                public FilePackageView aggregate() {
                    return this;
                }

                @Override
                public String getCommonSourceUrl() {
                    return null;
                }

                @Override
                public int getOfflineCount() {
                    return 0;
                }

                @Override
                public int getOnlineCount() {
                    return 0;
                }

                @Override
                public void requestUpdate() {
                }

                @Override
                public boolean updateRequired() {
                    return false;
                }

                @Override
                public ChildrenView.ChildrenAvailablility getAvailability() {
                    return ChildrenView.ChildrenAvailablility.UNKNOWN;
                }

                @Override
                public String getMessage(Object requestor) {
                    return null;
                }

                public PackageController<FilePackage, DownloadLink> getControlledby() {
                    return null;
                }
            };
            private static final long serialVersionUID = 1L;

            @Override
            public void _add(DownloadLink ... links) {
            }

            @Override
            public FilePackageView getView() {
                return this.view;
            }

            @Override
            public void remove(DownloadLink ... links) {
            }

            @Override
            public void setControlledBy(PackageController<FilePackage, DownloadLink> controller) {
            }
        };
        FP.setName(_JDT.T.controller_packages_defaultname());
        FilePackage.FP.downloadLinkList = new ArrayList<DownloadLink>(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isEmpty() {
                return true;
            }

            @Override
            public DownloadLink set(int index, DownloadLink element) {
                return null;
            }

            @Override
            public boolean add(DownloadLink e) {
                return true;
            }

            @Override
            public void add(int index, DownloadLink element) {
            }

            @Override
            public boolean addAll(Collection<? extends DownloadLink> c) {
                return false;
            }

            @Override
            public boolean addAll(int index, Collection<? extends DownloadLink> c) {
                return false;
            }

            public ArrayList<DownloadLink> getDownloadLinkList() {
                return new ArrayList<DownloadLink>();
            }
        };
    }
}

