/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.Icon;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.controlling.packagecontroller.ChildrenView;
import jd.plugins.DownloadLink;
import jd.plugins.FavitIcon;
import jd.plugins.FilePackage;
import jd.plugins.PluginProgress;
import jd.plugins.PluginStateCollection;
import jd.plugins.download.DownloadInterface;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.StringUtils;
import org.appwork.utils.Time;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.DomainInfo;
import org.jdownloader.controlling.DownloadLinkView;
import org.jdownloader.extensions.extraction.ExtractionProgress;
import org.jdownloader.extensions.extraction.ExtractionStatus;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTableModelData;
import org.jdownloader.gui.views.downloads.columns.AvailabilityColumn;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.plugins.ConditionalSkipReason;
import org.jdownloader.plugins.FinalLinkState;
import org.jdownloader.plugins.MirrorLoading;
import org.jdownloader.plugins.SkipReason;
import org.jdownloader.plugins.TimeOutCondition;
import org.jdownloader.settings.GeneralSettings;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;

public class FilePackageView
extends ChildrenView<FilePackage, DownloadLink> {
    private final FilePackage pkg;
    protected volatile long lastUpdateTimestamp = -1L;
    protected volatile boolean lastRunningState = false;
    protected volatile long finishedDate = -1L;
    protected volatile long estimatedETA = -1L;
    private volatile int offline = 0;
    private volatile int online = 0;
    private final AtomicLong updatesRequired = new AtomicLong(0L);
    private volatile long updatesDone = -1L;
    private volatile String availabilityColumnString = null;
    private volatile ChildrenView.ChildrenAvailablility availability = ChildrenView.ChildrenAvailablility.UNKNOWN;
    private volatile int count = 0;
    protected static final long GUIUPDATETIMEOUT = ((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).getDownloadViewRefresh();
    protected static final boolean FORCED_MIRROR_CASE_INSENSITIVE = CrossSystem.isWindows() || ((GeneralSettings)JsonConfig.create(GeneralSettings.class)).isForceMirrorDetectionCaseInsensitive();
    private volatile DomainInfo[] domains = new DomainInfo[0];
    private volatile long size = 0L;
    private volatile int finalCount = 0;
    private volatile int unknownFileSizes = 0;
    private long done = 0L;
    private int enabledCount;
    private PluginStateCollection pluginStates;
    private PluginProgress singlePluginProgress = null;
    private String commonSourceUrl;
    private static final AbstractIcon EXTRACTICONOK = new AbstractIcon("extract_ok", 16);
    private static final AbstractIcon EXTRACTICONERROR = new AbstractIcon("extract_error", 16);
    private static final AbstractIcon EXTRACTICONSTART = new AbstractIcon("extract_run", 16);
    private static final AbstractIcon FALSEICON = new AbstractIcon("false", 16);
    public static final Comparator<DomainInfo> DOMAININFOCOMPARATOR = new Comparator<DomainInfo>(){

        @Override
        public int compare(DomainInfo o1, DomainInfo o2) {
            return o1.getTld().compareTo(o2.getTld());
        }
    };
    private static final WeakHashMap<DomainInfo, WeakHashMap<Icon, Icon>> ICONCACHE = new WeakHashMap();

    @Override
    public boolean isEnabled() {
        return this.enabledCount > 0;
    }

    public FilePackageView(FilePackage pkg) {
        this.pkg = pkg;
    }

    public int getUnknownFileSizes() {
        return this.unknownFileSizes;
    }

    public int getFinalCount() {
        return this.finalCount;
    }

    public PluginStateCollection getPluginStates() {
        return this.pluginStates;
    }

    @Override
    public DomainInfo[] getDomainInfos() {
        return this.domains;
    }

    public long getSize() {
        return this.size;
    }

    public long getDone() {
        return this.done;
    }

    public long getETA() {
        return this.estimatedETA;
    }

    public boolean isFinished() {
        long ret = this.finishedDate;
        return ret > 0L || ret == Integer.MIN_VALUE;
    }

    public int getDisabledCount() {
        return Math.max(0, this.size() - this.enabledCount);
    }

    public long getFinishedDate() {
        long ret = this.finishedDate;
        if (ret <= 0L) {
            return -1L;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilePackageView aggregate() {
        long lupdatesRequired = this.updatesRequired.get();
        this.lastUpdateTimestamp = Time.systemIndependentCurrentJVMTimeMillis();
        FilePackageView filePackageView = this;
        synchronized (filePackageView) {
            Temp tmp = new Temp();
            PackageControllerTableModelData.PackageControllerTableModelDataPackage tableModelDataPackage = this.getTableModelDataPackage();
            if (tableModelDataPackage != null) {
                for (DownloadLink child : tableModelDataPackage.getVisibleChildren()) {
                    this.addLinkToTemp(tmp, child);
                }
            } else {
                boolean readL = this.pkg.getModifyLock().readLock();
                try {
                    for (DownloadLink link : this.pkg.getChildren()) {
                        this.addLinkToTemp(tmp, link);
                    }
                }
                finally {
                    this.pkg.getModifyLock().readUnlock(readL);
                }
            }
            this.writeTempToFields(tmp);
            this.updatesDone = lupdatesRequired;
            if (this.domains.length != tmp.domains.size() || !tmp.domains.values().containsAll(Arrays.asList(this.domains))) {
                ArrayList lst = new ArrayList(tmp.domains.values());
                if (lst.size() > 1) {
                    Collections.sort(lst, DOMAININFOCOMPARATOR);
                }
                this.domains = lst.toArray(new DomainInfo[tmp.domains.size()]);
            }
        }
        return this;
    }

    protected void writeTempToFields(Temp tmp) {
        long size = -1L;
        long done = 0L;
        long speed = -1L;
        long maxSingleETA = -1L;
        boolean atLeastOneEnabled = false;
        for (LinkInfo linkInfo : tmp.linkInfos.values()) {
            if (!linkInfo.enabled) continue;
            atLeastOneEnabled = true;
            break;
        }
        for (LinkInfo linkInfo : tmp.linkInfos.values()) {
            long singleETA;
            if (atLeastOneEnabled && !linkInfo.enabled) continue;
            if (linkInfo.speed >= 0L) {
                if (speed == -1L) {
                    speed = 0L;
                }
                speed += linkInfo.speed;
            }
            if (linkInfo.bytesTotal >= 0L) {
                if (size == -1L) {
                    size = 0L;
                }
                size += linkInfo.bytesTotal;
            } else {
                tmp.newUnknownFileSizes++;
            }
            if (linkInfo.bytesDone >= 0L) {
                done += linkInfo.bytesDone;
            }
            long bytesLeft = Math.max(-1L, linkInfo.bytesTotal - linkInfo.bytesDone);
            if (linkInfo.speed <= 0L || bytesLeft < 0L || (singleETA = bytesLeft / linkInfo.speed) <= maxSingleETA) continue;
            maxSingleETA = singleETA;
        }
        this.count = tmp.count;
        this.done = done;
        this.size = size;
        this.finalCount = tmp.newFinalCount;
        this.unknownFileSizes = tmp.newUnknownFileSizes;
        this.enabledCount = tmp.newEnabledCount;
        this.finishedDate = tmp.allFinished && atLeastOneEnabled ? (tmp.newFinishedDate <= 0L ? Integer.MIN_VALUE : tmp.newFinishedDate) : -1L;
        if (speed >= 0L) {
            this.lastRunningState = true;
            if (size >= 0L && speed > 0L) {
                long bytesLeft = Math.max(-1L, size - done);
                long packageETA = bytesLeft / speed;
                this.estimatedETA = Math.max(maxSingleETA, packageETA);
            } else {
                this.estimatedETA = Integer.MIN_VALUE;
            }
        } else {
            this.estimatedETA = -1L;
            this.lastRunningState = false;
        }
        if (!tmp.sameSourceFullUrl) {
            tmp.sameSource = tmp.sameSource + "[...]";
        }
        this.singlePluginProgress = tmp.pluginProgress != null && tmp.pluginProgress.size() == 1 ? (PluginProgress)tmp.pluginProgress.iterator().next() : null;
        this.commonSourceUrl = tmp.sameSource;
        this.pluginStates = new PluginStateCollection(tmp.pluginStates.values());
        this.offline = tmp.newOffline;
        this.online = tmp.newOnline;
        this.availability = this.updateAvailability(tmp);
        this.availabilityColumnString = _GUI.T.AvailabilityColumn_getStringValue_object_(tmp.newOnline, tmp.count);
    }

    public final ChildrenView.ChildrenAvailablility updateAvailability(Temp tmp) {
        int count = tmp.count;
        int online = tmp.newOnline;
        int offline = tmp.newOffline;
        if (online > 0 && online == count) {
            return ChildrenView.ChildrenAvailablility.ONLINE;
        }
        if (offline > 0 && offline == count) {
            return ChildrenView.ChildrenAvailablility.OFFLINE;
        }
        if (offline == 0 && online == 0 || online == 0 && offline > 0) {
            return ChildrenView.ChildrenAvailablility.UNKNOWN;
        }
        return ChildrenView.ChildrenAvailablility.MIXED;
    }

    public String getCommonSourceUrl() {
        return this.commonSourceUrl;
    }

    private ConditionalSkipReason getConditionalSkipReason(DownloadLink link) {
        ConditionalSkipReason conditionalSkipReason = link.getConditionalSkipReason();
        if (conditionalSkipReason == null || conditionalSkipReason.isConditionReached()) {
            return null;
        }
        if (conditionalSkipReason instanceof MirrorLoading) {
            return null;
        }
        return conditionalSkipReason;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Icon getFavIcon(DomainInfo domainInfo, Icon icon) {
        WeakHashMap<DomainInfo, WeakHashMap<Icon, Icon>> weakHashMap = ICONCACHE;
        synchronized (weakHashMap) {
            Icon ret;
            WeakHashMap<Icon, Icon> cache = ICONCACHE.get(domainInfo);
            if (cache == null) {
                cache = new WeakHashMap();
                ICONCACHE.put(domainInfo, cache);
            }
            if ((ret = cache.get(icon)) == null) {
                ret = new FavitIcon(icon, domainInfo);
                cache.put(icon, ret);
            }
            return ret;
        }
    }

    protected void addLinkToTemp(Temp tmp, final DownloadLink link) {
        FinalLinkState finalLinkState;
        SkipReason skipReason;
        Icon icon;
        ConditionalSkipReason conditionalSkipReason;
        tmp.count++;
        final DomainInfo domainInfo = link.getDomainInfo();
        tmp.domains.put(domainInfo.getTld(), domainInfo);
        DownloadLinkView view = link.getView();
        String sourceUrl = view.getDisplayUrl();
        if (sourceUrl != null) {
            tmp.sameSource = StringUtils.getCommonalities((String)tmp.sameSource, (String)sourceUrl);
            tmp.sameSourceFullUrl = tmp.sameSourceFullUrl && tmp.sameSource.equals(sourceUrl);
        }
        if (DownloadLink.AvailableStatus.FALSE == link.getAvailableStatus()) {
            tmp.newOffline++;
        } else if (DownloadLink.AvailableStatus.TRUE == link.getAvailableStatus()) {
            tmp.newOnline++;
        }
        String id = null;
        PluginState<Object> ps = null;
        PluginProgress prog = link.getPluginProgress();
        if (prog != null) {
            Icon icon2;
            if (tmp.pluginProgress == null) {
                tmp.pluginProgress = new HashSet();
            }
            tmp.pluginProgress.add(prog);
            if (!(prog instanceof ExtractionProgress) && (icon2 = prog.getIcon(this)) != null) {
                String message;
                id = prog.getClass().getName().concat(link.getHost());
                if (!tmp.pluginStates.containsKey(id) && (message = prog.getMessage(this)) != null) {
                    ps = new PluginState<PluginProgress>(prog, null, null){
                        String msg;
                        {
                            super(cause, message2, icon22);
                            this.msg = null;
                        }

                        @Override
                        public PluginProgress getCause() {
                            PluginProgress ret = (PluginProgress)super.getCause();
                            if (link.getPluginProgress() == ret) {
                                return ret;
                            }
                            return null;
                        }

                        @Override
                        public Icon getIcon() {
                            if (this.stateIcon == null) {
                                this.stateIcon = FilePackageView.this.getFavIcon(domainInfo, icon2);
                            }
                            return this.stateIcon;
                        }

                        @Override
                        public String getDescription() {
                            if (this.msg == null) {
                                this.msg = message + " (" + domainInfo.getTld() + ")";
                            }
                            return this.msg;
                        }
                    };
                    tmp.pluginStates.put(id, ps);
                }
            }
        }
        if ((conditionalSkipReason = this.getConditionalSkipReason(link)) != null && (icon = conditionalSkipReason.getIcon(this, link)) != null) {
            String message;
            id = conditionalSkipReason.getClass().getName().concat(link.getHost());
            if (!tmp.pluginStates.containsKey(id) && (message = conditionalSkipReason.getMessage(this, link)) != null) {
                ps = new PluginState<ConditionalSkipReason>(conditionalSkipReason, null, null){

                    @Override
                    public ConditionalSkipReason getCause() {
                        ConditionalSkipReason ret = (ConditionalSkipReason)super.getCause();
                        if (FilePackageView.this.getConditionalSkipReason(link) == ret) {
                            return ret;
                        }
                        return null;
                    }

                    @Override
                    public Icon getIcon() {
                        if (this.stateIcon == null) {
                            this.stateIcon = FilePackageView.this.getFavIcon(domainInfo, icon);
                        }
                        return this.stateIcon;
                    }

                    @Override
                    public String getDescription() {
                        if (this.description == null) {
                            this.description = message + " (" + domainInfo.getTld() + ")";
                        }
                        return this.description;
                    }
                };
                tmp.pluginStates.put(id, ps);
            }
        }
        if ((skipReason = link.getSkipReason()) != null) {
            id = skipReason.name();
            if (!tmp.pluginStates.containsKey(id)) {
                ps = new PluginState<SkipReason>(skipReason, null, null){

                    @Override
                    public String getDescription() {
                        return skipReason.getExplanation(this, link);
                    }

                    @Override
                    public SkipReason getCause() {
                        SkipReason ret = (SkipReason)((Object)super.getCause());
                        if (link.getSkipReason() == ret) {
                            return ret;
                        }
                        return null;
                    }

                    @Override
                    public Icon getIcon() {
                        if (this.stateIcon == null) {
                            this.stateIcon = skipReason.getIcon(this, 18);
                        }
                        return this.stateIcon;
                    }
                };
                tmp.pluginStates.put(id, ps);
            }
        }
        if ((finalLinkState = link.getFinalLinkState()) != null) {
            String archiveID;
            switch (finalLinkState) {
                case FAILED: 
                case FAILED_CRC32: 
                case FAILED_EXISTS: 
                case FAILED_FATAL: 
                case FAILED_MD5: 
                case FAILED_SHA1: 
                case FAILED_SHA256: 
                case OFFLINE: 
                case PLUGIN_DEFECT: {
                    id = "error".concat(link.getHost());
                    if (tmp.pluginStates.containsKey(id)) break;
                    ps = new PluginState<FinalLinkState>(finalLinkState, null, null){

                        @Override
                        public FinalLinkState getCause() {
                            FinalLinkState ret = (FinalLinkState)((Object)super.getCause());
                            if (link.getFinalLinkState() == ret) {
                                return ret;
                            }
                            return null;
                        }

                        @Override
                        public Icon getIcon() {
                            if (this.stateIcon == null) {
                                this.stateIcon = FilePackageView.this.getFavIcon(domainInfo, FALSEICON);
                            }
                            return this.stateIcon;
                        }

                        @Override
                        public String getDescription() {
                            if (this.description == null) {
                                this.description = _GUI.T.FilePackageView_addLinkToTemp_downloaderror_() + " (" + domainInfo.getTld() + ")";
                            }
                            return this.description;
                        }
                    };
                    tmp.pluginStates.put(id, ps);
                    break;
                }
            }
            final ExtractionStatus extractionStatus = link.getExtractionStatus();
            if (extractionStatus != null && StringUtils.isNotEmpty((String)(archiveID = link.getArchiveID()))) {
                switch (extractionStatus) {
                    case ERROR: 
                    case ERROR_PW: 
                    case ERROR_CRC: 
                    case ERROR_NOT_ENOUGH_SPACE: 
                    case ERRROR_FILE_NOT_FOUND: {
                        ExtractionPluginState eps;
                        if (extractionStatus.getExplanation() == null) break;
                        id = "extractError:" + extractionStatus.name();
                        ps = (PluginState)tmp.pluginStates.get(id);
                        if (ps == null) {
                            ps = new ExtractionPluginState(null, EXTRACTICONERROR){

                                @Override
                                public String getDescription() {
                                    if (this.description == null) {
                                        StringBuilder sb = new StringBuilder();
                                        sb.append(extractionStatus.getExplanation());
                                        sb.append(": ");
                                        int i = 0;
                                        for (DownloadLink archive : this.archives.values()) {
                                            if (i > 0) {
                                                sb.append("\r\n");
                                            }
                                            sb.append(archive.getName());
                                            ++i;
                                        }
                                        this.description = sb.toString();
                                    }
                                    return this.description;
                                }
                            };
                            tmp.pluginStates.put(id, ps);
                            eps = (ExtractionPluginState)ps;
                            eps.archives.put(archiveID, link);
                            break;
                        }
                        eps = (ExtractionPluginState)ps;
                        if (eps.archives.containsKey(archiveID)) break;
                        eps.archives.put(archiveID, link);
                        break;
                    }
                    case SUCCESSFUL: {
                        ExtractionPluginState eps;
                        if (extractionStatus.getExplanation() == null) break;
                        id = "extractSuccess";
                        ps = (PluginState)tmp.pluginStates.get(id);
                        if (ps == null) {
                            ps = new ExtractionPluginState(null, EXTRACTICONOK){

                                @Override
                                public ExtractionStatus getCause() {
                                    for (DownloadLink link : this.archives.values()) {
                                        if (link.getExtractionStatus() == ExtractionStatus.SUCCESSFUL) continue;
                                        return null;
                                    }
                                    return ExtractionStatus.SUCCESSFUL;
                                }

                                @Override
                                public String getDescription() {
                                    if (this.description == null) {
                                        StringBuilder sb = new StringBuilder();
                                        sb.append(extractionStatus.getExplanation());
                                        sb.append(": ");
                                        int i = 0;
                                        for (DownloadLink archive : this.archives.values()) {
                                            if (i > 0) {
                                                sb.append("\r\n");
                                            }
                                            sb.append(archive.getName());
                                            ++i;
                                        }
                                        this.description = sb.toString();
                                    }
                                    return this.description;
                                }
                            };
                            tmp.pluginStates.put(id, ps);
                            eps = (ExtractionPluginState)ps;
                            eps.archives.put(archiveID, link);
                            break;
                        }
                        eps = (ExtractionPluginState)ps;
                        if (eps.archives.containsKey(archiveID)) break;
                        eps.archives.put(archiveID, link);
                        break;
                    }
                    case RUNNING: {
                        String message;
                        id = "ExtractionRunning".concat(archiveID);
                        PluginProgress prog2 = link.getPluginProgress();
                        ps = null;
                        if (prog2 != null && prog2 instanceof ExtractionProgress && !tmp.pluginStates.containsKey(id) && (message = prog2.getMessage(this)) != null) {
                            ps = new PluginState<PluginProgress>(prog2, null, (Icon)EXTRACTICONSTART){

                                @Override
                                public PluginProgress getCause() {
                                    PluginProgress ret = (PluginProgress)super.getCause();
                                    if (link.getPluginProgress() == ret) {
                                        return ret;
                                    }
                                    return null;
                                }

                                @Override
                                public String getDescription() {
                                    if (this.description == null) {
                                        this.description = message + " (" + link.getName() + ")";
                                    }
                                    return this.description;
                                }
                            };
                            tmp.pluginStates.put(id, ps);
                        }
                        if (ps != null || tmp.pluginStates.containsKey(id) || (message = extractionStatus.getExplanation()) == null) break;
                        ps = new PluginState<PluginProgress>(prog2, null, (Icon)EXTRACTICONSTART){

                            @Override
                            public PluginProgress getCause() {
                                PluginProgress ret = (PluginProgress)super.getCause();
                                if (link.getPluginProgress() == ret) {
                                    return ret;
                                }
                                return null;
                            }

                            @Override
                            public String getDescription() {
                                if (this.description == null) {
                                    this.description = message + " (" + link.getName() + ")";
                                }
                                return this.description;
                            }
                        };
                        tmp.pluginStates.put(id, ps);
                    }
                }
            }
        }
        if (skipReason != null || finalLinkState != null) {
            tmp.newFinalCount++;
        }
        boolean isEnabled = link.isEnabled();
        String displayName = FORCED_MIRROR_CASE_INSENSITIVE ? view.getDisplayName().toLowerCase(Locale.ENGLISH) : view.getDisplayName();
        LinkInfo linkInfo = null;
        if (isEnabled) {
            if (finalLinkState == null || FinalLinkState.PLUGIN_DEFECT.equals((Object)finalLinkState)) {
                tmp.allFinished = false;
            }
            tmp.newEnabledCount++;
            if (conditionalSkipReason instanceof MirrorLoading) {
                MirrorLoading mirrorLoading = (MirrorLoading)conditionalSkipReason;
                DownloadLink downloadLink = mirrorLoading.getDownloadLink();
                linkInfo = (LinkInfo)tmp.linkInfos.get(displayName);
                if (linkInfo == null || linkInfo.link != downloadLink) {
                    linkInfo = new LinkInfo();
                    linkInfo.link = downloadLink;
                    DownloadLinkView downloadView = downloadLink.getView();
                    linkInfo.bytesTotal = downloadView.getBytesTotal();
                    linkInfo.bytesDone = downloadView.getBytesLoaded();
                    SingleDownloadController controller = downloadLink.getDownloadLinkController();
                    if (controller != null) {
                        DownloadInterface downloadInterface = controller.getDownloadInstance();
                        if (downloadInterface == null || System.currentTimeMillis() - downloadInterface.getStartTimeStamp() < 5000L) {
                            linkInfo.speed = 0L;
                        } else {
                            linkInfo.speed = downloadView.getSpeedBps();
                        }
                    }
                    tmp.linkInfos.put(displayName, linkInfo);
                }
            } else {
                linkInfo = (LinkInfo)tmp.linkInfos.get(displayName);
                if (linkInfo == null) {
                    linkInfo = new LinkInfo();
                    linkInfo.link = link;
                    tmp.linkInfos.put(displayName, linkInfo);
                }
                linkInfo.enabled = true;
                SingleDownloadController controller = link.getDownloadLinkController();
                if (controller != null) {
                    linkInfo.bytesTotal = view.getBytesTotal();
                    linkInfo.bytesDone = view.getBytesLoaded();
                    DownloadInterface downloadInterface = controller.getDownloadInstance();
                    if (downloadInterface == null || System.currentTimeMillis() - downloadInterface.getStartTimeStamp() < 5000L) {
                        linkInfo.speed = 0L;
                    } else {
                        linkInfo.speed = view.getSpeedBps();
                    }
                } else if (linkInfo.speed < 0L) {
                    if (linkInfo.bytesTotal < view.getBytesTotal()) {
                        linkInfo.bytesTotal = view.getBytesTotal();
                    }
                    if (linkInfo.bytesDone < view.getBytesLoaded()) {
                        linkInfo.bytesDone = view.getBytesLoaded();
                    }
                }
            }
        } else {
            linkInfo = (LinkInfo)tmp.linkInfos.get(displayName);
            if (linkInfo == null) {
                linkInfo = new LinkInfo();
                linkInfo.link = link;
                linkInfo.enabled = false;
                tmp.linkInfos.put(displayName, linkInfo);
            }
            if (!linkInfo.enabled && linkInfo.speed < 0L) {
                if (linkInfo.bytesTotal < view.getBytesTotal()) {
                    linkInfo.bytesTotal = view.getBytesTotal();
                }
                if (linkInfo.bytesDone < view.getBytesLoaded()) {
                    linkInfo.bytesDone = view.getBytesLoaded();
                }
            }
        }
        if (linkInfo != null && FinalLinkState.OFFLINE.equals((Object)finalLinkState) || FinalLinkState.PLUGIN_DEFECT.equals((Object)finalLinkState)) {
            if (linkInfo.bytesTotal < 0L) {
                linkInfo.bytesTotal = 0L;
            }
            if (linkInfo.bytesDone < 0L) {
                linkInfo.bytesDone = 0L;
            }
        }
        if (tmp.allFinished && link.getFinishedDate() > tmp.newFinishedDate) {
            tmp.newFinishedDate = link.getFinishedDate();
        }
    }

    public int getOfflineCount() {
        return this.offline;
    }

    public int getOnlineCount() {
        return this.online;
    }

    @Override
    public void requestUpdate() {
        this.updatesRequired.incrementAndGet();
    }

    @Override
    public boolean updateRequired() {
        long now;
        boolean ret;
        boolean bl = ret = this.updatesRequired.get() != this.updatesDone;
        if (!ret && this.pkg.isEnabled() && (now = Time.systemIndependentCurrentJVMTimeMillis()) - this.lastUpdateTimestamp > GUIUPDATETIMEOUT) {
            this.lastUpdateTimestamp = now;
            for (PluginState pluginState : this.getPluginStates()) {
                Object cause = pluginState.getCause();
                if (cause == null) {
                    ret = true;
                    break;
                }
                if (!(cause instanceof TimeOutCondition) && !(cause instanceof PluginProgress)) continue;
                ret = true;
                break;
            }
            if (!ret) {
                ret = DownloadWatchDog.getInstance().hasRunningDownloads(this.pkg);
            }
        }
        return ret;
    }

    @Override
    public ChildrenView.ChildrenAvailablility getAvailability() {
        return this.availability;
    }

    @Override
    public String getMessage(Object requestor) {
        if (requestor instanceof AvailabilityColumn) {
            return this.availabilityColumnString;
        }
        return null;
    }

    public String getDownloadDirectory() {
        return this.pkg.getDownloadDirectory();
    }

    public PluginProgress getSinglePluginProgress() {
        return this.singlePluginProgress;
    }

    public boolean isRunning() {
        return this.lastRunningState;
    }

    @Override
    public int size() {
        return this.count;
    }

    public class ExtractionPluginState
    extends PluginState<ExtractionStatus> {
        protected final Map<String, DownloadLink> archives;

        protected ExtractionPluginState(String message, Icon icon2) {
            super(null, message, icon2);
            this.archives = new HashMap<String, DownloadLink>();
        }
    }

    public class PluginState<T> {
        protected String description;
        protected Icon stateIcon;
        protected final T cause;

        public String getDescription() {
            return this.description;
        }

        public Icon getIcon() {
            return this.stateIcon;
        }

        public T getCause() {
            return this.cause;
        }

        protected PluginState(T cause, String message, Icon icon2) {
            this.cause = cause;
            this.description = message;
            this.stateIcon = icon2;
        }
    }

    private class Temp {
        private int newUnknownFileSizes = 0;
        private int newFinalCount = 0;
        private long newFinishedDate = -1L;
        private int newOffline = 0;
        private int newOnline = 0;
        private int newEnabledCount = 0;
        private int count = 0;
        private final HashMap<String, LinkInfo> linkInfos = new HashMap();
        private final HashMap<String, DomainInfo> domains = new HashMap();
        private boolean allFinished = true;
        private String sameSource = null;
        private boolean sameSourceFullUrl = true;
        private Set<PluginProgress> pluginProgress = null;
        private final HashMap<Object, PluginState<?>> pluginStates = new HashMap();

        private Temp() {
        }
    }

    private static class LinkInfo {
        private long bytesTotal = -1L;
        private long bytesDone = -1L;
        private long speed = -1L;
        private boolean enabled = true;
        private DownloadLink link;

        private LinkInfo() {
        }
    }
}

