/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins;

import java.io.File;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.regex.Pattern;
import javax.swing.Icon;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.packagecontroller.AbstractPackageChildrenNode;
import jd.parser.Regex;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.appwork.utils.Files;
import org.appwork.utils.StringUtils;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.controlling.filter.CompiledFiletypeFilter;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.NewTheme;
import org.jdownloader.logging.LogController;

public class LinkInfo {
    private final int partNum;
    private final Icon icon;
    private final CompiledFiletypeFilter.ExtensionsFilterInterface extension;
    private static final HashMap<String, WeakReference<LinkInfo>> CACHE = new HashMap();

    public Icon getIcon() {
        return this.icon;
    }

    public int getPartNum() {
        return this.partNum;
    }

    public CompiledFiletypeFilter.ExtensionsFilterInterface getExtension() {
        return this.extension;
    }

    private LinkInfo(int partNum, CompiledFiletypeFilter.ExtensionsFilterInterface extension, Icon icon) {
        this.partNum = partNum;
        this.icon = icon;
        this.extension = extension;
    }

    public static LinkInfo getLinkInfo(File file) {
        if (file == null || !file.isFile()) {
            return null;
        }
        return LinkInfo.getLinkInfo(file.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkInfo getLinkInfo(String fileName) {
        if (StringUtils.isEmpty((String)fileName)) {
            return null;
        }
        final String fileNameExtension = Files.getExtension((String)fileName);
        int num = -1;
        try {
            String partID = new Regex(fileName, "\\.r(\\d+)$").getMatch(0);
            if (partID == null) {
                partID = new Regex(fileName, "\\.pa?r?t?\\.?(\\d+).*?\\.rar$").getMatch(0);
            }
            if (partID != null) {
                num = Integer.parseInt(partID);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        String mimeHint = null;
        String ID2 = fileNameExtension + "_" + num + "_" + mimeHint;
        HashMap<String, WeakReference<LinkInfo>> hashMap = CACHE;
        synchronized (hashMap) {
            LinkInfo ret = null;
            WeakReference<LinkInfo> linkInfo = CACHE.get(ID2);
            if (linkInfo == null || (ret = (LinkInfo)linkInfo.get()) == null) {
                final CompiledFiletypeFilter.CompiledFiletypeExtension hint = CompiledFiletypeFilter.getExtensionsFilterInterface(mimeHint);
                final CompiledFiletypeFilter.CompiledFiletypeExtension compiled = CompiledFiletypeFilter.getExtensionsFilterInterface(fileNameExtension);
                CompiledFiletypeFilter.ExtensionsFilterInterface extension = compiled == null || hint != null && !hint.isSameExtensionGroup(compiled) ? new CompiledFiletypeFilter.ExtensionsFilterInterface(){
                    final String extension;
                    final String desc;
                    final Pattern pattern;
                    {
                        if (fileNameExtension != null && fileNameExtension.matches("^[a-zA-Z0-9]{1,4}$")) {
                            this.extension = fileNameExtension;
                            this.desc = fileNameExtension;
                            this.pattern = Pattern.compile(Pattern.quote(fileNameExtension), 34);
                        } else {
                            this.extension = "";
                            this.desc = _GUI.T.settings_linkgrabber_filter_others();
                            this.pattern = null;
                        }
                    }

                    @Override
                    public CompiledFiletypeFilter.ExtensionsFilterInterface getSource() {
                        return hint;
                    }

                    @Override
                    public Pattern compiledAllPattern() {
                        if (hint != null) {
                            return hint.compiledAllPattern();
                        }
                        return null;
                    }

                    @Override
                    public String getDesc() {
                        if (hint != null) {
                            return hint.getDesc();
                        }
                        return this.desc;
                    }

                    @Override
                    public String getIconID() {
                        if (hint != null) {
                            return hint.getIconID();
                        }
                        return null;
                    }

                    @Override
                    public Pattern getPattern() {
                        if (hint != null) {
                            return hint.compiledAllPattern();
                        }
                        return this.pattern;
                    }

                    @Override
                    public String name() {
                        return this.extension;
                    }

                    @Override
                    public boolean isSameExtensionGroup(CompiledFiletypeFilter.ExtensionsFilterInterface extension) {
                        if (hint != null) {
                            return hint.isSameExtensionGroup(extension);
                        }
                        return extension != null && extension.getIconID() == null && StringUtils.equals((String)extension.name(), (String)this.name());
                    }

                    @Override
                    public CompiledFiletypeFilter.ExtensionsFilterInterface[] listSameGroup() {
                        if (hint != null) {
                            return hint.listSameGroup();
                        }
                        return new CompiledFiletypeFilter.ExtensionsFilterInterface[]{this};
                    }
                } : new CompiledFiletypeFilter.ExtensionsFilterInterface(){

                    @Override
                    public Pattern compiledAllPattern() {
                        return compiled.compiledAllPattern();
                    }

                    @Override
                    public String getDesc() {
                        return compiled.getDesc();
                    }

                    @Override
                    public String getIconID() {
                        return compiled.getIconID();
                    }

                    @Override
                    public Pattern getPattern() {
                        return compiled.getPattern();
                    }

                    @Override
                    public CompiledFiletypeFilter.ExtensionsFilterInterface getSource() {
                        return compiled;
                    }

                    @Override
                    public String name() {
                        return fileNameExtension;
                    }

                    @Override
                    public boolean isSameExtensionGroup(CompiledFiletypeFilter.ExtensionsFilterInterface extension) {
                        return compiled.isSameExtensionGroup(extension);
                    }

                    @Override
                    public CompiledFiletypeFilter.ExtensionsFilterInterface[] listSameGroup() {
                        return compiled.listSameGroup();
                    }
                };
                ret = new LinkInfo(num, extension, LinkInfo.getIcon(fileName, extension));
                CACHE.put(ID2, new WeakReference<LinkInfo>(ret));
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkInfo getLinkInfo(AbstractPackageChildrenNode abstractChildrenNode) {
        if (abstractChildrenNode != null) {
            String mimeHint;
            String fileName;
            AbstractPackageChildrenNode<FilePackage> link;
            if (abstractChildrenNode instanceof DownloadLink) {
                link = (DownloadLink)abstractChildrenNode;
                fileName = ((DownloadLink)link).getView().getDisplayName();
                mimeHint = ((DownloadLink)link).getMimeHint();
            } else if (abstractChildrenNode instanceof CrawledLink) {
                link = (CrawledLink)abstractChildrenNode;
                fileName = ((CrawledLink)link).getName();
                DownloadLink downloadLink = ((CrawledLink)link).getDownloadLink();
                mimeHint = downloadLink != null ? downloadLink.getMimeHint() : null;
            } else {
                fileName = abstractChildrenNode.getName();
                mimeHint = null;
            }
            final String fileNameExtension = Files.getExtension((String)fileName);
            int num = -1;
            try {
                String partID = new Regex(fileName, "\\.r(\\d+)$").getMatch(0);
                if (partID == null) {
                    partID = new Regex(fileName, "\\.pa?r?t?\\.?(\\d+).*?\\.rar$").getMatch(0);
                }
                if (partID != null) {
                    num = Integer.parseInt(partID);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            String ID2 = fileNameExtension + "_" + num + "_" + mimeHint;
            HashMap<String, WeakReference<LinkInfo>> hashMap = CACHE;
            synchronized (hashMap) {
                LinkInfo ret = null;
                WeakReference<LinkInfo> linkInfo = CACHE.get(ID2);
                if (linkInfo == null || (ret = (LinkInfo)linkInfo.get()) == null) {
                    final CompiledFiletypeFilter.CompiledFiletypeExtension hint = CompiledFiletypeFilter.getExtensionsFilterInterface(mimeHint);
                    final CompiledFiletypeFilter.CompiledFiletypeExtension compiled = CompiledFiletypeFilter.getExtensionsFilterInterface(fileNameExtension);
                    CompiledFiletypeFilter.ExtensionsFilterInterface extension = compiled == null || hint != null && !hint.isSameExtensionGroup(compiled) ? new CompiledFiletypeFilter.ExtensionsFilterInterface(){
                        final String extension;
                        final String desc;
                        final Pattern pattern;
                        {
                            if (fileNameExtension != null && fileNameExtension.matches("^[a-zA-Z0-9]{1,4}$")) {
                                this.extension = fileNameExtension;
                                this.desc = fileNameExtension;
                                this.pattern = Pattern.compile(Pattern.quote(fileNameExtension), 34);
                            } else {
                                this.extension = "";
                                this.desc = _GUI.T.settings_linkgrabber_filter_others();
                                this.pattern = null;
                            }
                        }

                        @Override
                        public CompiledFiletypeFilter.ExtensionsFilterInterface getSource() {
                            if (compiled != null) {
                                return compiled;
                            }
                            return hint;
                        }

                        @Override
                        public Pattern compiledAllPattern() {
                            if (compiled != null) {
                                return compiled.compiledAllPattern();
                            }
                            if (hint != null) {
                                return hint.compiledAllPattern();
                            }
                            return null;
                        }

                        @Override
                        public String getDesc() {
                            if (compiled != null) {
                                return compiled.getDesc();
                            }
                            if (hint != null) {
                                return hint.getDesc();
                            }
                            return this.desc;
                        }

                        @Override
                        public String getIconID() {
                            if (compiled != null) {
                                return compiled.getIconID();
                            }
                            if (hint != null) {
                                return hint.getIconID();
                            }
                            return null;
                        }

                        @Override
                        public Pattern getPattern() {
                            if (compiled != null) {
                                return compiled.compiledAllPattern();
                            }
                            if (hint != null) {
                                return hint.compiledAllPattern();
                            }
                            return this.pattern;
                        }

                        @Override
                        public String name() {
                            return this.extension;
                        }

                        @Override
                        public boolean isSameExtensionGroup(CompiledFiletypeFilter.ExtensionsFilterInterface extension) {
                            if (compiled != null) {
                                return compiled.isSameExtensionGroup(extension);
                            }
                            if (hint != null) {
                                return hint.isSameExtensionGroup(extension);
                            }
                            return extension != null && extension.getIconID() == null && StringUtils.equals((String)extension.name(), (String)this.name());
                        }

                        @Override
                        public CompiledFiletypeFilter.ExtensionsFilterInterface[] listSameGroup() {
                            if (compiled != null) {
                                return compiled.listSameGroup();
                            }
                            if (hint != null) {
                                return hint.listSameGroup();
                            }
                            return new CompiledFiletypeFilter.ExtensionsFilterInterface[]{this};
                        }
                    } : new CompiledFiletypeFilter.ExtensionsFilterInterface(){

                        @Override
                        public Pattern compiledAllPattern() {
                            return compiled.compiledAllPattern();
                        }

                        @Override
                        public String getDesc() {
                            return compiled.getDesc();
                        }

                        @Override
                        public String getIconID() {
                            return compiled.getIconID();
                        }

                        @Override
                        public Pattern getPattern() {
                            return compiled.getPattern();
                        }

                        @Override
                        public CompiledFiletypeFilter.ExtensionsFilterInterface getSource() {
                            return compiled;
                        }

                        @Override
                        public String name() {
                            return fileNameExtension;
                        }

                        @Override
                        public boolean isSameExtensionGroup(CompiledFiletypeFilter.ExtensionsFilterInterface extension) {
                            return compiled.isSameExtensionGroup(extension);
                        }

                        @Override
                        public CompiledFiletypeFilter.ExtensionsFilterInterface[] listSameGroup() {
                            return compiled.listSameGroup();
                        }
                    };
                    ret = new LinkInfo(num, extension, LinkInfo.getIcon(fileName, extension));
                    CACHE.put(ID2, new WeakReference<LinkInfo>(ret));
                }
                return ret;
            }
        }
        return null;
    }

    public static Icon getIcon(String name, CompiledFiletypeFilter.ExtensionsFilterInterface extension) {
        Icon newIcon = null;
        String ext = Files.getExtension((String)name);
        if (CrossSystem.isWindows() && ext != null) {
            try {
                newIcon = CrossSystem.getMime().getFileIcon(ext, 16, 16);
            }
            catch (Throwable e) {
                LogController.CL().log(e);
            }
        }
        if (newIcon == null) {
            String iconID = null;
            if (extension != null && extension.getIconID() != null) {
                iconID = extension.getIconID();
            }
            if (StringUtils.isEmpty(iconID)) {
                iconID = "file";
            }
            newIcon = NewTheme.I().getIcon(iconID, 16);
        }
        return newIcon;
    }
}

