/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import jd.controlling.packagecontroller.AbstractNodeNotifier;
import jd.plugins.DownloadLink;
import jd.plugins.DownloadLinkProperty;
import org.appwork.utils.BinaryLogic;
import org.appwork.utils.formatter.StringFormatter;

public class LinkStatus
implements Serializable {
    public static final int FINISHED = 2;
    public static final int ERROR_RETRY = 4;
    public static final int ERROR_CAPTCHA = 8;
    public static final int ERROR_IP_BLOCKED = 16;
    public static final int ERROR_FILE_NOT_FOUND = 32;
    public static final int ERROR_PREMIUM = 256;
    public static final int ERROR_DOWNLOAD_INCOMPLETE = 512;
    public static final int ERROR_TEMPORARILY_UNAVAILABLE = 2048;
    public static final int ERROR_HOSTER_TEMPORARILY_UNAVAILABLE = 4096;
    public static final int ERROR_ALREADYEXISTS = 8192;
    public static final int ERROR_DOWNLOAD_FAILED = 16384;
    public static final int ERROR_FATAL = 131072;
    public static final int ERROR_PLUGIN_DEFECT = 0x400000;
    public static final int VALUE_NETWORK_IO_ERROR = 1;
    public static final int VALUE_LOCAL_IO_ERROR = 2;
    private static final long serialVersionUID = 3885661829491436448L;
    private final DownloadLink downloadLink;
    private String errorMessage;
    private int status = 4;
    private String statusText = null;
    private long value = 0L;
    private int retryCount = 0;

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }

    public LinkStatus(DownloadLink downloadLink) {
        this.downloadLink = downloadLink;
    }

    public long getValue() {
        return this.value;
    }

    @Deprecated
    public boolean hasStatus(int status) {
        return (this.status & status) != 0;
    }

    public void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    public void setStatus(int status) {
        this.status = status;
        DownloadLink dl = this.downloadLink;
        if (dl != null && dl.hasNotificationListener()) {
            dl.notifyChanges(AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new DownloadLinkProperty(dl, DownloadLinkProperty.Property.LINKSTATUS, LinkStatus.toString(status)));
        }
    }

    public void setStatusText(String l) {
        if (this.statusText != null && this.statusText.equals(l)) {
            return;
        }
        this.statusText = l;
        DownloadLink dl = this.downloadLink;
        if (dl != null && dl.hasNotificationListener()) {
            dl.notifyChanges(AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new DownloadLinkProperty(dl, DownloadLinkProperty.Property.LINKSTATUS, this.statusText));
        }
    }

    public static String toString(int status) {
        StringBuilder ret = new StringBuilder();
        for (Field f : LinkStatus.class.getDeclaredFields()) {
            if (!Modifier.isStatic(f.getModifiers()) || f.getType() != Integer.TYPE) continue;
            try {
                if (f.getName().startsWith("VALUE") || !BinaryLogic.containsAll((int)status, (int[])new int[]{f.getInt(null)})) continue;
                if (ret.length() > 0) {
                    ret.append(", ");
                }
                ret.append(f.getName());
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return ret.toString();
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append(StringFormatter.fillString((String)Integer.toBinaryString(this.status), (String)"0", (String)"", (int)32) + " < Statuscode\r\n");
        if (this.statusText != null) {
            ret.append("StatusText: ").append(this.statusText).append("\r\n");
        }
        if (this.errorMessage != null) {
            ret.append("ErrorMessage: ").append(this.errorMessage).append("\r\n");
        }
        return ret.toString();
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getStatus() {
        return this.status;
    }
}

