/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.packagecontroller.AbstractNode;
import jd.plugins.Account;
import jd.plugins.AccountInfo;
import jd.plugins.DownloadLink;
import jd.plugins.DownloadLinkProperty;
import jd.plugins.FilePackage;
import jd.plugins.FilePackageProperty;
import org.appwork.storage.config.annotations.LabelInterface;
import org.appwork.utils.StringUtils;
import org.appwork.utils.Time;
import org.appwork.utils.formatter.SizeFormatter;
import org.jdownloader.DomainInfo;
import org.jdownloader.controlling.download.DownloadControllerListener;
import org.jdownloader.gui.translate._GUI;

public class MultiHostHost
implements DownloadControllerListener {
    private Boolean enabled = null;
    private String name = null;
    private List<String> domains = new ArrayList<String>();
    private Boolean isUnlimitedTraffic = null;
    private Boolean isUnlimitedLinks = null;
    private long linksLeft = -1L;
    private long linksMax = -1L;
    private long trafficLeft = -1L;
    private long trafficMax = -1L;
    private String unavailableStatusText = null;
    private long unavailableUntilTimestamp = -1L;
    private Short trafficCalculationFactorPercent = null;
    private int maxChunks = 0;
    private int maxDownloads = -1;
    private Boolean resume = null;
    private String statusText = null;
    private MultihosterHostStatus status = null;
    private static final long MAX_UNAVAILABLE_TIME = 300000L;
    private AccountInfo accountInfo = null;
    private final AtomicBoolean propertyListenerEnabled = new AtomicBoolean(false);
    private DomainInfo domainInfo = null;

    public AccountInfo getAccountInfo() {
        return this.accountInfo;
    }

    protected void setAccountInfo(AccountInfo accountInfo) {
        this.accountInfo = accountInfo;
    }

    public MultiHostHost() {
    }

    public MultiHostHost(String domain) {
        this.name = domain;
        this.setDomain(domain);
    }

    private boolean isEnabled(Boolean booleanValue) {
        return booleanValue == null || booleanValue != false;
    }

    private String getEnabledProperty() {
        return "multihost_" + this.getDomain() + "_enabled";
    }

    public boolean isEnabled() {
        Account ac = this.getAccount();
        boolean ret = ac == null ? this.isEnabled(this.enabled) : ac.getBooleanProperty(this.getEnabledProperty(), this.isEnabled(this.enabled)).booleanValue();
        return ret;
    }

    protected Account getAccount() {
        AccountInfo ai = this.getAccountInfo();
        if (ai == null) {
            return null;
        }
        return ai.getAccount();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        Account ac = this.getAccount();
        if (ac != null) {
            ac.setProperty(this.getEnabledProperty(), this.enabled);
        }
        if (enabled) {
            this.clearErrorStatus();
        }
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.getDomain();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addDomain(String domain) {
        if (domain == null) {
            throw new IllegalArgumentException();
        }
        List<String> domains = this.getDomains();
        if (!domains.contains(domain)) {
            domains.add(domain);
        }
    }

    public DomainInfo getDomainInfo() {
        if (this.domainInfo == null || !StringUtils.equalsIgnoreCase((String)this.getDomain(), (String)this.domainInfo.getDomain())) {
            this.domainInfo = DomainInfo.getInstance(this.getDomain());
        }
        return this.domainInfo;
    }

    public void addDomains(List<String> domains) {
        if (domains == null) {
            throw new IllegalArgumentException();
        }
        for (String domain : domains) {
            this.addDomain(domain);
        }
    }

    public void setDomain(String domain) {
        if (domain == null) {
            throw new IllegalArgumentException();
        }
        this.domains.clear();
        this.domains.add(domain);
    }

    public void setDomains(List<String> domains) {
        if (domains == null) {
            throw new IllegalArgumentException();
        }
        this.domains = domains;
    }

    public long getLinksLeft() {
        return this.linksLeft;
    }

    public void setLinksLeft(long num) {
        this.linksLeft = num;
        this.isUnlimitedLinks = false;
    }

    public long getLinksMax() {
        return this.linksMax;
    }

    public void setLinksMax(long num) {
        this.linksMax = num;
        this.isUnlimitedLinks = false;
    }

    public long getTrafficLeft() {
        return this.trafficLeft;
    }

    public void setTrafficLeft(long trafficLeft) {
        this.trafficLeft = trafficLeft;
        this.isUnlimitedTraffic = false;
    }

    public long getTrafficMax() {
        return this.trafficMax;
    }

    public void setTrafficMax(long bytes) {
        this.trafficMax = bytes;
        this.isUnlimitedTraffic = false;
    }

    public short getTrafficCalculationFactorPercent() {
        if (this.trafficCalculationFactorPercent == null) {
            return 100;
        }
        return this.trafficCalculationFactorPercent;
    }

    public void setTrafficCalculationFactorPercent(short num) {
        this.trafficCalculationFactorPercent = num;
    }

    public boolean isUnlimitedLinks() {
        return this.isUnlimitedLinks == null || this.isUnlimitedLinks != false;
    }

    public void setUnlimitedLinks(Boolean param) {
        this.isUnlimitedLinks = param;
        if (param == null || param.equals(Boolean.TRUE)) {
            this.linksLeft = -1L;
            this.linksMax = -1L;
        }
    }

    public boolean isUnlimitedTraffic() {
        return this.isUnlimitedTraffic == null || this.isUnlimitedTraffic != false;
    }

    public void setUnlimitedTraffic(Boolean param) {
        this.isUnlimitedTraffic = param;
        if (param == null || param.equals(Boolean.TRUE)) {
            this.trafficLeft = -1L;
            this.trafficMax = -1L;
        }
    }

    public String getStatusText() {
        return this.statusText;
    }

    public void setStatusText(String statusText) {
        this.statusText = statusText;
    }

    public String getTitle() {
        if (this.name != null) {
            return this.name;
        }
        if (this.domains != null && this.domains.size() > 0) {
            return this.domains.get(0);
        }
        return null;
    }

    public void setErrorStatus(String text, long waitMillis) {
        this.setUnavailableStatusText(text);
        this.setUnavailableTime(waitMillis);
        if (waitMillis > 0L && this.propertyListenerEnabled.compareAndSet(false, true)) {
            DownloadController.getInstance().getEventSender().addListener((EventListener)this, true);
        }
    }

    public void clearErrorStatus() {
        this.setUnavailableStatusText(null);
        this.setUnavailableTimestamp(-1L);
        if (this.propertyListenerEnabled.compareAndSet(true, false)) {
            DownloadController.getInstance().getEventSender().removeListener((EventListener)this);
        }
    }

    public MultihosterHostStatus getStatus() {
        if (this.status != null) {
            return this.status;
        }
        return MultihosterHostStatus.WORKING;
    }

    public void setStatus(MultihosterHostStatus status) {
        this.status = MultihosterHostStatus.WORKING.equals((Object)status) ? null : status;
    }

    public int getMaxChunks() {
        return this.maxChunks;
    }

    public void setMaxChunks(int maxChunks) {
        this.maxChunks = maxChunks;
    }

    public boolean isResumable() {
        if (this.resume == null) {
            return true;
        }
        return this.resume;
    }

    public void setResumable(boolean resume) {
        this.resume = resume;
    }

    public boolean supportsDomain(String domain) {
        if (domain == null) {
            return false;
        }
        domain = domain.toLowerCase(Locale.ENGLISH);
        return this.getDomains().contains(domain);
    }

    public String getDomain() {
        List<String> domains = this.getDomains();
        if (domains.size() > 0) {
            return domains.get(0);
        }
        return null;
    }

    public List<String> getDomains() {
        return this.domains;
    }

    public String getUnavailableStatusText() {
        return this.unavailableStatusText;
    }

    private void setUnavailableStatusText(String unavailableStatusText) {
        this.unavailableStatusText = unavailableStatusText;
    }

    public long getUnavailableUntilTimestamp() {
        return this.unavailableUntilTimestamp;
    }

    private final void setUnavailableTimestamp(long num) {
        this.unavailableUntilTimestamp = num;
    }

    private final void setUnavailableTime(long milliseconds) {
        long timestampFinal = Math.min(milliseconds, 300000L);
        this.setUnavailableTimestamp(Time.systemIndependentCurrentJVMTimeMillis() + timestampFinal);
    }

    public long getUnavailableTimeMillis() {
        long unavailableTimestamp = this.getUnavailableUntilTimestamp();
        if (unavailableTimestamp > 0L) {
            return this.getUnavailableUntilTimestamp() - Time.systemIndependentCurrentJVMTimeMillis();
        }
        return 0L;
    }

    public int getMaxDownloads() {
        return this.maxDownloads;
    }

    public void setMaxDownloads(int maxDownloads) {
        this.maxDownloads = maxDownloads;
    }

    public String toString() {
        String title = this.getTitle();
        return title + " | Status: " + (Object)((Object)this.getStatus()) + " | StatusText: " + this.getStatusText() + " | UnavailableStatusText: " + this.getUnavailableStatusText() + " | LinksAvailable: " + this.getLinksLeft() + "/" + this.getLinksMax() + " | Traffic: " + SizeFormatter.formatBytes((long)this.getTrafficLeft()) + "/" + SizeFormatter.formatBytes((long)this.getTrafficMax()) + " | Chunks: " + this.getMaxChunks() + " | Resume: " + this.isResumable();
    }

    @Override
    public void onDownloadControllerAddedPackage(FilePackage pkg) {
    }

    @Override
    public void onDownloadControllerStructureRefresh(FilePackage pkg) {
    }

    @Override
    public void onDownloadControllerStructureRefresh() {
    }

    @Override
    public void onDownloadControllerStructureRefresh(AbstractNode node, Object param) {
    }

    @Override
    public void onDownloadControllerRemovedPackage(FilePackage pkg) {
    }

    @Override
    public void onDownloadControllerRemovedLinklist(List<DownloadLink> list) {
    }

    @Override
    public void onDownloadControllerUpdatedData(DownloadLink downloadlink, DownloadLinkProperty property) {
        if (downloadlink != null && DownloadLinkProperty.Property.RESET.equals((Object)property.getProperty()) && downloadlink.getHost().equals(this.getDomain())) {
            this.clearErrorStatus();
        }
    }

    @Override
    public void onDownloadControllerUpdatedData(FilePackage pkg, FilePackageProperty property) {
    }

    @Override
    public void onDownloadControllerUpdatedData(DownloadLink downloadlink) {
    }

    @Override
    public void onDownloadControllerUpdatedData(FilePackage pkg) {
    }

    public static enum MultihosterHostStatus implements LabelInterface
    {
        WORKING{

            public String getLabel() {
                return _GUI.T.multihost_single_host_object_status_working();
            }
        }
        ,
        WORKING_UNSTABLE{

            public String getLabel() {
                return _GUI.T.multihost_single_host_object_status_working_unstable();
            }
        }
        ,
        DEACTIVATED_JDOWNLOADER{

            public String getLabel() {
                return _GUI.T.multihost_single_host_object_status_deactivated_jdownloader();
            }
        }
        ,
        DEACTIVATED_JDOWNLOADER_UNSUPPORTED{

            public String getLabel() {
                return _GUI.T.multihost_single_host_object_status_deactivated_jdownloader_unsupported();
            }
        }
        ,
        DEACTIVATED_JDOWNLOADER_NOT_ALLOWED_BY_ORIGINAL_PLUGIN{

            public String getLabel() {
                return _GUI.T.multihost_single_host_object_status_deactivated_jdownloader_not_allowed_by_original_plugin();
            }
        }
        ,
        DEACTIVATED_MULTIHOST{

            public String getLabel() {
                return _GUI.T.multihost_single_host_object_status_deactivated_multihost();
            }
        }
        ,
        DEACTIVATED_MULTIHOST_NOT_FOR_THIS_ACCOUNT_TYPE{

            public String getLabel() {
                return _GUI.T.multihost_single_host_object_status_deactivated_multihost_not_for_this_account_type();
            }
        };

    }
}

