/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins;

import java.util.regex.Pattern;
import jd.parser.Regex;
import org.jdownloader.controlling.filter.CompiledFiletypeFilter;

public class ParsedFilename {
    private final String originalfilename;
    private final String filenameWithoutExtension;
    private final String filenameWithoutExtensionAdvanced;
    private final String extension;
    private final String extensionAdvanced;
    private final CompiledFiletypeFilter.CompiledFiletypeExtension extCompiled;
    private boolean isMultipartArchive = false;

    public static ParsedFilename parse(String str) {
        return new ParsedFilename(str);
    }

    public ParsedFilename(String filename) {
        if (filename == null) {
            throw new IllegalArgumentException();
        }
        this.originalfilename = filename;
        String extAdvanced = null;
        if (filename.contains(".")) {
            int extensionPosition = filename.lastIndexOf(".");
            this.extension = filename.substring(extensionPosition);
            this.extCompiled = CompiledFiletypeFilter.getExtensionsFilterInterface(this.extension);
            this.filenameWithoutExtension = filename.substring(0, extensionPosition);
            if (this.filenameWithoutExtension.contains(".")) {
                Pattern[] doubleDotExtensionPatterns;
                for (Pattern doubleDotExtensionPattern : doubleDotExtensionPatterns = new Pattern[]{Pattern.compile("(\\.part[0-9]+\\.rar)$", 2), Pattern.compile("(\\.7z\\.[0-9]+)$", 2)}) {
                    extAdvanced = new Regex((Object)filename, doubleDotExtensionPattern).getMatch(0);
                    if (extAdvanced == null) continue;
                    this.isMultipartArchive = true;
                    break;
                }
            }
        } else {
            this.extension = null;
            this.extCompiled = null;
            this.filenameWithoutExtension = filename;
        }
        if (extAdvanced != null) {
            this.extensionAdvanced = extAdvanced;
            this.filenameWithoutExtensionAdvanced = filename.replaceFirst(extAdvanced + "$", "");
        } else {
            this.extensionAdvanced = this.extension;
            this.filenameWithoutExtensionAdvanced = this.filenameWithoutExtension;
        }
    }

    public String getFilenameWithoutExtension() {
        return this.filenameWithoutExtension;
    }

    public String getFilenameWithoutExtensionAdvanced() {
        return this.filenameWithoutExtensionAdvanced;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getExtensionAdvanced() {
        return this.extensionAdvanced;
    }

    public CompiledFiletypeFilter.CompiledFiletypeExtension getExtCompiled() {
        return this.extCompiled;
    }

    public String getOriginalfilename() {
        return this.originalfilename;
    }

    public boolean isMultipartArchive() {
        return this.isMultipartArchive;
    }
}

