/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import jd.controlling.linkcollector.LinkOriginDetails;
import jd.controlling.linkcrawler.CrawledLink;
import jd.nutils.Formatter;
import jd.plugins.ContainerStatus;
import jd.plugins.DownloadLink;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.config.JsonConfig;
import org.appwork.uio.CloseReason;
import org.appwork.uio.ConfirmDialogInterface;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.Application;
import org.appwork.utils.DebugMode;
import org.appwork.utils.Files;
import org.appwork.utils.Regex;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.swing.dialog.ConfirmDialog;
import org.jdownloader.controlling.FileCreationManager;
import org.jdownloader.gui.notify.AbstractBubbleSupport;
import org.jdownloader.gui.notify.BasicNotify;
import org.jdownloader.gui.notify.BubbleNotify;
import org.jdownloader.gui.notify.Element;
import org.jdownloader.gui.notify.gui.AbstractNotifyWindow;
import org.jdownloader.gui.notify.gui.CFG_BUBBLE;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.logging.LogController;
import org.jdownloader.plugins.components.containers.ContainerConfig;
import org.jdownloader.plugins.config.AccountConfigInterface;
import org.jdownloader.plugins.config.PluginConfigInterface;
import org.jdownloader.plugins.config.PluginHost;
import org.jdownloader.plugins.config.Type;
import org.jdownloader.translate._JDT;
import org.jdownloader.utils.JDFileUtils;

public abstract class PluginsC {
    private final Pattern pattern;
    private final String name;
    private final long version;
    protected LogInterface logger = LogController.TRASH;
    private static final PluginsCBubbleSupport INSTANCE = new PluginsCBubbleSupport();
    protected ArrayList<CrawledLink> cls = new ArrayList();
    protected String md5;
    protected byte[] k;
    private final Matcher matcher;
    private CrawledLink currentLink = null;

    public LogInterface getLogger() {
        return this.logger;
    }

    public void setLogger(LogInterface logger) {
        if (logger == null) {
            logger = LogController.TRASH;
        }
        this.logger = logger;
    }

    public static PluginsCBubbleSupport getBubbleSupportInstance() {
        return INSTANCE;
    }

    public PluginsC(String name, String pattern, String rev) {
        this.pattern = Pattern.compile(pattern, 2);
        this.matcher = this.pattern.matcher("");
        this.name = name;
        long version = -1L;
        try {
            version = Formatter.getRevision((String)rev);
        }
        catch (Throwable e) {
            this.logger.log(e);
            version = -1L;
        }
        this.version = version;
    }

    public abstract PluginsC newPluginInstance();

    public abstract ContainerStatus callDecryption(File var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean canHandle(String data) {
        if (data != null) {
            Matcher matcher = this.matcher;
            synchronized (matcher) {
                boolean bl;
                try {
                    bl = this.matcher.reset(data).find();
                    this.matcher.reset("");
                }
                catch (Throwable throwable) {
                    this.matcher.reset("");
                    throw throwable;
                }
                return bl;
            }
        }
        return false;
    }

    public String createContainerString(ArrayList<DownloadLink> downloadLinks) {
        return null;
    }

    public Pattern getSupportedLinks() {
        return this.pattern;
    }

    public String getName() {
        return this.name;
    }

    public long getVersion() {
        return this.version;
    }

    public boolean hideLinks() {
        return true;
    }

    public abstract String[] encrypt(String var1);

    public ArrayList<CrawledLink> getContainedDownloadlinks() {
        ArrayList ret = this.cls;
        return ret == null ? new ArrayList() : ret;
    }

    public synchronized void initContainer(CrawledLink source, File file, byte[] key) throws IOException {
        if (this.cls == null || this.cls.size() == 0) {
            this.logger.info("Init Container");
            if (key != null) {
                this.k = key;
            }
            try {
                ContainerStatus cs = this.callDecryption(file);
                if (cs == null) {
                    this.logger.warning("WTF ContainerStatus null was returned");
                }
                if (cs.isStatus(4)) {
                    this.displayBubbleNotification("Invalid container", "Processing the following container failed for unknown reasons:\n" + file.getAbsolutePath(), new AbstractIcon("addContainer", 32));
                } else if (cs.isStatus(16)) {
                    this.displayBubbleNotification("Invalid container password", "Processing the following container failed because the supplied passwords were incorrect:\n" + file.getAbsolutePath(), new AbstractIcon("addContainer", 32));
                } else if (cs.isStatus(2)) {
                    if (this.getContainedDownloadlinks().size() > 0) {
                        this.displayBubbleNotification("Successfully crawled container", "The following container has been processed successfully:\n" + file.getAbsolutePath(), new AbstractIcon("addContainer", 32));
                    }
                    this.deleteContainer(source, file);
                }
            }
            catch (Throwable e) {
                this.logger.log(e);
            }
        }
    }

    protected ContainerConfig.ContainerDeleteOption getDeleteOption(CrawledLink source, File file) throws Exception {
        if (this.isCrawledContainer(source, file)) {
            this.logger.fine("Do not ask - just delete crawled container: " + this.getDebugString(source, file));
            return ContainerConfig.ContainerDeleteOption.DELETE;
        }
        if (this.isTempContainer(source, file)) {
            this.logger.fine("Do not ask - just delete temp container: " + this.getDebugString(source, file));
            return ContainerConfig.ContainerDeleteOption.DELETE;
        }
        if (this.getContainedDownloadlinks().size() == 0) {
            return ContainerConfig.ContainerDeleteOption.DONT_DELETE;
        }
        ContainerConfig.ContainerDeleteOption ret = ((ContainerConfig)JsonConfig.create(ContainerConfig.class)).getDeleteContainerFilesAfterAddingThemAction();
        if (ContainerConfig.ContainerDeleteOption.ASK_FOR_DELETE.equals((Object)ret)) {
            ConfirmDialog dialog = new ConfirmDialog(0, _JDT.T.AddContainerAction_delete_container_title(), _JDT.T.AddContainerAction_delete_container_msg(file.toString()), new AbstractIcon("help", 32), _GUI.T.lit_yes(), _GUI.T.lit_no()){

                public String getDontShowAgainKey() {
                    return null;
                }
            };
            ConfirmDialogInterface s = (ConfirmDialogInterface)UIOManager.I().show(ConfirmDialogInterface.class, (UserIODefinition)dialog);
            s.throwCloseExceptions();
            ret = s.getCloseReason() == CloseReason.OK ? ContainerConfig.ContainerDeleteOption.DELETE : ContainerConfig.ContainerDeleteOption.DONT_DELETE;
            if (s.isDontShowAgainSelected()) {
                ((ContainerConfig)JsonConfig.create(ContainerConfig.class)).setDeleteContainerFilesAfterAddingThemAction(ret);
            }
        }
        return ret;
    }

    protected boolean isCrawledContainer(CrawledLink source, File file) throws URISyntaxException {
        File originFile = this.from(source.getOriginLink());
        if (originFile == null) {
            return true;
        }
        File sourceFile = this.from(source);
        return sourceFile != null && !originFile.equals(sourceFile);
    }

    protected boolean isTempContainer(CrawledLink source, File file) {
        File tmp = Application.getTempResource((String)"");
        String rel = Files.getRelativePath((File)tmp, (File)file);
        return rel != null;
    }

    protected void deleteContainer(CrawledLink source, File file) throws Exception {
        switch (this.getDeleteOption(source, file)) {
            case DELETE: {
                FileCreationManager.getInstance().delete(file, null);
                this.displayBubbleNotification("Deleted container file", "The following container file has been deleted:\n" + file.getName(), new AbstractIcon("addContainer", 32));
                break;
            }
            case RECYCLE: {
                try {
                    JDFileUtils.moveToTrash(file);
                    this.displayBubbleNotification("Moved container file to trash", "The following processed container file has been moved to trash:\n" + file.getName(), new AbstractIcon("addContainer", 32));
                }
                catch (IOException e) {
                    this.logger.log((Throwable)e);
                    this.logger.info("Could not move file to recycle bin: " + file);
                    this.displayBubbleNotification("Failed to move processed container file to trash", "Failed to move the following processed container file to trash:\n" + file.getName(), new AbstractIcon("addContainer", 32));
                }
                break;
            }
            case ASK_FOR_DELETE: {
                throw new WTFException("How did this happen!?");
            }
        }
    }

    protected String getDebugString(CrawledLink link, File file) {
        LinkOriginDetails originDetails;
        StringBuilder sb = new StringBuilder();
        sb.append(file);
        sb.append("|");
        sb.append(link.getURL());
        CrawledLink originLink = link.getOriginLink();
        if (originLink != link) {
            sb.append("|");
            sb.append(originLink.getURL());
        }
        if ((originDetails = link.getOrigin()) != null) {
            sb.append("|");
            sb.append((Object)originDetails.getOrigin());
        }
        return sb.toString();
    }

    public CrawledLink getCurrentLink() {
        return this.currentLink;
    }

    public void setCurrentLink(CrawledLink currentLink) {
        this.currentLink = currentLink;
    }

    public Class<? extends PluginConfigInterface> getConfigInterface() {
        for (Class<?> cls : this.getClass().getClasses()) {
            if (!PluginConfigInterface.class.isAssignableFrom(cls) || AccountConfigInterface.class.isAssignableFrom(cls)) continue;
            PluginHost anno = cls.getAnnotation(PluginHost.class);
            if (anno != null) {
                Type pluginType;
                if (DebugMode.TRUE_IN_IDE_ELSE_FALSE && (pluginType = Type.CONTAINER) != null && pluginType != anno.type()) {
                    LogController.CL(true).log((Throwable)new Exception("Please check:" + cls + "|type missmatch:" + (Object)((Object)anno.type()) + "!=" + (Object)((Object)pluginType)));
                }
                return cls;
            }
            return cls;
        }
        return null;
    }

    protected File from(CrawledLink source) throws URISyntaxException {
        String sourceURL = new Regex(source.getURL(), "(file:/.+)").getMatch(0);
        if (sourceURL == null) {
            return null;
        }
        String currentURI = sourceURL.replaceFirst("file:///?", "file:///");
        File ret = new File(new URI(currentURI));
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<CrawledLink> decryptContainer(CrawledLink source) {
        if (source.getURL() == null) {
            return null;
        }
        ArrayList<CrawledLink> retLinks = null;
        boolean showException = true;
        try {
            this.setCurrentLink(source);
            File file = this.from(source);
            if (file == null) {
                throw new Throwable("Invalid Container: " + source.getURL());
            }
            if (file.isFile()) {
                this.initContainer(source, file, null);
                retLinks = this.getContainedDownloadlinks();
            }
        }
        catch (Throwable e) {
            this.logger.log(e);
        }
        finally {
            this.setCurrentLink(null);
        }
        if (retLinks == null && showException) {
            this.logger.severe("ContainerPlugin out of date: " + this + " :" + this.getVersion());
        }
        return retLinks;
    }

    protected boolean canBePasswordProtected() {
        return false;
    }

    protected void displayBubbleNotification(String title, String text) {
        this.displayBubbleNotification(title, text, new AbstractIcon("info", 32));
    }

    protected void displayBubbleNotification(final String title, final String text, final Icon icon) {
        PluginsC.getBubbleSupportInstance().show(new BubbleNotify.AbstractNotifyWindowFactory(){

            @Override
            public AbstractNotifyWindow<?> buildAbstractNotifyWindow() {
                return new BasicNotify(title, text, icon);
            }
        });
    }

    public static class PluginsCBubbleSupport
    extends AbstractBubbleSupport {
        private PluginsCBubbleSupport() {
            super(_GUI.T.plugins_optional_JDLightTray_ballon_container(), CFG_BUBBLE.BUBBLE_NOTIFY_CONTAINER_LOADED_ENABLED);
        }

        @Override
        public List<Element> getElements() {
            return null;
        }

        @Override
        protected void show(BubbleNotify.AbstractNotifyWindowFactory factory) {
            super.show(factory);
        }
    }
}

