/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.components;

import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import jd.http.Browser;
import jd.parser.Regex;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;

public class PluginJSonUtils {
    public static final String NULL = new String("null");

    public static String escape(String s) {
        StringBuilder sb = new StringBuilder();
        block9: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                        String ss = Integer.toHexString(ch);
                        sb.append("\\u");
                        for (int k = 0; k < 4 - ss.length(); ++k) {
                            sb.append('0');
                        }
                        sb.append(ss.toUpperCase(Locale.ENGLISH));
                        continue block9;
                    }
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public static String unescape(String s) {
        StringBuilder sb = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        block15: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            try {
                switch (ch) {
                    case '\\': {
                        ch = s.charAt(++i);
                        switch (ch) {
                            case '\"': {
                                sb.append('\"');
                                break;
                            }
                            case '\\': {
                                sb.append('\\');
                                break;
                            }
                            case 'r': {
                                sb.append('\r');
                                break;
                            }
                            case 'n': {
                                sb.append('\n');
                                break;
                            }
                            case 't': {
                                sb.append('\t');
                                break;
                            }
                            case 'f': {
                                sb.append('\f');
                                break;
                            }
                            case 'b': {
                                sb.append('\b');
                                break;
                            }
                            case 'u': {
                                sb2.delete(0, sb2.length());
                                int ii = ++i + 4;
                                while (i < ii) {
                                    ch = s.charAt(i);
                                    sb2.append(ch);
                                    ++i;
                                }
                                --i;
                                sb.append((char)Long.parseLong(sb2.toString(), 16));
                                break;
                            }
                            default: {
                                sb.append(ch);
                                break;
                            }
                        }
                        continue block15;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String getJsonValue(String source, String key) {
        return PluginJSonUtils.getJson(source, key, false);
    }

    public static String getJsonValue(Browser browser, String key) {
        return PluginJSonUtils.getJson(browser.toString(), key, false);
    }

    public static String getJson(String source, String key, boolean returnNullAsString) {
        String xtraResult;
        if (source == null || key == null) {
            return null;
        }
        String result = new Regex(source, "\"" + Pattern.quote(key) + "\"[ \t]*:[ \t]*(![01]|-?\\d+(\\.\\d+)?|true|false|null)").getMatch(0);
        if ("null".equals(result)) {
            if (returnNullAsString) {
                return NULL;
            }
            return null;
        }
        if (result == null && (result = new Regex(source, "\"" + Pattern.quote(key) + "\"[ \t]*:[ \t]*\"([^\"]*)\"").getMatch(0)) != null) {
            while (result.endsWith("\\") && (xtraResult = new Regex(source, "\"" + Pattern.quote(key) + "\"[ \t]*:[ \t]*\"(" + Pattern.quote(result) + "\"[^\"]*\"?)\"").getMatch(0)) != null) {
                result = xtraResult;
            }
        }
        if (result == null) {
            result = new Regex(source, "[^a-zA-Z0-9_\\-]+" + Pattern.quote(key) + "[ \t]*:[ \t]*(![01]|-?\\d+(\\.\\d+)?|true|false|null)").getMatch(0);
            if ("null".equals(result)) {
                if (returnNullAsString) {
                    return NULL;
                }
                return null;
            }
            if (result == null && (result = new Regex(source, "[^a-zA-Z0-9_\\-]+" + Pattern.quote(key) + "[ \t]*:[ \t]*\"([^\"]*)\"").getMatch(0)) != null) {
                while (result.endsWith("\\") && (xtraResult = new Regex(source, "[^a-zA-Z0-9_\\-]+" + Pattern.quote(key) + "[ \t]*:[ \t]*\"(" + Pattern.quote(result) + "\"[^\"]*\"?)\"").getMatch(0)) != null) {
                    result = xtraResult;
                }
            }
            if (result == null) {
                result = new Regex(source, "'" + Pattern.quote(key) + "'[ \t]*:[ \t]*(![01]|-?\\d+(\\.\\d+)?|true|false|null)").getMatch(0);
                if ("null".equals(result)) {
                    if (returnNullAsString) {
                        return NULL;
                    }
                    return null;
                }
                if (result == null && (result = new Regex(source, "'" + Pattern.quote(key) + "'[ \t]*:[ \t]*'([^']*)'").getMatch(0)) != null) {
                    while (result.endsWith("'") && (xtraResult = new Regex(source, "\"" + Pattern.quote(key) + "\"[ \t]*:[ \t]*'(" + Pattern.quote(result) + "'[^']*'?)'").getMatch(0)) != null) {
                        result = xtraResult;
                    }
                }
            }
        }
        if ((result = PluginJSonUtils.validateResultForArrays(source, result)) != null) {
            result = PluginJSonUtils.unescape(result);
        }
        return result;
    }

    public static String getJson(String source, String key) {
        return PluginJSonUtils.getJson(source, key, true);
    }

    public static String getJson(Browser ibr, String key) {
        return PluginJSonUtils.getJson(ibr.toString(), key, true);
    }

    public static String getJson(Browser ibr, String key, boolean returnNullAsString) {
        return PluginJSonUtils.getJson(ibr.toString(), key, returnNullAsString);
    }

    public static String getJsonArray(Browser ibr, String key) {
        return PluginJSonUtils.getJsonArray(ibr.toString(), key);
    }

    public static String getJsonArray(String source, String key) {
        if (source == null || key == null) {
            return null;
        }
        String result = new Regex(source, "\"" + Pattern.quote(key) + "\"\\s*:\\s*(\\[\\s*\\{.*?\\}\\s*\\]|\\[.*?\\])\\s*(?:,|\\})").getMatch(0);
        if (result == null) {
            result = new Regex(source, Pattern.quote(key) + "\\s*:\\s*(\\[\\s*\\{.*?\\}\\s*\\]|\\[.*?\\])\\s*(?:,|\\})").getMatch(0);
        }
        if ((result = PluginJSonUtils.validateResultForArrays(source, result)) != null) {
            result = PluginJSonUtils.unescape(result);
        }
        return result;
    }

    public static String[] getJsonResultsFromArray(String source) {
        if (source == null) {
            return null;
        }
        try {
            List jsonParsed = (List)JSonStorage.restoreFromString((String)source, (TypeRef)TypeRef.LIST);
            if (jsonParsed != null) {
                String[] ret = new String[jsonParsed.size()];
                for (int i = 0; i < ret.length; ++i) {
                    ret[i] = !(jsonParsed.get(i) instanceof String) ? JSonStorage.toString(jsonParsed.get(i)) : String.valueOf(jsonParsed.get(i));
                }
                return ret;
            }
        }
        catch (Throwable jsonParsed) {
            // empty catch block
        }
        String[] result = new Regex(source, "^\\s*\\[\\s*\\{.+$").matches() ? new Regex(source, "\\s*(?:\\[|,)\\s*(\\{.*?\\})\\s*").getColumn(0) : new Regex(source, "\\s*(?:\\[|,)\\s*\"([^\"]*)\"\\s*").getColumn(0);
        if (result != null) {
            for (int i = 0; i < result.length; ++i) {
                result[i] = PluginJSonUtils.validateResultForArrays(source, result[i]);
            }
        }
        return result;
    }

    public static String getJsonNested(Browser ibr, String key) {
        return PluginJSonUtils.getJsonNested(ibr.toString(), key);
    }

    public static String getJsonNested(String source, String key) {
        if (source == null || key == null) {
            return null;
        }
        String result = new Regex(source, "\"" + Pattern.quote(key) + "\"[ \t]*:[ \t]*\\{(.*?)\\}(?:,|\\})").getMatch(0);
        if (result == null) {
            result = new Regex(source, Pattern.quote(key) + "[ \t]*:[ \t]*\\{(.*?)\\}(?:,|\\})").getMatch(0);
        }
        result = PluginJSonUtils.validateResultForArrays(source, result);
        return result;
    }

    public static String ammendJson(String source, String key, Object value) {
        if (key == null || value == null) {
            return null;
        }
        String result = source;
        result = result == null ? "{" : result.substring(0, result.length() - 1) + ",";
        boolean useBracket = value instanceof String;
        result = result.concat("\"" + key + "\":" + (useBracket ? "\"" : "") + (useBracket ? PluginJSonUtils.escape(value.toString()) : value) + (useBracket ? "\"" : "") + "}");
        return result;
    }

    public static String validateResultForArrays(String source, String result) {
        String newi;
        if (result == null) {
            return result;
        }
        String i = result;
        while (true) {
            String[] bracketA = new Regex(i, "(?!\\\\\\{)\\{").getColumn(-1);
            String[] bracketB = new Regex(i, "(?!\\\\\\})\\}").getColumn(-1);
            if (bracketA == null || bracketB == null || bracketA.length == bracketB.length) break;
            newi = new Regex(source, Pattern.quote(i) + "(?!\\\\\\})[^\\}]*\\}").getMatch(-1);
            if (newi == null) {
                return i;
            }
            i = newi;
        }
        while (true) {
            String[] bracketC = new Regex(i, "(?!\\\\\\[)\\[").getColumn(-1);
            String[] bracketD = new Regex(i, "(?!\\\\\\])\\]").getColumn(-1);
            if (bracketC == null || bracketD == null || bracketC.length == bracketD.length) break;
            newi = new Regex(source, Pattern.quote(i) + "(?!\\\\\\])[^\\]]*\\]").getMatch(-1);
            if (newi == null) {
                return i;
            }
            i = newi;
        }
        return i;
    }

    public static boolean parseBoolean(String input) {
        if (input == null) {
            return false;
        }
        if ("yes".equalsIgnoreCase(input)) {
            return true;
        }
        if ("no".equalsIgnoreCase(input)) {
            return false;
        }
        if ("true".equalsIgnoreCase(input)) {
            return true;
        }
        if ("false".equalsIgnoreCase(input)) {
            return false;
        }
        if ("0".equalsIgnoreCase(input)) {
            return false;
        }
        if ("1".equalsIgnoreCase(input)) {
            return true;
        }
        if ("!0".equalsIgnoreCase(input)) {
            return true;
        }
        if ("!1".equalsIgnoreCase(input)) {
            return false;
        }
        return false;
    }
}

