/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.components;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;

public class ZeveraApiTracker {
    private static final ArrayList<String> APIS = new ArrayList();
    private final LinkedHashMap<String, Integer> failures = new LinkedHashMap();
    private String current = null;
    private boolean hasFailed = false;

    private String getRandomApi() {
        return APIS.get(new Random().nextInt(APIS.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String get() {
        LinkedHashMap<String, Integer> linkedHashMap = this.failures;
        synchronized (linkedHashMap) {
            if (this.current != null && !this.hasFailed) {
                return this.current;
            }
            if (this.current == null && this.failures.isEmpty()) {
                this.current = this.getRandomApi();
                this.hasFailed = false;
                return this.current;
            }
            if (this.failures.size() != APIS.size()) {
                this.current = this.getRandomApi();
                while (this.failures.containsKey(this.current)) {
                    this.current = this.getRandomApi();
                }
                this.hasFailed = false;
                return this.current;
            }
            int failure = 0;
            String server = null;
            for (Map.Entry<String, Integer> e : this.failures.entrySet()) {
                if (server == null) {
                    server = e.getKey();
                    failure = e.getValue();
                    continue;
                }
                if (e.getValue() >= failure) continue;
                server = e.getKey();
                failure = e.getValue();
            }
            this.current = server;
            this.hasFailed = false;
            return server;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setFailure() {
        LinkedHashMap<String, Integer> linkedHashMap = this.failures;
        synchronized (linkedHashMap) {
            int currentFailure = this.failures.containsKey(this.current) ? this.failures.get(this.current) : 0;
            this.failures.put(this.current, currentFailure + 1);
            this.current = null;
            this.hasFailed = true;
        }
    }

    static {
        APIS.add("api.");
        APIS.add("api1.");
        APIS.add("api2.");
        APIS.add("api24.");
        APIS.add("api64.");
    }
}

