/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.download.raf;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import jd.plugins.download.SparseFile;
import jd.plugins.download.raf.FileBytesCacheFlusher;
import jd.plugins.download.raf.FileBytesMap;
import org.appwork.utils.Application;
import org.appwork.utils.IO;

public class BytesMappedFile
implements FileBytesCacheFlusher {
    protected final File file;
    protected final FileBytesMap bytesMap;
    protected volatile RandomAccessFile raf = null;
    protected final CopyOnWriteArrayList<BytesMappedFileCallback> callBacks = new CopyOnWriteArrayList();
    protected final WeakHashMap<Thread, Object> locks = new WeakHashMap();
    protected volatile IOException ioException = null;
    protected volatile boolean flushFlag = false;
    private final boolean trySparse;

    public BytesMappedFile(File file) {
        this(file, new FileBytesMap(), true);
    }

    public BytesMappedFile(File file, boolean trySparse) {
        this(file, new FileBytesMap(), trySparse);
    }

    public BytesMappedFile(File file, FileBytesMap fileBytesMap, boolean trySparse) {
        this.file = file;
        this.bytesMap = fileBytesMap;
        this.trySparse = trySparse;
        long fileSize = file.length();
        long finalFileSize = fileBytesMap.getFinalSize();
        long markedBytes = fileBytesMap.getMarkedBytes();
        if (fileSize < markedBytes || finalFileSize >= 0L && fileSize > finalFileSize) {
            throw new IllegalStateException("File:" + file + "|Length:" + file.length() + "|FileBytesMap:" + fileBytesMap);
        }
    }

    public synchronized boolean lock() {
        return this.locks.put(Thread.currentThread(), this) == null;
    }

    public synchronized boolean unlock() {
        return this.locks.remove(Thread.currentThread()) != null;
    }

    public synchronized boolean open(BytesMappedFileCallback callback) throws IOException {
        if (this.raf == null) {
            try {
                if (this.trySparse && Application.getJavaVersion() >= Application.JAVA17) {
                    SparseFile.createSparseFile(this.file);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.raf = IO.open((File)this.file, (String)"rw");
            this.callBacks.add(callback);
            return true;
        }
        this.callBacks.add(callback);
        return false;
    }

    public synchronized boolean isOpen() {
        return this.raf != null && this.callBacks.size() > 0;
    }

    public synchronized boolean isLocked() {
        return this.locks.size() > 0;
    }

    public File getFile() {
        return this.file;
    }

    public FileBytesMap getFileBytesMap() {
        return this.bytesMap;
    }

    public synchronized boolean close(BytesMappedFileCallback callback) throws IOException {
        if (this.callBacks.remove(callback) && this.callBacks.size() == 0) {
            try {
                if (this.raf != null) {
                    try {
                        this.raf.getChannel().force(true);
                    }
                    finally {
                        this.raf.close();
                    }
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.ioException = null;
                this.raf = null;
            }
        }
        return false;
    }

    @Override
    public synchronized void flushed() {
        block8: {
            if (this.raf != null && this.flushFlag) {
                try {
                    if (this.ioException != null) break block8;
                    this.raf.getChannel().force(true);
                    this.onFlushed();
                }
                catch (IOException e) {
                    if (this.ioException != null) {
                        this.ioException = e;
                    }
                }
                finally {
                    this.flushFlag = false;
                    for (BytesMappedFileCallback callback : this.callBacks) {
                        if (callback == null) continue;
                        callback.onFlush(this, this.ioException);
                    }
                }
            }
        }
    }

    protected void onFlushed() throws IOException {
    }

    @Override
    public synchronized void flush(byte[] writeCache, int writeCachePosition, int length, long fileWritePosition) {
        if (this.raf != null && this.ioException == null) {
            try {
                long skippable = this.bytesMap.skippable(fileWritePosition, length);
                if (skippable < (long)length) {
                    int cachePosition = writeCachePosition + (int)skippable;
                    int writeLength = length - (int)skippable;
                    long filePosition = fileWritePosition + skippable;
                    this.raf.seek(filePosition);
                    this.raf.write(writeCache, cachePosition, writeLength);
                    this.bytesMap.mark(filePosition, writeLength);
                    this.flushFlag = true;
                }
            }
            catch (IOException e) {
                this.ioException = e;
            }
        }
    }

    public static interface BytesMappedFileCallback {
        public void onFlush(BytesMappedFile var1, IOException var2);
    }
}

