/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.download.raf;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Locale;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.plugins.download.raf.BytesMappedFile;
import jd.plugins.download.raf.FileBytesMap;
import jd.plugins.download.raf.FileBytesMapViewInterface;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.Storable;
import org.appwork.storage.StorableAllowPrivateAccessModifier;
import org.appwork.storage.TypeRef;
import org.appwork.utils.Files;
import org.appwork.utils.Hash;
import org.appwork.utils.IO;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.logging.LogController;

public class BytesMappedFileManager {
    private final HashMap<File, BytesMappedFile> openFiles = new HashMap();
    private static final BytesMappedFileManager INSTANCE = new BytesMappedFileManager();

    public static BytesMappedFileManager getInstance() {
        return INSTANCE;
    }

    private BytesMappedFileManager() {
    }

    public synchronized FileBytesMap.FileBytesMapView getFileBytesMapView(File file) throws IOException {
        File mapFile = BytesMappedFileManager.getMapFile(file);
        BytesMappedFile ret = this.openFiles.get(mapFile);
        if (ret != null) {
            return new FileBytesMap.FileBytesMapView(ret.getFileBytesMap());
        }
        return new FileBytesMap.FileBytesMapView(this.readFileBytesMap(file));
    }

    public synchronized BytesMappedFile get(File file) throws IOException {
        File mapFile = BytesMappedFileManager.getMapFile(file);
        return this.openFiles.get(mapFile);
    }

    public synchronized BytesMappedFile lock(File file) throws IOException {
        File mapFile = BytesMappedFileManager.getMapFile(file);
        BytesMappedFile ret = this.openFiles.get(mapFile);
        if (ret == null) {
            FileBytesMap fileBytesMap = this.readFileBytesMap(file);
            long fileSize = file.length();
            long finalFileSize = fileBytesMap.getFinalSize();
            long markedBytes = fileBytesMap.getMarkedBytes();
            if (fileSize < markedBytes || finalFileSize >= 0L && fileSize > finalFileSize) {
                LogController.CL(true).severe("PartFileReset:File:" + file + "|Length:" + file.length() + "|FileBytesMap:" + fileBytesMap);
                fileBytesMap.reset();
            }
            ret = new BytesMappedFile(file, fileBytesMap, true){

                @Override
                protected void onFlushed() throws IOException {
                    BytesMappedFileManager.this.write(this);
                }
            };
            this.openFiles.put(mapFile, ret);
        }
        LogController.CL(true).severe("lock:File:" + file + "|FileBytesMap:" + ret.getFileBytesMap());
        ret.lock();
        return ret;
    }

    public synchronized Boolean unlock(BytesMappedFile mappedFile) throws IOException {
        LogController.CL(true).severe("unlock:File:" + mappedFile.getFile());
        File mapFile = BytesMappedFileManager.getMapFile(mappedFile.getFile());
        BytesMappedFile ret = this.openFiles.get(mapFile);
        if (ret != null) {
            if (ret.unlock() && !ret.isOpen() && !ret.isLocked()) {
                LogController.CL(true).severe("removed:File:" + mappedFile.getFile());
                this.openFiles.remove(mapFile);
                return true;
            }
            return false;
        }
        return null;
    }

    public synchronized BytesMappedFile open(BytesMappedFile mappedFile, BytesMappedFile.BytesMappedFileCallback callback) throws IOException {
        File mapFile = BytesMappedFileManager.getMapFile(mappedFile.getFile());
        BytesMappedFile ret = this.openFiles.get(mapFile);
        if (ret != null && mappedFile == ret) {
            LogController.CL(true).severe("open:File:" + mappedFile.getFile() + "|FileBytesMap:" + ret.getFileBytesMap());
            ret.open(callback);
            return ret;
        }
        return null;
    }

    public synchronized BytesMappedFile open(File file, BytesMappedFile.BytesMappedFileCallback callback) throws IOException {
        File mapFile = BytesMappedFileManager.getMapFile(file);
        BytesMappedFile ret = this.openFiles.get(mapFile);
        if (ret == null) {
            FileBytesMap fileBytesMap = this.readFileBytesMap(file);
            long fileSize = file.length();
            long finalFileSize = fileBytesMap.getFinalSize();
            long markedBytes = fileBytesMap.getMarkedBytes();
            if (fileSize < markedBytes || finalFileSize >= 0L && fileSize > finalFileSize) {
                LogController.CL(true).severe("PartFileReset:File:" + file + "|Length:" + file.length() + "|FileBytesMap:" + fileBytesMap);
                fileBytesMap.reset();
            }
            ret = new BytesMappedFile(file, fileBytesMap, true){

                @Override
                protected void onFlushed() throws IOException {
                    BytesMappedFileManager.this.write(this);
                }
            };
            this.openFiles.put(mapFile, ret);
        }
        LogController.CL(true).severe("open:File:" + file + "|FileBytesMap:" + ret.getFileBytesMap());
        ret.open(callback);
        return ret;
    }

    public synchronized Boolean close(BytesMappedFile mappedFile, BytesMappedFile.BytesMappedFileCallback callback) throws IOException {
        LogController.CL(true).severe("close:File:" + mappedFile.getFile());
        File mapFile = BytesMappedFileManager.getMapFile(mappedFile.getFile());
        BytesMappedFile ret = this.openFiles.get(mapFile);
        if (ret != null) {
            if (ret.close(callback) && !ret.isLocked()) {
                LogController.CL(true).severe("removed:File:" + mappedFile.getFile());
                this.openFiles.remove(mapFile);
                return true;
            }
            return false;
        }
        return null;
    }

    public static String getFileBytesMapID(File file) {
        return BytesMappedFileManager.getFileBytesMapID(file.getName());
    }

    public static String getFileBytesMapID(String fileName) {
        String name = CrossSystem.isWindows() || DownloadWatchDog.getInstance().isForceMirrorDetectionCaseInsensitive() ? fileName.toLowerCase(Locale.ENGLISH) : fileName;
        String ext = Files.getExtension((String)name);
        return name.length() + "-" + Hash.getMD5((String)name) + "." + ext + ".jdresume";
    }

    public static File getMapFile(File file) {
        File parentFile = file.getParentFile();
        return new File(parentFile, BytesMappedFileManager.getFileBytesMapID(file));
    }

    protected FileBytesMap readFileBytesMap(File file) throws IOException {
        File mapFile = BytesMappedFileManager.getMapFile(file);
        FileBytesMap ret = new FileBytesMap();
        if (mapFile.exists()) {
            try {
                byte[] bytes = IO.readFile((File)mapFile);
                BytesMappedFileStorable storable = (BytesMappedFileStorable)JSonStorage.stringToObject((String)new String(bytes, "UTF-8"), (TypeRef)new TypeRef<BytesMappedFileStorable>(){}, null);
                if (storable != null) {
                    ret.set(storable);
                }
            }
            catch (IOException e) {
                LogController.CL(true).log((Throwable)e);
                throw e;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(final BytesMappedFile bytesMappedFile) throws IOException {
        BytesMappedFile bytesMappedFile2 = bytesMappedFile;
        synchronized (bytesMappedFile2) {
            File file = bytesMappedFile.getFile();
            File mapFile = BytesMappedFileManager.getMapFile(file);
            try {
                IO.secureWrite((File)mapFile, (IO.WriteToFileCallback)new IO.WriteToFileCallback(){

                    public void writeTo(OutputStream os) throws IOException {
                        JSonStorage.getMapper().writeObject(os, (Object)new BytesMappedFileStorable(bytesMappedFile));
                    }

                    public void onIOException(IOException e) throws IOException {
                    }

                    public void onClosed() {
                    }
                }, (IO.SYNC)IO.SYNC.META_AND_DATA);
            }
            catch (IOException e) {
                LogController.CL(true).log((Throwable)e);
                throw e;
            }
        }
    }

    private static final class BytesMappedFileStorable
    implements Storable,
    FileBytesMapViewInterface {
        private long[][] markedAreas = null;
        private String name = null;
        private long finalSize = -1L;

        @StorableAllowPrivateAccessModifier
        private BytesMappedFileStorable() {
        }

        public BytesMappedFileStorable(BytesMappedFile bytesMappedFile) {
            this.name = bytesMappedFile.getFile().getName();
            FileBytesMap.FileBytesMapView view = new FileBytesMap.FileBytesMapView(bytesMappedFile.getFileBytesMap());
            this.finalSize = view.getFinalSize();
            this.markedAreas = view.getMarkedAreas();
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @Override
        public long getFinalSize() {
            return this.finalSize;
        }

        public void setFinalSize(long finalSize) {
            this.finalSize = finalSize;
        }

        @Override
        public long[][] getMarkedAreas() {
            return this.markedAreas;
        }

        public void setMarkedAreas(long[][] markedAreas) {
            this.markedAreas = markedAreas;
        }
    }
}

