/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.download.raf;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import jd.controlling.downloadcontroller.DiskSpaceReservation;
import jd.controlling.downloadcontroller.DownloadSession;
import jd.controlling.downloadcontroller.ExceptionRunnable;
import jd.controlling.downloadcontroller.FileIsLockedException;
import jd.controlling.downloadcontroller.ManagedThrottledConnectionHandler;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.http.Browser;
import jd.http.Request;
import jd.http.URLConnectionAdapter;
import jd.parser.Regex;
import jd.plugins.DownloadLink;
import jd.plugins.Plugin;
import jd.plugins.PluginException;
import jd.plugins.download.DownloadInterface;
import jd.plugins.download.DownloadLinkDownloadable;
import jd.plugins.download.Downloadable;
import jd.plugins.download.HashInfo;
import jd.plugins.download.HashResult;
import jd.plugins.download.raf.BytesMappedFile;
import jd.plugins.download.raf.BytesMappedFileManager;
import jd.plugins.download.raf.ChunkRange;
import jd.plugins.download.raf.ChunkStrategy;
import jd.plugins.download.raf.FileBytesCache;
import jd.plugins.download.raf.FileBytesCacheFlusher;
import jd.plugins.download.raf.FileBytesMap;
import jd.plugins.download.raf.HTTPChunk;
import jd.plugins.download.raf.HTTPDownloadHints;
import jd.plugins.download.raf.MaxJumpStrategy;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.StringUtils;
import org.appwork.utils.formatter.TimeFormatter;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.net.HTTPHeader;
import org.appwork.utils.net.httpconnection.HTTPConnectionUtils;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.jna.windows.FileSystemHelper;
import org.jdownloader.plugins.DownloadPluginProgress;
import org.jdownloader.plugins.SkipReason;
import org.jdownloader.plugins.SkipReasonException;
import org.jdownloader.settings.GeneralSettings;
import org.jdownloader.translate._JDT;
import org.jdownloader.updatev2.InternetConnectionSettings;

public class HTTPDownloader
extends DownloadInterface
implements FileBytesCacheFlusher,
BytesMappedFile.BytesMappedFileCallback {
    private final AtomicReference<BytesMappedFile> bytesMappedFile = new AtomicReference<Object>(null);
    private volatile File outputCompleteFile;
    private volatile File outputFinalCompleteFile;
    private volatile File outputPartFile;
    private final AtomicBoolean connectedFlag = new AtomicBoolean(false);
    private final AtomicBoolean downloadingFlag = new AtomicBoolean(false);
    private final CopyOnWriteArrayList<HTTPChunk> activeChunks = new CopyOnWriteArrayList();
    private final ArrayList<Runnable> queuedTasks = new ArrayList();
    private int readTimeout = 100000;
    private int requestTimeout = 100000;
    private final AtomicReference<STATEFLAG> stateFlag = new AtomicReference<STATEFLAG>(STATEFLAG.RUN);
    protected int chunksNum = 1;
    protected int maxChunks = 0;
    private boolean tryRangeRequest = false;
    protected Browser browser;
    protected volatile URLConnectionAdapter connection;
    protected final Downloadable downloadable;
    protected final LogInterface logger;
    protected final ManagedThrottledConnectionHandler connectionHandler;
    private long startTimeStamp = -1L;
    private boolean resumedDownload;
    private final FileBytesCache downloadWriteCache;
    private final FileBytesMap cacheMap = new FileBytesMap();
    private final HashMap<HTTPChunk.ERROR, AtomicInteger> errorMap = new HashMap();
    private ChunkStrategy chunkStrategy = null;
    private final HTTPDownloadHints rafHints;

    protected AtomicReference<STATEFLAG> getStateFlag() {
        return this.stateFlag;
    }

    protected synchronized int addError(HTTPChunk.ERROR error) {
        AtomicInteger ret = this.errorMap.get((Object)error);
        if (ret == null) {
            ret = new AtomicInteger(0);
            this.errorMap.put(error, ret);
        }
        return ret.incrementAndGet();
    }

    protected synchronized int removeError(HTTPChunk.ERROR error) {
        AtomicInteger ret = this.errorMap.remove((Object)error);
        if (ret != null) {
            return ret.get();
        }
        return 0;
    }

    protected synchronized boolean hasErrors() {
        return !this.errorMap.isEmpty();
    }

    protected synchronized int getErrors(HTTPChunk.ERROR error) {
        AtomicInteger ret = this.errorMap.get((Object)error);
        if (ret != null) {
            return ret.get();
        }
        return 0;
    }

    protected synchronized void clearErrors() {
        this.errorMap.clear();
    }

    protected FileBytesMap getCacheMap() {
        return this.cacheMap;
    }

    protected HTTPDownloadHints getRafHints() {
        return this.rafHints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChunkNum(final int chunksNum) {
        if (this.checkAccess()) {
            if (this.getMaxChunks() > 0 && chunksNum > this.getMaxChunks()) {
                return;
            }
            this.chunksNum = Math.max(1, chunksNum);
            this.logger.info("setChunkNum: " + this.chunksNum);
            CopyOnWriteArrayList<HTTPChunk> copyOnWriteArrayList = this.activeChunks;
            synchronized (copyOnWriteArrayList) {
                this.activeChunks.notifyAll();
            }
        }
        List<Runnable> list = this.queuedTasks;
        synchronized (list) {
            if (this.downloadingFlag.get()) {
                this.queuedTasks.add(new Runnable(){

                    @Override
                    public void run() {
                        HTTPDownloader.this.setChunkNum(chunksNum);
                    }
                });
            }
        }
        list = this.activeChunks;
        synchronized (list) {
            this.activeChunks.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setMaxChunksNum(int maxChunks) {
        if (this.checkAccess()) {
            this.maxChunks = Math.max(0, maxChunks);
            this.logger.info("setMaxChunks: " + this.maxChunks);
            if (maxChunks > 0 && this.chunksNum > maxChunks) {
                this.setChunkNum(maxChunks);
            }
            CopyOnWriteArrayList<HTTPChunk> copyOnWriteArrayList = this.activeChunks;
            synchronized (copyOnWriteArrayList) {
                this.activeChunks.notifyAll();
            }
            return maxChunks;
        }
        return -1;
    }

    public int getMaxChunks() {
        Integer maxChunksSupported = this.rafHints.getMaxChunksSupported();
        if (maxChunksSupported != null) {
            return Math.max(this.maxChunks, maxChunksSupported);
        }
        return this.maxChunks;
    }

    public int getChunkNum() {
        return this.chunksNum;
    }

    public int getActiveChunks() {
        return this.activeChunks.size();
    }

    @Override
    public ManagedThrottledConnectionHandler getManagedConnetionHandler() {
        return this.connectionHandler;
    }

    public HTTPDownloader(Downloadable downloadLink, Request request) throws IOException, PluginException {
        this.connectionHandler = new ManagedThrottledConnectionHandler();
        this.downloadable = downloadLink;
        this.logger = downloadLink.getLogger();
        this.browser = downloadLink.getContextBrowser();
        InternetConnectionSettings config = (InternetConnectionSettings)JsonConfig.create((String)"cfg/org.jdownloader.settings.InternetConnectionSettings", InternetConnectionSettings.class);
        this.setRequestTimeout(config.getHttpConnectTimeout());
        this.setReadTimeout(config.getHttpReadTimeout());
        this.setInitialRequest(request);
        downloadLink.setDownloadInterface(this);
        this.downloadWriteCache = DownloadSession.getDownloadWriteCache();
        this.chunkStrategy = new MaxJumpStrategy(this, 524288000L, 524288L);
        this.rafHints = (HTTPDownloadHints)this.downloadable.getDataBindingInterface(HTTPDownloadHints.class);
    }

    protected boolean checkAccess() {
        Thread thread = Thread.currentThread();
        return thread instanceof SingleDownloadController && ((SingleDownloadController)((Object)thread)).getDownloadInstance() == this;
    }

    public void setResume(boolean value) {
        if (this.checkAccess()) {
            this.logger.info("setResume: " + value);
            this.tryRangeRequest = value;
            this.downloadable.setResumeable(value);
        }
    }

    protected boolean tryRangeRequest() {
        Boolean isRangeRequestSupported = this.rafHints.isRangeRequestSupported();
        if (isRangeRequestSupported != null) {
            return isRangeRequestSupported;
        }
        return this.tryRangeRequest || this.downloadable.isServerComaptibleForByteRangeRequest();
    }

    @Override
    public long getStartTimeStamp() {
        return this.startTimeStamp;
    }

    protected Browser getBrowser() {
        return this.browser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URLConnectionAdapter connect() throws IOException, PluginException {
        if (this.connectedFlag.compareAndSet(false, true)) {
            boolean okayFlag = false;
            try {
                Boolean validation;
                Browser br = this.getBrowser();
                this.setReadTimeout(br.getReadTimeout());
                this.setRequestTimeout(br.getConnectTimeout());
                this.initialRequest.setConnectTimeout(this.getRequestTimeout());
                this.initialRequest.setReadTimeout(this.getReadTimeout());
                File partFile = new File(this.downloadable.getFileOutputPart());
                BytesMappedFile lockedBytesMappedFile = this.bytesMappedFile.get();
                if (lockedBytesMappedFile == null || BytesMappedFileManager.getInstance().get(partFile) != lockedBytesMappedFile) {
                    this.closeBytesMappedFile();
                    lockedBytesMappedFile = BytesMappedFileManager.getInstance().lock(partFile);
                    this.bytesMappedFile.set(lockedBytesMappedFile);
                }
                if ((validation = this.validateFileBytesMapView(lockedBytesMappedFile.getFileBytesMap())) != null && validation.booleanValue()) {
                    this.logger.info("Valid CacheMap available");
                    this.cacheMap.set(lockedBytesMappedFile.getFileBytesMap());
                } else {
                    this.logger.info("No CacheMap available");
                    this.cacheMap.reset();
                }
                this.connection = this.openConnection(null);
                if (this.initialRequest.getLocation() != null) {
                    URLConnectionAdapter uRLConnectionAdapter = this.connection;
                    return uRLConnectionAdapter;
                }
                if (this.tryRangeRequest()) {
                    if (this.downloadable.isServerComaptibleForByteRangeRequest() && this.connection.getRequestProperty("Range") == null) {
                        this.logger.info("Try again with range request if possible");
                        this.connection.disconnect();
                        this.connection = this.openConnection(true);
                    }
                    if (this.connection.getResponseCode() == 416) {
                        this.addError(HTTPChunk.ERROR.RANGE);
                        this.logger.info("Try again to avoid 416");
                        this.connection.disconnect();
                        this.connection = this.openConnection(false);
                    }
                }
                okayFlag = true;
                URLConnectionAdapter uRLConnectionAdapter = this.connection;
                return uRLConnectionAdapter;
            }
            finally {
                this.connectedFlag.set(okayFlag);
            }
        }
        throw new IllegalStateException("Already connecting/connected");
    }

    public VALIDATION_RESULT validateConnection(URLConnectionAdapter validatingConnection) {
        VALIDATION_RESULT result = new VALIDATION_RESULT();
        URLConnectionAdapter initialConnection = this.connection;
        if (initialConnection == null) {
            result.setFailed(VALIDATION.CONNECTION_MISSING);
            return result;
        }
        boolean validationWorkaround = StringUtils.contains((String)validatingConnection.getHeaderField("Server"), (String)"IIS");
        if (!validationWorkaround) {
            String bContentType;
            String aContentType;
            if (initialConnection.isContentDisposition() && validatingConnection.isContentDisposition()) {
                result.setOk(VALIDATION.CONTENT_DISPOSITION);
                String aFileName = Plugin.getFileNameFromDispositionHeader(initialConnection);
                String bFileName = Plugin.getFileNameFromDispositionHeader(validatingConnection);
                if (!StringUtils.equals((String)aFileName, (String)bFileName)) {
                    this.logger.severe("sameContent: FALSE|Filename:'" + aFileName + "'<->'" + bFileName + "'");
                    result.setFailed(VALIDATION.CONTENT_DISPOSITION_NAME);
                } else {
                    result.setOk(VALIDATION.CONTENT_DISPOSITION_NAME);
                }
            }
            if (!StringUtils.equals((String)(aContentType = initialConnection.getHeaderField("Content-Type")), (String)(bContentType = validatingConnection.getHeaderField("Content-Type")))) {
                this.logger.severe("sameContent: FALSE|ContentType:'" + aContentType + "'<->'" + bContentType + "'");
                result.setFailed(VALIDATION.CONTENT_TYPE);
            } else {
                result.setOk(VALIDATION.CONTENT_TYPE);
            }
            long verifiedFileSize = this.getVerifiedFileSize();
            if (verifiedFileSize >= 0L) {
                long connectionLength = HTTPDownloader.getCompleteContentLength(this.logger, validatingConnection, true);
                if (connectionLength >= 0L && verifiedFileSize != connectionLength) {
                    this.logger.severe("sameContent: FALSE|verifiedFileSize:'" + verifiedFileSize + "'<->'" + connectionLength + "'");
                    result.setFailed(VALIDATION.VERIFIED_SIZE);
                } else if (connectionLength < 0L && HTTPDownloader.getCompleteContentLength(this.logger, initialConnection, true) >= 0L) {
                    this.logger.severe("sameContent: FALSE|missingContentLength");
                    result.setFailed(VALIDATION.CONTENT_LENGTH);
                } else {
                    result.setOk(VALIDATION.VERIFIED_SIZE);
                    result.setOk(VALIDATION.CONTENT_LENGTH);
                }
            }
            if (result.isOk()) {
                this.logger.severe("sameContent: TRUE");
            }
            return result;
        }
        this.logger.severe("sameContent: TRUE(IIS Workaround)");
        return result;
    }

    @Override
    public URLConnectionAdapter connect(Browser br) throws Exception {
        if (this.initialRequest == null) {
            throw new IllegalStateException("Wrong Mode. Instance is in direct Connection mode");
        }
        this.logger.finer("Connecting...");
        if (this.browser != br) {
            this.logger.info("Different Browser Instance for openDownload and connect!");
            this.browser = br;
        }
        return this.connect();
    }

    protected static long[] parseRequestRange(String bytes) {
        return HTTPConnectionUtils.parseRequestRange((String)bytes);
    }

    protected URLConnectionAdapter openConnection(Boolean requestRangeIfPossible) throws IOException {
        URLConnectionAdapter connection;
        String rangeRequest;
        boolean tryRangeRequest = this.tryRangeRequest() && !Boolean.FALSE.equals(requestRangeIfPossible);
        List<ChunkRange> unMarkedAreas = this.chunkStrategy.getUnMarkedAreas();
        long verifiedFileSize = this.downloadable.getVerifiedFileSize();
        if (tryRangeRequest && unMarkedAreas.size() > 0 && unMarkedAreas.get(0).getFrom() > 0L) {
            ChunkRange chunkRange = unMarkedAreas.get(0);
            rangeRequest = chunkRange.getRangeHeaderContent(true);
        } else {
            rangeRequest = Boolean.TRUE.equals(requestRangeIfPossible) ? new ChunkRange(0L).getRangeHeaderContent(true) : null;
        }
        this.initialRequest.getHeaders().put(new HTTPHeader("Accept-Encoding", "identity", false));
        if (rangeRequest != null) {
            long[] contentRange;
            if (this.initialRequest.getHeaders().getHeader("Range") != null) {
                this.logger.info("Override Header:" + this.initialRequest.getHeaders().getHeader("Range"));
                this.initialRequest.getHeaders().remove("Range");
            }
            this.initialRequest.getHeaders().put(new HTTPHeader("Range", rangeRequest, false));
            connection = this.browser.openRequestConnection(this.initialRequest, false);
            if (connection.getRequest().getLocation() != null) {
                return connection;
            }
            if ((connection.getResponseCode() == 200 || connection.getResponseCode() == 206) && (contentRange = connection.getRange()) != null && verifiedFileSize >= 0L && contentRange[2] != verifiedFileSize) {
                if (connection.isContentDecoded()) {
                    this.logger.info("Ignore Response: verifiedFileSize does match contentRange/Length with Content-Encoding:" + connection.getHeaderField("Content-Encoding"));
                } else {
                    this.logger.info("Strange Response: verifiedFileSize does match contentRange/Length with Content-Encoding:" + connection.getHeaderField("Content-Encoding"));
                }
            }
            return connection;
        }
        if (this.initialRequest.getHeaders().getHeader("Range") != null) {
            this.logger.info("Override Header:" + this.initialRequest.getHeaders().getHeader("Range"));
            this.initialRequest.getHeaders().remove("Range");
        }
        this.initialRequest.getHeaders().put(new HTTPHeader("Range", null, false));
        connection = this.browser.openRequestConnection(this.initialRequest, false);
        if (connection.getRequest().getLocation() != null) {
            return connection;
        }
        long[] contentRange = connection.getRange();
        if (contentRange != null) {
            this.logger.info("Strange Response: received contentRange/Length and not having asked for a range!");
            if (contentRange[0] != 0L) {
                throw new IOException("Invalid Response: contentRange does not start at 0!");
            }
            if (verifiedFileSize >= 0L) {
                if (contentRange[2] == verifiedFileSize) {
                    this.logger.info("Strange Response: verifiedFileSize(" + verifiedFileSize + ") does match contentRange/Length(" + contentRange[2] + ")!");
                } else if (connection.getResponseCode() == 200 || connection.getResponseCode() == 206) {
                    this.logger.severe("Invalid Response: verifiedFileSize(" + verifiedFileSize + ") does not match contentRange/Length(" + contentRange[2] + ")!");
                }
            }
        }
        return connection;
    }

    protected Boolean validateFileBytesMapView(FileBytesMap fileBytesMap) {
        if (fileBytesMap == null || fileBytesMap.getMarkedBytes() == 0L) {
            return false;
        }
        long verifiedFileSize = this.downloadable.getVerifiedFileSize();
        if (verifiedFileSize >= 0L) {
            long finalFileSize = fileBytesMap.getFinalSize();
            if (finalFileSize >= 0L) {
                return finalFileSize == verifiedFileSize;
            }
            long currentSize = fileBytesMap.getSize();
            return verifiedFileSize >= currentSize;
        }
        return false;
    }

    protected int getReadTimeout() {
        return Math.max(10000, this.readTimeout);
    }

    protected int getRequestTimeout() {
        return Math.max(10000, this.requestTimeout);
    }

    protected boolean isFileComplete() {
        BytesMappedFile bytesMappedFile = this.bytesMappedFile.get();
        if (bytesMappedFile != null) {
            long markedSize = bytesMappedFile.getFileBytesMap().getMarkedBytes();
            long expectedFileSize = bytesMappedFile.getFileBytesMap().getFinalSize();
            if (expectedFileSize >= 0L) {
                boolean ret = markedSize == expectedFileSize;
                this.logger.info("isFileComplete: ExpectedSize:" + expectedFileSize + "|MarkedSize:" + markedSize + "=" + ret);
                return ret;
            }
            long verifiedFileSize = this.getVerifiedFileSize();
            if (verifiedFileSize >= 0L) {
                boolean ret = markedSize == verifiedFileSize;
                this.logger.info("isFileComplete: VerifiedFileSize:" + verifiedFileSize + "|MarkedSize:" + markedSize + "=" + ret);
                return ret;
            }
        }
        return false;
    }

    protected boolean isDownloadComplete() {
        if (this.isFileComplete()) {
            return true;
        }
        if (!this.externalDownloadStop() && !this.hasErrors()) {
            this.logger.info("isDownloadComplete: errorFree=true");
            return true;
        }
        this.logger.info("isDownloadComplete: false");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onChunkFinished(HTTPChunk chunk) {
        if (this.activeChunks.contains(chunk)) {
            CopyOnWriteArrayList<HTTPChunk> copyOnWriteArrayList = this.activeChunks;
            synchronized (copyOnWriteArrayList) {
                this.activeChunks.notifyAll();
            }
        }
    }

    protected byte[] getChunkBuffer(HTTPChunk chunk) {
        return new byte[32768];
    }

    private void setRangeRequestSupported(Boolean b) {
        this.logger.info("setRangeRequestSupported: " + b);
        this.rafHints.setRangeRequestSupported(b);
    }

    private void setMaxChunksSupported(Integer maxChunks) {
        this.logger.info("setMaxChunksSupported: " + maxChunks);
        this.rafHints.setMaxChunksSupported(maxChunks);
        if (maxChunks != null) {
            this.setMaxChunksNum(maxChunks);
        }
    }

    private void parseHashesFromHeaders() {
        HashInfo hashInfo = HTTPDownloader.getHashInfoFromHeaders(this.getLogger(), this.connection);
        if (hashInfo != null) {
            this.downloadable.setHashInfo(hashInfo);
        }
    }

    private static HashInfo newConnectionHashInfo(LogInterface logger, String hash, HashInfo.TYPE type) {
        try {
            return new ConnectionHashInfo(hash, type);
        }
        catch (IllegalArgumentException e) {
            if (logger != null) {
                logger.log((Throwable)e);
            } else {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static HashInfo getHashInfoFromHeaders(LogInterface logger, URLConnectionAdapter con) {
        HashInfo hashInfo = HTTPDownloader.parseXGoogHash(logger, con);
        if (hashInfo == null) {
            hashInfo = HTTPDownloader.parseAmazonHash(logger, con);
        }
        if (hashInfo == null) {
            String contentEncoding = con.getHeaderField("Content-Encoding");
            String requestContentRange = con.getRequestProperty("Range");
            if (con.getHeaderField("X-Mod-H264-Streaming") == null && HTTPDownloader.isNoneContentEncoding(contentEncoding) && requestContentRange == null && HTTPDownloader.getCompleteContentLength(logger, con, false) >= 0L) {
                String contentSHA1 = con.getHeaderField("Content-SHA1");
                String contentMD5 = con.getHeaderField("Content-MD5");
                HashInfo hashInfo2 = hashInfo = contentSHA1 != null ? HTTPDownloader.newConnectionHashInfo(logger, contentSHA1, HashInfo.TYPE.SHA1) : null;
                hashInfo = hashInfo == null ? (contentMD5 != null ? HTTPDownloader.newConnectionHashInfo(logger, contentMD5, HashInfo.TYPE.MD5) : null) : hashInfo;
            }
        }
        return hashInfo;
    }

    public static HashInfo parseXGoogHash(LogInterface logger, URLConnectionAdapter con) {
        HashInfo ret = null;
        List googleHashList = con.getRequest().getResponseHeaders("X-Goog-Hash");
        if (googleHashList != null && googleHashList.size() > 0) {
            for (String googleHash : googleHashList) {
                if (googleHash == null) continue;
                try {
                    HashInfo hashInfo;
                    String md5 = new Regex(googleHash, "md5\\s*=\\s*([^,]+)").getMatch(0);
                    String crc32c = new Regex(googleHash, "crc32c\\s*=\\s*([^,]+)").getMatch(0);
                    if (md5 != null) {
                        hashInfo = HTTPDownloader.newConnectionHashInfo(logger, md5, HashInfo.TYPE.MD5);
                    } else {
                        if (crc32c == null) continue;
                        hashInfo = HTTPDownloader.newConnectionHashInfo(logger, crc32c, HashInfo.TYPE.CRC32C);
                    }
                    if (hashInfo == null || ret != null && !hashInfo.isStrongerThan(ret)) continue;
                    ret = hashInfo;
                }
                catch (Exception ignore) {
                    logger.log((Throwable)ignore);
                }
            }
        }
        return ret;
    }

    public static HashInfo parseAmazonHash(LogInterface logger, URLConnectionAdapter con) {
        List amazonHashList = con.getRequest().getResponseHeaders("x-amz-meta-md5-hash");
        if (amazonHashList != null && amazonHashList.size() > 0) {
            for (String amazonHash : amazonHashList) {
                HashInfo ret;
                if (amazonHash == null || (ret = HTTPDownloader.newConnectionHashInfo(logger, amazonHash, HashInfo.TYPE.MD5)) == null) continue;
                return ret;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startDownload() throws Exception {
        try {
            DiskSpaceReservation reservation;
            block69: {
                boolean bl;
                try {
                    this.downloadable.validateLastChallengeResponse();
                }
                catch (Throwable e) {
                    LogSource.exception((LogInterface)this.logger, (Throwable)e);
                }
                this.logger.finer("Start Downloading");
                if (!this.connectedFlag.get()) {
                    this.connect(this.getBrowser());
                    if (this.connection != null && this.connection.getRequest().getLocation() != null) {
                        throw new PluginException(0x400000, "Redirectloop");
                    }
                }
                if (this.connection == null || !this.connection.isOK()) {
                    if (this.connection != null) {
                        this.logger.finest(this.connection.toString());
                    }
                    throw new PluginException(0x400000);
                }
                this.downloadable.setAvailable(DownloadLink.AvailableStatus.TRUE);
                this.downloadable.updateFinalFileName();
                long contentLength = HTTPDownloader.getCompleteContentLength(this.logger, this.connection, true);
                String requestContentRange = this.connection.getRequestProperty("Range");
                long[] requestedRange = HTTPDownloader.parseRequestRange(requestContentRange);
                String responseContentEncoding = this.connection.getHeaderField("Content-Encoding");
                String responseAcceptRanges = this.connection.getHeaderField("Accept-Ranges");
                long[] responseContentRange = this.connection.getRange();
                if (this.connection.getHeaderField("Cf-Bgj") != null) {
                    this.logger.info("Cloudflare Image Compression detected!");
                }
                if (requestContentRange != null) {
                    this.logger.info("InitialConnection with RangeRequest: " + requestContentRange);
                    if (responseContentRange != null) {
                        if (responseContentRange[0] != requestedRange[0]) {
                            throw new WTFException("FIXME: RangeError(From)");
                        }
                        if (requestedRange[1] >= 0L && responseContentRange[1] != requestedRange[1]) {
                            throw new WTFException("FIXME: RangeError(To)");
                        }
                    } else if (!"bytes".equalsIgnoreCase(responseAcceptRanges)) {
                        this.logger.info("It seems RangeRequest is not supported: " + responseAcceptRanges);
                        this.setRangeRequestSupported(false);
                    }
                } else {
                    this.logger.info("InitialConnection without RangeRequest");
                    if (this.getErrors(HTTPChunk.ERROR.RANGE) > 0) {
                        this.removeError(HTTPChunk.ERROR.RANGE);
                        this.logger.info("It seems RangeRequest is not supported because it failed: " + responseAcceptRanges);
                        this.setRangeRequestSupported(false);
                    }
                }
                if (this.connection.getResponseCode() == 206) {
                    this.setRangeRequestSupported(true);
                }
                if (!HTTPDownloader.isNoneContentEncoding(responseContentEncoding)) {
                    this.logger.severe("Content-Encoding(" + responseContentEncoding + ") prevents RangeRequest!");
                    this.setRangeRequestSupported(false);
                    if (responseContentRange != null) {
                        if (responseContentRange[0] > 0L) {
                            throw new WTFException("UNSUPPORTED: resume content-Encoding");
                        }
                        if (contentLength >= 0L && responseContentRange[1] + 1L != contentLength) {
                            throw new WTFException("UNSUPPORTED: chunked content-Encoding");
                        }
                    } else if (requestedRange[0] >= 0L && requestedRange[0] != 0L) {
                        throw new WTFException("UNSUPPORTED: resume content-Encoding");
                    }
                }
                this.parseHashesFromHeaders();
                reservation = this.downloadable.createDiskSpaceReservation();
                try {
                    if (!this.downloadable.checkIfWeCanWrite(new ExceptionRunnable(){

                        @Override
                        public void run() throws Exception {
                            HTTPDownloader.this.downloadable.checkAndReserve(reservation);
                            HTTPDownloader.this.createOutputChannel();
                            try {
                                HTTPDownloader.this.downloadable.lockFiles(HTTPDownloader.this.outputCompleteFile, HTTPDownloader.this.outputFinalCompleteFile, HTTPDownloader.this.outputPartFile);
                            }
                            catch (FileIsLockedException e) {
                                HTTPDownloader.this.downloadable.unlockFiles(HTTPDownloader.this.outputCompleteFile, HTTPDownloader.this.outputFinalCompleteFile, HTTPDownloader.this.outputPartFile);
                                throw new PluginException(8192, null, e);
                            }
                        }
                    }, null)) {
                        throw new SkipReasonException(SkipReason.INVALID_DESTINATION);
                    }
                    BytesMappedFile lockedBytesMappedFile = this.bytesMappedFile.get();
                    if (lockedBytesMappedFile == null || BytesMappedFileManager.getInstance().get(this.outputPartFile) != lockedBytesMappedFile) {
                        if (lockedBytesMappedFile != null) {
                            this.logger.warning("WARNING: BytesMappedFile changed!");
                        }
                        this.closeBytesMappedFile();
                        lockedBytesMappedFile = BytesMappedFileManager.getInstance().lock(this.outputPartFile);
                        this.bytesMappedFile.set(lockedBytesMappedFile);
                    }
                    BytesMappedFileManager.getInstance().open(lockedBytesMappedFile, (BytesMappedFile.BytesMappedFileCallback)this);
                    FileBytesMap fileBytesMap = lockedBytesMappedFile.getFileBytesMap();
                    long verifiedFileSize = this.downloadable.getVerifiedFileSize();
                    long compareSize = fileBytesMap.getFinalSize();
                    if (fileBytesMap.getMarkedBytes() > 0L) {
                        if (contentLength >= 0L) {
                            if (fileBytesMap.getSize() > contentLength) {
                                throw new WTFException("FIXME: sizeMissmatch of BytesMappedFile(" + fileBytesMap.getSize() + ") and Content-Length(" + contentLength + ")");
                            }
                            if (fileBytesMap.getFinalSize() < 0L) {
                                this.logger.info("Set Content-Length(" + contentLength + ") for BytesMappedFile");
                                fileBytesMap.setFinalSize(contentLength);
                            }
                        } else if (verifiedFileSize >= 0L) {
                            if (fileBytesMap.getSize() > verifiedFileSize) {
                                throw new WTFException("FIXME: sizeMissmatch of BytesMappedFile(" + fileBytesMap.getSize() + ") and VerifiedFileSize(" + verifiedFileSize + ")");
                            }
                            if (fileBytesMap.getFinalSize() < 0L) {
                                this.logger.info("Set VerifiedFileSize(" + verifiedFileSize + ") for BytesMappedFile");
                                fileBytesMap.setFinalSize(verifiedFileSize);
                            }
                        }
                    } else if (contentLength >= 0L) {
                        this.logger.info("Use Content-Length(" + contentLength + ") for BytesMappedFile");
                        fileBytesMap.setFinalSize(contentLength);
                        if (verifiedFileSize >= 0L && contentLength != verifiedFileSize) {
                            this.logger.info("Warning Content-Length(" + contentLength + ") does not match VerifiedFileSize(" + verifiedFileSize + ")");
                        }
                    } else if (verifiedFileSize >= 0L) {
                        this.logger.info("Use VerifiedFileSize(" + verifiedFileSize + ") for BytesMappedFile");
                        fileBytesMap.setFinalSize(verifiedFileSize);
                    }
                    if (fileBytesMap.getFinalSize() != this.downloadable.getVerifiedFileSize() || fileBytesMap.getFinalSize() != compareSize) {
                        long mapSize = fileBytesMap.getFinalSize();
                        this.logger.info("Update BytesMappedFile(" + mapSize + ")");
                        BytesMappedFileManager.getInstance().write(lockedBytesMappedFile);
                        if (mapSize >= 0L) {
                            this.logger.info("Update VerifiedFileSize(" + mapSize + ")");
                            this.downloadable.setVerifiedFileSize(mapSize);
                        }
                    }
                    this.cacheMap.set(fileBytesMap);
                    if (!this.tryRangeRequest()) {
                        this.logger.info("Range-Request is not supported: reset cacheMap");
                        this.cacheMap.reset();
                        this.cacheMap.setFinalSize(fileBytesMap.getFinalSize());
                    }
                    boolean bl2 = this.resumedDownload = this.cacheMap.getMarkedBytes() > 0L;
                    if (!this.download()) break block69;
                    this.logger.info("Download is complete");
                    HashResult hashResult = this.getHashResult(this.downloadable, this.outputPartFile);
                    if (hashResult != null) {
                        this.logger.info(hashResult.toString());
                    }
                    this.downloadable.setHashResult(hashResult);
                    if (hashResult == null || hashResult.match()) {
                        this.downloadable.setVerifiedFileSize(this.outputPartFile.length());
                    } else if (hashResult.getHashInfo().isTrustworthy()) {
                        throw new PluginException(16384, _JDT.T.system_download_doCRC2_failed((Object)hashResult.getHashInfo().getType()));
                    }
                    this.finalizeDownload(this.outputPartFile, this.outputCompleteFile);
                    this.downloadable.setLinkStatus(2);
                    bl = true;
                }
                catch (Throwable throwable) {
                    try {
                        this.closeBytesMappedFile();
                        try {
                            this.downloadable.free(reservation);
                        }
                        catch (Throwable ignore) {
                            LogSource.exception((LogInterface)this.logger, (Throwable)ignore);
                        }
                    }
                    catch (Throwable throwable2) {
                        this.downloadable.unlockFiles(this.outputCompleteFile, this.outputFinalCompleteFile, this.outputPartFile);
                        throw throwable2;
                    }
                    this.downloadable.unlockFiles(this.outputCompleteFile, this.outputFinalCompleteFile, this.outputPartFile);
                    throw throwable;
                }
                try {
                    this.closeBytesMappedFile();
                    try {
                        this.downloadable.free(reservation);
                    }
                    catch (Throwable ignore) {
                        LogSource.exception((LogInterface)this.logger, (Throwable)ignore);
                    }
                }
                catch (Throwable throwable) {
                    this.downloadable.unlockFiles(this.outputCompleteFile, this.outputFinalCompleteFile, this.outputPartFile);
                    throw throwable;
                }
                this.downloadable.unlockFiles(this.outputCompleteFile, this.outputFinalCompleteFile, this.outputPartFile);
                return bl;
            }
            if (!this.externalDownloadStop()) {
                if (this.getErrors(HTTPChunk.ERROR.NOT_ENOUGH_SPACE_ON_DISK) > 0) {
                    throw new SkipReasonException(SkipReason.DISK_FULL);
                }
                if (this.getErrors(HTTPChunk.ERROR.FLUSHING) > 0) {
                    throw new SkipReasonException(SkipReason.DISK_FULL);
                }
                if (this.getErrors(HTTPChunk.ERROR.CONNECTING) > 0 || this.getErrors(HTTPChunk.ERROR.DOWNLOADING) > 0) {
                    throw new PluginException(512, 1L);
                }
                throw new PluginException(512, _JDT.T.download_error_message_incomplete());
            }
            boolean bl = false;
            try {
                this.closeBytesMappedFile();
                try {
                    this.downloadable.free(reservation);
                }
                catch (Throwable ignore) {
                    LogSource.exception((LogInterface)this.logger, (Throwable)ignore);
                }
            }
            catch (Throwable throwable) {
                this.downloadable.unlockFiles(this.outputCompleteFile, this.outputFinalCompleteFile, this.outputPartFile);
                throw throwable;
            }
            this.downloadable.unlockFiles(this.outputCompleteFile, this.outputFinalCompleteFile, this.outputPartFile);
            return bl;
        }
        finally {
            this.cleanupDownladInterface();
        }
    }

    private static boolean isNoneContentEncoding(String contentEncoding) {
        return contentEncoding == null || "none".equalsIgnoreCase(contentEncoding);
    }

    protected static long getCompleteContentLength(LogInterface logger, URLConnectionAdapter connection, boolean forceTrustContentLength) {
        if (connection != null) {
            String contentEncoding = connection.getHeaderField("Content-Encoding");
            if (!HTTPDownloader.isNoneContentEncoding(contentEncoding)) {
                logger.info("Don't trust ContentLength:contentEncoding=" + contentEncoding);
                return -1L;
            }
            String h264StreamingMod = connection.getHeaderField("X-Mod-H264-Streaming");
            if (forceTrustContentLength || HTTPDownloader.isNoneContentEncoding(contentEncoding) && h264StreamingMod == null) {
                long[] contentRange = connection.getRange();
                if (contentRange != null && contentRange[2] >= 0L) {
                    return contentRange[2];
                }
                String range = connection.getRequestProperty("Range");
                long[] parsedRange = HTTPDownloader.parseRequestRange(range);
                if ((range == null || parsedRange[0] == 0L && parsedRange[1] < 0L) && connection.getLongContentLength() >= 0L && connection.isOK()) {
                    return connection.getLongContentLength();
                }
            } else {
                logger.info("Don't trust ContentLength:contentEncoding=" + contentEncoding + "|h264StreamingMod=" + h264StreamingMod);
            }
        }
        return -1L;
    }

    protected long getVerifiedFileSize() {
        long verifiedFileSize = this.downloadable.getVerifiedFileSize();
        if (verifiedFileSize >= 0L) {
            return verifiedFileSize;
        }
        if (this.connection != null) {
            return HTTPDownloader.getCompleteContentLength(this.logger, this.connection, false);
        }
        return -1L;
    }

    public Request getRequest() {
        return this.initialRequest;
    }

    @Override
    public URLConnectionAdapter getConnection() {
        if (this.connection == null && this.initialRequest != null) {
            return this.initialRequest.getHttpConnection();
        }
        return this.connection;
    }

    @Override
    public boolean externalDownloadStop() {
        return this.stateFlag.get() == STATEFLAG.STOP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopDownload() {
        if (this.stateFlag.compareAndSet(STATEFLAG.RUN, STATEFLAG.STOP)) {
            this.logger.info("stopDownload");
            CopyOnWriteArrayList<HTTPChunk> copyOnWriteArrayList = this.activeChunks;
            synchronized (copyOnWriteArrayList) {
                this.activeChunks.notifyAll();
            }
        }
    }

    protected int getChunksInArea(ChunkRange chunkRange) {
        int ret = 0;
        for (HTTPChunk chunk : this.activeChunks) {
            if (!chunk.isRunning()) continue;
            if (chunk.getChunkRange().getLength() >= 0L) {
                if (chunkRange.getFrom() >= chunk.getChunkRange().getFrom() && chunkRange.getFrom() <= chunk.getChunkRange().getTo()) {
                    ++ret;
                    continue;
                }
                if (chunkRange.getLength() < 0L || chunkRange.getTo() < chunk.getChunkRange().getFrom() || chunkRange.getTo() > chunk.getChunkRange().getTo()) continue;
                ++ret;
                continue;
            }
            if (chunkRange.getFrom() < chunk.getChunkRange().getFrom()) continue;
            ++ret;
        }
        return ret;
    }

    protected boolean hasChunkFrom(ChunkRange chunkRange) {
        for (HTTPChunk chunk : this.activeChunks) {
            if (!chunk.isRunning() || chunk.getChunkRange().getFrom() != chunkRange.getFrom()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean download() {
        boolean bl;
        DownloadPluginProgress downloadPluginProgress;
        block37: {
            downloadPluginProgress = null;
            if (!this.isFileComplete()) break block37;
            boolean bl2 = true;
            this.flushWriteCache();
            try {
                long startTimeStamp = this.getStartTimeStamp();
                if (startTimeStamp > 0L) {
                    this.downloadable.addDownloadTime(System.currentTimeMillis() - this.getStartTimeStamp());
                }
            }
            catch (Throwable startTimeStamp) {
                // empty catch block
            }
            try {
                this.downloadable.removeConnectionHandler(this.getManagedConnetionHandler());
            }
            catch (Throwable startTimeStamp) {
                // empty catch block
            }
            this.downloadable.removePluginProgress(downloadPluginProgress);
            this.close();
            return bl2;
        }
        try {
            this.startTimeStamp = System.currentTimeMillis();
            this.downloadable.setConnectionHandler(this.getManagedConnetionHandler());
            downloadPluginProgress = new DownloadPluginProgress(this.downloadable, this, Color.GREEN.darker());
            this.downloadable.addPluginProgress(downloadPluginProgress);
            ArrayList<HTTPChunk> finishedChunks = new ArrayList<HTTPChunk>();
            this.downloadingFlag.set(true);
            this.downloadable.setDownloadBytesLoaded(this.cacheMap.getMarkedBytes());
            while (true) {
                List<HTTPChunk> nextChunks;
                ArrayList<Runnable> startTimeStamp = this.queuedTasks;
                synchronized (startTimeStamp) {
                    for (Runnable task : this.queuedTasks) {
                        try {
                            task.run();
                        }
                        catch (Throwable e) {
                            LogSource.exception((LogInterface)this.logger, (Throwable)e);
                        }
                    }
                    this.queuedTasks.clear();
                }
                if (this.getStateFlag().get() == STATEFLAG.RUN && (nextChunks = this.chunkStrategy.getNextChunks(finishedChunks)) != null && nextChunks.size() > 0) {
                    for (HTTPChunk nextChunk : nextChunks) {
                        if (this.stateFlag.get() != STATEFLAG.RUN) continue;
                        this.activeChunks.add(nextChunk);
                        nextChunk.start();
                    }
                }
                if (this.activeChunks.size() == 0) break;
                CopyOnWriteArrayList<HTTPChunk> copyOnWriteArrayList = this.activeChunks;
                synchronized (copyOnWriteArrayList) {
                    finishedChunks.clear();
                    for (HTTPChunk chunk : this.activeChunks) {
                        if (!chunk.isRunning()) {
                            finishedChunks.add(chunk);
                            this.activeChunks.remove(chunk);
                            continue;
                        }
                        if (this.getStateFlag().get() == STATEFLAG.RUN) continue;
                        chunk.closeConnections();
                        this.activeChunks.remove(chunk);
                    }
                    if (this.getStateFlag().get() == STATEFLAG.RUN && finishedChunks.size() == 0) {
                        try {
                            if (this.activeChunks.size() >= this.getChunkNum()) {
                                this.activeChunks.wait();
                            } else {
                                this.activeChunks.wait(1000L);
                            }
                        }
                        catch (InterruptedException e) {
                            LogSource.exception((LogInterface)this.logger, (Throwable)e);
                        }
                    }
                }
            }
            this.flushWriteCache();
            bl = this.isDownloadComplete();
            this.flushWriteCache();
        }
        catch (Throwable throwable) {
            this.flushWriteCache();
            try {
                long startTimeStamp = this.getStartTimeStamp();
                if (startTimeStamp > 0L) {
                    this.downloadable.addDownloadTime(System.currentTimeMillis() - this.getStartTimeStamp());
                }
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            try {
                this.downloadable.removeConnectionHandler(this.getManagedConnetionHandler());
            }
            catch (Throwable throwable3) {
                // empty catch block
            }
            this.downloadable.removePluginProgress(downloadPluginProgress);
            this.close();
            throw throwable;
        }
        try {
            long startTimeStamp = this.getStartTimeStamp();
            if (startTimeStamp > 0L) {
                this.downloadable.addDownloadTime(System.currentTimeMillis() - this.getStartTimeStamp());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.downloadable.removeConnectionHandler(this.getManagedConnetionHandler());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.downloadable.removePluginProgress(downloadPluginProgress);
        this.close();
        return bl;
    }

    private void flushWriteCache() {
        if (this.downloadingFlag.get()) {
            this.downloadWriteCache.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        if (HTTPDownloader.this.downloadingFlag.get()) {
                            HTTPDownloader.this.downloadWriteCache.flushIfContains(HTTPDownloader.this);
                        }
                    }
                    finally {
                        ArrayList arrayList = HTTPDownloader.this.queuedTasks;
                        synchronized (arrayList) {
                            HTTPDownloader.this.downloadingFlag.set(false);
                            HTTPDownloader.this.queuedTasks.clear();
                        }
                        HTTPDownloader.this.downloadable.setDownloadBytesLoaded(((BytesMappedFile)HTTPDownloader.this.bytesMappedFile.get()).getFileBytesMap().getMarkedBytes());
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean terminate() {
        if (this.stateFlag.compareAndSet(STATEFLAG.RUN, STATEFLAG.KILL)) {
            this.logger.info("terminate");
            CopyOnWriteArrayList<HTTPChunk> copyOnWriteArrayList = this.activeChunks;
            synchronized (copyOnWriteArrayList) {
                this.activeChunks.notifyAll();
            }
            return true;
        }
        return false;
    }

    public void setReadTimeout(int readTimeout) {
        if (this.checkAccess()) {
            this.readTimeout = readTimeout;
        }
    }

    public void setRequestTimeout(int requestTimeout) {
        if (this.checkAccess()) {
            this.requestTimeout = requestTimeout;
        }
    }

    protected void finalizeDownload(File outputPartFile, File outputCompleteFile) throws Exception {
        if (!this.downloadable.rename(outputPartFile, outputCompleteFile)) {
            throw new PluginException(16384, _JDT.T.system_download_errors_couldnotrename(), 2L);
        }
        try {
            Date lastModifiedDate = HTTPDownloader.getLastModifiedDate(this.getDownloadable(), this.connection);
            if (lastModifiedDate != null && ((GeneralSettings)JsonConfig.create(GeneralSettings.class)).isUseOriginalLastModified()) {
                outputCompleteFile.setLastModified(lastModifiedDate.getTime());
            } else {
                outputCompleteFile.setLastModified(System.currentTimeMillis());
            }
        }
        catch (Throwable e) {
            this.logger.log(e);
        }
        try {
            if (CrossSystem.isWindows()) {
                this.logger.info("Removed SparseFlag:" + outputCompleteFile + "|" + FileSystemHelper.FSCTL_SET_SPARSE(outputCompleteFile, false));
            }
        }
        catch (Throwable e) {
            this.logger.log(e);
        }
    }

    public static Date getLastModifiedDate(Downloadable downloadable, URLConnectionAdapter con) {
        long lastModifiedTimestampDownloadLink;
        Date lastModifiedDate = null;
        if (downloadable instanceof DownloadLinkDownloadable && (lastModifiedTimestampDownloadLink = ((DownloadLinkDownloadable)downloadable).getDownloadLink().getLastModifiedTimestamp()) != -1L) {
            lastModifiedDate = new Date(lastModifiedTimestampDownloadLink);
        }
        if (lastModifiedDate == null && con != null) {
            lastModifiedDate = TimeFormatter.parseDateString((String)con.getHeaderField("Last-Modified"));
        }
        return lastModifiedDate;
    }

    @Override
    public boolean isResumedDownload() {
        return this.resumedDownload;
    }

    private void createOutputChannel() throws SkipReasonException {
        try {
            String fileOutput = this.downloadable.getFileOutput();
            this.logger.info("createOutputChannel for " + fileOutput);
            String finalFileOutput = this.downloadable.getFinalFileOutput();
            this.outputFinalCompleteFile = this.outputCompleteFile = new File(fileOutput);
            if (!fileOutput.equals(finalFileOutput)) {
                this.outputFinalCompleteFile = new File(finalFileOutput);
            }
            this.outputPartFile = new File(this.downloadable.getFileOutputPart());
        }
        catch (Exception e) {
            LogSource.exception((LogInterface)this.logger, (Throwable)e);
            throw new SkipReasonException(SkipReason.INVALID_DESTINATION, e);
        }
    }

    @Override
    public long getTotalLinkBytesLoadedLive() {
        return this.cacheMap.getMarkedBytesLive();
    }

    public void cleanupDownladInterface() {
        try {
            if (this.initialRequest != null && this.initialRequest.getHttpConnection() != null) {
                this.initialRequest.getHttpConnection().disconnect();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.connection != null) {
                this.connection.disconnect();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void closeBytesMappedFile() {
        try {
            Boolean ret;
            BytesMappedFile lbytesMappedFile = this.bytesMappedFile.getAndSet(null);
            if (lbytesMappedFile != null && (ret = BytesMappedFileManager.getInstance().unlock(lbytesMappedFile)) != null) {
                if (ret.booleanValue()) {
                    this.logger.info("File released: " + lbytesMappedFile.getFile());
                } else {
                    this.logger.info("Close File?: " + lbytesMappedFile.getFile());
                    ret = BytesMappedFileManager.getInstance().close(lbytesMappedFile, this);
                    this.logger.info("File closed: " + lbytesMappedFile.getFile() + "|result:" + ret);
                }
            }
        }
        catch (Throwable e) {
            LogSource.exception((LogInterface)this.logger, (Throwable)e);
        }
    }

    public LogInterface getLogger() {
        return this.logger;
    }

    @Override
    public void close() {
        this.cleanupDownladInterface();
        this.closeBytesMappedFile();
    }

    @Override
    public Downloadable getDownloadable() {
        return this.downloadable;
    }

    protected long write(HTTPChunk httpChunk, byte[] readBuffer, int length, long fileWritePosition) {
        long overlap;
        BytesMappedFile file = this.getBytesMappedFile();
        if (this.stateFlag.get() != STATEFLAG.RUN || file == null) {
            return 0L;
        }
        long skippable = file.getFileBytesMap().skippable(fileWritePosition, length);
        if (skippable < (long)length) {
            this.downloadWriteCache.write(this, fileWritePosition, readBuffer, length);
        }
        if ((overlap = this.cacheMap.mark(fileWritePosition, length)) != (long)length) {
            return overlap;
        }
        return length;
    }

    @Override
    public void flush(byte[] writeCache, int writeCachePosition, int length, long fileWritePosition) {
        BytesMappedFile file = this.getBytesMappedFile();
        if (this.downloadingFlag.get() && file != null) {
            file.flush(writeCache, writeCachePosition, length, fileWritePosition);
        }
    }

    protected BytesMappedFile getBytesMappedFile() {
        return this.bytesMappedFile.get();
    }

    @Override
    public void flushed() {
        BytesMappedFile file = this.getBytesMappedFile();
        if (this.downloadingFlag.get() && file != null) {
            file.flushed();
        }
    }

    @Override
    public FileBytesMap.FileBytesMapView getCacheMapView() {
        return new FileBytesMap.FileBytesMapView(this.cacheMap);
    }

    @Override
    public void onFlush(BytesMappedFile bytesMappedFile, IOException ioException) {
        if (ioException != null) {
            LogSource.exception((LogInterface)this.logger, (Throwable)ioException);
            if (this.terminate()) {
                String message = ioException.getMessage();
                if (StringUtils.containsIgnoreCase((String)message, (String)"There is not enough space on the disk") || StringUtils.containsIgnoreCase((String)message, (String)"No space left on device") || StringUtils.containsIgnoreCase((String)message, (String)"Disk quota exceeded")) {
                    this.addError(HTTPChunk.ERROR.NOT_ENOUGH_SPACE_ON_DISK);
                } else {
                    this.addError(HTTPChunk.ERROR.FLUSHING);
                }
            }
        }
    }

    protected void updateCacheMapSize(URLConnectionAdapter connection) {
        long completeContentLength;
        long verifiedFileSize = this.downloadable.getVerifiedFileSize();
        if (verifiedFileSize < 0L && (completeContentLength = HTTPDownloader.getCompleteContentLength(this.logger, connection, false)) > 0L && completeContentLength >= this.cacheMap.getMarkedBytes()) {
            this.logger.info("Update VerifiedFileSize(" + completeContentLength + ") from URLConnection:\r\n" + connection);
            this.cacheMap.setFinalSize(completeContentLength);
            this.downloadable.setVerifiedFileSize(completeContentLength);
            BytesMappedFile bytesMappedFile = this.getBytesMappedFile();
            if (bytesMappedFile != null) {
                bytesMappedFile.getFileBytesMap().setFinalSize(completeContentLength);
            }
        }
    }

    private static class ConnectionHashInfo
    extends HashInfo {
        private ConnectionHashInfo(String hash, HashInfo.TYPE type) {
            super(hash, type, true, false);
        }

        @Override
        public boolean isStrongerThan(HashInfo hashInfo) {
            if (hashInfo instanceof ConnectionHashInfo) {
                return super.isStrongerThan(hashInfo);
            }
            return true;
        }
    }

    public static enum VALIDATION {
        CONTENT_DISPOSITION,
        CONTENT_DISPOSITION_NAME,
        CONTENT_TYPE,
        CONTENT_LENGTH,
        VERIFIED_SIZE,
        CONNECTION_MISSING;

    }

    public class VALIDATION_RESULT {
        private Set<VALIDATION> ok = new HashSet<VALIDATION>();
        private Set<VALIDATION> failed = new HashSet<VALIDATION>();

        protected void setOk(VALIDATION test) {
            if (test != null) {
                this.failed.remove((Object)test);
                this.ok.add(test);
            }
        }

        protected void setFailed(VALIDATION test) {
            if (test != null) {
                this.failed.add(test);
                this.ok.remove((Object)test);
            }
        }

        public boolean hasOk(VALIDATION test) {
            return test != null && this.ok.contains((Object)test);
        }

        public boolean hasFailed(VALIDATION test) {
            return test != null && this.failed.contains((Object)test);
        }

        public int countOk() {
            return this.ok.size();
        }

        public int countFailed() {
            return this.failed.size();
        }

        public Set<VALIDATION> getOk() {
            return new HashSet<VALIDATION>(this.ok);
        }

        public Set<VALIDATION> getFailed() {
            return new HashSet<VALIDATION>(this.failed);
        }

        public boolean isOk() {
            return this.failed.size() == 0;
        }

        public boolean isFailed() {
            return this.failed.size() > 0;
        }
    }

    public static enum STATEFLAG {
        RUN,
        STOP,
        KILL;

    }
}

