/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.download.raf;

import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import jd.controlling.downloadcontroller.DiskSpaceReservation;
import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.downloadcontroller.ExceptionRunnable;
import jd.controlling.downloadcontroller.FileIsLockedException;
import jd.controlling.downloadcontroller.ManagedThrottledConnectionHandler;
import jd.http.Browser;
import jd.http.Request;
import jd.http.URLConnectionAdapter;
import jd.plugins.DownloadLink;
import jd.plugins.PluginException;
import jd.plugins.download.DownloadInterface;
import jd.plugins.download.DownloadLinkDownloadable;
import jd.plugins.download.Downloadable;
import jd.plugins.download.HashInfo;
import jd.plugins.download.HashResult;
import jd.plugins.download.SparseFile;
import jd.plugins.download.raf.HTTPDownloader;
import jd.plugins.download.raf.RAFChunk;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.Application;
import org.appwork.utils.Exceptions;
import org.appwork.utils.IO;
import org.appwork.utils.StringUtils;
import org.appwork.utils.formatter.TimeFormatter;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.jna.unix.FileSystemHelper;
import org.jdownloader.plugins.DownloadPluginProgress;
import org.jdownloader.plugins.SkipReason;
import org.jdownloader.plugins.SkipReasonException;
import org.jdownloader.settings.GeneralSettings;
import org.jdownloader.translate._JDT;
import org.jdownloader.updatev2.InternetConnectionSettings;

public class OldRAFDownload
extends DownloadInterface {
    private final AtomicReference<RandomAccessFile> outputPartFileRaf = new AtomicReference<Object>(null);
    private volatile File outputCompleteFile;
    private volatile File outputFinalCompleteFile;
    private volatile File outputPartFile;
    private final AtomicBoolean connected = new AtomicBoolean(false);
    private final CopyOnWriteArrayList<RAFChunk> chunks = new CopyOnWriteArrayList();
    protected volatile long totalLinkBytesLoaded = 0L;
    protected AtomicLong totalLinkBytesLoadedLive = new AtomicLong(0L);
    private int readTimeout = 100000;
    private int requestTimeout = 100000;
    private final AtomicBoolean terminated = new AtomicBoolean(false);
    private final AtomicBoolean abort = new AtomicBoolean(false);
    protected int chunkNum = 1;
    private boolean resume = false;
    protected boolean dlAlreadyFinished = false;
    protected Browser browser;
    protected URLConnectionAdapter connection;
    protected Downloadable downloadable;
    protected PluginException caughtPluginException = null;
    public LogInterface logger;
    protected Request request = null;
    protected ManagedThrottledConnectionHandler connectionHandler = null;
    private long startTimeStamp = -1L;
    private boolean resumedDownload;
    public static final ArrayList<AtomicBoolean> HASHCHECK_QEUEU = new ArrayList();
    private Integer allocationUnitSize = null;

    public void setChunkNum(int num) {
        if (num <= 0) {
            this.logger.severe("Chunks value must be >=1");
            return;
        }
        this.chunkNum = num;
    }

    public boolean isResumable() {
        return this.downloadable.isResumable();
    }

    @Override
    public ManagedThrottledConnectionHandler getManagedConnetionHandler() {
        return this.connectionHandler;
    }

    public boolean isRangeRequestSupported() {
        return this.resume;
    }

    public OldRAFDownload(Downloadable downloadLink, Request request) throws IOException, PluginException {
        this.init(downloadLink, request);
    }

    protected void init(Downloadable downloadLink, Request request) {
        this.connectionHandler = new ManagedThrottledConnectionHandler();
        this.downloadable = downloadLink;
        this.logger = downloadLink.getLogger();
        this.browser = downloadLink.getContextBrowser();
        InternetConnectionSettings config = (InternetConnectionSettings)JsonConfig.create((String)"cfg/org.jdownloader.settings.InternetConnectionSettings", InternetConnectionSettings.class);
        this.requestTimeout = config.getHttpConnectTimeout();
        this.readTimeout = config.getHttpReadTimeout();
        this.request = request;
        downloadLink.setDownloadInterface(this);
    }

    public void setResume(boolean value) {
        this.resume = value;
        if (value && !this.checkResumabled()) {
            this.logger.warning("Resumepoint not valid");
        }
        this.downloadable.setResumeable(value);
    }

    @Override
    public long getStartTimeStamp() {
        return this.startTimeStamp;
    }

    @Override
    public URLConnectionAdapter connect(Browser br) throws Exception {
        this.setReadTimeout(br.getReadTimeout());
        this.setRequestTimeout(br.getConnectTimeout());
        this.request.setConnectTimeout(this.getRequestTimeout());
        this.request.setReadTimeout(this.getReadTimeout());
        br.setRequest(this.request);
        URLConnectionAdapter ret = this.connect();
        return ret;
    }

    public URLConnectionAdapter connect() throws Exception {
        if (this.connected.getAndSet(true)) {
            throw new IllegalStateException("Already connected");
        }
        this.logger.finer("Connect...");
        if (this.request == null) {
            throw new IllegalStateException("Wrong Mode. Instance is in direct Connection mode");
        }
        boolean resumed = false;
        if (this.isRangeRequestSupported() && this.checkResumabled()) {
            this.logger.finer(".....connectResumable");
            resumed = this.connectResumable();
        } else {
            int tmp;
            long verifiedFileSize = this.downloadable.getVerifiedFileSize();
            if (verifiedFileSize > 0L && this.getChunkNum() > 1 && (tmp = Math.min(Math.max(1, (int)(verifiedFileSize / 102400L)), this.getChunkNum())) != this.getChunkNum()) {
                this.logger.finer("Corrected Chunknum: " + this.getChunkNum() + " -->" + tmp);
                this.setChunkNum(tmp);
            }
            if (this.isRangeRequestSupported()) {
                this.logger.finer(".....connectFirstRange");
                this.connectFirstRange();
            } else {
                this.logger.finer(".....connectRangeless");
                this.request.getHeaders().remove("Range");
                this.browser.openRequestConnection(this.request, false);
            }
        }
        if (this.downloadable.isDebug()) {
            this.logger.finest("\r\n" + this.request.printHeaders());
        }
        this.connection = this.request.getHttpConnection();
        if (this.request.getLocation() != null) {
            throw new PluginException(512, -1L);
        }
        if (this.downloadable.getVerifiedFileSize() < 0L) {
            String contentType = this.connection.getContentType();
            boolean trustFileSize = contentType == null || !contentType.contains("html") && !contentType.contains("text");
            this.logger.info("Trust FileSize: " + trustFileSize + " " + contentType);
            if (this.connection.getRange() != null && trustFileSize) {
                if (this.connection.getRange()[2] > 0L) {
                    this.downloadable.setDownloadTotalBytes(this.connection.getRange()[2]);
                }
            } else if (!resumed && this.connection.getCompleteContentLength() > 0L && this.connection.isOK() && trustFileSize) {
                this.downloadable.setDownloadTotalBytes(this.connection.getCompleteContentLength());
            }
        }
        if (this.connection.getResponseCode() == 416 && resumed && this.downloadable.getChunksProgress() != null && this.downloadable.getChunksProgress().length == 1 && this.downloadable.getVerifiedFileSize() == this.downloadable.getChunksProgress()[0] + 1L) {
            this.logger.info("Faking Content-Disposition for already finished downloads");
            if (!this.connection.isContentDisposition()) {
                ArrayList<String> list = new ArrayList<String>();
                list.add("fakeContent");
                this.connection.getHeaderFields().put("Content-Disposition", list);
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add("application/octet-stream");
            this.connection.getHeaderFields().put("Content-Type", list);
            this.dlAlreadyFinished = true;
        }
        return this.connection;
    }

    public int getReadTimeout() {
        return Math.max(10000, this.readTimeout);
    }

    public int getRequestTimeout() {
        return Math.max(10000, this.requestTimeout);
    }

    protected boolean checkResumabled() {
        long[] chunksP = this.downloadable.getChunksProgress();
        if (chunksP == null || chunksP.length == 0 || chunksP.length == 1 && chunksP[0] == 0L) {
            return false;
        }
        long fileSize = this.getFileSize();
        int chunks = chunksP.length;
        long part = fileSize / (long)chunks;
        long last = -1L;
        this.logger.info("FileSize: " + fileSize + " Chunks: " + chunks + "(" + Arrays.toString(chunksP) + ") ChunkSize: " + part);
        for (int i = 0; i < chunks; ++i) {
            long fix;
            long dif = chunksP[i] - (long)i * part;
            if (dif < 0L || chunksP[i] < 0L) {
                this.logger.info("Invalid Chunk " + i + ": " + chunksP[i] + " dif= " + dif);
                fix = Math.max(0L, (long)i * part - 1024L);
                this.logger.info("Fix Chunk " + i + ": " + chunksP[i] + " to " + fix);
                chunksP[i] = fix;
            }
            if (chunksP[i] <= last) {
                this.logger.info("Suspicious Chunk " + i + ": " + chunksP[i] + " <= " + last);
            } else if (chunksP[i] >= (long)(i + 1) * part - 1L) {
                fix = Math.max(0L, (long)(i + 1) * part - 1024L);
                this.logger.info("Fix Chunk " + i + ": " + chunksP[i] + " to " + fix);
                chunksP[i] = fix;
            } else {
                this.logger.info("Valid Chunk " + i + ": " + chunksP[i]);
            }
            last = chunksP[i];
        }
        this.downloadable.setChunksProgress(chunksP);
        if (chunks > 0) {
            if (chunks <= this.getChunkNum()) {
                this.setChunkNum(chunks);
            } else {
                this.logger.info("Download has " + chunks + " Chunks but only " + this.getChunkNum() + " allowed! Change to 1!");
                this.setChunkNum(1);
                this.downloadable.setChunksProgress(new long[]{chunksP[0]});
            }
            return true;
        }
        return false;
    }

    protected void connectFirstRange() throws IOException {
        boolean preferOpenRangeFirst;
        long fileSize;
        long part = fileSize = this.getFileSize();
        boolean verifiedSize = this.downloadable.getVerifiedFileSize() > 0L;
        boolean openRangeRequested = false;
        boolean rangeRequested = false;
        DownloadLink downloadLink = this.downloadable instanceof DownloadLinkDownloadable ? ((DownloadLinkDownloadable)this.downloadable).getDownloadLink() : null;
        boolean bl = preferOpenRangeFirst = downloadLink == null || downloadLink.getBooleanProperty("oldraf_preferOpenRangeFirst", Boolean.TRUE) != false;
        if (preferOpenRangeFirst || !verifiedSize || this.getChunkNum() == 1) {
            openRangeRequested = true;
            if (this.downloadable.isServerComaptibleForByteRangeRequest()) {
                rangeRequested = true;
                this.request.getHeaders().put("Range", "bytes=0-");
            }
        } else {
            openRangeRequested = false;
            rangeRequested = true;
            part = fileSize / (long)this.getChunkNum();
            this.request.getHeaders().put("Range", "bytes=0-" + (part - 1L));
        }
        this.browser.openRequestConnection(this.request, false);
        if (this.request.getHttpConnection().getResponseCode() == 416) {
            this.logger.warning("HTTP/1.1 416 Requested Range Not Satisfiable");
            if (this.downloadable.isDebug()) {
                this.logger.finest("\r\n" + this.request.printHeaders());
            }
            throw new IllegalStateException("HTTP/1.1 416 Requested Range Not Satisfiable");
        }
        if (this.request.getHttpConnection().getRange() == null) {
            String responseAcceptRanges = this.request.getHttpConnection().getHeaderField("Accept-Ranges");
            if (openRangeRequested && !rangeRequested) {
                this.logger.warning("FirstRange was openRange without any RangeRequest!");
            } else if (openRangeRequested && rangeRequested && "bytes".equalsIgnoreCase(responseAcceptRanges)) {
                this.logger.info("FirstRange was openRange but no range response but range accepted!");
            } else {
                this.logger.warning("No Chunkload");
                this.setChunkNum(1);
            }
        } else {
            long[] range = this.request.getHttpConnection().getRange();
            if (range[0] != 0L) {
                throw new IllegalStateException("Range Error. Requested " + this.request.getHeaders().get("Range") + ". Got range: " + this.request.getHttpConnection().getHeaderField("Content-Range"));
            }
            if (verifiedSize && range[1] < part - 1L) {
                if (downloadLink == null || !StringUtils.equals((String)downloadLink.getStringProperty("streamMod"), (String)"limitedRangeLength")) {
                    throw new IllegalStateException("Range Error. Requested " + this.request.getHeaders().get("Range") + " Got range: " + this.request.getHttpConnection().getHeaderField("Content-Range"));
                }
            } else if (!openRangeRequested && range[1] == range[2] - 1L && this.getChunkNum() > 1) {
                this.logger.warning(" Chunkload Protection.. Requested " + this.request.getHeaders().get("Range") + " Got range: " + this.request.getHttpConnection().getHeaderField("Content-Range"));
                this.setChunkNum(1);
            } else if (verifiedSize && range[1] > part - 1L) {
                if (verifiedSize && range[1] == part) {
                    this.logger.severe("Workaround for buggy http server: rangeEND=contentEND, it must be rangeEND-1=contentEND as 0 is first byte!");
                    return;
                }
                if (this.request.getHttpConnection().getResponseCode() == 200 && !rangeRequested && verifiedSize && fileSize == range[2]) {
                    this.logger.severe("Workaround for buggy http server: no range requested, but got content-range response with 200 header");
                    return;
                }
                throw new IllegalStateException("Range Error. Requested " + this.request.getHeaders().get("Range") + " Got range: " + this.request.getHttpConnection().getHeaderField("Content-Range"));
            }
        }
    }

    public boolean handleErrors() throws PluginException {
        boolean isExternalStop = this.externalDownloadStop();
        long verifiedFileSize = this.getVerifiedFileSize();
        long fileSize = this.getFileSize();
        this.logger.severe("ExternalStop: " + isExternalStop + "|VerifiedFilesize: " + verifiedFileSize + "|FileSize: " + fileSize + "|Loaded: " + this.totalLinkBytesLoaded);
        if (verifiedFileSize >= 0L) {
            if (this.totalLinkBytesLoaded >= verifiedFileSize) {
                this.logger.severe("VerifiedFilesize: " + verifiedFileSize + " Loaded: " + this.totalLinkBytesLoaded);
                this.downloadable.setLinkStatus(2);
                return true;
            }
            if (isExternalStop) {
                return false;
            }
            if (this.caughtPluginException != null) {
                throw this.caughtPluginException;
            }
            throw new PluginException(512, _JDT.T.download_error_message_incomplete());
        }
        if (fileSize >= 0L) {
            if (this.totalLinkBytesLoaded >= fileSize || !isExternalStop && this.caughtPluginException == null) {
                this.logger.severe("Filesize: " + fileSize + " Loaded: " + this.totalLinkBytesLoaded);
                this.downloadable.setLinkStatus(2);
                return true;
            }
            if (isExternalStop) {
                return false;
            }
            if (this.caughtPluginException != null) {
                throw this.caughtPluginException;
            }
            throw new PluginException(512, _JDT.T.download_error_message_incomplete());
        }
        if (this.externalDownloadStop()) {
            return false;
        }
        if (this.caughtPluginException == null) {
            this.downloadable.setLinkStatus(2);
            return true;
        }
        throw this.caughtPluginException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void error(PluginException pluginException) {
        OldRAFDownload oldRAFDownload = this;
        synchronized (oldRAFDownload) {
            if (this.externalDownloadStop()) {
                return;
            }
            LogSource.exception((LogInterface)this.logger, (Throwable)pluginException);
            if (this.caughtPluginException == null) {
                this.caughtPluginException = pluginException;
            }
        }
        this.terminate(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onChunkFinished(RAFChunk chunk) {
        CopyOnWriteArrayList<RAFChunk> copyOnWriteArrayList = this.chunks;
        synchronized (copyOnWriteArrayList) {
            this.chunks.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startDownload() throws Exception {
        try {
            boolean bl;
            try {
                this.downloadable.validateLastChallengeResponse();
            }
            catch (Throwable e) {
                LogSource.exception((LogInterface)this.logger, (Throwable)e);
            }
            this.logger.finer("Start Download");
            if (this.dlAlreadyFinished) {
                this.downloadable.setAvailable(DownloadLink.AvailableStatus.TRUE);
                this.logger.finer("DownloadAlreadyFinished workaround");
                this.downloadable.setLinkStatus(2);
                boolean e = true;
                return e;
            }
            if (!this.connected.get()) {
                this.connect();
            }
            if (this.connection != null) {
                long verifiedFileSize;
                boolean verifiedFileSizeNotAvailable;
                String displayName;
                String contentEncoding = this.connection.getHeaderField("Content-Encoding");
                long[] responseRange = this.connection.getRange();
                boolean skipVerifyFileSizeCheck = true;
                if (this.downloadable instanceof DownloadLinkDownloadable && (StringUtils.equalsIgnoreCase((String)(displayName = ((DownloadLinkDownloadable)this.downloadable).getDownloadLinkController().getProcessingPlugin().getLazyP().getDisplayName()), (String)"directhttp") || StringUtils.equalsIgnoreCase((String)displayName, (String)"http links"))) {
                    skipVerifyFileSizeCheck = false;
                }
                boolean bl2 = verifiedFileSizeNotAvailable = (verifiedFileSize = this.downloadable.getVerifiedFileSize()) < 0L;
                if (StringUtils.containsIgnoreCase((String)contentEncoding, (String)"gzip") && (verifiedFileSizeNotAvailable || skipVerifyFileSizeCheck)) {
                    this.logger.info("Content-Encoding: 'gzip' detected! Disable Resume/Chunks because " + verifiedFileSizeNotAvailable + "|" + skipVerifyFileSizeCheck);
                    this.setResume(false);
                    this.setChunkNum(1);
                }
                String string = this.connection.getHeaderField("Transfer-Encoding");
            }
            this.downloadable.updateFinalFileName();
            if (this.connection == null || !this.connection.isOK()) {
                if (this.connection != null) {
                    this.logger.finest(this.connection.toString());
                }
                try {
                    this.connection.disconnect();
                }
                catch (Throwable contentEncoding) {
                    // empty catch block
                }
                throw new PluginException(2048, 600000L);
            }
            if (this.connection.getRequest().getLocation() != null) {
                throw new PluginException(0x400000);
            }
            if (this.downloadable.getVerifiedFileSize() < 0L) {
                if (this.connection.getRange() != null) {
                    if (this.connection.getRange()[2] >= 0L) {
                        this.downloadable.setVerifiedFileSize(this.connection.getRange()[2]);
                    }
                } else if (this.connection.getRequestProperty("Range") == null && this.connection.getCompleteContentLength() >= 0L && this.connection.isOK()) {
                    this.downloadable.setVerifiedFileSize(this.connection.getCompleteContentLength());
                }
            }
            try {
                DownloadPluginProgress downloadPluginProgress = null;
                this.downloadable.setConnectionHandler(this.getManagedConnetionHandler());
                HashInfo hashInfo = HTTPDownloader.getHashInfoFromHeaders(this.logger, this.connection);
                if (hashInfo != null) {
                    this.downloadable.setHashInfo(hashInfo);
                }
                final DiskSpaceReservation reservation = this.downloadable.createDiskSpaceReservation();
                try {
                    if (!this.downloadable.checkIfWeCanWrite(new ExceptionRunnable(){

                        @Override
                        public void run() throws Exception {
                            OldRAFDownload.this.downloadable.checkAndReserve(reservation);
                            OldRAFDownload.this.createOutputChannel();
                            try {
                                OldRAFDownload.this.downloadable.lockFiles(OldRAFDownload.this.outputCompleteFile, OldRAFDownload.this.outputFinalCompleteFile, OldRAFDownload.this.outputPartFile);
                            }
                            catch (FileIsLockedException e) {
                                OldRAFDownload.this.downloadable.unlockFiles(OldRAFDownload.this.outputCompleteFile, OldRAFDownload.this.outputFinalCompleteFile, OldRAFDownload.this.outputPartFile);
                                throw new PluginException(8192);
                            }
                        }
                    }, null)) {
                        throw new SkipReasonException(SkipReason.INVALID_DESTINATION);
                    }
                    this.startTimeStamp = System.currentTimeMillis();
                    downloadPluginProgress = new DownloadPluginProgress(this.downloadable, this, Color.GREEN.darker());
                    this.downloadable.addPluginProgress(downloadPluginProgress);
                    this.setupChunks();
                    this.downloadable.setAvailable(DownloadLink.AvailableStatus.TRUE);
                    this.waitForChunks();
                }
                catch (Throwable throwable) {
                    try {
                        this.downloadable.free(reservation);
                    }
                    catch (Throwable e) {
                        LogSource.exception((LogInterface)this.logger, (Throwable)e);
                    }
                    try {
                        long startTimeStamp = this.getStartTimeStamp();
                        if (startTimeStamp > 0L) {
                            this.downloadable.addDownloadTime(System.currentTimeMillis() - this.getStartTimeStamp());
                        }
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    this.downloadable.removePluginProgress(downloadPluginProgress);
                    throw throwable;
                }
                try {
                    this.downloadable.free(reservation);
                }
                catch (Throwable e) {
                    LogSource.exception((LogInterface)this.logger, (Throwable)e);
                }
                try {
                    long startTimeStamp = this.getStartTimeStamp();
                    if (startTimeStamp > 0L) {
                        this.downloadable.addDownloadTime(System.currentTimeMillis() - this.getStartTimeStamp());
                    }
                }
                catch (Throwable startTimeStamp) {
                    // empty catch block
                }
                this.downloadable.removePluginProgress(downloadPluginProgress);
                HashResult result = this.onChunksReady();
                if (result != null) {
                    this.logger.info((Object)((Object)result.getHashInfo().getType()) + "-Check: " + (result.match() ? "ok" : "failed"));
                    if (result.match()) {
                        this.downloadable.setLinkStatusText(_JDT.T.system_download_doCRC2_success((Object)result.getHashInfo().getType()));
                    } else {
                        throw new PluginException(16384, _JDT.T.system_download_doCRC2_failed((Object)result.getHashInfo().getType()));
                    }
                }
                bl = this.handleErrors();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        this.cleanupDownladInterface();
                    }
                    catch (Throwable throwable3) {
                        this.downloadable.unlockFiles(this.outputCompleteFile, this.outputFinalCompleteFile, this.outputPartFile);
                        throw throwable3;
                    }
                    this.downloadable.unlockFiles(this.outputCompleteFile, this.outputFinalCompleteFile, this.outputPartFile);
                    throw throwable;
                }
                catch (PluginException e) {
                    this.error(e);
                    throw e;
                }
                catch (Exception e) {
                    if (e instanceof FileNotFoundException) {
                        this.error(new PluginException(16384, _JDT.T.download_error_message_localio(e.getMessage()), 2L));
                    } else {
                        LogSource.exception((LogInterface)this.logger, (Throwable)e);
                    }
                    throw e;
                }
            }
            try {
                this.cleanupDownladInterface();
            }
            catch (Throwable throwable) {
                this.downloadable.unlockFiles(this.outputCompleteFile, this.outputFinalCompleteFile, this.outputPartFile);
                throw throwable;
            }
            this.downloadable.unlockFiles(this.outputCompleteFile, this.outputFinalCompleteFile, this.outputPartFile);
            return bl;
        }
        finally {
            this.cleanupDownladInterface();
        }
    }

    public int getChunkNum() {
        return this.chunkNum;
    }

    protected long getFileSize() {
        long size = this.getVerifiedFileSize();
        if (size >= 0L) {
            return size;
        }
        if (this.connection != null) {
            if (this.connection.getRange() != null && this.connection.getRange()[2] > 0L) {
                return this.connection.getRange()[2];
            }
            if (this.connection.getRequestProperty("Range") == null && this.connection.getCompleteContentLength() > 0L && this.connection.isOK()) {
                return this.connection.getCompleteContentLength();
            }
        }
        if (this.downloadable.getDownloadTotalBytes() > 0L) {
            return this.downloadable.getDownloadTotalBytes();
        }
        return -1L;
    }

    protected long getVerifiedFileSize() {
        return this.downloadable.getVerifiedFileSize();
    }

    public Request getRequest() {
        return this.request;
    }

    @Override
    public URLConnectionAdapter getConnection() {
        return this.connection;
    }

    @Override
    public boolean externalDownloadStop() {
        return this.abort.get();
    }

    @Override
    public void stopDownload() {
        if (!this.abort.getAndSet(true)) {
            this.logger.info("externalStop recieved");
            this.terminate(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void waitForChunks() {
        try {
            this.logger.finer("Wait for chunks");
            while (true) {
                try {
                    block7: while (true) {
                        CopyOnWriteArrayList<RAFChunk> copyOnWriteArrayList = this.chunks;
                        // MONITORENTER : copyOnWriteArrayList
                        for (RAFChunk chunk : this.chunks) {
                            if (!chunk.isAlive() || !chunk.isRunning()) continue;
                            this.chunks.wait(1000L);
                            // MONITOREXIT : copyOnWriteArrayList
                            continue block7;
                        }
                        break;
                    }
                    // MONITOREXIT : copyOnWriteArrayList
                }
                catch (InterruptedException e) {
                    this.terminate(true);
                    continue;
                }
                break;
            }
            this.downloadable.setDownloadBytesLoaded(this.totalLinkBytesLoaded);
            return;
        }
        catch (Throwable e) {
            LogSource.exception((LogInterface)this.logger, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void terminate(boolean forcedWaiting) {
        if (!this.terminated.getAndSet(true) || forcedWaiting) {
            if (!this.externalDownloadStop()) {
                this.logger.severe("A critical Downloaderror occured. Terminate...");
            }
            while (true) {
                CopyOnWriteArrayList<RAFChunk> copyOnWriteArrayList = this.chunks;
                synchronized (copyOnWriteArrayList) {
                    block10: {
                        boolean wait = false;
                        for (RAFChunk chunk : this.chunks) {
                            if (!chunk.isRunning()) continue;
                            chunk.closeConnections();
                            if (chunk == Thread.currentThread()) continue;
                            wait = true;
                        }
                        if (wait) {
                            try {
                                this.chunks.wait(1000L);
                                break block10;
                            }
                            catch (InterruptedException e) {
                                LogSource.exception((LogInterface)this.logger, (Throwable)e);
                            }
                        }
                        break;
                    }
                }
            }
        }
    }

    protected boolean connectResumable() throws IOException {
        long[] chunkProgress = this.downloadable.getChunksProgress();
        long verifiedFileSize = this.downloadable.getVerifiedFileSize();
        long fileSize = this.getFileSize();
        String start = "";
        String end = "";
        boolean rangeRequested = false;
        this.logger.info("chunksProgress: " + Arrays.toString(chunkProgress));
        start = chunkProgress[0] == 0L ? Long.toString(0L) : Long.toString(chunkProgress[0] + 1L);
        if (verifiedFileSize > 0L) {
            end = chunkProgress.length == 1 ? "" : Long.toString(verifiedFileSize / (long)chunkProgress.length);
            this.logger.info("VerifiedFileSize: " + verifiedFileSize + "|Start:" + start + "|End:" + end);
        } else {
            end = chunkProgress.length == 1 ? "" : Long.toString(chunkProgress[1] + 1L);
            this.logger.info("FileSize: " + fileSize + "|Start:" + start + "|End:" + end);
        }
        if (start.equals("0") && (verifiedFileSize < 0L || "".equals(end))) {
            this.logger.info("rangeless resumable connect");
            rangeRequested = false;
            this.request.getHeaders().remove("Range");
        } else {
            rangeRequested = true;
            if (start.equalsIgnoreCase(end)) {
                this.logger.info("WTF, start equals end! Workaround: maybe manipulating the startRange?! it's about time for new downloadcore!");
            }
            this.request.getHeaders().put("Range", "bytes=" + start + "-" + end);
        }
        this.browser.openRequestConnection(this.request, false);
        return rangeRequested;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HashResult onChunksReady() throws Exception {
        HashResult result = null;
        try {
            long timeStamp = System.currentTimeMillis();
            try {
                for (RAFChunk c : this.chunks) {
                    c.closeConnections();
                }
            }
            finally {
                this.logger.info("All connections closed:" + TimeFormatter.formatMilliSeconds((long)(System.currentTimeMillis() - timeStamp), (int)0));
            }
        }
        finally {
            this.cleanupDownladInterface();
        }
        if (!this.handleErrors()) {
            return result;
        }
        HashResult hashResult = this.getHashResult(this.downloadable, this.outputPartFile);
        this.downloadable.setHashResult(hashResult);
        if (hashResult == null || hashResult.match()) {
            this.downloadable.setVerifiedFileSize(this.outputPartFile.length());
        } else if (hashResult.getHashInfo().isTrustworthy()) {
            throw new PluginException(16384, _JDT.T.system_download_doCRC2_failed((Object)hashResult.getHashInfo().getType()));
        }
        boolean renameOkay = this.downloadable.rename(this.outputPartFile, this.outputCompleteFile);
        if (renameOkay) {
            try {
                Date lastModifiedDate = HTTPDownloader.getLastModifiedDate(this.getDownloadable(), this.connection);
                if (lastModifiedDate != null && ((GeneralSettings)JsonConfig.create(GeneralSettings.class)).isUseOriginalLastModified()) {
                    this.outputCompleteFile.setLastModified(lastModifiedDate.getTime());
                } else {
                    this.outputCompleteFile.setLastModified(System.currentTimeMillis());
                }
            }
            catch (Throwable e) {
                this.logger.log(e);
            }
            try {
                if (CrossSystem.isWindows()) {
                    this.logger.info("Removed SparseFlag:" + this.outputCompleteFile + "|" + org.jdownloader.jna.windows.FileSystemHelper.FSCTL_SET_SPARSE(this.outputCompleteFile, false));
                }
            }
            catch (Throwable e) {
                this.logger.log(e);
            }
        } else {
            this.error(new PluginException(16384, _JDT.T.system_download_errors_couldnotrename(), 2L));
        }
        return result;
    }

    protected boolean checkResumeConnection() {
        String requestedRange = this.connection.getRequestProperty("Range");
        if (requestedRange != null) {
            long[] responseRange = this.connection.getRange();
            if (responseRange == null) {
                this.logger.info("RequestRange: " + requestedRange + "|No ResponseRange but connection has responseCode=" + this.connection.getResponseCode() + " and content-length=" + this.connection.getCompleteContentLength());
                this.setChunkNum(1);
                return false;
            }
            this.logger.info("RequestRange: " + requestedRange + "|ResponseRange:" + Arrays.toString(responseRange));
            return true;
        }
        return true;
    }

    protected void setupChunks() throws Exception {
        if (this.isRangeRequestSupported() && this.checkResumabled() && this.checkResumeConnection()) {
            this.logger.finer("Setup resume");
            this.resumedDownload = true;
            this.setupResume();
        } else {
            this.logger.finer("Setup virgin download");
            this.resumedDownload = false;
            this.setupVirginStart();
        }
    }

    @Override
    public boolean isResumedDownload() {
        return this.resumedDownload;
    }

    private void setupVirginStart() throws FileNotFoundException {
        RAFChunk chunk;
        this.totalLinkBytesLoaded = 0L;
        this.downloadable.setDownloadBytesLoaded(0L);
        long fileSize = this.getFileSize();
        long partSize = 0L;
        int chunks = this.getChunkNum();
        if (fileSize < 0L) {
            if (chunks > 1) {
                this.logger.warning("Unknown FileSize->reset chunks to 1 and start at beginning");
                chunks = 1;
            } else {
                this.logger.warning("Unknown FileSize->start at beginning");
            }
        } else if (fileSize == 0L) {
            if (chunks > 1) {
                this.logger.warning("Zero FileSize->reset chunks to 1 and start at beginning");
                chunks = 1;
            } else {
                this.logger.warning("Zero FileSize->start at beginning");
            }
        } else {
            partSize = fileSize / (long)chunks;
            if (this.connection.getRange() != null) {
                if (this.connection.getRange()[1] == this.connection.getRange()[2] - 1L || this.connection.getRange()[1] == this.connection.getRange()[2]) {
                    this.logger.warning("Chunkload protection. this may cause traffic errors");
                    partSize = fileSize / (long)chunks;
                } else {
                    partSize = (fileSize - this.connection.getLongContentLength()) / (long)Math.max(1, chunks - 1);
                }
            }
            if (partSize <= 0L) {
                this.logger.warning("Filesize is " + fileSize + " but partSize is " + partSize + "-> reset chunks to 1");
                chunks = 1;
            }
        }
        this.setChunkNum(chunks);
        this.logger.finer("Start Download in " + chunks + " chunks. Chunksize: " + partSize);
        this.downloadable.setChunksProgress(new long[this.chunkNum]);
        int start = 0;
        long rangePosition = 0L;
        int id = 0;
        if (this.connection.getRange() != null && this.connection.getRange()[1] != this.connection.getRange()[2] - 1L) {
            rangePosition = this.connection.getRange()[1];
            chunk = new RAFChunk(0L, rangePosition, this.connection, this, this.downloadable, id++);
            ++rangePosition;
            this.logger.finer("Setup chunk 0: " + chunk);
            this.addChunk(chunk);
            ++start;
        }
        for (int i = start; i < chunks; ++i) {
            if (i == chunks - 1) {
                chunk = new RAFChunk(rangePosition, -1L, this.connection, this, this.downloadable, id++);
            } else {
                chunk = new RAFChunk(rangePosition, rangePosition + partSize - 1L, this.connection, this, this.downloadable, id++);
                rangePosition += partSize;
            }
            this.logger.finer("Setup chunk " + i + ": " + chunk);
            this.addChunk(chunk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChunk(RAFChunk chunk) {
        CopyOnWriteArrayList<RAFChunk> copyOnWriteArrayList = this.chunks;
        synchronized (copyOnWriteArrayList) {
            this.chunks.add(chunk);
            chunk.startChunk();
        }
    }

    protected void addChunk(DownloadInterface.Chunk chunk) {
        throw new WTFException("This should not happen!");
    }

    protected boolean writeChunkBytes(DownloadInterface.Chunk chunk) {
        throw new WTFException("This should not happen!");
    }

    private void createOutputChannel() throws SkipReasonException {
        try {
            String fileOutput = this.downloadable.getFileOutput();
            this.logger.info("createOutputChannel for " + fileOutput);
            String finalFileOutput = this.downloadable.getFinalFileOutput();
            this.outputFinalCompleteFile = this.outputCompleteFile = new File(fileOutput);
            if (!fileOutput.equals(finalFileOutput)) {
                this.outputFinalCompleteFile = new File(finalFileOutput);
            }
            this.outputPartFile = new File(this.downloadable.getFileOutputPart());
            try {
                if (Application.getJavaVersion() >= Application.JAVA17) {
                    SparseFile.createSparseFile(this.outputPartFile);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.outputPartFileRaf.set(IO.open((File)this.outputPartFile, (String)"rw"));
        }
        catch (Exception e) {
            LogSource.exception((LogInterface)this.logger, (Throwable)e);
            throw new SkipReasonException(SkipReason.INVALID_DESTINATION, e);
        }
    }

    private void setupResume() throws FileNotFoundException {
        long parts = this.getFileSize() / (long)this.getChunkNum();
        this.logger.info("Resume: " + this.getFileSize() + " partsize: " + parts);
        int id = 0;
        for (int i = 0; i < this.getChunkNum(); ++i) {
            RAFChunk chunk;
            if (i == this.getChunkNum() - 1) {
                chunk = new RAFChunk(this.downloadable.getChunksProgress()[i] == 0L ? 0L : this.downloadable.getChunksProgress()[i] + 1L, -1L, this.connection, this, this.downloadable, id++);
                chunk.setLoaded(this.downloadable.getChunksProgress()[i] - (long)i * parts + 1L);
            } else {
                chunk = new RAFChunk(this.downloadable.getChunksProgress()[i] == 0L ? 0L : this.downloadable.getChunksProgress()[i] + 1L, (long)(i + 1) * parts - 1L, this.connection, this, this.downloadable, id++);
                chunk.setLoaded(this.downloadable.getChunksProgress()[i] - (long)i * parts + 1L);
            }
            this.logger.finer("Setup chunk " + i + ": " + chunk);
            this.addChunk(chunk);
        }
    }

    @Override
    public long getTotalLinkBytesLoadedLive() {
        return this.totalLinkBytesLoadedLive.get();
    }

    public synchronized void setTotalLinkBytesLoaded(long loaded) {
        this.totalLinkBytesLoaded = loaded;
        this.totalLinkBytesLoadedLive.set(loaded);
    }

    protected synchronized void addToTotalLinkBytesLoaded(long block, boolean updateLiveData) {
        this.totalLinkBytesLoaded += block;
        if (updateLiveData) {
            this.totalLinkBytesLoadedLive.addAndGet(block);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int write(RAFChunk chunk) {
        int written = -1;
        try {
            File file = this.outputPartFile;
            synchronized (file) {
                RandomAccessFile raf = this.outputPartFileRaf.get();
                long writePos = chunk.getCurrentBytesPosition();
                raf.seek(writePos);
                written = chunk.write(raf);
            }
            DownloadController.getInstance().requestSaving();
            return written;
        }
        catch (Exception e) {
            LogSource.exception((LogInterface)this.logger, (Throwable)e);
            this.error(new PluginException(16384, Exceptions.getStackTrace((Throwable)e), 2L));
            return written;
        }
    }

    public void cleanupDownladInterface() {
        try {
            try {
                this.downloadable.removeConnectionHandler(this.getManagedConnetionHandler());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.connection.disconnect();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        finally {
            this.closeOutputChannel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeOutputChannel() {
        block15: {
            try {
                long timeStamp;
                RandomAccessFile loutputPartFileRaf = this.outputPartFileRaf.getAndSet(null);
                if (loutputPartFileRaf == null) break block15;
                try {
                    timeStamp = System.currentTimeMillis();
                    try {
                        loutputPartFileRaf.getChannel().force(true);
                    }
                    catch (IOException e) {
                        this.logger.log((Throwable)e);
                    }
                    finally {
                        this.logger.info("Buffers forced to disk:" + TimeFormatter.formatMilliSeconds((long)(System.currentTimeMillis() - timeStamp), (int)0));
                    }
                }
                finally {
                    timeStamp = System.currentTimeMillis();
                    try {
                        loutputPartFileRaf.close();
                    }
                    finally {
                        this.logger.info("File closed:" + TimeFormatter.formatMilliSeconds((long)(System.currentTimeMillis() - timeStamp), (int)0));
                    }
                }
            }
            catch (Throwable e) {
                LogSource.exception((LogInterface)this.logger, (Throwable)e);
            }
        }
    }

    public LogInterface getLogger() {
        return this.logger;
    }

    @Override
    public void close() {
    }

    @Override
    public Downloadable getDownloadable() {
        return this.downloadable;
    }

    protected synchronized int getAllocationUnitSize() {
        if (this.allocationUnitSize == null) {
            File outputPartFile = this.outputPartFile;
            if (outputPartFile == null) {
                return 4096;
            }
            CrossSystem.OperatingSystem os = CrossSystem.getOS();
            try {
                if (os.isMinimum(CrossSystem.OperatingSystem.WINDOWS_XP)) {
                    this.allocationUnitSize = org.jdownloader.jna.windows.FileSystemHelper.getAllocationUnitSize(outputPartFile);
                } else if (os.getFamily() == CrossSystem.OSFamily.BSD || os.getFamily() == CrossSystem.OSFamily.LINUX) {
                    this.allocationUnitSize = FileSystemHelper.getAllocationUnitSize(outputPartFile);
                }
            }
            catch (Throwable e) {
                this.logger.log(e);
            }
            if (this.allocationUnitSize == null || this.allocationUnitSize < 0) {
                this.allocationUnitSize = 4096;
            }
            this.logger.info("AllocationUnitSize:" + this.allocationUnitSize + "|" + outputPartFile);
        }
        return this.allocationUnitSize;
    }
}

