/*
 * Decompiled with CFR 0.152.
 */
package jd.update;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import jd.nutils.Executer;
import jd.nutils.OutdatedParser;
import jd.nutils.zip.UnZip;
import org.jdownloader.controlling.FileCreationManager;

public class Restarter {
    private static boolean WAIT_FOR_JDOWNLOADER_TERM = false;
    private static boolean RESTART = false;
    private static Logger logger;
    private static boolean NOLOG;

    public static String getStackTrace(Throwable thrown) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        thrown.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    public static void main(String[] args) {
        for (String arg : args) {
            if (arg.equalsIgnoreCase("-restart")) {
                RESTART = true;
            }
            if (!arg.equalsIgnoreCase("-nolog")) continue;
            NOLOG = true;
        }
        try {
            logger = Logger.getLogger("org.jdownloader");
            if (!NOLOG) {
                FileHandler handler = new FileHandler("restarter.log", false);
                logger.addHandler(handler);
            }
        }
        catch (IOException handler) {
            // empty catch block
        }
        try {
            while (new File("JDownloader.jar").exists() && !new File("JDownloader.jar").canWrite()) {
                logger.severe("Wait for jdownloader terminating");
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            new File("update/tools/tinyupdate.jar").deleteOnExit();
            FileCreationManager.getInstance().delete(new File("update/tools/tinyupdate.jar"), null);
            Restarter.extract(new File("update"));
            Restarter.move(new File("update"));
            for (int i = 0; !Restarter.removeFiles() && i <= 3; ++i) {
                Thread.sleep(2000L);
            }
            String javaPath = new File(new File(System.getProperty("sun.boot.library.path")), "javaw.exe").getAbsolutePath();
            if (RESTART) {
                if (System.getProperty("os.name").toLowerCase().contains("mac")) {
                    Executer exec = new Executer("open");
                    exec.setLogger(logger);
                    exec.addParameters(new String[]{"-n", "jDownloader.app"});
                    exec.setRunin(new File(".").getAbsolutePath());
                    exec.setWaitTimeout(0);
                    exec.start();
                } else {
                    Executer exec = new File(javaPath).exists() ? new Executer(javaPath) : new Executer("java");
                    exec.setLogger(logger);
                    exec.addParameters(new String[]{"-jar", "-Xmx512m", "JDownloader.jar", "-rfu"});
                    exec.setRunin(new File(".").getAbsolutePath());
                    exec.setWaitTimeout(0);
                    exec.start();
                }
                Thread.sleep(1000L);
                System.exit(0);
            }
        }
        catch (Throwable e) {
            logger.severe(Restarter.getStackTrace(e));
            JOptionPane.showMessageDialog(null, Restarter.getStackTrace(e));
        }
    }

    private static void extract(File file) {
        try {
            for (File f : file.listFiles()) {
                if (f.isDirectory()) {
                    Restarter.extract(f);
                    continue;
                }
                if (!f.getName().endsWith(".extract")) continue;
                logger.info("Extract: " + f);
                UnZip u = new UnZip(f, f.getParentFile());
                u.setOverwrite(false);
                try {
                    File[] efiles = u.extract();
                    logger.info("-->: " + efiles.length + " files");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean removeFiles() {
        return OutdatedParser.parseFile((File)new File("outdated.dat"));
    }

    private static void move(File dir) {
        if (!dir.isDirectory()) {
            return;
        }
        block2: for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                Restarter.move(f);
                continue;
            }
            String n = new File("update").getAbsolutePath();
            File newFile = new File(f.getAbsolutePath().replace(n, "").substring(1)).getAbsoluteFile();
            logger.info("./update -> real  " + n + " ->" + newFile.getAbsolutePath());
            logger.info("Exists: " + newFile.exists());
            if (!newFile.getParentFile().exists()) {
                logger.info("Parent Exists: false");
                if (FileCreationManager.getInstance().mkdir(newFile.getParentFile())) {
                    logger.info("^^CREATED");
                } else {
                    logger.info("^^CREATION FAILED");
                }
            }
            int waittime = 15000;
            while (newFile.exists() && !FileCreationManager.getInstance().delete(newFile, null) && !WAIT_FOR_JDOWNLOADER_TERM) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if ((waittime -= 1000) < 0) {
                    logger.severe("^^COULD NOT DELETE");
                    continue block2;
                }
                logger.severe("^^WAIT FOR DELETE");
            }
            if (!newFile.exists()) {
                WAIT_FOR_JDOWNLOADER_TERM = true;
                logger.severe("^^DELETE OLD OK");
            } else {
                logger.severe("^^DELETE OLD FAILED");
            }
            logger.severe("RENAME :" + f.renameTo(newFile));
            if (f.getParentFile().list().length != 0) continue;
            logger.severe("^^REMOVED PARENT DIR");
            FileCreationManager.getInstance().delete(f.getParentFile(), null);
        }
        if (dir.list() != null && dir.list().length == 0) {
            FileCreationManager.getInstance().delete(dir, null);
        }
    }

    static {
        NOLOG = false;
    }
}

