/*
 * Decompiled with CFR 0.152.
 */
package jd.update;

import java.io.Serializable;
import java.util.List;

public class Server
implements Serializable {
    private static final long serialVersionUID = 701200615385983L;
    private int percent;
    private String path;
    private long requestTime = 0L;
    private int requestCount = 0;

    public int getPercent() {
        return this.percent;
    }

    public void setPercent(int percent) {
        this.percent = percent;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String toString() {
        return this.path + " (" + this.percent + "%)";
    }

    public Server(int percent, String host) {
        this.percent = percent;
        this.path = host;
    }

    public static Server selectServer(List<Server> list) {
        int rand = (int)(Math.random() * 100.0);
        int total = 0;
        Server ret = null;
        for (Server s : list) {
            if (s.getPercent() <= 0) {
                return Server.selectServerByRequestTime(list);
            }
            ret = s;
            if (rand > (total += s.getPercent()) || rand <= total - s.getPercent()) continue;
            break;
        }
        return ret;
    }

    private static Server selectServerByRequestTime(List<Server> list) {
        Server ret = null;
        for (Server s : list) {
            if (ret != null && s.getRequestTime() >= ret.getRequestTime()) continue;
            ret = s;
        }
        return ret;
    }

    public void setRequestTime(long l) {
        this.requestTime = (this.requestTime * (long)this.requestCount + l) / (long)(this.requestCount + 1);
        ++this.requestCount;
    }

    public long getRequestTime() {
        return this.requestTime;
    }
}

