/*
 * Decompiled with CFR 0.152.
 */
package jd.utils;

public final class EditDistance {
    public static final int damerauLevenshteinDistance(String l1, String l2) {
        int i;
        if (l1 == null || l2 == null) {
            throw new IllegalArgumentException("Letter must not be null");
        }
        int n = l1.length();
        int m = l2.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int n1 = n + 1;
        int[] p = new int[n1];
        int[] d = new int[n1];
        int[] c = new int[n1];
        int cost = 0;
        for (i = 1; i <= n; ++i) {
            p[i] = i;
        }
        for (int j = 1; j <= m; ++j) {
            int j1 = j;
            int j2 = --j1;
            --j2;
            char t_j = l2.charAt(j1);
            d[0] = j;
            for (i = 1; i <= n; ++i) {
                int i2;
                int i1 = i - 1;
                cost = l1.charAt(i1) == t_j ? 0 : 1;
                d[i] = Math.min(d[i1] + 1, Math.min(p[i] + 1, p[i1] + cost));
                if (i <= 1 || j <= 1 || l1.charAt(i1) != l2.charAt(j2) || l1.charAt(i2 = i1 - 1) != l2.charAt(j1)) continue;
                d[i] = Math.min(d[i], c[i2] + (cost > 0 ? 1 : cost));
            }
            for (i = 0; i <= n; ++i) {
                c[i] = p[i];
            }
            int[] _d = p;
            p = d;
            d = _d;
        }
        return p[n];
    }

    public static int getLevenshteinDifference(String s, String t) {
        if (s == null) {
            if (t == null) {
                return 0;
            }
            return t.length();
        }
        int sLength = s.length();
        if (t == null) {
            return sLength;
        }
        if (s.equals(t)) {
            return 0;
        }
        return 100 * EditDistance.getLevenshteinDistance(s, t) / Math.max(sLength, t.length());
    }

    public static int getLevenshteinDistance(String s, String t) {
        int i;
        if (s == null) {
            if (t == null) {
                return 0;
            }
            return t.length();
        }
        if (t == null) {
            return s.length();
        }
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int n1 = n + 1;
        int[] p = new int[n1];
        int[] d = new int[n1];
        for (i = 0; i <= n; ++i) {
            p[i] = i;
        }
        for (int j = 1; j <= m; ++j) {
            char t_j = t.charAt(j - 1);
            d[0] = j;
            for (i = 1; i <= n; ++i) {
                int i1 = i - 1;
                d[i] = Math.min(Math.min(d[i1] + 1, p[i] + 1), p[i1] + (s.charAt(i1) == t_j ? 0 : 1));
            }
            int[] _d = p;
            p = d;
            d = _d;
        }
        return p[n];
    }

    private EditDistance() {
    }
}

