/*
 * Decompiled with CFR 0.152.
 */
package jd.utils;

import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdownloader.logging.LogController;

public final class JDHexUtils {
    static final byte[] HEX_CHAR_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    public static final String REGEX_FIND_ALL_HEX = "[[a-fA-F0-9]{2}]*?";
    public static final String REGEX_MATCH_ALL_HEX = "([[a-fA-F0-9]{2}]*?)";
    public static final String REGEX_HTTP_NEWLINE = JDHexUtils.getHexString("\r") + "{1}" + JDHexUtils.getHexString("\n") + "{1}";
    public static final Pattern PATTERN_JAVASCRIPT_HEX = Pattern.compile("\\\\x([a-f0-9]{2})", 2);

    private JDHexUtils() {
    }

    public static String toString(String hexString) {
        if (hexString == null) {
            return null;
        }
        return new String(JDHexUtils.getByteArray(hexString));
    }

    public static String decodeJavascriptHex(String javascriptHexString) {
        StringBuffer sb = new StringBuffer();
        Matcher m = PATTERN_JAVASCRIPT_HEX.matcher(javascriptHexString);
        while (m.find()) {
            m.appendReplacement(sb, JDHexUtils.toString(m.group(1)));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static byte[] getByteArray(String hexString) {
        if (hexString == null) {
            return null;
        }
        int length = hexString.length();
        byte[] buffer = new byte[(length + 1) / 2];
        boolean evenByte = true;
        byte nextByte = 0;
        int bufferOffset = 0;
        if (length % 2 == 1) {
            evenByte = false;
        }
        for (int i = 0; i < length; ++i) {
            int nibble;
            char c = hexString.charAt(i);
            if (c >= '0' && c <= '9') {
                nibble = c - 48;
            } else if (c >= 'A' && c <= 'F') {
                nibble = c - 65 + 10;
            } else if (c >= 'a' && c <= 'f') {
                nibble = c - 97 + 10;
            } else {
                throw new NumberFormatException("Invalid hex digit '" + c + "'.");
            }
            if (evenByte) {
                nextByte = (byte)(nibble << 4);
            } else {
                nextByte = (byte)(nextByte + (byte)nibble);
                buffer[bufferOffset++] = nextByte;
            }
            evenByte = !evenByte;
        }
        return buffer;
    }

    public static String getHexString(byte[] raw) {
        byte[] hex = new byte[2 * raw.length];
        int index = 0;
        for (byte b : raw) {
            int v = b & 0xFF;
            hex[index++] = HEX_CHAR_TABLE[v >>> 4];
            hex[index++] = HEX_CHAR_TABLE[v & 0xF];
        }
        try {
            return new String(hex, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            LogController.CL().log((Throwable)e);
            return null;
        }
    }

    public static String getHexString(String string) {
        if (string == null) {
            return null;
        }
        try {
            byte[] raw = string.getBytes("ASCII");
            byte[] hex = new byte[2 * raw.length];
            int index = 0;
            for (byte b : raw) {
                int v = b & 0xFF;
                hex[index++] = HEX_CHAR_TABLE[v >>> 4];
                hex[index++] = HEX_CHAR_TABLE[v & 0xF];
            }
            return new String(hex, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            LogController.CL().log((Throwable)e);
            return null;
        }
    }
}

