/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api;

import java.io.EOFException;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.storage.config.handler.StorageHandler;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.StringUtils;
import org.appwork.utils.formatter.HexFormatter;
import org.appwork.utils.net.httpserver.HttpConnection;
import org.appwork.utils.net.httpserver.HttpHandlerInfo;
import org.appwork.utils.net.httpserver.HttpServer;
import org.appwork.utils.net.httpserver.RawHttpConnectionInterface;
import org.appwork.utils.net.httpserver.handler.HttpRequestHandler;
import org.appwork.utils.net.httpserver.requests.GetRequest;
import org.appwork.utils.net.httpserver.requests.HeadRequest;
import org.appwork.utils.net.httpserver.requests.OptionsRequest;
import org.appwork.utils.net.httpserver.requests.PostRequest;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jsse.provider.IDNUtil;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.DefaultTlsServer;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.ServerName;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsCredentialedDecryptor;
import org.bouncycastle.tls.TlsCredentialedSigner;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsServer;
import org.bouncycastle.tls.TlsServerProtocol;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.impl.bc.BcDefaultTlsCredentialedDecryptor;
import org.bouncycastle.tls.crypto.impl.bc.BcDefaultTlsCredentialedSigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.util.Strings;
import org.jdownloader.api.CertStorable;
import org.jdownloader.api.DeprecatedAPIRequestInterface;
import org.jdownloader.logging.LogController;

public class DeprecatedAPIServer
extends HttpServer {
    private static final HashMap<String, APICert> APICERTS = new HashMap();
    private static final File APICERTSFILE = Application.getTempResource((String)"myjd.certs");
    private static final AtomicBoolean APICERTSFILELOADED = new AtomicBoolean(false);

    public DeprecatedAPIServer(int port) {
        super(port);
    }

    public HttpHandlerInfo registerRequestHandler(HttpRequestHandler handler) {
        return super.registerRequestHandler(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final APICert getAPICert(String serverName) throws Exception {
        String cn = serverName != null ? (serverName.matches("(?i)^\\d+-\\d+-\\d+-\\d+.mydns.jdownloader.org$") || serverName.matches("(?i)^[a-fA-F0-9]{8}.mydns.jdownloader.org$") || serverName.matches("(?i)^[a-fA-F0-9]{32}.mydns.jdownloader.org$") ? "*.mydns.jdownloader.org" : serverName) : "localhost";
        HashMap<String, APICert> hashMap = APICERTS;
        synchronized (hashMap) {
            APICert apiCert;
            if (APICERTSFILELOADED.compareAndSet(false, true) && APICERTSFILE.exists()) {
                try {
                    List certStorables = (List)JSonStorage.restoreFrom((File)APICERTSFILE, (boolean)false, (byte[])JSonStorage.KEY, (TypeRef)new TypeRef<ArrayList<CertStorable>>(){}, null);
                    if (certStorables != null) {
                        for (CertStorable certStorable : certStorables) {
                            try {
                                APICert apiCert2 = new APICert(certStorable);
                                String[] subjects = apiCert2.getSubjects();
                                if (subjects == null) continue;
                                for (String subject : subjects) {
                                    if (APICERTS.containsKey(subject)) continue;
                                    APICERTS.put(subject, apiCert2);
                                }
                            }
                            catch (Throwable e) {
                                LogController.CL(DeprecatedAPIServer.class).log(e);
                            }
                        }
                    }
                }
                catch (Throwable e) {
                    LogController.CL(DeprecatedAPIServer.class).log(e);
                }
            }
            if ((apiCert = APICERTS.get(cn)) == null) {
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
                keyPairGenerator.initialize(2048);
                KeyPair keyPair = keyPairGenerator.genKeyPair();
                X509Certificate cert = DeprecatedAPIServer.createSelfSignedCertificate(keyPair, cn);
                X509CertificateHolder holder = new X509CertificateHolder(cert.getEncoded());
                GeneralNames subjectAltNames = GeneralNames.fromExtensions((Extensions)holder.getExtensions(), (ASN1ObjectIdentifier)Extension.subjectAlternativeName);
                ArrayList<String> subjects = new ArrayList<String>();
                block13: for (GeneralName subjectAltName : subjectAltNames.getNames()) {
                    switch (subjectAltName.getTagNo()) {
                        case 2: {
                            subjects.add(subjectAltName.getName().toString());
                            continue block13;
                        }
                        case 7: {
                            subjects.add(InetAddress.getByAddress(DEROctetString.getInstance((Object)subjectAltName.getName()).getOctets()).getHostAddress());
                        }
                    }
                }
                apiCert = new APICert(keyPair, cert, subjects.toArray(new String[0]));
                for (String subject : subjects) {
                    if (APICERTS.containsKey(subject)) continue;
                    APICERTS.put(subject, apiCert);
                }
                ArrayList<CertStorable> certStorables = new ArrayList<CertStorable>();
                for (APICert toStorable : new HashSet<APICert>(APICERTS.values())) {
                    CertStorable storable = toStorable.toCertStorable();
                    if (storable == null) continue;
                    certStorables.add(storable);
                }
                final byte[] json = JSonStorage.getMapper().objectToByteArray(certStorables);
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        JSonStorage.saveTo((File)APICERTSFILE, (boolean)false, (byte[])JSonStorage.KEY, (byte[])json, (IO.SYNC)IO.SYNC.META_AND_DATA);
                    }
                };
                StorageHandler.enqueueWrite((Runnable)run, (String)APICERTSFILE.getAbsolutePath(), (boolean)true);
            }
            return apiCert;
        }
    }

    protected static X509Certificate createSelfSignedCertificate(KeyPair keyPair, String cn) throws Exception {
        long now = System.currentTimeMillis();
        Date notBefore = new Date(now - 86400000L);
        Date notAfter = new Date(now + 1576800000000L);
        ContentSigner contentSigner = new JcaContentSignerBuilder("SHA256WithRSA").build(keyPair.getPrivate());
        X500Name x500Name = new X500Name("CN=Self signed certificate for local JDownloader@" + System.getProperty("user.name", "User"));
        JcaX509ExtensionUtils extUtils = new JcaX509ExtensionUtils();
        JcaX509v3CertificateBuilder certificateBuilder = new JcaX509v3CertificateBuilder(x500Name, BigInteger.valueOf(now), notBefore, notAfter, x500Name, keyPair.getPublic());
        certificateBuilder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)extUtils.createSubjectKeyIdentifier(keyPair.getPublic()));
        certificateBuilder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)extUtils.createAuthorityKeyIdentifier(keyPair.getPublic()));
        certificateBuilder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(false));
        certificateBuilder.addExtension(Extension.keyUsage, false, (ASN1Encodable)new KeyUsage(224));
        ArrayList<GeneralName> alternativeNames = new ArrayList<GeneralName>();
        if (StringUtils.equalsIgnoreCase((String)"localhost", (String)cn)) {
            alternativeNames.add(new GeneralName(7, "127.0.0.1"));
            alternativeNames.add(new GeneralName(2, cn));
        } else if (cn.matches("^\\d+\\.\\d+\\.\\d+\\.\\d+$")) {
            alternativeNames.add(new GeneralName(7, cn));
            alternativeNames.add(new GeneralName(2, "localhost"));
        } else {
            alternativeNames.add(new GeneralName(2, cn));
            alternativeNames.add(new GeneralName(7, "127.0.0.1"));
            alternativeNames.add(new GeneralName(2, "localhost"));
        }
        GeneralNames subjectAltNames = new GeneralNames(alternativeNames.toArray(new GeneralName[0]));
        certificateBuilder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)subjectAltNames);
        return new JcaX509CertificateConverter().setProvider((Provider)new BouncyCastleProvider()).getCertificate(certificateBuilder.build(contentSigner));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpConnection autoWrapSSLConnection(final Socket clientSocket, AutoSSLHttpConnectionFactory factory) throws IOException {
        OutputStream httpOS;
        InputStream httpIS;
        boolean finallyCloseSocket = true;
        clientSocket.setSoTimeout(60000);
        InputStream is = clientSocket.getInputStream();
        byte[] guessProtocolBuffer = new byte[8];
        int index = 0;
        for (index = 0; index < 8; ++index) {
            int read = is.read();
            if (read == -1) {
                if (index == 0) {
                    HttpConnection httpConnection = null;
                    return httpConnection;
                }
                throw new EOFException("guess protocol failed: " + index);
            }
            guessProtocolBuffer[index] = (byte)read;
        }
        HttpConnection.HttpConnectionType httpConnectionType = HttpConnection.HttpConnectionType.get((byte[])guessProtocolBuffer);
        final PushbackInputStream clientSocketIS = new PushbackInputStream(is, 8);
        clientSocketIS.unread(guessProtocolBuffer, 0, index);
        if (!HttpConnection.HttpConnectionType.UNKNOWN.equals((Object)httpConnectionType)) {
            httpIS = clientSocketIS;
            httpOS = clientSocket.getOutputStream();
        } else {
            TlsServerProtocol tlsServerProtocol = new TlsServerProtocol(clientSocketIS, clientSocket.getOutputStream()){
                InputStream modifiedTlsInputStream;
                {
                    super(x0, x1);
                    this.modifiedTlsInputStream = null;
                }

                public InputStream getInputStream() {
                    if (this.modifiedTlsInputStream == null && super.getInputStream() != null) {
                        this.modifiedTlsInputStream = new FilterInputStream(super.getInputStream()){

                            @Override
                            public int available() throws IOException {
                                int dataAvailable = this.applicationDataAvailable();
                                if (dataAvailable > 0) {
                                    return dataAvailable;
                                }
                                int socketAvailable = clientSocketIS.available();
                                if (socketAvailable >= 5) {
                                    return socketAvailable;
                                }
                                return 0;
                            }
                        };
                    }
                    return this.modifiedTlsInputStream;
                }
            };
            tlsServerProtocol.accept((TlsServer)new DefaultTlsServer((TlsCrypto)new BcTlsCrypto(new SecureRandom())){
                private Certificate cert;
                private AsymmetricKeyParameter keyParam;
                {
                    super(x0);
                    this.cert = null;
                    this.keyParam = null;
                }

                public void notifySecureRenegotiation(boolean arg0) throws IOException {
                }

                protected String getServerName(Hashtable arg0) throws IOException {
                    Vector serverNames = TlsExtensionsUtils.getServerNameExtensionClient((Hashtable)arg0);
                    if (serverNames != null) {
                        for (ServerName serverName : serverNames) {
                            if (serverName.getNameType() != 0) continue;
                            String name = IDNUtil.toASCII((String)Strings.fromUTF8ByteArray((byte[])serverName.getNameData()), (int)IDNUtil.USE_STD3_ASCII_RULES);
                            return name;
                        }
                    }
                    return null;
                }

                protected boolean allowEncryptThenMAC() {
                    return false;
                }

                public void processClientExtensions(Hashtable arg0) throws IOException {
                    String serverName = this.getServerName(arg0);
                    if (serverName == null) {
                        serverName = clientSocket.getLocalAddress().getHostAddress();
                    }
                    super.processClientExtensions(arg0);
                    try {
                        APICert apiCert = DeprecatedAPIServer.getAPICert(serverName);
                        ArrayList<TlsCertificate> certificates = new ArrayList<TlsCertificate>();
                        for (byte[] certificiate : apiCert.getX509()) {
                            certificates.add(this.context.getCrypto().createCertificate(certificiate));
                        }
                        this.cert = new Certificate(certificates.toArray(new TlsCertificate[0]));
                        this.keyParam = apiCert.getAsymKeyParam();
                    }
                    catch (Exception e) {
                        LogController.CL(DeprecatedAPIServer.class).log((Throwable)e);
                        throw new IOException(e);
                    }
                }

                protected TlsCredentialedDecryptor getRSAEncryptionCredentials() throws IOException {
                    return new BcDefaultTlsCredentialedDecryptor((BcTlsCrypto)this.getCrypto(), this.cert, this.keyParam);
                }

                protected ProtocolVersion[] getSupportedVersions() {
                    return ProtocolVersion.TLSv12.only();
                }

                protected TlsCredentialedSigner getRSASignerCredentials() throws IOException {
                    SignatureAndHashAlgorithm signatureAndHashAlgorithm = new SignatureAndHashAlgorithm(4, 1);
                    return new BcDefaultTlsCredentialedSigner(new TlsCryptoParameters((TlsContext)this.context), (BcTlsCrypto)this.getCrypto(), this.keyParam, this.cert, signatureAndHashAlgorithm);
                }
            });
            httpIS = tlsServerProtocol.getInputStream();
            httpOS = tlsServerProtocol.getOutputStream();
        }
        finallyCloseSocket = false;
        HttpConnection httpConnection = factory.create(clientSocket, httpIS, httpOS);
        return httpConnection;
        finally {
            try {
                if (finallyCloseSocket) {
                    clientSocket.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected Runnable createConnectionHandler(final Socket clientSocket) throws IOException {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    HttpConnection httpConnection = DeprecatedAPIServer.autoWrapSSLConnection(clientSocket, new AutoSSLHttpConnectionFactory(){

                        @Override
                        public HttpConnection create(Socket clientSocket, InputStream is, OutputStream os) throws IOException {
                            return new CustomHttpConnection(DeprecatedAPIServer.this, clientSocket, is, os);
                        }
                    });
                    if (httpConnection != null) {
                        httpConnection.run();
                    }
                }
                catch (Throwable e) {
                    LogController.CL(DeprecatedAPIServer.class).log(e);
                }
            }
        };
    }

    public static interface AutoSSLHttpConnectionFactory {
        public HttpConnection create(Socket var1, InputStream var2, OutputStream var3) throws IOException;
    }

    public class CustomHttpConnection
    extends HttpConnection {
        protected CustomHttpConnection(HttpServer server, Socket clientSocket, InputStream is, OutputStream os) throws IOException {
            super(server, clientSocket, is, os);
        }

        protected GetRequest buildGetRequest() {
            return new DeprecatedGetRequest(this);
        }

        protected HeadRequest buildHeadRequest() {
            return new DeprecatedHeadRequest(this);
        }

        protected OptionsRequest buildOptionsRequest() {
            return new DeprecatedOptionsRequest(this);
        }

        protected PostRequest buildPostRequest() {
            return new DeprecatedPostRequest(this);
        }

        public CustomHttpConnection(HttpServer server, Socket clientSocket) throws IOException {
            super(server, clientSocket);
        }
    }

    public static final class DeprecatedGetRequest
    extends GetRequest
    implements DeprecatedAPIRequestInterface {
        public DeprecatedGetRequest(HttpConnection connection) {
            super((RawHttpConnectionInterface)connection);
        }
    }

    public static final class DeprecatedHeadRequest
    extends HeadRequest
    implements DeprecatedAPIRequestInterface {
        public DeprecatedHeadRequest(HttpConnection connection) {
            super((RawHttpConnectionInterface)connection);
        }
    }

    public static final class DeprecatedOptionsRequest
    extends OptionsRequest
    implements DeprecatedAPIRequestInterface {
        public DeprecatedOptionsRequest(HttpConnection connection) {
            super((RawHttpConnectionInterface)connection);
        }
    }

    public static final class DeprecatedPostRequest
    extends PostRequest
    implements DeprecatedAPIRequestInterface {
        public DeprecatedPostRequest(HttpConnection connection) {
            super((RawHttpConnectionInterface)connection);
        }
    }

    protected static class APICert {
        private final KeyPair keyPair;
        private final AsymmetricKeyParameter asymKeyParam;
        private final List<byte[]> x509 = new ArrayList<byte[]>();
        private final String[] subjects;

        protected final KeyPair getKeyPair() {
            return this.keyPair;
        }

        protected final AsymmetricKeyParameter getAsymKeyParam() {
            return this.asymKeyParam;
        }

        protected final String[] getSubjects() {
            return this.subjects;
        }

        protected APICert() {
            this.asymKeyParam = null;
            this.subjects = null;
            this.keyPair = null;
        }

        protected final List<byte[]> getX509() {
            return this.x509;
        }

        protected APICert(KeyPair keyPair, X509Certificate x509, String[] subjects) throws CertificateEncodingException, IOException {
            this.keyPair = keyPair;
            this.asymKeyParam = PrivateKeyFactory.createKey((byte[])keyPair.getPrivate().getEncoded());
            this.x509.add(x509.getEncoded());
            this.subjects = (String[])subjects.clone();
        }

        protected CertStorable toCertStorable() throws CertificateEncodingException, IOException {
            if (this.keyPair != null && this.x509.size() == 1) {
                CertStorable ret = new CertStorable();
                ret.setCert(HexFormatter.byteArrayToHex((byte[])this.x509.get(0)));
                ret.setPrivateKey(HexFormatter.byteArrayToHex((byte[])this.keyPair.getPrivate().getEncoded()));
                ret.setPublicKey(HexFormatter.byteArrayToHex((byte[])this.keyPair.getPublic().getEncoded()));
                ret.setSubjects(this.subjects);
                return ret;
            }
            return null;
        }

        protected APICert(CertStorable certStorable) throws Exception {
            this.x509.add(HexFormatter.hexToByteArray((String)certStorable.getCert()));
            PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(HexFormatter.hexToByteArray((String)certStorable.getPublicKey())));
            PrivateKey privateKey = KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(HexFormatter.hexToByteArray((String)certStorable.getPrivateKey())));
            this.keyPair = new KeyPair(publicKey, privateKey);
            this.asymKeyParam = PrivateKeyFactory.createKey((byte[])privateKey.getEncoded());
            this.subjects = certStorable.getSubjects();
        }
    }
}

