/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URL;
import org.appwork.exceptions.WTFException;
import org.appwork.remoteapi.DefaultDocsPageFactory;
import org.appwork.remoteapi.SessionRemoteAPI;
import org.appwork.remoteapi.Template;
import org.appwork.storage.Storable;
import org.appwork.storage.config.annotations.LabelInterface;
import org.appwork.utils.IO;
import org.appwork.utils.StringUtils;
import org.jdownloader.myjdownloader.client.bindings.ApiDoc;
import org.jdownloader.myjdownloader.client.json.DeviceErrorType;
import org.jdownloader.myjdownloader.client.json.JsonFactoryInterface;
import org.jdownloader.myjdownloader.client.json.ServerErrorType;

public class DocsPageFactoryImpl
extends DefaultDocsPageFactory {
    public DocsPageFactoryImpl(SessionRemoteAPI<?> api) throws SecurityException, NoSuchMethodException {
        super(api);
    }

    protected void addNavigation(DefaultDocsPageFactory.HTMLStringBuilder nav, Template template) {
        try {
            template.put("navigation", IO.readURLToString((URL)DocsPageFactoryImpl.class.getResource("Docs.basics.nav.html")) + nav.toString());
        }
        catch (IOException e) {
            throw new WTFException((Throwable)e);
        }
    }

    protected String getDocByField(Field fi) {
        System.out.println(fi);
        String ret = super.getDocByField(fi);
        ApiDoc an = fi.getAnnotation(ApiDoc.class);
        if (an != null && StringUtils.isNotEmpty((String)an.value())) {
            ret = ret == null ? an.value() : ret + "\r\n" + an.value();
        }
        return ret;
    }

    protected String getDocByMethod(Method m) {
        String ret = super.getDocByMethod(m);
        ApiDoc an = m.getAnnotation(ApiDoc.class);
        if (an != null && StringUtils.isNotEmpty((String)an.value())) {
            ret = ret == null ? an.value() : ret + "\r\n" + an.value();
        }
        return ret;
    }

    private String replace(String readURLToString) {
        readURLToString = readURLToString.replace("<!--%%%DeviceErrorType%%%-->", this.createEnumList(DeviceErrorType.class));
        readURLToString = readURLToString.replace("<!--%%%ServerErrorType%%%-->", this.createEnumList(ServerErrorType.class));
        return readURLToString;
    }

    private String createEnumList(Class<? extends Enum> num) {
        DefaultDocsPageFactory.HTMLStringBuilder content = new DefaultDocsPageFactory.HTMLStringBuilder((DefaultDocsPageFactory)this);
        content.comment("Start " + num + "");
        content.append("<ul class='enums'>");
        for (Enum c : num.getEnumConstants()) {
            content.append("<li>");
            try {
                Field fi = num.getField(c.name());
                org.appwork.remoteapi.annotations.ApiDoc docAnno = fi.getAnnotation(org.appwork.remoteapi.annotations.ApiDoc.class);
                if (docAnno != null) {
                    this.appendDocs(content, docAnno.value());
                }
                if (num == DeviceErrorType.class) {
                    this.appendDocs(content, "HTTP Response Code: " + ((DeviceErrorType)c).getCode());
                } else if (num == ServerErrorType.class) {
                    this.appendDocs(content, "HTTP Response Code: " + ((ServerErrorType)c).getCode());
                }
            }
            catch (NoSuchFieldException docAnno) {
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            if (LabelInterface.class.isAssignableFrom(num)) {
                this.appendDocs(content, ((LabelInterface)c).getLabel());
            }
            content.append(c.name());
            content.append("</li>");
        }
        content.append("</ul>");
        content.comment("End " + num + "");
        return content.toString();
    }

    protected void addContent(DefaultDocsPageFactory.HTMLStringBuilder content, Template template) {
        try {
            template.put("content", this.replace(IO.readURLToString((URL)DocsPageFactoryImpl.class.getResource("Docs.basics.html"))) + content.toString());
        }
        catch (IOException e) {
            throw new WTFException((Throwable)e);
        }
    }

    protected void addTitle(Template template) {
        template.put("title", "My.JDownloader API Documentation");
    }

    protected String readCSSStyle() {
        String ret = super.readCSSStyle();
        ret = ret.replace("#1b9bff", "#307782");
        ret = ret.replace("#0787eb", "#175E69");
        ret = ret.replace("#0082e7", "#00444F");
        ret = ret + "\r\n/*JD Customization*/\r\n";
        try {
            ret = ret + IO.readURLToString((URL)DocsPageFactoryImpl.class.getResource("Docs.style.css"));
        }
        catch (IOException e) {
            throw new WTFException((Throwable)e);
        }
        return ret;
    }

    protected boolean isAddObjectToHelp(Type returnType) {
        return Storable.class.isAssignableFrom((Class)returnType) || JsonFactoryInterface.class.isAssignableFrom((Class)returnType);
    }
}

