/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.captcha;

import java.util.concurrent.CopyOnWriteArraySet;
import org.appwork.remoteapi.events.EventObject;
import org.appwork.remoteapi.events.EventPublisher;
import org.appwork.remoteapi.events.RemoteAPIEventsSender;
import org.appwork.remoteapi.events.SimpleEventObject;
import org.jdownloader.captcha.v2.Challenge;
import org.jdownloader.captcha.v2.solverjob.SolverJob;

public class CaptchaAPIEventPublisher
implements EventPublisher {
    private final CopyOnWriteArraySet<RemoteAPIEventsSender> eventSenders = new CopyOnWriteArraySet();
    private final String[] eventIDs = new String[]{EVENTID.NEW.name(), EVENTID.DONE.name()};

    public String[] getPublisherEventIDs() {
        return this.eventIDs;
    }

    public String getPublisherName() {
        return "captchas";
    }

    private final boolean hasSubscriptionFor(String eventID) {
        if (this.eventSenders.size() > 0) {
            for (RemoteAPIEventsSender eventSender : this.eventSenders) {
                if (!eventSender.hasSubscriptionFor((EventPublisher)this, eventID)) continue;
                return true;
            }
        }
        return false;
    }

    public void fireJobDoneEvent(SolverJob<?> job) {
        if (this.hasSubscriptionFor(EVENTID.DONE.name())) {
            SimpleEventObject eventObject = new SimpleEventObject((EventPublisher)this, EVENTID.DONE.name(), (Object)job.getChallenge().getId().getID());
            for (RemoteAPIEventsSender eventSender : this.eventSenders) {
                eventSender.publishEvent((EventObject)eventObject, null);
            }
        }
    }

    public void fireNewJobEvent(SolverJob<?> job, Challenge<?> challenge) {
        if (this.hasSubscriptionFor(EVENTID.NEW.name())) {
            SimpleEventObject eventObject = new SimpleEventObject((EventPublisher)this, EVENTID.NEW.name(), (Object)challenge.getId().getID());
            for (RemoteAPIEventsSender eventSender : this.eventSenders) {
                eventSender.publishEvent((EventObject)eventObject, null);
            }
        }
    }

    public synchronized void register(RemoteAPIEventsSender eventsAPI) {
        this.eventSenders.add(eventsAPI);
    }

    public synchronized void unregister(RemoteAPIEventsSender eventsAPI) {
        this.eventSenders.remove(eventsAPI);
    }

    private static enum EVENTID {
        NEW,
        DONE;

    }
}

