/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.captcha;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.WeakHashMap;
import jd.controlling.captcha.SkipException;
import jd.controlling.captcha.SkipRequest;
import jd.plugins.DownloadLink;
import org.appwork.remoteapi.RemoteAPI;
import org.appwork.remoteapi.RemoteAPIRequest;
import org.appwork.remoteapi.RemoteAPIResponse;
import org.appwork.remoteapi.exceptions.InternalApiException;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.jdownloader.api.captcha.CaptchaAPI;
import org.jdownloader.api.captcha.CaptchaAPIEventPublisher;
import org.jdownloader.api.captcha.CaptchaAPIManualRemoteSolverService;
import org.jdownloader.api.captcha.CaptchaJob;
import org.jdownloader.api.captcha.CaptchaMyJDownloaderRemoteSolverSettings;
import org.jdownloader.api.captcha.InvalidCaptchaIDException;
import org.jdownloader.api.captcha.InvalidChallengeTypeException;
import org.jdownloader.api.myjdownloader.MyJDownloaderController;
import org.jdownloader.api.myjdownloader.MyJDownloaderHttpConnection;
import org.jdownloader.api.myjdownloader.MyJDownloaderRequestInterface;
import org.jdownloader.captcha.event.ChallengeResponseListener;
import org.jdownloader.captcha.v2.AbstractResponse;
import org.jdownloader.captcha.v2.Challenge;
import org.jdownloader.captcha.v2.ChallengeResponseController;
import org.jdownloader.captcha.v2.ChallengeSolver;
import org.jdownloader.captcha.v2.JobRunnable;
import org.jdownloader.captcha.v2.challenge.hcaptcha.HCaptchaChallenge;
import org.jdownloader.captcha.v2.challenge.oauth.AccountLoginOAuthChallenge;
import org.jdownloader.captcha.v2.challenge.recaptcha.v2.RecaptchaV2Challenge;
import org.jdownloader.captcha.v2.challenge.stringcaptcha.ImageCaptchaChallenge;
import org.jdownloader.captcha.v2.solver.jac.SolverException;
import org.jdownloader.captcha.v2.solverjob.SolverJob;
import org.jdownloader.myjdownloader.client.json.SessionInfoResponse;

public class CaptchaAPISolver
extends ChallengeSolver<Object>
implements CaptchaAPI,
ChallengeResponseListener {
    private static final CaptchaAPISolver INSTANCE = new CaptchaAPISolver();
    private final CaptchaAPIEventPublisher eventPublisher;
    private final CaptchaMyJDownloaderRemoteSolverSettings config = (CaptchaMyJDownloaderRemoteSolverSettings)JsonConfig.create(CaptchaMyJDownloaderRemoteSolverSettings.class);

    public static CaptchaAPISolver getInstance() {
        return INSTANCE;
    }

    protected int getDefaultWaitForOthersTimeout() {
        return 120000;
    }

    @Override
    protected boolean isChallengeSupported(Challenge<?> c) {
        return c instanceof HCaptchaChallenge || c instanceof RecaptchaV2Challenge || c instanceof AccountLoginOAuthChallenge || c instanceof ImageCaptchaChallenge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void solve(SolverJob<Object> job) throws InterruptedException, SolverException, SkipException {
        Challenge<Object> challenge = job.getChallenge();
        job.getLogger().info("Fire MyJDownloader Captcha Event");
        if (challenge instanceof RecaptchaV2Challenge) {
            try {
                ((RecaptchaV2Challenge)challenge).createBasicCaptchaChallenge(false);
            }
            catch (Throwable e) {
                job.getLogger().log(e);
            }
        }
        MyJDownloaderController.getInstance().pushCaptchaFlag(true);
        try {
            while (!this.isJobDone(job)) {
                Thread.sleep(250L);
            }
        }
        finally {
            job.getLogger().info("Wait done");
        }
    }

    public CaptchaAPISolver() {
        super(new CaptchaAPIManualRemoteSolverService(), 0);
        this.eventPublisher = new CaptchaAPIEventPublisher();
        ChallengeResponseController.getInstance().getEventSender().addListener(this, true);
    }

    public CaptchaAPIEventPublisher getEventPublisher() {
        return this.eventPublisher;
    }

    @Override
    public List<CaptchaJob> list(RemoteAPIRequest request) {
        ArrayList<CaptchaJob> ret = new ArrayList<CaptchaJob>();
        for (SolverJob<?> entry : ChallengeResponseController.getInstance().listJobs()) {
            CaptchaJob captchaJob;
            Challenge<?> challenge;
            if (entry.isDone() || !this.isChallengeSupported(challenge = entry.getChallenge()) || (captchaJob = this.getCaptchaJob(request, challenge.getId().getID())) == null) continue;
            ret.add(captchaJob);
        }
        Collections.sort(ret, new Comparator<CaptchaJob>(){

            @Override
            private final int compare(long x, long y) {
                return x < y ? -1 : (x == y ? 0 : 1);
            }

            @Override
            public int compare(CaptchaJob o1, CaptchaJob o2) {
                return this.compare(o1.getTimeout(), o2.getTimeout());
            }
        });
        return ret;
    }

    @Override
    public void get(RemoteAPIRequest request, RemoteAPIResponse response, long id) throws InternalApiException, InvalidCaptchaIDException {
        this.get(request, response, id, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void get(RemoteAPIRequest request, RemoteAPIResponse response, long id, String format) throws InternalApiException, InvalidCaptchaIDException {
        SolverJob<?> job = this.getJobByChallengeId(id);
        if (job == null || job.isDone()) {
            throw new InvalidCaptchaIDException();
        }
        try {
            Challenge<?> challenge = job.getChallenge();
            OutputStream out = RemoteAPI.getOutputStream((RemoteAPIResponse)response, (RemoteAPIRequest)request, (boolean)RemoteAPI.gzip((RemoteAPIRequest)request), (boolean)true);
            try {
                HashMap<String, Object> captchaResponseData = new HashMap<String, Object>();
                captchaResponseData.put("data", challenge.getAPIStorable(format));
                if (request.getHttpRequest() instanceof MyJDownloaderRequestInterface) {
                    captchaResponseData.put("rid", ((MyJDownloaderRequestInterface)request.getHttpRequest()).getRid());
                }
                out.write(JSonStorage.serializeToJson(captchaResponseData).getBytes("UTF-8"));
            }
            finally {
                try {
                    out.close();
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Exception e) {
            LoggerFactory.getDefaultLogger().log((Throwable)e);
            throw new InternalApiException((Throwable)e);
        }
    }

    private SolverJob<?> getJobByChallengeId(long id) {
        return ChallengeResponseController.getInstance().getJobByChallengeId(id);
    }

    @Override
    public boolean isJobDone(SolverJob<?> job) {
        if (this.isMyJDownloaderActive()) {
            return super.isJobDone(job);
        }
        return true;
    }

    @Override
    public void enqueue(SolverJob<Object> job) {
        if (!this.isMyJDownloaderActive()) {
            job.setSolverDone(this);
        } else {
            super.enqueue(job);
        }
    }

    private boolean isMyJDownloaderActive() {
        return MyJDownloaderController.getInstance().isActive();
    }

    @Override
    public boolean solve(long id, String result) throws InvalidCaptchaIDException, InvalidChallengeTypeException {
        return this.solve(id, result, null);
    }

    @Override
    public boolean solve(long id, String result, String resultFormat) throws InvalidCaptchaIDException, InvalidChallengeTypeException {
        SolverJob<?> job = this.getJobByChallengeId(id);
        if (job == null || job.isDone()) {
            throw new InvalidCaptchaIDException();
        }
        Challenge<Object> challenge = job.getChallenge();
        AbstractResponse<?> ret = challenge.parseAPIAnswer(result, resultFormat, this);
        if (ret == null) {
            throw new InvalidChallengeTypeException(challenge.getClass().getName());
        }
        job.addAnswer(ret);
        return true;
    }

    @Override
    @Deprecated
    public boolean skip(long id) throws InvalidCaptchaIDException {
        return this.skip(id, SkipRequest.SINGLE);
    }

    @Override
    public boolean skip(long id, SkipRequest type) throws InvalidCaptchaIDException {
        SolverJob<?> job = this.getJobByChallengeId(id);
        if (job == null) {
            throw new InvalidCaptchaIDException();
        }
        ChallengeResponseController.getInstance().setSkipRequest(type, this, job.getChallenge());
        return true;
    }

    @Override
    public void kill(SolverJob<Object> job) {
        super.kill(job);
        MyJDownloaderController.getInstance().pushCaptchaFlag(this.hasJobs());
    }

    @Override
    public CaptchaJob getCaptchaJob(RemoteAPIRequest request, long id) {
        SolverJob<?> entry = this.getJobByChallengeId(id);
        if (entry != null) {
            CaptchaJob ret = new CaptchaJob();
            Challenge<?> challenge = entry.getChallenge();
            for (Class<?> cls = challenge.getClass(); cls != null && StringUtils.isEmpty((String)ret.getType()); cls = cls.getSuperclass()) {
                ret.setType(cls.getSimpleName());
                ret.setChallengeType(cls.getSimpleName());
            }
            if (challenge instanceof HCaptchaChallenge) {
                SessionInfoResponse sessionInfo;
                MyJDownloaderHttpConnection con = MyJDownloaderHttpConnection.getMyJDownloaderHttpConnection(request);
                SessionInfoResponse sessionInfoResponse = sessionInfo = con != null ? con.getSessionInfo() : null;
                if (sessionInfo != null && StringUtils.startsWithCaseInsensitive((String)sessionInfo.getAppKey(), (String)"myjd_webinterface")) {
                    ret.setType("RecaptchaV2Challenge");
                }
            }
            ret.setID(challenge.getId().getID());
            ret.setHoster(challenge.getHost());
            ret.setCaptchaCategory(challenge.getTypeID());
            ret.setExplain(challenge.getExplain());
            ret.setRemaining(challenge.getRemainingTimeout());
            ret.setTimeout(challenge.getTimeout());
            ret.setCreated(challenge.getCreated());
            DownloadLink link = challenge.getDownloadLink();
            if (link != null) {
                ret.setLink(link.getUniqueID().getID());
            }
            return ret;
        }
        return null;
    }

    @Override
    public void onNewJobAnswer(SolverJob<?> job, AbstractResponse<?> response) {
    }

    @Override
    public void onJobDone(SolverJob<?> job) {
        this.getEventPublisher().fireJobDoneEvent(job);
        this.dispose(job);
        MyJDownloaderController.getInstance().pushCaptchaFlag(this.hasJobs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasJobs() {
        WeakHashMap weakHashMap = this.map;
        synchronized (weakHashMap) {
            return this.map.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose(SolverJob<?> job) {
        JobRunnable suc;
        WeakHashMap weakHashMap = this.map;
        synchronized (weakHashMap) {
            suc = (JobRunnable)this.map.remove(job);
        }
        if (suc != null) {
            suc.fireDoneAndAfterSolveEvents();
        }
    }

    @Override
    public long keepAlive(long jobId) {
        SolverJob<?> entry = this.getJobByChallengeId(jobId);
        if (entry == null) {
            ChallengeResponseController.getInstance().keepAlivePendingChallenges(null);
            return -1L;
        }
        ChallengeResponseController.getInstance().keepAlivePendingChallenges(entry.getChallenge());
        return entry.getChallenge().getRemainingTimeout();
    }

    @Override
    public void onNewJob(SolverJob<?> job) {
        this.getEventPublisher().fireNewJobEvent(job, job.getChallenge());
    }

    @Override
    public void onJobSolverEnd(ChallengeSolver<?> solver, SolverJob<?> job) {
    }

    @Override
    public void onJobSolverStart(ChallengeSolver<?> solver, SolverJob<?> job) {
    }
}

