/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.cnl2;

import java.io.IOException;
import org.appwork.net.protocol.http.HTTPConstants;
import org.appwork.net.protocol.http.ResponseCodeInterface;
import org.appwork.remoteapi.RemoteAPI;
import org.appwork.remoteapi.exceptions.BasicRemoteAPIException;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.net.HTTPHeader;
import org.appwork.utils.net.httpserver.HttpConnection;
import org.appwork.utils.net.httpserver.HttpHandlerInfo;
import org.appwork.utils.net.httpserver.handler.ExtendedHttpRequestHandler;
import org.appwork.utils.net.httpserver.handler.HttpRequestHandler;
import org.appwork.utils.net.httpserver.requests.GetRequest;
import org.appwork.utils.net.httpserver.requests.HttpRequest;
import org.appwork.utils.net.httpserver.requests.OptionsRequest;
import org.appwork.utils.net.httpserver.responses.HttpResponse;
import org.jdownloader.api.DeprecatedAPIHttpServerController;
import org.jdownloader.api.RemoteAPIConfig;
import org.jdownloader.api.cnl2.ExternInterfaceImpl;

public class ExternInterface {
    private static ExternInterface INSTANCE = new ExternInterface();

    private ExternInterface() {
        final RemoteAPIConfig config = (RemoteAPIConfig)JsonConfig.create(RemoteAPIConfig.class);
        if (config.isExternInterfaceEnabled()) {
            Thread serverInit = new Thread(){

                @Override
                public void run() {
                    ExternInterfaceRemoteAPI remoteAPI = new ExternInterfaceRemoteAPI();
                    try {
                        remoteAPI.register(new ExternInterfaceImpl());
                        while (config.isExternInterfaceEnabled() && !Thread.currentThread().isInterrupted()) {
                            try {
                                HttpHandlerInfo handler = DeprecatedAPIHttpServerController.getInstance().registerRequestHandler(9666, config.isExternInterfaceLocalhostOnly(), (HttpRequestHandler)remoteAPI);
                                break;
                            }
                            catch (IOException e) {
                                Thread.sleep(30000L);
                            }
                        }
                    }
                    catch (Throwable e) {
                        LoggerFactory.getDefaultLogger().log(e);
                    }
                }
            };
            serverInit.setDaemon(true);
            serverInit.setName("ExternInterface: init");
            serverInit.start();
        }
    }

    public static ExternInterface getINSTANCE() {
        return INSTANCE;
    }

    private class ExternInterfaceRemoteAPI
    extends RemoteAPI
    implements ExtendedHttpRequestHandler,
    HttpConnection.ConnectionHook {
        private ExternInterfaceRemoteAPI() {
        }

        public boolean onGetRequest(GetRequest request, HttpResponse response) throws BasicRemoteAPIException {
            if (request instanceof OptionsRequest) {
                response.getResponseHeaders().add(new HTTPHeader("Content-Length", "0"));
                response.setResponseCode((ResponseCodeInterface)HTTPConstants.ResponseCode.SUCCESS_OK);
                return true;
            }
            return super.onGetRequest(request, response);
        }

        public void onBeforeSendHeaders(HttpResponse response) {
            String pna;
            HttpRequest request = response.getConnection().getRequest();
            response.getResponseHeaders().add(new HTTPHeader("Access-Control-Max-Age", "1800"));
            response.getResponseHeaders().add(new HTTPHeader("Access-Control-Allow-Origin", "*"));
            response.getResponseHeaders().add(new HTTPHeader("Access-Control-Allow-Methods", "OPTIONS, GET, POST"));
            String allowHeaders = request.getRequestHeaders().getValue("Access-Control-Request-Headers");
            if (allowHeaders != null) {
                response.getResponseHeaders().addIfAbsent(new HTTPHeader("Access-Control-Allow-Headers", allowHeaders));
            }
            if ((pna = request.getRequestHeaders().getValue("Access-Control-Request-Private-Network")) != null) {
                response.getResponseHeaders().addIfAbsent(new HTTPHeader("Access-Control-Allow-Private-Network", pna));
            }
            response.getResponseHeaders().remove("Content-Security-Policy");
            response.getResponseHeaders().remove("X-Frame-Options");
            response.getResponseHeaders().remove("X-Xss-Protection");
            response.getResponseHeaders().remove("Referrer-Policy");
            response.getResponseHeaders().remove("X-Content-Type-Options");
        }

        public void onBeforeRequest(HttpRequest request, HttpResponse response) {
            response.setHook((HttpConnection.ConnectionHook)this);
        }

        public void onAfterRequest(HttpRequest request, HttpResponse response, boolean handled) {
        }

        public void onAfterRequestException(HttpRequest request, HttpResponse response, Throwable e) {
        }
    }
}

