/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.config;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import javax.swing.Icon;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.WarnLevel;
import org.appwork.exceptions.WTFException;
import org.appwork.remoteapi.RemoteAPIRequest;
import org.appwork.remoteapi.exceptions.BadParameterException;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.annotations.EnumLabel;
import org.appwork.storage.config.annotations.LabelInterface;
import org.appwork.storage.config.annotations.RequiresRestart;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.storage.config.handler.StorageHandler;
import org.appwork.uio.UIOManager;
import org.appwork.utils.StringUtils;
import org.appwork.utils.Time;
import org.appwork.utils.reflection.Clazz;
import org.appwork.utils.swing.dialog.ConfirmDialog;
import org.jdownloader.api.RemoteAPIController;
import org.jdownloader.api.config.AdvancedConfigManagerAPI;
import org.jdownloader.api.config.AdvancedConfigQueryStorable;
import org.jdownloader.api.config.EnumOption;
import org.jdownloader.api.config.InvalidValueException;
import org.jdownloader.api.myjdownloader.MyJDownloaderHttpConnection;
import org.jdownloader.extensions.ExtensionController;
import org.jdownloader.extensions.LazyExtension;
import org.jdownloader.extensions.OptionalExtension;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.images.NewTheme;
import org.jdownloader.myjdownloader.client.bindings.AdvancedConfigEntryDataStorable;
import org.jdownloader.myjdownloader.client.bindings.interfaces.AdvancedConfigInterface;
import org.jdownloader.myjdownloader.client.json.SessionInfoResponse;
import org.jdownloader.plugins.config.PluginJsonConfig;
import org.jdownloader.plugins.controller.PluginClassLoader;
import org.jdownloader.plugins.controller.crawler.CrawlerPluginController;
import org.jdownloader.plugins.controller.crawler.LazyCrawlerPlugin;
import org.jdownloader.plugins.controller.host.HostPluginController;
import org.jdownloader.plugins.controller.host.LazyHostPlugin;
import org.jdownloader.settings.advanced.AdvancedConfigAPIEntry;
import org.jdownloader.settings.advanced.AdvancedConfigEntry;
import org.jdownloader.settings.advanced.AdvancedConfigManager;
import org.jdownloader.updatev2.InstallLog;
import org.jdownloader.updatev2.RestartController;
import org.jdownloader.updatev2.RestartRequest;
import org.jdownloader.updatev2.SmartRlyRestartRequest;
import org.jdownloader.updatev2.UpdateController;
import org.jdownloader.updatev2.UpdaterListener;

public class AdvancedConfigManagerAPIImpl
implements AdvancedConfigManagerAPI {
    private static final String EXTENSION = "Extension";

    public AdvancedConfigManagerAPIImpl() {
        RemoteAPIController.validateInterfaces(AdvancedConfigManagerAPI.class, AdvancedConfigInterface.class);
    }

    @Override
    public ArrayList<AdvancedConfigAPIEntry> query(AdvancedConfigQueryStorable query) {
        ArrayList<AdvancedConfigAPIEntry> ret = new ArrayList<AdvancedConfigAPIEntry>();
        List<AdvancedConfigEntry> entries = AdvancedConfigManager.getInstance().list();
        boolean isInterfaceQuery = !StringUtils.isEmpty((String)query.getConfigInterface());
        Pattern cPat = null;
        if (!StringUtils.isEmpty((String)query.getPattern())) {
            cPat = Pattern.compile(query.getPattern(), 34);
        }
        for (AdvancedConfigEntry advancedConfigEntry : entries) {
            if (isInterfaceQuery && !query.getConfigInterface().equals(advancedConfigEntry.getKeyHandler().getStorageHandler().getConfigInterface().getName()) || cPat != null && !cPat.matcher(advancedConfigEntry.getKeyHandler().getStorageHandler().getConfigInterface().getName() + "." + advancedConfigEntry.getKeyHandler().getKey()).matches()) continue;
            try {
                ret.add(this.createAPIEntry(query.isDescription(), query.isValues(), query.isDefaultValues(), query.isEnumInfo(), advancedConfigEntry));
            }
            catch (Exception e) {
                throw new WTFException((Throwable)e);
            }
        }
        if (query.isIncludeExtensions()) {
            for (AdvancedConfigAPIEntry advancedConfigAPIEntry : this.createExtensionConfigList(query)) {
                if (cPat != null && !cPat.matcher(advancedConfigAPIEntry.getInterfaceName() + "." + advancedConfigAPIEntry.getKey()).matches()) continue;
                ret.add(advancedConfigAPIEntry);
            }
        }
        return ret;
    }

    @Override
    public Object get(String interfaceName, String storage, String key) {
        KeyHandler<Object> kh = this.getKeyHandler(interfaceName, storage, key);
        if (kh == null) {
            return null;
        }
        return kh.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean set(RemoteAPIRequest request, String interfaceName, String storage, String key, Object value) throws InvalidValueException {
        if (EXTENSION.equals(interfaceName)) {
            Boolean setValue;
            try {
                String jsonString = JSonStorage.serializeToJson((Object)value);
                setValue = (Boolean)JSonStorage.restoreFromString((String)jsonString, (TypeRef)TypeRef.BOOLEAN);
                if (setValue == null) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
            for (LazyExtension ext : ExtensionController.getInstance().getExtensions()) {
                if (!this.createExtensionToggleDummyKey("Enable", ext).equals(key)) continue;
                try {
                    ext._setEnabled(Boolean.TRUE.equals(setValue));
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
            if (key != null && key.startsWith("InstallExtension")) {
                String toInstall = StringUtils.toLowerCaseOrNull((String)key.substring("InstallExtension".length()));
                this.installExtension(toInstall, Boolean.TRUE.equals(setValue));
                return true;
            }
            return false;
        }
        KeyHandler<Object> keyHandler = this.getKeyHandler(interfaceName, storage, key);
        if (keyHandler != null) {
            Type type = keyHandler.getRawType();
            TypeRef<Object> typeRef = new TypeRef<Object>(type){};
            try {
                Object setValue = null;
                if (value instanceof String) {
                    try {
                        setValue = JSonStorage.restoreFromString((String)((String)value), (TypeRef)typeRef);
                    }
                    catch (Exception e) {
                        String jsonString = JSonStorage.serializeToJson((Object)value);
                        setValue = JSonStorage.restoreFromString((String)jsonString, (TypeRef)typeRef);
                    }
                } else {
                    String jsonString = JSonStorage.serializeToJson((Object)value);
                    setValue = JSonStorage.restoreFromString((String)jsonString, (TypeRef)typeRef);
                }
                GenericConfigEventListener<Object> listener = this.createRestartRequiredConfigEventListener(request, keyHandler);
                keyHandler.getEventSender().addListener(listener);
                try {
                    keyHandler.setValue(setValue);
                }
                finally {
                    keyHandler.getEventSender().removeListener(listener);
                }
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    protected boolean isMyJDownloaderWebinterface(RemoteAPIRequest request) {
        MyJDownloaderHttpConnection con = MyJDownloaderHttpConnection.getMyJDownloaderHttpConnection(request);
        SessionInfoResponse sessionInfo = con != null ? con.getSessionInfo() : null;
        return sessionInfo != null && StringUtils.startsWithCaseInsensitive((String)sessionInfo.getAppKey(), (String)"myjd_webinterface");
    }

    protected GenericConfigEventListener<Object> createRestartRequiredConfigEventListener(RemoteAPIRequest request, final KeyHandler<Object> keyHandler) {
        if (this.isMyJDownloaderWebinterface(request) && keyHandler.getAnnotation(RequiresRestart.class) != null) {
            return new GenericConfigEventListener<Object>(){

                public void onConfigValueModified(final KeyHandler<Object> keyHandler2, Object newValue) {
                    if (JDGui.bugme((WarnLevel)WarnLevel.NORMAL)) {
                        new Thread("RestartRequired:" + keyHandler2.getKey()){
                            {
                                super(x0);
                                this.setDaemon(true);
                            }

                            @Override
                            public void run() {
                                ConfirmDialog d = new ConfirmDialog(48, _GUI.T.AdvancedConfigEntry_setValue_restart_warning_title(keyHandler2.getKey()), _GUI.T.AdvancedConfigEntry_setValue_restart_warning(keyHandler2.getKey()), NewTheme.I().getIcon("warning", 32), null, null){

                                    public String getDontShowAgainKey() {
                                        return "RestartRequiredAdvancedConfig_" + this.getKey();
                                    }
                                };
                                d.show();
                            }
                        }.start();
                    }
                }

                private String getHandlerKey() {
                    return keyHandler.getKey();
                }

                private String getKey() {
                    return this.getConfigInterfaceName().concat(".").concat(this.getHandlerKey());
                }

                private String getConfigInterfaceName() {
                    String ret = keyHandler.getStorageHandler().getConfigInterface().getSimpleName();
                    if (ret.contains("Config")) {
                        ret = ret.replace("Config", "");
                    }
                    return ret;
                }

                public void onConfigValidatorError(KeyHandler<Object> keyHandler2, Object invalidValue, ValidationException validateException) {
                }
            };
        }
        return null;
    }

    @Override
    @Deprecated
    public ArrayList<AdvancedConfigAPIEntry> list(String pattern, boolean returnDescription, boolean returnValues, boolean returnDefaultValues) {
        return this.list(pattern, returnDescription, returnValues, returnDefaultValues, false);
    }

    @Override
    @Deprecated
    public ArrayList<AdvancedConfigAPIEntry> list(String pattern, boolean returnDescription, boolean returnValues, boolean returnDefaultValues, boolean returnEnumInfo) {
        try {
            AdvancedConfigQueryStorable query = new AdvancedConfigQueryStorable();
            query.setPattern(pattern);
            query.setDescription(true);
            query.setValues(returnValues);
            query.setDefaultValues(returnDefaultValues);
            query.setEnumInfo(returnEnumInfo);
            query.setIncludeExtensions(true);
            return this.query(query);
        }
        catch (Exception e) {
            throw new WTFException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reset(RemoteAPIRequest request, String interfaceName, String storage, String key) {
        KeyHandler<Object> keyHandler = this.getKeyHandler(interfaceName, storage, key);
        if (keyHandler == null) {
            return false;
        }
        try {
            GenericConfigEventListener<Object> listener = this.createRestartRequiredConfigEventListener(request, keyHandler);
            keyHandler.getEventSender().addListener(listener);
            try {
                keyHandler.setValue(keyHandler.getDefaultValue());
            }
            finally {
                keyHandler.getEventSender().removeListener(listener);
            }
        }
        catch (ValidationException e) {
            return false;
        }
        return true;
    }

    @Override
    public Object getDefault(String interfaceName, String storage, String key) {
        KeyHandler<Object> kh = this.getKeyHandler(interfaceName, storage, key);
        return kh.getDefaultValue();
    }

    @Override
    public ArrayList<AdvancedConfigAPIEntry> list() {
        return this.list(null, false, false, false, false);
    }

    @Override
    public ArrayList<EnumOption> listEnum(String type) throws BadParameterException {
        try {
            Class<?> cls = Class.forName(type);
            return this.listEnumOptions(cls);
        }
        catch (Exception e) {
            throw new BadParameterException((Throwable)e, "Bad Type: " + type);
        }
    }

    private ArrayList<EnumOption> listEnumOptions(Class<?> cls) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, NoSuchFieldException {
        Object[] values;
        ArrayList<EnumOption> ret = new ArrayList<EnumOption>();
        for (Object o : values = (Object[])cls.getMethod("values", new Class[0]).invoke(null, new Object[0])) {
            String label = null;
            EnumLabel lbl = cls.getDeclaredField(o.toString()).getAnnotation(EnumLabel.class);
            if (lbl != null) {
                label = lbl.value();
            } else if (o instanceof LabelInterface) {
                label = ((LabelInterface)o).getLabel();
            }
            ret.add(new EnumOption(o.toString(), label));
        }
        return ret;
    }

    private List<AdvancedConfigAPIEntry> createExtensionConfigList(AdvancedConfigQueryStorable query) {
        String dummyKey;
        AdvancedConfigAPIEntry entry;
        ArrayList<AdvancedConfigAPIEntry> ret = new ArrayList<AdvancedConfigAPIEntry>();
        for (OptionalExtension optionalExtension : ExtensionController.getInstance().getOptionalExtensions()) {
            entry = new AdvancedConfigAPIEntry();
            entry.setInterfaceName(EXTENSION);
            entry.setAbstractType(AdvancedConfigEntryDataStorable.AbstractType.BOOLEAN);
            if (query.isDefaultValues()) {
                entry.setDefaultValue(false);
            }
            if (query.isDescription()) {
                entry.setDocs("Install Extension: " + optionalExtension.getName());
            }
            dummyKey = "InstallExtension" + StringUtils.toUpperCaseOrNull((String)optionalExtension.getExtensionID());
            entry.setKey(dummyKey);
            if (query.isValues()) {
                entry.setValue(optionalExtension.isInstalled());
            }
            ret.add(entry);
        }
        for (LazyExtension lazyExtension : ExtensionController.getInstance().getExtensions()) {
            entry = new AdvancedConfigAPIEntry();
            entry.setInterfaceName(EXTENSION);
            entry.setAbstractType(AdvancedConfigEntryDataStorable.AbstractType.BOOLEAN);
            if (query.isDefaultValues()) {
                entry.setDefaultValue(false);
            }
            if (query.isDescription()) {
                entry.setDocs("Enable/Disable Extension: " + lazyExtension.getName());
            }
            dummyKey = this.createExtensionToggleDummyKey("Enable", lazyExtension);
            entry.setKey(dummyKey);
            if (query.isValues()) {
                entry.setValue(lazyExtension._isEnabled());
            }
            ret.add(entry);
        }
        return ret;
    }

    private AdvancedConfigAPIEntry createAPIEntry(boolean returnDescription, boolean returnValues, boolean returnDefaultValues, boolean returnEnumInfo, AdvancedConfigEntry entry) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, NoSuchFieldException {
        AdvancedConfigAPIEntry acae = new AdvancedConfigAPIEntry(entry, returnDescription, returnValues, returnDefaultValues);
        if (returnEnumInfo && Clazz.isEnum(entry.getClazz())) {
            ArrayList<EnumOption> enumOptions = this.listEnumOptions(entry.getClazz());
            String[][] constants = new String[enumOptions.size()][2];
            String label = null;
            Enum value = (Enum)entry.getValue();
            for (int i = 0; i < enumOptions.size(); ++i) {
                EnumOption option = enumOptions.get(i);
                constants[i] = new String[]{option.getName(), option.getLabel()};
                if (value == null || !value.name().equals(option.getName())) continue;
                label = constants[i][1];
            }
            acae.setEnumLabel(label);
            acae.setEnumOptions(constants);
        }
        return acae;
    }

    protected String createExtensionToggleDummyKey(String namespace, LazyExtension ext) {
        int lastP = ext.getClassname().lastIndexOf(".");
        String dummyKey = namespace + ext.getClassname().substring(lastP + 1);
        return dummyKey;
    }

    private KeyHandler<Object> getKeyHandler(String interfaceName, String storage, String key) {
        StorageHandler storageHandler = StorageHandler.getStorageHandler((String)interfaceName, (String)storage);
        if (storageHandler == null) {
            if (interfaceName.startsWith("jd.plugins.hoster.") || interfaceName.startsWith("jd.plugins.decrypter")) {
                String ifName;
                ArrayList ret = new ArrayList();
                PluginClassLoader.PluginClassLoaderChild pluginClassLoader = PluginClassLoader.getInstance().getChild();
                for (LazyHostPlugin hplg : HostPluginController.getInstance().list()) {
                    ifName = hplg.getConfigInterface();
                    if (!StringUtils.equals((String)ifName, (String)interfaceName)) continue;
                    try {
                        Object cf = PluginJsonConfig.get(pluginClassLoader.loadClass(ifName));
                        storageHandler = cf._getStorageHandler();
                        break;
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                        System.out.println(ifName);
                    }
                }
                for (LazyCrawlerPlugin cplg : CrawlerPluginController.getInstance().list()) {
                    ifName = cplg.getConfigInterface();
                    if (!StringUtils.isNotEmpty((String)ifName)) continue;
                    System.out.println(ifName);
                }
            }
            if (storageHandler == null) {
                return null;
            }
        }
        KeyHandler kh = storageHandler.getKeyHandler(key);
        return kh;
    }

    private void installExtension(final String toInstall, final boolean installFlag) {
        final UpdateController controller = UpdateController.getInstance();
        if (StringUtils.isNotEmpty((String)toInstall) && controller.isHandlerSet()) {
            new Thread("Install Extension:" + toInstall + "|" + installFlag){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (installFlag != controller.isExtensionInstalled(toInstall) && UIOManager.I().showConfirmDialog(0, _GUI.T.lit_are_you_sure(), installFlag ? _GUI.T.installExtension_remote_install_rly(toInstall) : _GUI.T.installExtension_remote_remove_rly(toInstall))) {
                        UpdaterListener listener = null;
                        try {
                            final AtomicLong last = new AtomicLong(Time.systemIndependentCurrentJVMTimeMillis());
                            listener = new UpdaterListener(){

                                public void onUpdatesAvailable(boolean selfupdate, InstallLog installlog) {
                                }

                                public void onUpdaterStatusUpdate(String label, Icon icon, double p) {
                                    if (System.currentTimeMillis() - last.get() > 5000L) {
                                        if (installFlag) {
                                            UIOManager.I().showConfirmDialog(16, _GUI.T.installExtension_remote_install_title(toInstall), _GUI.T.installExtension_remote_install_wait(), (Icon)new AbstractIcon("wait", 32), _GUI.T.lit_continue(), null);
                                        } else {
                                            UIOManager.I().showConfirmDialog(16, _GUI.T.installExtension_remote_remove_title(toInstall), _GUI.T.installExtension_remote_remove_wait(), (Icon)new AbstractIcon("wait", 32), _GUI.T.lit_continue(), null);
                                        }
                                        last.set(Time.systemIndependentCurrentJVMTimeMillis());
                                    }
                                }
                            };
                            controller.getEventSender().addListener((EventListener)listener);
                            if (installFlag) {
                                controller.runExtensionInstallation(toInstall);
                            } else {
                                controller.runExtensionUnInstallation(toInstall);
                            }
                            while (true) {
                                Thread.sleep(1000L);
                                if (!controller.isRunning()) break;
                                controller.waitForUpdate();
                            }
                            boolean pending = controller.hasPendingUpdates();
                            boolean restart = installFlag ? UIOManager.I().showConfirmDialog(0, "Install Extension " + toInstall, _GUI.T.UninstalledExtension_waiting_for_restart(), (Icon)new AbstractIcon("restart", 32), _GUI.T.lit_restart_now(), _GUI.T.lit_later()) : UIOManager.I().showConfirmDialog(0, "Remove Extension " + toInstall, _GUI.T.InstalledExtension_waiting_for_restart(), (Icon)new AbstractIcon("restart", 32), _GUI.T.lit_restart_now(), _GUI.T.lit_later());
                            if (restart) {
                                RestartController.getInstance().asyncRestart((RestartRequest)new SmartRlyRestartRequest(true));
                            }
                            controller.getEventSender().removeListener((EventListener)listener);
                        }
                        catch (Exception e) {
                            UIOManager.I().showException(_GUI.T.lit_error_occured(), (Throwable)e);
                        }
                        finally {
                            controller.getEventSender().removeListener(listener);
                        }
                    }
                }
            }.start();
        }
    }
}

