/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.content.v2;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import jd.plugins.FavitIcon;
import org.appwork.exceptions.WTFException;
import org.appwork.remoteapi.RemoteAPI;
import org.appwork.remoteapi.RemoteAPIRequest;
import org.appwork.remoteapi.RemoteAPIResponse;
import org.appwork.remoteapi.exceptions.APIFileNotFoundException;
import org.appwork.remoteapi.exceptions.BadRequestException;
import org.appwork.remoteapi.exceptions.InternalApiException;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownEvent;
import org.appwork.shutdown.ShutdownRequest;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.StorageException;
import org.appwork.storage.TypeRef;
import org.appwork.swing.components.ExtMergedIcon;
import org.appwork.swing.components.IDIcon;
import org.appwork.swing.components.IconIdentifier;
import org.appwork.utils.Application;
import org.appwork.utils.Hash;
import org.appwork.utils.ImageProvider.ImageProvider;
import org.appwork.utils.images.IconIO;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.net.HTTPHeader;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.DomainInfo;
import org.jdownloader.api.RemoteAPIController;
import org.jdownloader.api.content.v2.ContentAPIV2;
import org.jdownloader.gui.views.components.MergedIcon;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.images.BadgeIcon;
import org.jdownloader.images.NewTheme;
import org.jdownloader.logging.LogController;
import org.jdownloader.myjdownloader.client.bindings.interfaces.ContentInterface;
import org.jdownloader.myjdownloader.client.json.IconDescriptor;

public class ContentAPIImplV2
implements ContentAPIV2 {
    private final String usedByWebInterface = "folder_opendownloadpasswordaddContainer";
    private final File descriptorMapCacheFile = Application.getResource((String)"tmp/iconIDMapCache");
    private static final TypeRef<Map<String, IconDescriptor>> TYPE_REF = new TypeRef<Map<String, IconDescriptor>>(){};
    private final HashMap<String, IconDescriptor> descriptorMap = new HashMap();

    public ContentAPIImplV2() {
        RemoteAPIController.validateInterfaces(ContentAPIV2.class, ContentInterface.class);
        Map<String, IconDescriptor> cache = this.loadDescriptorMap();
        if (cache != null) {
            this.descriptorMap.putAll(cache);
        }
        ShutdownController.getInstance().addShutdownEvent(new ShutdownEvent(){

            public void onShutdown(ShutdownRequest shutdownRequest) {
                ContentAPIImplV2.this.saveDescriptorMap();
            }

            public String toString() {
                return "save iconID cache to disk";
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, IconDescriptor> loadDescriptorMap() {
        if (this.descriptorMapCacheFile.isFile()) {
            Map map;
            FileInputStream fis = new FileInputStream(this.descriptorMapCacheFile);
            try {
                Map map2;
                map = map2 = (Map)JSonStorage.restoreFromInputStream((InputStream)fis, TYPE_REF);
            }
            catch (Throwable throwable) {
                try {
                    fis.close();
                    throw throwable;
                }
                catch (Throwable e) {
                    this.descriptorMapCacheFile.delete();
                    LogController.CL().log(e);
                }
            }
            fis.close();
            return map;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDescriptorMap() {
        try {
            if (!this.descriptorMapCacheFile.getParentFile().isDirectory()) {
                this.descriptorMapCacheFile.getParentFile().mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(this.descriptorMapCacheFile);
            try {
                byte[] bytes;
                HashMap<String, IconDescriptor> hashMap = this.descriptorMap;
                synchronized (hashMap) {
                    bytes = JSonStorage.serializeToJsonByteArray(this.descriptorMap);
                }
                fos.write(bytes);
            }
            finally {
                fos.close();
            }
        }
        catch (Throwable e) {
            this.descriptorMapCacheFile.delete();
            LogController.CL().log(e);
        }
    }

    @Override
    public void getFavIcon(RemoteAPIRequest request, RemoteAPIResponse response, String hostername) throws InternalApiException, APIFileNotFoundException {
        DomainInfo info = DomainInfo.getInstance(hostername);
        Icon favIcon = info.getFavIcon(false);
        if (favIcon == null) {
            throw new APIFileNotFoundException();
        }
        OutputStream out = null;
        try {
            response.getResponseHeaders().add(new HTTPHeader("Cache-Control", "public,max-age=60", false));
            response.getResponseHeaders().add(new HTTPHeader("Content-Type", "image/png", false));
            out = RemoteAPI.getOutputStream((RemoteAPIResponse)response, (RemoteAPIRequest)request, (boolean)RemoteAPI.gzip((RemoteAPIRequest)request), (boolean)false);
            ImageProvider.writeImage((RenderedImage)IconIO.toBufferedImage((Icon)favIcon), (String)"png", (OutputStream)out);
        }
        catch (IOException e) {
            LoggerFactory.getDefaultLogger().log((Throwable)e);
            throw new InternalApiException((Throwable)e);
        }
        finally {
            try {
                out.close();
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public void getFileIcon(RemoteAPIRequest request, RemoteAPIResponse response, String extension) throws InternalApiException {
        OutputStream out = null;
        try {
            response.getResponseHeaders().add(new HTTPHeader("Cache-Control", "public,max-age=60", false));
            response.getResponseHeaders().add(new HTTPHeader("Content-Type", "image/png", false));
            out = RemoteAPI.getOutputStream((RemoteAPIResponse)response, (RemoteAPIRequest)request, (boolean)RemoteAPI.gzip((RemoteAPIRequest)request), (boolean)false);
            ImageProvider.writeImage((RenderedImage)IconIO.toBufferedImage((Icon)CrossSystem.getMime().getFileIcon(extension, 16, 16)), (String)"png", (OutputStream)out);
        }
        catch (IOException e) {
            LoggerFactory.getDefaultLogger().log((Throwable)e);
            throw new InternalApiException((Throwable)e);
        }
        finally {
            try {
                out.close();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIconKey(Icon icon) {
        if (icon instanceof IDIcon) {
            IconIdentifier id = ((IDIcon)icon).getIdentifier();
            IconDescriptor ret = (IconDescriptor)JSonStorage.convert((Object)id, (TypeRef)new TypeRef<IconDescriptor>(){});
            String s = JSonStorage.serializeToJson((Object)ret);
            try {
                String cr32 = Hash.getMD5((byte[])s.getBytes("UTF-8"));
                String iconKey = "kc." + cr32;
                HashMap<String, IconDescriptor> hashMap = this.descriptorMap;
                synchronized (hashMap) {
                    this.descriptorMap.put(iconKey, ret);
                }
                return iconKey;
            }
            catch (Throwable e) {
                throw new WTFException(e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IconDescriptor getIconDescription(String key) throws InternalApiException {
        if (key.startsWith("kc.")) {
            HashMap<String, IconDescriptor> hashMap = this.descriptorMap;
            synchronized (hashMap) {
                return this.descriptorMap.get(key);
            }
        }
        return null;
    }

    @Override
    public void getIcon(RemoteAPIRequest request, RemoteAPIResponse response, String key, int size) throws InternalApiException, APIFileNotFoundException, BadRequestException {
        if (size > 128) {
            throw new BadRequestException("Size is limited to 128px!");
        }
        OutputStream out = null;
        try {
            if ("myjdownloader".equalsIgnoreCase(key)) {
                key = "logo/myjdownloader";
            }
            response.getResponseHeaders().add(new HTTPHeader("Cache-Control", "public,max-age=60", false));
            response.getResponseHeaders().add(new HTTPHeader("Content-Type", "image/png", false));
            if (key.startsWith("{")) {
                IconDescriptor desc = (IconDescriptor)JSonStorage.restoreFromString((String)key, (TypeRef)new TypeRef<IconDescriptor>(){});
                if (desc == null) {
                    throw new APIFileNotFoundException();
                }
                BufferedImage ico = IconIO.toBufferedImage((Icon)this.createIcon(desc, size));
                out = RemoteAPI.getOutputStream((RemoteAPIResponse)response, (RemoteAPIRequest)request, (boolean)RemoteAPI.gzip((RemoteAPIRequest)request), (boolean)false);
                ImageProvider.writeImage((RenderedImage)ico, (String)"png", (OutputStream)out);
            } else if (key.startsWith("kc.")) {
                IconDescriptor desc = this.getIconDescription(key);
                if (desc == null) {
                    throw new APIFileNotFoundException();
                }
                BufferedImage ico = IconIO.toBufferedImage((Icon)this.createIcon(desc, size));
                out = RemoteAPI.getOutputStream((RemoteAPIResponse)response, (RemoteAPIRequest)request, (boolean)RemoteAPI.gzip((RemoteAPIRequest)request), (boolean)false);
                ImageProvider.writeImage((RenderedImage)ico, (String)"png", (OutputStream)out);
            } else {
                BufferedImage ico = IconIO.toBufferedImage((Icon)new AbstractIcon(key, size));
                out = RemoteAPI.getOutputStream((RemoteAPIResponse)response, (RemoteAPIRequest)request, (boolean)RemoteAPI.gzip((RemoteAPIRequest)request), (boolean)false);
                ImageProvider.writeImage((RenderedImage)ico, (String)"png", (OutputStream)out);
            }
        }
        catch (IOException e) {
            LoggerFactory.getDefaultLogger().log((Throwable)e);
            throw new InternalApiException((Throwable)e);
        }
        finally {
            try {
                out.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private Icon createIcon(IconDescriptor desc, int size) throws InternalApiException, StorageException {
        if (desc.getCls() == null && desc.getKey() != null) {
            return NewTheme.I().getIcon(desc.getKey(), size);
        }
        if ("ColMerge".equals(desc.getCls())) {
            Icon[] icons = new Icon[desc.getRsc().size()];
            for (int i = 0; i < desc.getRsc().size(); ++i) {
                icons[i] = this.createIcon(desc.getRsc().get(i), size);
            }
            return new MergedIcon(icons);
        }
        if ("Badge".equals(desc.getCls())) {
            if (desc.getRsc().get(0).getCls() == null && desc.getRsc().get(1).getCls() == null) {
                return new BadgeIcon(desc.getRsc().get(0).getKey(), desc.getRsc().get(1).getKey(), size);
            }
            return new BadgeIcon(this.createIcon(desc.getRsc().get(0), size), this.createIcon(desc.getRsc().get(1), size / 2), 0, 0);
        }
        if ("Merge".equals(desc.getCls())) {
            ExtMergedIcon ret = new ExtMergedIcon();
            int orgWidth = ((Number)desc.getPrps().get("width")).intValue();
            int orgHeight = ((Number)desc.getPrps().get("height")).intValue();
            double hfaktor = (double)size / (double)Math.max(orgHeight, orgWidth);
            for (int i = 0; i < desc.getRsc().size(); ++i) {
                int x = 0;
                int y = 0;
                HashMap<String, Object> props = desc.getRsc().get(i).getPrps();
                int orgIconWidth = ((Number)props.get("width")).intValue();
                int orgIconHeight = ((Number)props.get("height")).intValue();
                int newIconSize = (int)((double)Math.max(orgIconWidth, orgIconHeight) * hfaktor);
                if (props != null) {
                    if (props.containsKey("x")) {
                        x = (int)((double)((Number)props.get("x")).intValue() * hfaktor);
                    }
                    if (props.containsKey("y")) {
                        y = (int)((double)((Number)props.get("y")).intValue() * hfaktor);
                    }
                }
                ret.add(this.createIcon(desc.getRsc().get(i), newIconSize), x, y);
            }
            ret.crop(size, size);
            return ret;
        }
        if ("DomainInfo".equals(desc.getCls())) {
            return DomainInfo.getInstance(desc.getKey());
        }
        if ("Favit".equals(desc.getCls())) {
            return new FavitIcon(this.createIcon(desc.getRsc().get(1), size), DomainInfo.getInstance(desc.getRsc().get(0).getKey()));
        }
        throw new InternalApiException((Throwable)new Exception("Cannot paint " + JSonStorage.serializeToJson((Object)desc)));
    }
}

