/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.downloads;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.appwork.remoteapi.events.Subscriber;
import org.appwork.storage.JSonStorage;
import org.appwork.utils.Hash;
import org.appwork.utils.StringUtils;
import org.jdownloader.api.downloads.DownloadControllerEventPublisher;
import org.jdownloader.api.downloads.v2.DownloadLinkAPIStorableV2;
import org.jdownloader.api.downloads.v2.DownloadsAPIV2Impl;
import org.jdownloader.api.downloads.v2.FilePackageAPIStorableV2;
import org.jdownloader.api.downloads.v2.LinkQueryStorable;
import org.jdownloader.api.downloads.v2.PackageQueryStorable;
import org.jdownloader.myjdownloader.client.bindings.AbstractNodeStorable;

public class ChannelCollector {
    private volatile long interval = 1000L;
    private volatile long lastPush;
    private final Subscriber subscriber;
    private HashSet<String> activeSubscriptions;
    private final LinkQueryStorable linkQuery;
    private final PackageQueryStorable pkgQuery;
    private HashMap<Long, DownloadLinkAPIStorableV2> compareMap = new HashMap();
    private final HashMap<String, String> dupeCache = new HashMap();
    private final HashMap<Long, FilePackageAPIStorableV2> comparePackageMap = new HashMap();

    public ChannelCollector(Subscriber s) {
        this.subscriber = s;
        this.linkQuery = new LinkQueryStorable();
        this.linkQuery.setBytesLoaded(true);
        this.linkQuery.setBytesTotal(true);
        this.linkQuery.setEta(true);
        this.linkQuery.setSpeed(true);
        this.linkQuery.setStatus(true);
        this.pkgQuery = new PackageQueryStorable();
        this.pkgQuery.setBytesLoaded(true);
        this.pkgQuery.setBytesTotal(true);
        this.pkgQuery.setEta(true);
        this.pkgQuery.setSpeed(true);
        this.pkgQuery.setStatus(true);
    }

    public void setLastPush(long lastPush) {
        this.lastPush = lastPush;
    }

    public boolean isAlive() {
        return this.subscriber.isAlive();
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public void updateSubscriptions() {
        HashSet<String> eventIds = new HashSet<String>();
        for (String id : DownloadControllerEventPublisher.INTERVAL_EVENT_ID_LIST) {
            if (!this.subscriber.isSubscribed("downloads." + id)) continue;
            eventIds.add(id);
        }
        this.activeSubscriptions = eventIds;
    }

    public boolean hasIntervalSubscriptions() {
        return this.isAlive() && this.activeSubscriptions != null && this.activeSubscriptions.size() > 0;
    }

    public long getLastPush() {
        return this.lastPush;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Object> getDiff(DownloadLink dl) {
        ChannelCollector channelCollector = this;
        synchronized (channelCollector) {
            DownloadLinkAPIStorableV2 newData = DownloadsAPIV2Impl.toStorable(this.linkQuery, dl, (Object)this);
            DownloadLinkAPIStorableV2 oldData = this.compareMap.get(dl.getUniqueID().getID());
            this.compareMap.put(dl.getUniqueID().getID(), newData);
            HashMap<String, Object> dif = new HashMap<String, Object>();
            if (oldData == null || newData.getBytesLoaded() != oldData.getBytesLoaded()) {
                dif.put("bytesLoaded", newData.getBytesLoaded());
            }
            if (oldData == null || newData.getBytesTotal() != oldData.getBytesTotal()) {
                dif.put("bytesTotal", newData.getBytesTotal());
            }
            if (oldData == null || newData.getEta() != oldData.getEta()) {
                dif.put("eta", newData.getEta());
            }
            if (oldData == null || newData.getSpeed() != oldData.getSpeed()) {
                dif.put("speed", newData.getSpeed());
            }
            if (oldData == null || !StringUtils.equals((String)newData.getStatus(), (String)oldData.getStatus())) {
                dif.put("status", newData.getStatus());
            }
            if (oldData == null || !StringUtils.equals((String)newData.getStatusIconKey(), (String)oldData.getStatusIconKey())) {
                dif.put("statusIconKey", newData.getStatusIconKey());
            }
            return dif;
        }
    }

    public Subscriber getSubscriber() {
        return this.subscriber;
    }

    public void updateBase(DownloadLink dl) {
        this.compareMap.put(dl.getUniqueID().getID(), DownloadsAPIV2Impl.toStorable(this.linkQuery, dl, (Object)this));
    }

    protected void cleanUp(HashSet<DownloadLink> linksToProcess) {
        Long key;
        HashSet<Long> idMap = new HashSet<Long>();
        HashSet<Long> idParentMap = new HashSet<Long>();
        for (DownloadLink dl : linksToProcess) {
            idMap.add(dl.getUniqueID().getID());
            FilePackage filePackage = dl.getParentNode();
            if (filePackage == null) continue;
            idParentMap.add(filePackage.getUniqueID().getID());
        }
        ArrayList<Long> toRemove = new ArrayList<Long>();
        for (Map.Entry<Long, DownloadLinkAPIStorableV2> entry : this.compareMap.entrySet()) {
            key = entry.getKey();
            if (key != null && idMap.contains(key)) continue;
            toRemove.add(key);
        }
        for (Long l : toRemove) {
            this.compareMap.remove(l);
        }
        toRemove.clear();
        for (Map.Entry<Long, AbstractNodeStorable> entry : this.comparePackageMap.entrySet()) {
            key = entry.getKey();
            if (key != null && idParentMap.contains(key)) continue;
            toRemove.add(key);
        }
        for (Long l : toRemove) {
            this.comparePackageMap.remove(l);
        }
    }

    public synchronized boolean updateDupeCache(String string, HashMap<String, Object> copy) {
        String id;
        String string2 = id = copy == null ? null : Hash.getMD5((String)JSonStorage.serializeToJson(copy));
        if (StringUtils.equals((String)id, (String)this.dupeCache.get(string))) {
            return false;
        }
        this.dupeCache.put(string, id);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Object> getDiff(FilePackage p) {
        ChannelCollector channelCollector = this;
        synchronized (channelCollector) {
            FilePackageAPIStorableV2 newData = DownloadsAPIV2Impl.toStorable(this.pkgQuery, p, (Object)this);
            FilePackageAPIStorableV2 oldData = this.comparePackageMap.get(p.getUniqueID().getID());
            this.comparePackageMap.put(p.getUniqueID().getID(), newData);
            HashMap<String, Object> dif = new HashMap<String, Object>();
            if (oldData == null || newData.getBytesLoaded() != oldData.getBytesLoaded()) {
                dif.put("bytesLoaded", newData.getBytesLoaded());
            }
            if (oldData == null || newData.getBytesTotal() != oldData.getBytesTotal()) {
                dif.put("bytesTotal", newData.getBytesTotal());
            }
            if (oldData == null || newData.getEta() != oldData.getEta()) {
                dif.put("eta", newData.getEta());
            }
            if (oldData == null || newData.getSpeed() != oldData.getSpeed()) {
                dif.put("speed", newData.getSpeed());
            }
            if (oldData == null || !StringUtils.equals((String)newData.getStatus(), (String)oldData.getStatus())) {
                dif.put("status", newData.getStatus());
            }
            if (oldData == null || !StringUtils.equals((String)newData.getStatusIconKey(), (String)oldData.getStatusIconKey())) {
                dif.put("statusIconKey", newData.getStatusIconKey());
            }
            return dif;
        }
    }
}

