/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.downloads;

import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.downloadcontroller.DownloadLinkCandidate;
import jd.controlling.downloadcontroller.DownloadLinkCandidateResult;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.downloadcontroller.DownloadWatchDogProperty;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.controlling.downloadcontroller.event.DownloadWatchdogListener;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.packagecontroller.PackageController;
import jd.plugins.DownloadLink;
import jd.plugins.DownloadLinkProperty;
import jd.plugins.FilePackage;
import jd.plugins.FilePackageProperty;
import jd.plugins.FilePackageView;
import org.appwork.exceptions.WTFException;
import org.appwork.remoteapi.events.EventObject;
import org.appwork.remoteapi.events.EventPublisher;
import org.appwork.remoteapi.events.EventsAPI;
import org.appwork.remoteapi.events.RemoteAPIEventsSender;
import org.appwork.remoteapi.events.SimpleEventObject;
import org.appwork.remoteapi.events.Subscriber;
import org.appwork.remoteapi.events.local.LocalEventsAPIListener;
import org.appwork.remoteapi.exceptions.BadParameterException;
import org.appwork.storage.SimpleMapper;
import org.appwork.storage.TypeRef;
import org.appwork.utils.event.queue.Queue;
import org.appwork.utils.event.queue.QueueAction;
import org.jdownloader.api.RemoteAPIController;
import org.jdownloader.api.downloads.ChannelCollector;
import org.jdownloader.api.downloads.DownloadControllerEventPublisherInterface;
import org.jdownloader.api.downloads.DownloadListDiffStorable;
import org.jdownloader.api.downloads.v2.DownloadLinkAPIStorableV2;
import org.jdownloader.api.downloads.v2.DownloadsAPIV2Impl;
import org.jdownloader.api.downloads.v2.FilePackageAPIStorableV2;
import org.jdownloader.api.downloads.v2.LinkQueryStorable;
import org.jdownloader.api.downloads.v2.PackageQueryStorable;
import org.jdownloader.controlling.UniqueAlltimeID;
import org.jdownloader.controlling.download.DownloadControllerListener;
import org.jdownloader.extensions.extraction.ExtractionStatus;
import org.jdownloader.myjdownloader.client.bindings.PriorityStorable;
import org.jdownloader.myjdownloader.client.bindings.interfaces.DownloadsEventsInterface;
import org.jdownloader.plugins.FinalLinkState;

public class DownloadControllerEventPublisher
implements EventPublisher,
DownloadControllerListener,
LocalEventsAPIListener,
DownloadControllerEventPublisherInterface,
DownloadWatchdogListener {
    private final CopyOnWriteArraySet<RemoteAPIEventsSender> remoteEventSenders = new CopyOnWriteArraySet();
    private static final List<String> EVENT_ID_LIST;
    private final CopyOnWriteArraySet<DownloadLink> linksWithPluginProgress = new CopyOnWriteArraySet();
    private final CopyOnWriteArrayList<ChannelCollector> collectors = new CopyOnWriteArrayList();
    protected static final List<String> INTERVAL_EVENT_ID_LIST;
    private ScheduledExecutorService executer;
    private final EventsAPI eventsAPI;
    private final AtomicLong backEndChangeID = new AtomicLong(-1L);
    private final AtomicLong contentChangesCounter = new AtomicLong(-1L);
    private final Queue queue = new Queue("DownloadControllerEventPublisher"){

        public void killQueue() {
        }
    };
    private static final String LINK_UPDATE_availability;
    private static final String LINK_UPDATE_comment;
    private static final String LINK_UPDATE_url;
    private static final String LINK_UPDATE_bytesTotal;
    private static final String LINK_UPDATE_priority;
    private static final String LINK_UPDATE_name;
    private static final String LINK_UPDATE_extractionStatus;
    private static final String LINK_UPDATE_status;
    private static final String LINK_UPDATE_skipped;
    private static final String LINK_UPDATE_finished;
    private static final String LINK_UPDATE_reset;
    private static final String PACKAGE_UPDATE_reset;
    private static final String LINK_UPDATE_resume;
    private static final String PACKAGE_UPDATE_resume;
    private static final String LINK_UPDATE_running;
    private static final String PACKAGE_UPDATE_running;
    private static final String PACKAGE_UPDATE_status;
    private static final String LINK_UPDATE_enabled;
    private static final String PACKAGE_UPDATE_enabled;
    private static final String PACKAGE_UPDATE_name;
    private static final String PACKAGE_UPDATE_priority;
    private final WeakHashMap<Subscriber, List<EventObject>> buffer = new WeakHashMap();

    public DownloadControllerEventPublisher(EventsAPI eventsapi) {
        RemoteAPIController.validateInterfaces(DownloadControllerEventPublisherInterface.class, DownloadsEventsInterface.class);
        this.eventsAPI = eventsapi;
        eventsapi.getLocalEventSender().addListener((EventListener)this);
    }

    public String[] getPublisherEventIDs() {
        return EVENT_ID_LIST.toArray(new String[0]);
    }

    public String getPublisherName() {
        return "downloads";
    }

    public synchronized void register(RemoteAPIEventsSender eventsAPI) {
        boolean wasEmpty = this.remoteEventSenders.isEmpty();
        this.remoteEventSenders.add(eventsAPI);
        if (wasEmpty && !this.remoteEventSenders.isEmpty()) {
            DownloadController.getInstance().addListener(this, true);
            DownloadWatchDog.getInstance().getEventSender().addListener(this, true);
        }
    }

    public synchronized void unregister(RemoteAPIEventsSender eventsAPI) {
        this.remoteEventSenders.remove(eventsAPI);
        if (this.remoteEventSenders.isEmpty()) {
            DownloadController.getInstance().removeListener(this);
            DownloadWatchDog.getInstance().getEventSender().removeListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDownloadControllerAddedPackage(FilePackage pkg) {
        boolean flush = false;
        if (this.hasSubscriptionFor(BASIC_EVENT.ADD_CONTENT.name())) {
            this.fire(BASIC_EVENT.ADD_CONTENT.name(), null, BASIC_EVENT.ADD_CONTENT.name());
            flush = true;
        }
        if (this.hasSubscriptionFor(BASIC_EVENT.ADD_PACKAGE.name())) {
            HashMap<String, Long> dls = new HashMap<String, Long>();
            long afterUuid = -1L;
            PackageController<FilePackage, DownloadLink> controller = pkg.getControlledBy();
            if (controller != null) {
                boolean readL = controller.readLock();
                try {
                    FilePackage fp;
                    int index = controller.indexOf(pkg);
                    if (index > 0 && (fp = controller.getPackages().get(index - 1)) != null) {
                        afterUuid = fp.getUniqueID().getID();
                    }
                }
                finally {
                    controller.readUnlock(readL);
                }
            }
            dls.put("uuid", pkg.getUniqueID().getID());
            dls.put("afterUuid", afterUuid);
            this.fire(BASIC_EVENT.ADD_PACKAGE.name(), dls, BASIC_EVENT.ADD_PACKAGE.name() + "." + pkg.getUniqueID().getID());
            flush = true;
        }
        if (flush) {
            this.flushBuffer();
        }
    }

    @Override
    public void onDownloadControllerStructureRefresh(FilePackage pkg) {
        if (this.hasControllerChanges() && this.hasSubscriptionFor(BASIC_EVENT.REFRESH_STRUCTURE.name())) {
            this.fire(BASIC_EVENT.REFRESH_STRUCTURE.name(), null, BASIC_EVENT.REFRESH_STRUCTURE.name());
            this.flushBuffer();
        }
    }

    @Override
    public void onDownloadControllerStructureRefresh() {
        if (this.hasControllerChanges() && this.hasSubscriptionFor(BASIC_EVENT.REFRESH_STRUCTURE.name())) {
            this.fire(BASIC_EVENT.REFRESH_STRUCTURE.name(), null, BASIC_EVENT.REFRESH_STRUCTURE.name());
            this.flushBuffer();
        }
    }

    private final boolean hasControllerChanges() {
        long newChange = DownloadController.getInstance().getPackageControllerChanges();
        return this.backEndChangeID.getAndSet(newChange) != newChange;
    }

    private final boolean hasContentChanges() {
        long newChange = DownloadController.getInstance().getContentChanges();
        return this.contentChangesCounter.getAndSet(newChange) != newChange;
    }

    @Override
    public void onDownloadControllerStructureRefresh(AbstractNode node, Object param) {
        if (this.hasControllerChanges() && this.hasSubscriptionFor(BASIC_EVENT.REFRESH_STRUCTURE.name())) {
            this.fire(BASIC_EVENT.REFRESH_STRUCTURE.name(), null, BASIC_EVENT.REFRESH_STRUCTURE.name());
            this.flushBuffer();
        }
    }

    @Override
    public void onDownloadControllerRemovedPackage(FilePackage pkg) {
        boolean flush = false;
        if (this.hasSubscriptionFor(BASIC_EVENT.REMOVE_CONTENT.name())) {
            this.fire(BASIC_EVENT.REMOVE_CONTENT.name(), null, null);
            flush = true;
        }
        if (this.hasSubscriptionFor(BASIC_EVENT.REMOVE_PACKAGE.name())) {
            HashMap<String, Long> dls = new HashMap<String, Long>();
            dls.put("uuid", pkg.getUniqueID().getID());
            this.fire(BASIC_EVENT.REMOVE_PACKAGE.name(), dls, BASIC_EVENT.REMOVE_PACKAGE.name() + "." + pkg.getUniqueID().getID());
            flush = true;
        }
        if (flush) {
            this.flushBuffer();
        }
    }

    @Override
    public void onDownloadControllerRemovedLinklist(List<DownloadLink> list) {
        boolean flush = false;
        if (this.hasSubscriptionFor(BASIC_EVENT.REMOVE_CONTENT.name())) {
            this.fire(BASIC_EVENT.REMOVE_CONTENT.name(), null, null);
            flush = true;
        }
        if (this.hasSubscriptionFor(BASIC_EVENT.REMOVE_LINK.name())) {
            long[] ret = new long[list.size()];
            int index = 0;
            for (DownloadLink link : list) {
                ret[index++] = link.getUniqueID().getID();
            }
            HashMap<String, long[]> dls = new HashMap<String, long[]>();
            dls.put("uuids", ret);
            this.fire(BASIC_EVENT.REMOVE_LINK.name(), dls, null);
            flush = true;
        }
        if (flush) {
            this.flushBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDownloadControllerUpdatedData(DownloadLink dl, DownloadLinkProperty property) {
        block40: {
            boolean flush;
            block41: {
                if (!this.hasListener()) break block40;
                flush = false;
                if (property == null) break block41;
                FilePackage parent = dl.getParentNode();
                switch (property.getProperty()) {
                    case ARCHIVE: {
                        break;
                    }
                    case ARCHIVE_ID: {
                        break;
                    }
                    case AVAILABILITY: {
                        if (!this.hasSubscriptionFor(LINK_UPDATE_availability)) break;
                        HashMap<String, Object> dls = new HashMap<String, Object>();
                        dls.put("uuid", dl.getUniqueID().getID());
                        dls.put("availability", property.getValue());
                        this.fire(LINK_UPDATE_availability, dls, LINK_UPDATE_availability + "." + dl.getUniqueID().getID());
                        flush = true;
                        break;
                    }
                    case CHUNKS: {
                        break;
                    }
                    case COMMENT: {
                        if (!this.hasSubscriptionFor(LINK_UPDATE_comment)) break;
                        HashMap<String, Object> dls = new HashMap<String, Object>();
                        dls.put("uuid", dl.getUniqueID().getID());
                        dls.put("comment", property.getValue());
                        this.fire(LINK_UPDATE_comment, dls, LINK_UPDATE_comment + "." + dl.getUniqueID().getID());
                        flush = true;
                        break;
                    }
                    case URL_CONTAINER: 
                    case URL_ORIGIN: 
                    case URL_REFERRER: 
                    case URL_CONTENT: {
                        if (!this.hasSubscriptionFor(LINK_UPDATE_url)) break;
                        HashMap<String, Object> dls = new HashMap<String, Object>();
                        dls.put("uuid", dl.getUniqueID().getID());
                        dls.put("url", dl.getView().getDisplayUrl());
                        this.fire(LINK_UPDATE_url, dls, LINK_UPDATE_url + "." + dl.getUniqueID().getID());
                        flush = true;
                        break;
                    }
                    case CONDITIONAL_SKIPPED: {
                        this.pushStatus(dl);
                        break;
                    }
                    case DOWNLOAD_PASSWORD: {
                        break;
                    }
                    case DOWNLOADSIZE: 
                    case DOWNLOADSIZE_VERIFIED: {
                        if (!this.hasSubscriptionFor(LINK_UPDATE_bytesTotal)) break;
                        HashMap<String, Object> dls = new HashMap<String, Object>();
                        dls.put("uuid", dl.getUniqueID().getID());
                        dls.put("bytesTotal", property.getValue());
                        this.fire(LINK_UPDATE_bytesTotal, dls, LINK_UPDATE_bytesTotal + "." + dl.getUniqueID().getID());
                        flush = true;
                        break;
                    }
                    case DOWNLOAD_CONTROLLER: {
                        HashMap<String, Constable> dls;
                        if (this.hasSubscriptionFor(LINK_UPDATE_running)) {
                            dls = new HashMap<String, Constable>();
                            dls.put("uuid", Long.valueOf(dl.getUniqueID().getID()));
                            dls.put("running", Boolean.valueOf(property.getValue() != null));
                            this.fire(LINK_UPDATE_running, dls, LINK_UPDATE_running + "." + dl.getUniqueID().getID());
                            flush = true;
                        }
                        if (!this.hasSubscriptionFor(PACKAGE_UPDATE_running)) break;
                        dls = new HashMap();
                        dls.put("uuid", Long.valueOf(parent.getUniqueID().getID()));
                        dls.put("running", Boolean.valueOf(property.getValue() != null || DownloadWatchDog.getInstance().hasRunningDownloads(parent)));
                        this.fire(PACKAGE_UPDATE_running, dls, PACKAGE_UPDATE_running + "." + parent.getUniqueID().getID());
                        flush = true;
                        break;
                    }
                    case ENABLED: {
                        HashMap<String, Constable> dls;
                        if (this.hasSubscriptionFor(LINK_UPDATE_enabled)) {
                            dls = new HashMap<String, Constable>();
                            dls.put("uuid", Long.valueOf(dl.getUniqueID().getID()));
                            dls.put("enabled", Boolean.valueOf(dl.isEnabled()));
                            this.fire(LINK_UPDATE_enabled, dls, LINK_UPDATE_enabled + "." + dl.getUniqueID().getID());
                            flush = true;
                        }
                        if (!this.hasSubscriptionFor(PACKAGE_UPDATE_enabled)) break;
                        dls = new HashMap();
                        dls.put("uuid", Long.valueOf(parent.getUniqueID().getID()));
                        boolean enabled = dl.isEnabled();
                        if (!enabled) {
                            boolean readL = parent.getModifyLock().readLock();
                            try {
                                for (DownloadLink link : parent.getChildren()) {
                                    if (!link.isEnabled()) continue;
                                    enabled = true;
                                    break;
                                }
                            }
                            finally {
                                parent.getModifyLock().readUnlock(readL);
                            }
                        }
                        dls.put("enabled", Boolean.valueOf(enabled));
                        this.fire(PACKAGE_UPDATE_enabled, dls, PACKAGE_UPDATE_enabled + "." + parent.getUniqueID().getID());
                        flush = true;
                        break;
                    }
                    case EXTRACTION_STATUS: {
                        if (!this.hasSubscriptionFor(LINK_UPDATE_extractionStatus)) break;
                        HashMap<String, Object> dls = new HashMap<String, Object>();
                        dls.put("uuid", dl.getUniqueID().getID());
                        ExtractionStatus es = dl.getExtractionStatus();
                        dls.put("extractionStatus", es == null ? null : es.toString());
                        this.fire(LINK_UPDATE_extractionStatus, dls, LINK_UPDATE_extractionStatus + "." + dl.getUniqueID().getID());
                        flush = true;
                        this.pushStatus(dl);
                        break;
                    }
                    case FINAL_STATE: {
                        if (!this.hasSubscriptionFor(LINK_UPDATE_finished)) break;
                        HashMap<String, Constable> dls = new HashMap<String, Constable>();
                        dls.put("uuid", Long.valueOf(dl.getUniqueID().getID()));
                        dls.put("finished", Boolean.valueOf(FinalLinkState.CheckFinished(dl.getFinalLinkState())));
                        this.fire(LINK_UPDATE_finished, dls, LINK_UPDATE_finished + "." + dl.getUniqueID().getID());
                        this.pushStatus(dl);
                        break;
                    }
                    case LINKSTATUS: {
                        if (!this.hasSubscriptionFor(LINK_UPDATE_status)) break;
                        HashMap<String, Object> dls = new HashMap<String, Object>();
                        dls.put("uuid", dl.getUniqueID().getID());
                        dls.put("status", property.getValue());
                        this.fire(LINK_UPDATE_status, dls, LINK_UPDATE_status + "." + dl.getUniqueID().getID());
                        flush = true;
                        break;
                    }
                    case NAME: {
                        if (!this.hasSubscriptionFor(LINK_UPDATE_name)) break;
                        HashMap<String, Object> dls = new HashMap<String, Object>();
                        dls.put("uuid", dl.getUniqueID().getID());
                        dls.put("name", dl.getView().getDisplayName());
                        this.fire(LINK_UPDATE_name, dls, LINK_UPDATE_name + "." + dl.getUniqueID().getID());
                        flush = true;
                        break;
                    }
                    case PLUGIN_PROGRESS: {
                        if (dl.getPluginProgress() == null) {
                            if (!this.linksWithPluginProgress.remove(dl)) break;
                            this.pushDiff(dl);
                            this.cleanup(dl);
                            break;
                        }
                        if (!this.linksWithPluginProgress.add(dl)) break;
                        this.queue.add((QueueAction)new QueueAction<Void, RuntimeException>(){

                            protected Void run() throws RuntimeException {
                                DownloadControllerEventPublisher.this.updateExecuter(true);
                                return null;
                            }
                        });
                        break;
                    }
                    case PRIORITY: {
                        if (!this.hasSubscriptionFor(LINK_UPDATE_priority)) break;
                        HashMap<String, Object> dls = new HashMap<String, Object>();
                        dls.put("uuid", dl.getUniqueID().getID());
                        dls.put("priority", (Object)PriorityStorable.get(dl.getPriorityEnum().name()));
                        this.fire(LINK_UPDATE_priority, dls, LINK_UPDATE_priority + "." + dl.getUniqueID().getID());
                        flush = true;
                        break;
                    }
                    case RESET: {
                        HashMap<String, Object> dls;
                        if (this.hasSubscriptionFor(LINK_UPDATE_reset)) {
                            dls = new HashMap<String, Object>();
                            dls.put("uuid", dl.getUniqueID().getID());
                            dls.put("reset", "true");
                            this.fire(LINK_UPDATE_reset, dls, LINK_UPDATE_reset + "." + dl.getUniqueID().getID());
                            flush = true;
                        }
                        if (!this.hasSubscriptionFor(PACKAGE_UPDATE_reset)) break;
                        dls = new HashMap();
                        dls.put("uuid", dl.getUniqueID().getID());
                        dls.put("reset", "true");
                        this.fire(PACKAGE_UPDATE_reset, dls, PACKAGE_UPDATE_reset + "." + parent.getUniqueID().getID());
                        flush = true;
                        break;
                    }
                    case RESUME: {
                        HashMap<String, Object> dls;
                        if (this.hasSubscriptionFor(LINK_UPDATE_resume)) {
                            dls = new HashMap<String, Object>();
                            dls.put("uuid", dl.getUniqueID().getID());
                            dls.put("resume", "true");
                            this.fire(LINK_UPDATE_resume, dls, LINK_UPDATE_resume + "." + dl.getUniqueID().getID());
                            flush = true;
                        }
                        if (!this.hasSubscriptionFor(PACKAGE_UPDATE_reset)) break;
                        dls = new HashMap();
                        dls.put("uuid", dl.getUniqueID().getID());
                        dls.put("resume", "true");
                        this.fire(PACKAGE_UPDATE_resume, dls, PACKAGE_UPDATE_resume + "." + parent.getUniqueID().getID());
                        flush = true;
                        break;
                    }
                    case RESUMABLE: {
                        break;
                    }
                    case SKIPPED: {
                        if (!this.hasSubscriptionFor(LINK_UPDATE_skipped)) break;
                        HashMap<String, Object> dls = new HashMap<String, Object>();
                        dls.put("uuid", dl.getUniqueID().getID());
                        dls.put("skipped", property.getValue() != null);
                        if (property.getValue() != null) {
                            dls.put("skipreason", property.getValue().toString());
                        }
                        this.fire(LINK_UPDATE_skipped, dls, LINK_UPDATE_skipped + "." + dl.getUniqueID().getID());
                        flush = true;
                        this.pushStatus(dl);
                        break;
                    }
                    case SPEED_LIMIT: {
                        break;
                    }
                    case URL_PROTECTION: {
                        break;
                    }
                    case VARIANT: {
                        break;
                    }
                    case VARIANTS: {
                        break;
                    }
                }
            }
            if (this.hasContentChanges() && this.hasSubscriptionFor(BASIC_EVENT.REFRESH_CONTENT.name())) {
                this.fire(BASIC_EVENT.REFRESH_CONTENT.name(), null, BASIC_EVENT.REFRESH_CONTENT.name());
                flush = true;
            }
            if (flush) {
                this.flushBuffer();
            }
        }
    }

    private void pushStatus(DownloadLink dl) {
        if (this.hasSubscriptionFor(LINK_UPDATE_status)) {
            HashMap<String, Object> dls = new HashMap<String, Object>();
            dls.put("uuid", dl.getUniqueID().getID());
            RemoteAPIController.getInstance().getDownloadsAPIV2();
            DownloadLinkAPIStorableV2 dlss = DownloadsAPIV2Impl.setStatus(new DownloadLinkAPIStorableV2(), dl, this);
            dls.put("statusIconKey", dlss.getStatusIconKey());
            dls.put("status", dlss.getStatus());
            this.fire(LINK_UPDATE_status, dls, LINK_UPDATE_status + "." + dl.getUniqueID().getID());
        }
        if (this.hasSubscriptionFor(PACKAGE_UPDATE_status)) {
            FilePackage fp = dl.getFilePackage();
            FilePackageView fpView = new FilePackageView(fp);
            fpView.aggregate();
            RemoteAPIController.getInstance().getDownloadsAPIV2();
            FilePackageAPIStorableV2 dpss = DownloadsAPIV2Impl.setStatus(new FilePackageAPIStorableV2(), fpView);
            HashMap<String, Object> dls = new HashMap<String, Object>();
            dls.put("uuid", fp.getUniqueID().getID());
            dls.put("statusIconKey", dpss.getStatusIconKey());
            dls.put("status", dpss.getStatus());
            this.fire(PACKAGE_UPDATE_status, dls, PACKAGE_UPDATE_status + "." + dl.getFilePackage().getUniqueID().getID());
        }
    }

    private void fire(final String eventID, final Object dls, final String collapseKey) {
        this.queue.add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                SimpleEventObject eventObject = new SimpleEventObject((EventPublisher)DownloadControllerEventPublisher.this, eventID, dls, collapseKey);
                for (ChannelCollector collector : DownloadControllerEventPublisher.this.collectors) {
                    DownloadControllerEventPublisher.this.pushToBuffer(collector, (EventObject)eventObject);
                }
                return null;
            }
        });
    }

    private final boolean hasListener() {
        return this.collectors.size() > 0;
    }

    private final boolean hasSubscriptionFor(String event) {
        if (this.collectors.size() > 0) {
            String eventID = this.getPublisherName().concat(".").concat(event);
            for (ChannelCollector collector : this.collectors) {
                if (!collector.getSubscriber().isSubscribed(eventID)) continue;
                return true;
            }
        }
        return false;
    }

    private void fire(BASIC_EVENT eventType, String eventID, Object dls, UniqueAlltimeID uniqueAlltimeID) {
        if (uniqueAlltimeID != null) {
            this.fire(eventType.name() + "." + eventID, dls, (Object)((Object)eventType) + "." + eventID + uniqueAlltimeID.getID());
        } else {
            this.fire(eventType.name() + "." + eventID, dls, null);
        }
    }

    @Override
    public void onDownloadControllerUpdatedData(FilePackage pkg, FilePackageProperty property) {
        if (this.hasListener()) {
            boolean flush = false;
            if (property != null) {
                switch (property.getProperty()) {
                    case COMMENT: {
                        if (!this.hasSubscriptionFor(BASIC_EVENT.PACKAGE_UPDATE.name())) break;
                        HashMap<String, Object> dls = new HashMap<String, Object>();
                        dls.put("uuid", pkg.getUniqueID().getID());
                        dls.put("comment", pkg.getComment());
                        this.fire(BASIC_EVENT.PACKAGE_UPDATE, FilePackageProperty.Property.COMMENT.name(), dls, pkg.getUniqueID());
                        flush = true;
                        break;
                    }
                    case FOLDER: {
                        break;
                    }
                    case NAME: {
                        if (!this.hasSubscriptionFor(PACKAGE_UPDATE_name)) break;
                        HashMap<String, Object> dls = new HashMap<String, Object>();
                        dls.put("uuid", pkg.getUniqueID().getID());
                        dls.put("name", pkg.getName());
                        this.fire(PACKAGE_UPDATE_name, dls, PACKAGE_UPDATE_name + "." + pkg.getUniqueID().getID());
                        flush = true;
                        break;
                    }
                    case PRIORITY: {
                        if (!this.hasSubscriptionFor(PACKAGE_UPDATE_priority)) break;
                        HashMap<String, Object> dls = new HashMap<String, Object>();
                        dls.put("uuid", pkg.getUniqueID().getID());
                        dls.put("priority", (Object)PriorityStorable.get(pkg.getPriorityEnum().name()));
                        this.fire(PACKAGE_UPDATE_priority, dls, PACKAGE_UPDATE_priority + "." + pkg.getUniqueID().getID());
                        flush = true;
                    }
                }
            }
            if (this.hasSubscriptionFor(BASIC_EVENT.REFRESH_CONTENT.name())) {
                this.fire(BASIC_EVENT.REFRESH_CONTENT.name(), null, BASIC_EVENT.REFRESH_CONTENT.name());
                flush = true;
            }
            if (flush) {
                this.flushBuffer();
            }
        }
    }

    @Override
    public void onDownloadControllerUpdatedData(DownloadLink downloadlink) {
        if (this.hasSubscriptionFor(BASIC_EVENT.REFRESH_CONTENT.name())) {
            this.fire(BASIC_EVENT.REFRESH_CONTENT.name(), null, BASIC_EVENT.REFRESH_CONTENT.name());
            this.flushBuffer();
        }
    }

    @Override
    public void onDownloadControllerUpdatedData(FilePackage pkg) {
        if (this.hasSubscriptionFor(BASIC_EVENT.REFRESH_CONTENT.name())) {
            this.fire(BASIC_EVENT.REFRESH_CONTENT.name(), null, BASIC_EVENT.REFRESH_CONTENT.name());
            this.flushBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateExecuter(boolean b) {
        DownloadControllerEventPublisher downloadControllerEventPublisher = this;
        synchronized (downloadControllerEventPublisher) {
            if (b) {
                if (this.executer == null) {
                    this.executer = Executors.newScheduledThreadPool(1);
                    this.executer.scheduleAtFixedRate(new Runnable(){
                        int terminationRounds = 0;

                        @Override
                        public void run() {
                            boolean kill = true;
                            int events = 0;
                            HashSet<DownloadLink> linksToProcess = null;
                            HashSet<FilePackage> packagesToProcess = null;
                            for (ChannelCollector collector : DownloadControllerEventPublisher.this.collectors) {
                                SimpleEventObject eventObject;
                                HashMap<String, Object> dls;
                                HashMap<String, Object> diff;
                                if (!collector.hasIntervalSubscriptions()) continue;
                                kill = false;
                                if (System.currentTimeMillis() - collector.getLastPush() < collector.getInterval()) continue;
                                collector.setLastPush(System.currentTimeMillis());
                                if (linksToProcess == null) {
                                    linksToProcess = new HashSet<DownloadLink>();
                                    for (SingleDownloadController singleDownloadController : DownloadWatchDog.getInstance().getRunningDownloadLinks()) {
                                        linksToProcess.add(singleDownloadController.getDownloadLink());
                                    }
                                    linksToProcess.addAll(DownloadControllerEventPublisher.this.linksWithPluginProgress);
                                }
                                for (DownloadLink downloadLink : linksToProcess) {
                                    diff = collector.getDiff(downloadLink);
                                    for (Map.Entry<String, Object> entry : diff.entrySet()) {
                                        dls = new HashMap<String, Object>();
                                        dls.put("uuid", downloadLink.getUniqueID().getID());
                                        dls.put(entry.getKey(), entry.getValue());
                                        eventObject = new SimpleEventObject((EventPublisher)DownloadControllerEventPublisher.this, BASIC_EVENT.LINK_UPDATE.name() + "." + entry.getKey(), dls, BASIC_EVENT.LINK_UPDATE.name() + "." + entry.getKey() + "." + downloadLink.getUniqueID().getID());
                                        ArrayList publishTo = new ArrayList();
                                        DownloadControllerEventPublisher.this.pushToBuffer(collector, (EventObject)eventObject);
                                        ++events;
                                    }
                                }
                                if (packagesToProcess == null) {
                                    packagesToProcess = new HashSet<FilePackage>();
                                    for (DownloadLink downloadLink : linksToProcess) {
                                        FilePackage p = downloadLink.getParentNode();
                                        if (p == null) continue;
                                        packagesToProcess.add(p);
                                    }
                                }
                                for (FilePackage filePackage : packagesToProcess) {
                                    diff = collector.getDiff(filePackage);
                                    for (Map.Entry<String, Object> entry : diff.entrySet()) {
                                        dls = new HashMap();
                                        dls.put("uuid", filePackage.getUniqueID().getID());
                                        dls.put(entry.getKey(), entry.getValue());
                                        eventObject = new SimpleEventObject((EventPublisher)DownloadControllerEventPublisher.this, BASIC_EVENT.PACKAGE_UPDATE.name() + "." + entry.getKey(), dls, BASIC_EVENT.LINK_UPDATE.name() + "." + entry.getKey() + "." + filePackage.getUniqueID().getID());
                                        DownloadControllerEventPublisher.this.pushToBuffer(collector, (EventObject)eventObject);
                                        ++events;
                                    }
                                }
                            }
                            if (events > 0) {
                                DownloadControllerEventPublisher.this.flushBuffer();
                            }
                            if (kill) {
                                ++this.terminationRounds;
                                if (this.terminationRounds > 10) {
                                    DownloadControllerEventPublisher.this.updateExecuter(false);
                                    throw new RuntimeException("Exit Executer");
                                }
                            } else {
                                this.terminationRounds = 0;
                            }
                        }
                    }, 0L, 100L, TimeUnit.MILLISECONDS);
                }
            } else if (this.executer != null) {
                this.executer.shutdownNow();
                this.executer = null;
            }
        }
    }

    protected void flushBuffer() {
        this.queue.add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                if (DownloadControllerEventPublisher.this.buffer.size() > 0) {
                    try {
                        for (Map.Entry es : DownloadControllerEventPublisher.this.buffer.entrySet()) {
                            DownloadControllerEventPublisher.this.eventsAPI.push((Subscriber)es.getKey(), (List)es.getValue());
                        }
                    }
                    finally {
                        DownloadControllerEventPublisher.this.buffer.clear();
                    }
                }
                return null;
            }
        });
    }

    private final ChannelCollector getChannelCollector(long channelID) {
        if (this.collectors.size() > 0) {
            for (ChannelCollector collector : this.collectors) {
                if (collector.getSubscriber().getSubscriptionID() != channelID) continue;
                return collector;
            }
        }
        return null;
    }

    public void onEventChannelOpened(Subscriber s) {
        ChannelCollector collector;
        if (s != null && (collector = this.getChannelCollector(s.getSubscriptionID())) == null) {
            collector = new ChannelCollector(s);
            this.collectors.add(collector);
            this.updateChannelCollector(collector);
        }
    }

    public void onEventChannelClosed(Subscriber s) {
        ChannelCollector collector;
        if (s != null && (collector = this.getChannelCollector(s.getSubscriptionID())) != null && this.collectors.remove(collector)) {
            this.updateChannelCollector(collector);
        }
    }

    private void updateChannelCollector(ChannelCollector collector) {
        if (collector != null) {
            collector.updateSubscriptions();
            boolean execute = false;
            for (ChannelCollector collectorEntry : this.collectors) {
                if (!collectorEntry.hasIntervalSubscriptions()) continue;
                execute = true;
                break;
            }
            final boolean finalExecute = execute;
            this.queue.add((QueueAction)new QueueAction<Void, RuntimeException>(){

                protected Void run() throws RuntimeException {
                    DownloadControllerEventPublisher.this.updateExecuter(finalExecute);
                    return null;
                }
            });
        }
    }

    public void onEventsChannelUpdate(Subscriber subscriber) {
        ChannelCollector collector = this.getChannelCollector(subscriber.getSubscriptionID());
        this.updateChannelCollector(collector);
    }

    @Override
    public boolean setStatusEventInterval(long channelID, long interval) {
        ChannelCollector collector = this.getChannelCollector(channelID);
        if (collector != null && collector.isAlive()) {
            collector.setInterval(interval);
            return true;
        }
        return false;
    }

    @Override
    public void onDownloadWatchdogDataUpdate() {
    }

    @Override
    public void onDownloadWatchdogStateIsIdle() {
    }

    @Override
    public void onDownloadWatchdogStateIsPause() {
    }

    @Override
    public void onDownloadWatchdogStateIsRunning() {
    }

    @Override
    public void onDownloadWatchdogStateIsStopped() {
    }

    @Override
    public void onDownloadWatchdogStateIsStopping() {
    }

    @Override
    public void onDownloadControllerStart(SingleDownloadController downloadController, final DownloadLinkCandidate candidate) {
        if (this.hasSubscriptionFor(BASIC_EVENT.LINK_UPDATE.name() + ".running")) {
            DownloadLink dl = candidate.getLink();
            HashMap<String, Constable> dls = new HashMap<String, Constable>();
            dls.put("uuid", Long.valueOf(dl.getUniqueID().getID()));
            dls.put("running", Boolean.valueOf(true));
            this.fire(BASIC_EVENT.LINK_UPDATE.name() + ".running", dls, BASIC_EVENT.LINK_UPDATE.name() + ".running." + dl.getUniqueID().getID());
            this.flushBuffer();
        }
        if (this.collectors.size() > 0) {
            this.queue.add((QueueAction)new QueueAction<Void, RuntimeException>(){

                protected Void run() throws RuntimeException {
                    for (ChannelCollector collector : DownloadControllerEventPublisher.this.collectors) {
                        if (!collector.hasIntervalSubscriptions()) continue;
                        collector.updateBase(candidate.getLink());
                    }
                    DownloadControllerEventPublisher.this.updateExecuter(true);
                    return null;
                }
            });
        }
    }

    @Override
    public void onDownloadControllerStopped(SingleDownloadController downloadController, DownloadLinkCandidate candidate, DownloadLinkCandidateResult result) {
        DownloadLink dl = candidate.getLink();
        if (this.hasSubscriptionFor(BASIC_EVENT.LINK_UPDATE.name() + ".running")) {
            HashMap<String, Constable> dls = new HashMap<String, Constable>();
            dls.put("uuid", Long.valueOf(dl.getUniqueID().getID()));
            dls.put("running", Boolean.valueOf(false));
            this.fire(BASIC_EVENT.LINK_UPDATE.name() + ".running", dls, BASIC_EVENT.LINK_UPDATE.name() + ".running." + dl.getUniqueID().getID());
        }
        if (this.collectors.size() > 0) {
            this.pushDiff(dl);
            this.cleanup(dl);
            this.flushBuffer();
        }
    }

    private void cleanup(DownloadLink dl2) {
        if (this.collectors.size() > 0) {
            this.queue.add((QueueAction)new QueueAction<Void, RuntimeException>(){

                protected Void run() throws RuntimeException {
                    HashSet<DownloadLink> linksToProcess = new HashSet<DownloadLink>();
                    for (SingleDownloadController dl : DownloadWatchDog.getInstance().getRunningDownloadLinks()) {
                        linksToProcess.add(dl.getDownloadLink());
                    }
                    linksToProcess.addAll(DownloadControllerEventPublisher.this.linksWithPluginProgress);
                    for (ChannelCollector collector : DownloadControllerEventPublisher.this.collectors) {
                        collector.cleanUp(linksToProcess);
                    }
                    return null;
                }
            });
        }
    }

    private void pushDiff(final DownloadLink dl) {
        if (this.collectors.size() > 0) {
            final FilePackage parent = dl.getParentNode();
            this.queue.add((QueueAction)new QueueAction<Void, RuntimeException>(){

                protected Void run() throws RuntimeException {
                    for (ChannelCollector collector : DownloadControllerEventPublisher.this.collectors) {
                        SimpleEventObject eventObject;
                        HashMap<String, Object> dls;
                        if (!collector.hasIntervalSubscriptions()) continue;
                        collector.setLastPush(System.currentTimeMillis());
                        HashMap<String, Object> diff = collector.getDiff(dl);
                        for (Map.Entry<String, Object> entry : diff.entrySet()) {
                            dls = new HashMap<String, Object>();
                            dls.put("uuid", dl.getUniqueID().getID());
                            dls.put(entry.getKey(), entry.getValue());
                            eventObject = new SimpleEventObject((EventPublisher)DownloadControllerEventPublisher.this, BASIC_EVENT.LINK_UPDATE.name() + "." + entry.getKey(), dls, BASIC_EVENT.LINK_UPDATE.name() + "." + entry.getKey() + "." + dl.getUniqueID().getID());
                            DownloadControllerEventPublisher.this.pushToBuffer(collector, (EventObject)eventObject);
                        }
                        if (parent == null) continue;
                        diff = collector.getDiff(parent);
                        for (Map.Entry<String, Object> entry : diff.entrySet()) {
                            dls = new HashMap();
                            dls.put("uuid", parent.getUniqueID().getID());
                            dls.put(entry.getKey(), entry.getValue());
                            eventObject = new SimpleEventObject((EventPublisher)DownloadControllerEventPublisher.this, BASIC_EVENT.PACKAGE_UPDATE.name() + "." + entry.getKey(), dls, BASIC_EVENT.LINK_UPDATE.name() + "." + entry.getKey() + "." + parent.getUniqueID().getID());
                            DownloadControllerEventPublisher.this.pushToBuffer(collector, (EventObject)eventObject);
                        }
                    }
                    return null;
                }
            });
        }
    }

    private void pushToBuffer(final ChannelCollector collector, final EventObject eventObject) {
        if (collector != null) {
            this.queue.add((QueueAction)new QueueAction<Void, RuntimeException>(){

                protected Void run() throws RuntimeException {
                    ArrayList<EventObject> lst;
                    Object dls = eventObject.getEventdata();
                    if (dls != null && dls instanceof HashMap) {
                        HashMap<String, Object> copy = new HashMap<String, Object>((HashMap)dls);
                        if (!collector.updateDupeCache(eventObject.getEventid() + "." + copy.remove("uuid"), copy)) {
                            return null;
                        }
                    }
                    if ((lst = (ArrayList<EventObject>)DownloadControllerEventPublisher.this.buffer.get(collector.getSubscriber())) == null) {
                        lst = new ArrayList<EventObject>();
                        DownloadControllerEventPublisher.this.buffer.put(collector.getSubscriber(), lst);
                    }
                    lst.add(eventObject);
                    return null;
                }
            });
        }
    }

    @Override
    public void onDownloadWatchDogPropertyChange(DownloadWatchDogProperty propertyChange) {
    }

    @Override
    public DownloadListDiffStorable queryLinks(LinkQueryStorable queryParams, int diffID) throws BadParameterException {
        throw new WTFException("Not Implemented");
    }

    static {
        INTERVAL_EVENT_ID_LIST = new ArrayList<String>();
        EVENT_ID_LIST = new ArrayList<String>();
        for (BASIC_EVENT t : BASIC_EVENT.values()) {
            EVENT_ID_LIST.add(t.name());
        }
        HashMap map = (HashMap)new SimpleMapper().convert((Object)new LinkQueryStorableDummy(), TypeRef.HASHMAP);
        for (Map.Entry es : map.entrySet()) {
            EVENT_ID_LIST.add(BASIC_EVENT.LINK_UPDATE.name() + "." + (String)es.getKey());
        }
        map = (HashMap)new SimpleMapper().convert((Object)new PackageQueryStorableDummy(), TypeRef.HASHMAP);
        for (Map.Entry es : map.entrySet()) {
            EVENT_ID_LIST.add(BASIC_EVENT.PACKAGE_UPDATE.name() + "." + (String)es.getKey());
        }
        INTERVAL_EVENT_ID_LIST.add(BASIC_EVENT.LINK_UPDATE.name() + ".speed");
        INTERVAL_EVENT_ID_LIST.add(BASIC_EVENT.LINK_UPDATE.name() + ".bytesLoaded");
        INTERVAL_EVENT_ID_LIST.add(BASIC_EVENT.LINK_UPDATE.name() + ".eta");
        INTERVAL_EVENT_ID_LIST.add(BASIC_EVENT.LINK_UPDATE.name() + ".bytesTotal");
        INTERVAL_EVENT_ID_LIST.add(BASIC_EVENT.LINK_UPDATE.name() + ".status");
        INTERVAL_EVENT_ID_LIST.add(BASIC_EVENT.PACKAGE_UPDATE.name() + ".speed");
        INTERVAL_EVENT_ID_LIST.add(BASIC_EVENT.PACKAGE_UPDATE.name() + ".bytesLoaded");
        INTERVAL_EVENT_ID_LIST.add(BASIC_EVENT.PACKAGE_UPDATE.name() + ".eta");
        INTERVAL_EVENT_ID_LIST.add(BASIC_EVENT.PACKAGE_UPDATE.name() + ".bytesTotal");
        INTERVAL_EVENT_ID_LIST.add(BASIC_EVENT.PACKAGE_UPDATE.name() + ".status");
        LINK_UPDATE_availability = BASIC_EVENT.LINK_UPDATE.name() + ".availability";
        LINK_UPDATE_comment = BASIC_EVENT.LINK_UPDATE.name() + ".comment";
        LINK_UPDATE_url = BASIC_EVENT.LINK_UPDATE.name() + ".url";
        LINK_UPDATE_bytesTotal = BASIC_EVENT.LINK_UPDATE.name() + ".bytesTotal";
        LINK_UPDATE_priority = BASIC_EVENT.LINK_UPDATE.name() + ".priority";
        LINK_UPDATE_name = BASIC_EVENT.LINK_UPDATE.name() + ".name";
        LINK_UPDATE_extractionStatus = BASIC_EVENT.LINK_UPDATE.name() + ".extractionStatus";
        LINK_UPDATE_status = BASIC_EVENT.LINK_UPDATE.name() + ".status";
        LINK_UPDATE_skipped = BASIC_EVENT.LINK_UPDATE.name() + ".skipped";
        LINK_UPDATE_finished = BASIC_EVENT.LINK_UPDATE.name() + ".finished";
        LINK_UPDATE_reset = BASIC_EVENT.LINK_UPDATE.name() + ".reset";
        PACKAGE_UPDATE_reset = BASIC_EVENT.PACKAGE_UPDATE.name() + ".reset";
        LINK_UPDATE_resume = BASIC_EVENT.LINK_UPDATE.name() + ".resume";
        PACKAGE_UPDATE_resume = BASIC_EVENT.PACKAGE_UPDATE.name() + ".resume";
        LINK_UPDATE_running = BASIC_EVENT.LINK_UPDATE.name() + ".running";
        PACKAGE_UPDATE_running = BASIC_EVENT.PACKAGE_UPDATE.name() + ".running";
        PACKAGE_UPDATE_status = BASIC_EVENT.PACKAGE_UPDATE.name() + ".status";
        LINK_UPDATE_enabled = BASIC_EVENT.LINK_UPDATE.name() + ".enabled";
        PACKAGE_UPDATE_enabled = BASIC_EVENT.PACKAGE_UPDATE.name() + ".enabled";
        PACKAGE_UPDATE_name = BASIC_EVENT.PACKAGE_UPDATE.name() + ".name";
        PACKAGE_UPDATE_priority = BASIC_EVENT.PACKAGE_UPDATE.name() + ".priority";
    }

    public static class LinkQueryStorableDummy
    extends LinkQueryStorable {
        @Override
        public String toJsonString() {
            return null;
        }
    }

    public static class PackageQueryStorableDummy
    extends PackageQueryStorable {
        @Override
        public String toJsonString() {
            return null;
        }
    }

    private static enum BASIC_EVENT {
        REFRESH_STRUCTURE,
        REMOVE_CONTENT,
        REMOVE_PACKAGE,
        REMOVE_LINK,
        ADD_CONTENT,
        ADD_PACKAGE,
        ADD_LINK,
        REFRESH_CONTENT,
        LINK_UPDATE,
        PACKAGE_UPDATE;

    }
}

