/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.downloads;

import java.util.HashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import jd.controlling.downloadcontroller.DownloadLinkCandidate;
import jd.controlling.downloadcontroller.DownloadLinkCandidateResult;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.downloadcontroller.DownloadWatchDogProperty;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.controlling.downloadcontroller.event.DownloadWatchdogListener;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.appwork.remoteapi.events.EventObject;
import org.appwork.remoteapi.events.EventPublisher;
import org.appwork.remoteapi.events.RemoteAPIEventsSender;
import org.appwork.remoteapi.events.SimpleEventObject;

public class DownloadWatchDogEventPublisher
implements EventPublisher,
DownloadWatchdogListener {
    private final CopyOnWriteArraySet<RemoteAPIEventsSender> eventSenders = new CopyOnWriteArraySet();
    private final String[] eventIDs = new String[]{EVENTID.PAUSED.name(), EVENTID.RUNNING.name(), EVENTID.STOPPED.name(), EVENTID.UPDATE.name()};

    @Override
    public void onDownloadWatchDogPropertyChange(DownloadWatchDogProperty propertyChange) {
        switch (propertyChange.getProperty()) {
            case STOPSIGN: {
                if (!this.hasSubscriptionFor(EVENTID.STOPSIGN.name())) break;
                HashMap<String, Object> dls = new HashMap<String, Object>();
                Object data = propertyChange.getValue();
                data = data instanceof FilePackage ? Long.valueOf(((FilePackage)propertyChange.getValue()).getUniqueID().getID()) : (data instanceof DownloadLink ? Long.valueOf(((DownloadLink)propertyChange.getValue()).getUniqueID().getID()) : String.valueOf(propertyChange.getValue()));
                dls.put("data", data);
                SimpleEventObject eventObject = new SimpleEventObject((EventPublisher)this, EVENTID.STOPSIGN.name(), dls);
                for (RemoteAPIEventsSender eventSender : this.eventSenders) {
                    eventSender.publishEvent((EventObject)eventObject, null);
                }
                break;
            }
        }
    }

    public String[] getPublisherEventIDs() {
        return this.eventIDs;
    }

    public String getPublisherName() {
        return "downloadwatchdog";
    }

    @Override
    public void onDownloadWatchdogDataUpdate() {
    }

    @Override
    public void onDownloadWatchdogStateIsIdle() {
    }

    private final boolean hasSubscriptionFor(String eventID) {
        if (this.eventSenders.size() > 0) {
            for (RemoteAPIEventsSender eventSender : this.eventSenders) {
                if (!eventSender.hasSubscriptionFor((EventPublisher)this, eventID)) continue;
                return true;
            }
        }
        return false;
    }

    private final void sendEventID(EVENTID eventid) {
        if (eventid != null && this.hasSubscriptionFor(eventid.name())) {
            SimpleEventObject eventObject = new SimpleEventObject((EventPublisher)this, eventid.name(), "watchDogState");
            for (RemoteAPIEventsSender eventSender : this.eventSenders) {
                eventSender.publishEvent((EventObject)eventObject, null);
            }
        }
    }

    @Override
    public void onDownloadWatchdogStateIsPause() {
        this.sendEventID(EVENTID.PAUSED);
    }

    @Override
    public void onDownloadWatchdogStateIsRunning() {
        this.sendEventID(EVENTID.RUNNING);
    }

    @Override
    public void onDownloadWatchdogStateIsStopped() {
        this.sendEventID(EVENTID.STOPPED);
    }

    @Override
    public void onDownloadWatchdogStateIsStopping() {
    }

    public synchronized void register(RemoteAPIEventsSender eventsAPI) {
        boolean wasEmpty = this.eventSenders.isEmpty();
        this.eventSenders.add(eventsAPI);
        if (wasEmpty && !this.eventSenders.isEmpty()) {
            DownloadWatchDog.getInstance().getEventSender().addListener(this, true);
        }
    }

    public synchronized void unregister(RemoteAPIEventsSender eventsAPI) {
        this.eventSenders.remove(eventsAPI);
        if (this.eventSenders.isEmpty()) {
            DownloadWatchDog.getInstance().getEventSender().removeListener(this);
        }
    }

    @Override
    public void onDownloadControllerStart(SingleDownloadController downloadController, DownloadLinkCandidate candidate) {
    }

    @Override
    public void onDownloadControllerStopped(SingleDownloadController downloadController, DownloadLinkCandidate candidate, DownloadLinkCandidateResult result) {
    }

    private static enum EVENTID {
        UPDATE,
        RUNNING,
        PAUSED,
        STOPSIGN,
        STOPPED;

    }
}

