/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.downloads;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.packagecontroller.AbstractPackageChildrenNodeFilter;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.appwork.remoteapi.APIQuery;
import org.jdownloader.api.downloads.DownloadLinkAPIStorable;
import org.jdownloader.api.downloads.DownloadsAPI;
import org.jdownloader.api.downloads.FilePackageAPIStorable;
import org.jdownloader.api.downloads.LinkStatusAPIStorable;
import org.jdownloader.controlling.DownloadLinkAggregator;
import org.jdownloader.extensions.extraction.ExtractionStatus;
import org.jdownloader.gui.views.components.packagetable.LinkTreeUtils;
import org.jdownloader.myjdownloader.client.json.JsonMap;
import org.jdownloader.plugins.FinalLinkState;
import org.jdownloader.settings.UrlDisplayType;

@Deprecated
public class DownloadsAPIImpl
implements DownloadsAPI {
    @Override
    public boolean start() {
        DownloadWatchDog.getInstance().startDownloads();
        return true;
    }

    @Override
    public boolean stop() {
        DownloadWatchDog.getInstance().stopDownloads();
        return true;
    }

    @Override
    public boolean pause(Boolean value) {
        DownloadWatchDog.getInstance().pauseDownloadWatchDog(value);
        return true;
    }

    @Override
    public String getJDState() {
        return DownloadWatchDog.getInstance().getStateMachine().getState().getLabel();
    }

    @Deprecated
    public DownloadsAPIImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public List<FilePackageAPIStorable> queryPackages(APIQuery queryParams) {
        void var8_12;
        DownloadController dlc = DownloadController.getInstance();
        DownloadWatchDog dwd = DownloadWatchDog.getInstance();
        ArrayList<Object> packages = dlc.getPackagesCopy();
        if (!((ArrayList)queryParams._getQueryParam("packageUUIDs", ArrayList.class, new ArrayList())).isEmpty()) {
            List requestedIds = (List)queryParams._getQueryParam("packageUUIDs", ArrayList.class, new ArrayList());
            ArrayList<FilePackage> toKeep = new ArrayList<FilePackage>();
            for (FilePackage filePackage : packages) {
                for (Long uuid : requestedIds) {
                    if (!uuid.equals(filePackage.getUniqueID().getID())) continue;
                    toKeep.add(filePackage);
                }
            }
            packages = toKeep;
        }
        ArrayList<FilePackageAPIStorable> ret = new ArrayList<FilePackageAPIStorable>(dlc.size());
        int startWith = queryParams._getStartAt();
        int maxResults = queryParams._getMaxResults();
        if (startWith > packages.size() - 1) {
            return ret;
        }
        if (startWith < 0) {
            startWith = 0;
        }
        if (maxResults < 0) {
            maxResults = packages.size();
        }
        int n = startWith;
        while (var8_12 < Math.min(startWith + maxResults, packages.size())) {
            FilePackage fp = (FilePackage)packages.get((int)var8_12);
            boolean readL = fp.getModifyLock().readLock();
            try {
                DownloadLinkAggregator aggregate = new DownloadLinkAggregator(fp);
                FilePackageAPIStorable fps = new FilePackageAPIStorable(fp);
                JsonMap infomap = new JsonMap();
                if (((Boolean)queryParams._getQueryParam("saveTo", Boolean.class, (Object)false)).booleanValue()) {
                    infomap.put("saveTo", fp.getView().getDownloadDirectory());
                }
                if (((Boolean)queryParams._getQueryParam("size", Boolean.class, (Object)false)).booleanValue()) {
                    long size = 0L;
                    for (DownloadLink dl : fp.getChildren()) {
                        size += dl.getView().getBytesTotalEstimated();
                    }
                    infomap.put("size", size);
                }
                if (((Boolean)queryParams._getQueryParam("childCount", Boolean.class, (Object)false)).booleanValue()) {
                    infomap.put("childCount", fp.getChildren().size());
                }
                if (((Boolean)queryParams._getQueryParam("hosts", Boolean.class, (Object)false)).booleanValue()) {
                    HashSet<String> hosts = new HashSet<String>();
                    for (DownloadLink dl : fp.getChildren()) {
                        hosts.add(dl.getHost());
                    }
                    infomap.put("hosts", hosts);
                }
                if (((Boolean)queryParams._getQueryParam("activeTask", Boolean.class, (Object)false)).booleanValue()) {
                    infomap.put("activeTask", "N/A");
                }
                if (((Boolean)queryParams._getQueryParam("speed", Boolean.class, (Object)false)).booleanValue()) {
                    infomap.put("speed", dwd.getDownloadSpeedbyFilePackage(fp));
                }
                if (((Boolean)queryParams._getQueryParam("finished", Boolean.class, (Object)false)).booleanValue()) {
                    infomap.put("finished", aggregate.isFinished());
                }
                if (((Boolean)queryParams._getQueryParam("eta", Boolean.class, (Object)false)).booleanValue()) {
                    infomap.put("eta", aggregate.getEta());
                }
                if (((Boolean)queryParams._getQueryParam("done", Boolean.class, (Object)false)).booleanValue()) {
                    Long done = 0L;
                    for (DownloadLink dl : fp.getChildren()) {
                        done = done + dl.getView().getBytesLoaded();
                    }
                    infomap.put("done", done);
                }
                if (((Boolean)queryParams._getQueryParam("progress", Boolean.class, (Object)false)).booleanValue()) {
                    infomap.put("progress", -1);
                }
                if (((Boolean)queryParams._getQueryParam("comment", Boolean.class, (Object)false)).booleanValue()) {
                    infomap.put("comment", fp.getComment());
                }
                if (queryParams.fieldRequested("enabled").booleanValue()) {
                    boolean enabled = false;
                    for (DownloadLink dl : fp.getChildren()) {
                        if (!dl.isEnabled()) continue;
                        enabled = true;
                        break;
                    }
                    infomap.put("enabled", enabled);
                }
                if (((Boolean)queryParams._getQueryParam("running", Boolean.class, (Object)false)).booleanValue()) {
                    infomap.put("running", dwd.getRunningFilePackages().contains(fp));
                }
                fps.setInfoMap(infomap);
                ret.add(fps);
            }
            finally {
                fp.getModifyLock().readUnlock(readL);
            }
            ++var8_12;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DownloadLinkAPIStorable> queryLinks(APIQuery queryParams) {
        int n;
        ArrayList<DownloadLinkAPIStorable> result = new ArrayList<DownloadLinkAPIStorable>();
        DownloadController dlc = DownloadController.getInstance();
        DownloadWatchDog dwd = DownloadWatchDog.getInstance();
        ArrayList<Long> packageUUIDs = new ArrayList<Long>();
        if (!((List)queryParams._getQueryParam("packageUUIDs", List.class, new ArrayList())).isEmpty()) {
            List uuidsFromQuery = (List)queryParams._getQueryParam("packageUUIDs", List.class, new ArrayList());
            for (Iterator<FilePackage> o : uuidsFromQuery) {
                try {
                    packageUUIDs.add((Long)((Object)o));
                }
                catch (ClassCastException classCastException) {}
            }
        }
        ArrayList<Object> matched = new ArrayList();
        if (packageUUIDs.isEmpty()) {
            matched = dlc.getPackagesCopy();
        } else {
            boolean b = dlc.readLock();
            try {
                for (FilePackage filePackage : dlc.getPackages()) {
                    if (!packageUUIDs.contains(filePackage.getUniqueID().getID())) continue;
                    matched.add(filePackage);
                }
            }
            finally {
                dlc.readUnlock(b);
            }
        }
        ArrayList<DownloadLink> links = new ArrayList<DownloadLink>();
        for (FilePackage filePackage : matched) {
            boolean b = filePackage.getModifyLock().readLock();
            try {
                links.addAll(filePackage.getChildren());
            }
            finally {
                filePackage.getModifyLock().readUnlock(b);
            }
        }
        if (links.isEmpty()) {
            return result;
        }
        int startWith = queryParams._getStartAt();
        int n2 = queryParams._getMaxResults();
        if (startWith > links.size() - 1) {
            return result;
        }
        if (startWith < 0) {
            startWith = 0;
        }
        if (n2 < 0) {
            n = links.size();
        }
        for (int i = startWith; i < Math.min(startWith + n, links.size()); ++i) {
            ExtractionStatus extractionStatus;
            DownloadLink dl = (DownloadLink)links.get(i);
            DownloadLinkAPIStorable dls = new DownloadLinkAPIStorable(dl);
            JsonMap infomap = new JsonMap();
            if (((Boolean)queryParams._getQueryParam("host", Boolean.class, (Object)false)).booleanValue()) {
                infomap.put("host", dl.getHost());
            }
            if (((Boolean)queryParams._getQueryParam("size", Boolean.class, (Object)false)).booleanValue()) {
                infomap.put("size", dl.getView().getBytesTotalEstimated());
            }
            if (((Boolean)queryParams._getQueryParam("done", Boolean.class, (Object)false)).booleanValue()) {
                infomap.put("done", dl.getView().getBytesLoaded());
            }
            if (((Boolean)queryParams._getQueryParam("speed", Boolean.class, (Object)false)).booleanValue()) {
                infomap.put("speed", dl.getView().getSpeedBps());
            }
            if (((Boolean)queryParams._getQueryParam("eta", Boolean.class, (Object)false)).booleanValue()) {
                infomap.put("eta", -1);
            }
            if (((Boolean)queryParams._getQueryParam("finished", Boolean.class, (Object)false)).booleanValue()) {
                infomap.put("finished", FinalLinkState.CheckFinished(dl.getFinalLinkState()));
            }
            if (((Boolean)queryParams._getQueryParam("linkStatus", Boolean.class, (Object)false)).booleanValue()) {
                infomap.put("linkStatus", new LinkStatusAPIStorable(dl));
            }
            if (((Boolean)queryParams._getQueryParam("running", Boolean.class, (Object)false)).booleanValue()) {
                infomap.put("running", dl.getDownloadLinkController() != null);
            }
            if (((Boolean)queryParams._getQueryParam("skipped", Boolean.class, (Object)false)).booleanValue()) {
                infomap.put("skipped", dl.isSkipped());
            }
            if (queryParams.fieldRequested("url").booleanValue()) {
                infomap.put("url", LinkTreeUtils.getUrlByType(UrlDisplayType.CONTENT, dl));
            }
            if (queryParams.fieldRequested("enabled").booleanValue()) {
                infomap.put("enabled", dl.isEnabled());
            }
            if (queryParams.fieldRequested("extractionStatus").booleanValue() && (extractionStatus = dl.getExtractionStatus()) != null) {
                infomap.put("extractionStatus", extractionStatus.name());
            }
            infomap.put("packageUUID", dl.getParentNode().getUniqueID().getID());
            dls.setInfoMap(infomap);
            result.add(dls);
        }
        return result;
    }

    @Override
    public int speed() {
        DownloadWatchDog dwd = DownloadWatchDog.getInstance();
        return dwd.getDownloadSpeedManager().getSpeed();
    }

    @Override
    public int packageCount() {
        return DownloadController.getInstance().getPackages().size();
    }

    @Override
    public boolean removeLinks(List<Long> linkIds) {
        return this.removeLinks(linkIds, null);
    }

    @Override
    public boolean removeLinks(List<Long> linkIds, List<Long> packageIds) {
        List<DownloadLink> links;
        if (linkIds != null && (links = this.getAllTheLinks(linkIds, packageIds)) != null && links.size() > 0) {
            DownloadController.getInstance().removeChildren(links);
            return true;
        }
        return false;
    }

    @Override
    public boolean forceDownload(List<Long> linkIds) {
        return this.forceDownload(linkIds, null);
    }

    @Override
    public boolean forceDownload(List<Long> linkIds, List<Long> packageIds) {
        DownloadController dlc = DownloadController.getInstance();
        DownloadWatchDog dwd = DownloadWatchDog.getInstance();
        dwd.forceDownload(this.getAllTheLinks(linkIds, packageIds));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean renamePackage(Long packageId, String newName) {
        if (packageId != null && newName != null) {
            DownloadController dlc = DownloadController.getInstance();
            boolean readL = dlc.readLock();
            FilePackage fp = null;
            try {
                for (FilePackage pkg : dlc.getPackages()) {
                    if (packageId.longValue() != pkg.getUniqueID().getID()) continue;
                    fp = pkg;
                    break;
                }
            }
            finally {
                dlc.readUnlock(readL);
            }
            if (fp != null) {
                fp.setName(newName);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean enableLinks(List<Long> linkIds) {
        if (linkIds == null) {
            return true;
        }
        return this.enableLinks(linkIds, null);
    }

    @Override
    public boolean enableLinks(List<Long> linkIds, List<Long> packageIds) {
        List<DownloadLink> sdl = this.getAllTheLinks(linkIds, packageIds);
        for (DownloadLink dl : sdl) {
            dl.setEnabled(true);
        }
        return true;
    }

    @Override
    public boolean disableLinks(List<Long> linkIds) {
        if (linkIds == null) {
            return true;
        }
        return this.disableLinks(linkIds, null);
    }

    @Override
    public boolean disableLinks(List<Long> linkIds, List<Long> packageIds) {
        List<DownloadLink> sdl = this.getAllTheLinks(linkIds, packageIds);
        for (DownloadLink dl : sdl) {
            dl.setEnabled(false);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean movePackages(APIQuery query) {
        List packageUUIDs = (List)query._getQueryParam("packageUUIDs", List.class, new ArrayList());
        Long afterDestPackageUUID = (Long)query._getQueryParam("afterDestPackageUUID", Long.class, null);
        DownloadController dlc = DownloadController.getInstance();
        ArrayList<FilePackage> selectedPackages = new ArrayList<FilePackage>();
        FilePackage afterDestPackage = null;
        boolean b = dlc.readLock();
        try {
            for (FilePackage fp : dlc.getPackages()) {
                if (packageUUIDs.contains(fp.getUniqueID().getID())) {
                    selectedPackages.add(fp);
                }
                if (afterDestPackageUUID == null || !afterDestPackageUUID.equals(fp.getUniqueID().getID())) continue;
                afterDestPackage = fp;
            }
        }
        finally {
            dlc.readUnlock(b);
        }
        dlc.move(selectedPackages, afterDestPackage);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean moveLinks(APIQuery query) {
        List selectedUUIDs = (List)query._getQueryParam("linkUUIDs", List.class, new ArrayList());
        Long afterDestLinkUUID = (Long)query._getQueryParam("afterDestLinkUUID", Long.class, (Object)-1L);
        Long targetPackageUUID = (Long)query._getQueryParam("destPackageUUID", Long.class, (Object)-1L);
        DownloadController dlc = DownloadController.getInstance();
        ArrayList<DownloadLink> selectedLinks = new ArrayList<DownloadLink>();
        DownloadLink afterDestLink = null;
        FilePackage destPackage = null;
        boolean b = dlc.readLock();
        try {
            for (DownloadLink dl : dlc.getAllChildren()) {
                if (selectedUUIDs.contains(dl.getUniqueID().getID())) {
                    selectedLinks.add(dl);
                }
                if (afterDestLink != null || !afterDestLinkUUID.equals(dl.getUniqueID().getID())) continue;
                afterDestLink = dl;
            }
            for (FilePackage fp : dlc.getPackages()) {
                if (!targetPackageUUID.equals(fp.getUniqueID().getID())) continue;
                destPackage = fp;
                break;
            }
        }
        finally {
            dlc.readUnlock(b);
        }
        dlc.move(selectedLinks, destPackage, afterDestLink);
        return true;
    }

    @Override
    public boolean resetLinks(List<Long> linkIds) {
        return this.resetLinks(linkIds, null);
    }

    @Override
    public boolean resetLinks(List<Long> linkIds, List<Long> packageIds) {
        List<DownloadLink> links = this.getAllTheLinks(linkIds, packageIds);
        DownloadWatchDog.getInstance().reset(links);
        return true;
    }

    @Override
    public Long getChildrenChanged(Long structureWatermark) {
        DownloadController lc = DownloadController.getInstance();
        if (lc.getChildrenChanges() != structureWatermark.longValue()) {
            return lc.getChildrenChanges();
        }
        return -1L;
    }

    private List<DownloadLink> getAllTheLinks(final List<Long> linkIds, List<Long> packageIds) {
        DownloadController dlc = DownloadController.getInstance();
        final List<DownloadLink> rmv = dlc.getChildrenByFilter(new AbstractPackageChildrenNodeFilter<DownloadLink>(){

            @Override
            public int returnMaxResults() {
                return 0;
            }

            @Override
            public boolean acceptNode(DownloadLink node) {
                return linkIds.contains(node.getUniqueID().getID());
            }
        });
        if (packageIds != null) {
            for (final FilePackage fp : dlc.getPackages()) {
                if (!packageIds.contains(fp.getUniqueID().getID())) continue;
                fp.getModifyLock().runReadLock(new Runnable(){

                    @Override
                    public void run() {
                        rmv.addAll(fp.getChildren());
                    }
                });
            }
        }
        return rmv;
    }
}

