/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.downloads.v2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.downloadcontroller.DownloadSession;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.packagecontroller.AbstractNode;
import jd.plugins.DecrypterRetryException;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.FilePackageView;
import jd.plugins.PluginProgress;
import jd.plugins.PluginStateCollection;
import org.appwork.remoteapi.exceptions.BadParameterException;
import org.jdownloader.DomainInfo;
import org.jdownloader.api.RemoteAPIController;
import org.jdownloader.api.downloads.v2.DownloadLinkAPIStorableV2;
import org.jdownloader.api.downloads.v2.DownloadsAPIV2;
import org.jdownloader.api.downloads.v2.FilePackageAPIStorableV2;
import org.jdownloader.api.downloads.v2.LinkQueryStorable;
import org.jdownloader.api.downloads.v2.PackageQueryStorable;
import org.jdownloader.api.utils.PackageControllerUtils;
import org.jdownloader.api.utils.SelectionInfoUtils;
import org.jdownloader.controlling.Priority;
import org.jdownloader.extensions.extraction.ExtractionStatus;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.myjdownloader.client.bindings.CleanupActionOptions;
import org.jdownloader.myjdownloader.client.bindings.PriorityStorable;
import org.jdownloader.myjdownloader.client.bindings.SkipReasonStorable;
import org.jdownloader.myjdownloader.client.bindings.UrlDisplayTypeStorable;
import org.jdownloader.myjdownloader.client.bindings.interfaces.DownloadsListInterface;
import org.jdownloader.myjdownloader.client.json.JsonMap;
import org.jdownloader.plugins.ConditionalSkipReason;
import org.jdownloader.plugins.FinalLinkState;
import org.jdownloader.plugins.MirrorLoading;
import org.jdownloader.plugins.SkipReason;
import org.jdownloader.plugins.TimeOutCondition;
import org.jdownloader.plugins.WaitForAccountSkipReason;
import org.jdownloader.plugins.WaitForAccountTrafficSkipReason;
import org.jdownloader.plugins.WaitWhileWaitingSkipReasonIsSet;
import org.jdownloader.plugins.WaitingSkipReason;

public class DownloadsAPIV2Impl
implements DownloadsAPIV2 {
    private final PackageControllerUtils<FilePackage, DownloadLink> packageControllerUtils;

    public DownloadsAPIV2Impl() {
        RemoteAPIController.validateInterfaces(DownloadsAPIV2.class, DownloadsListInterface.class);
        this.packageControllerUtils = new PackageControllerUtils<FilePackage, DownloadLink>(DownloadController.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FilePackageAPIStorableV2> queryPackages(PackageQueryStorable queryParams) throws BadParameterException {
        DownloadController dlc = DownloadController.getInstance();
        List<Object> packages = null;
        packages = queryParams.getPackageUUIDs() != null && queryParams.getPackageUUIDs().length > 0 ? this.packageControllerUtils.getPackages(queryParams.getPackageUUIDs()) : dlc.getPackagesCopy();
        ArrayList<FilePackageAPIStorableV2> ret = new ArrayList<FilePackageAPIStorableV2>(packages.size());
        if (packages.size() == 0) {
            return ret;
        }
        int startWith = queryParams.getStartAt();
        int maxResults = queryParams.getMaxResults();
        if (startWith > packages.size() - 1) {
            return ret;
        }
        if (startWith < 0) {
            startWith = 0;
        }
        if (maxResults < 0) {
            maxResults = packages.size();
        }
        for (int i = startWith; i < Math.min(startWith + maxResults, packages.size()); ++i) {
            FilePackage fp = (FilePackage)packages.get(i);
            boolean readL = fp.getModifyLock().readLock();
            try {
                FilePackageAPIStorableV2 fps = DownloadsAPIV2Impl.toStorable(queryParams, fp, (Object)this);
                ret.add(fps);
                continue;
            }
            finally {
                fp.getModifyLock().readUnlock(readL);
            }
        }
        return ret;
    }

    public static FilePackageAPIStorableV2 setStatus(FilePackageAPIStorableV2 fps, FilePackageView fpView) {
        PluginStateCollection ps = fpView.getPluginStates();
        if (ps != null && ps.size() > 0) {
            fps.setStatusIconKey(RemoteAPIController.getInstance().getContentAPI().getIconKey((Icon)((Object)ps.getMergedIcon())));
            fps.setStatus(ps.isMultiline() ? "" : ps.getText());
            return fps;
        }
        if (fpView.isFinished()) {
            fps.setStatusIconKey("true");
            fps.setStatus(_GUI.T.TaskColumn_getStringValue_finished_());
            return fps;
        }
        if (fpView.getETA() != -1L) {
            fps.setStatus(_GUI.T.TaskColumn_getStringValue_running_());
            return fps;
        }
        return fps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DownloadLinkAPIStorableV2> queryLinks(LinkQueryStorable queryParams) {
        ArrayList<DownloadLinkAPIStorableV2> result = new ArrayList<DownloadLinkAPIStorableV2>();
        DownloadController dlc = DownloadController.getInstance();
        ArrayList<DownloadLink> links = new ArrayList<DownloadLink>();
        if (queryParams.getLinkUUIDs() != null && queryParams.getLinkUUIDs().length > 0) {
            links.addAll(this.packageControllerUtils.getChildren(queryParams.getLinkUUIDs()));
        } else {
            List<Object> packages = queryParams.getPackageUUIDs() != null && queryParams.getPackageUUIDs().length > 0 ? this.packageControllerUtils.getPackages(queryParams.getPackageUUIDs()) : dlc.getPackagesCopy();
            if (queryParams.getJobUUIDs() != null && queryParams.getJobUUIDs().length > 0) {
                HashSet jobUUIDs = new HashSet();
                for (long id : queryParams.getJobUUIDs()) {
                    jobUUIDs.add(id);
                }
                for (FilePackage pkg : packages) {
                    boolean readL = pkg.getModifyLock().readLock();
                    try {
                        for (DownloadLink link : pkg.getChildren()) {
                            if (!jobUUIDs.contains(link.getJobID())) continue;
                            links.add(link);
                        }
                    }
                    finally {
                        pkg.getModifyLock().readUnlock(readL);
                    }
                }
            } else {
                for (FilePackage filePackage : packages) {
                    boolean b = filePackage.getModifyLock().readLock();
                    try {
                        links.addAll(filePackage.getChildren());
                    }
                    finally {
                        filePackage.getModifyLock().readUnlock(b);
                    }
                }
            }
        }
        if (links.isEmpty()) {
            return result;
        }
        int startWith = queryParams.getStartAt();
        int maxResults = queryParams.getMaxResults();
        if (startWith > links.size() - 1) {
            return result;
        }
        if (startWith < 0) {
            startWith = 0;
        }
        if (maxResults < 0) {
            maxResults = links.size();
        }
        int n = Math.min(startWith + maxResults, links.size());
        for (int i = startWith; i < n; ++i) {
            DownloadLink dl = (DownloadLink)links.get(i);
            DownloadLinkAPIStorableV2 dls = DownloadsAPIV2Impl.toStorable(queryParams, dl, (Object)this);
            result.add(dls);
        }
        return result;
    }

    public static FilePackageAPIStorableV2 toStorable(PackageQueryStorable queryParams, FilePackage fp, Object caller) {
        DownloadWatchDog dwd = DownloadWatchDog.getInstance();
        FilePackageAPIStorableV2 fps = new FilePackageAPIStorableV2(fp);
        FilePackageView fpView = new FilePackageView(fp);
        fpView.aggregate();
        if (queryParams.isPriority()) {
            fps.setPriority(PriorityStorable.get(fp.getPriorityEnum().name()));
        }
        if (queryParams.isSaveTo()) {
            fps.setSaveTo(fpView.getDownloadDirectory());
        }
        if (queryParams.isBytesTotal()) {
            fps.setBytesTotal(fpView.getSize());
        }
        if (queryParams.isChildCount()) {
            fps.setChildCount(fpView.size());
        }
        if (queryParams.isHosts()) {
            DomainInfo[] di = fpView.getDomainInfos();
            String[] hosts = new String[di.length];
            for (int j = 0; j < hosts.length; ++j) {
                hosts[j] = di[j].getTld();
            }
            fps.setHosts(hosts);
        }
        if (queryParams.isSpeed()) {
            fps.setSpeed(dwd.getDownloadSpeedbyFilePackage(fp));
        }
        if (queryParams.isStatus()) {
            DownloadsAPIV2Impl.setStatus(fps, fpView);
        }
        if (queryParams.isFinished()) {
            fps.setFinished(fpView.isFinished());
        }
        if (queryParams.isEta()) {
            fps.setEta(fpView.getETA());
        }
        if (queryParams.isBytesLoaded()) {
            fps.setBytesLoaded(fpView.getDone());
        }
        if (queryParams.isComment()) {
            fps.setComment(fp.getComment());
        }
        if (queryParams.isEnabled()) {
            fps.setEnabled(fpView.isEnabled());
        }
        if (queryParams.isRunning()) {
            fps.setRunning(dwd.getRunningFilePackages().contains(fp));
        }
        return fps;
    }

    public static DownloadLinkAPIStorableV2 toStorable(LinkQueryStorable queryParams, DownloadLink dl, Object caller) {
        ExtractionStatus extractionStatus;
        DownloadLinkAPIStorableV2 dls = new DownloadLinkAPIStorableV2(dl);
        if (queryParams.isPassword()) {
            dls.setDownloadPassword(dl.getDownloadPassword());
        }
        if (queryParams.isPriority()) {
            dls.setPriority(PriorityStorable.get(dl.getPriorityEnum().name()));
        }
        if (queryParams.isHost()) {
            dls.setHost(dl.getHost());
        }
        if (queryParams.isBytesTotal()) {
            dls.setBytesTotal(dl.getView().getBytesTotalEstimated());
        }
        if (queryParams.isStatus() || queryParams.isAdvancedStatus()) {
            DownloadsAPIV2Impl.setStatus(dls, dl, caller);
            if (!queryParams.isAdvancedStatus()) {
                dls.setAdvancedStatus(null);
            }
            if (!queryParams.isStatus()) {
                dls.setStatus(null);
                dls.setStatusIconKey(null);
            }
        }
        if (queryParams.isBytesLoaded()) {
            dls.setBytesLoaded(dl.getView().getBytesLoaded());
        }
        if (queryParams.isSpeed()) {
            dls.setSpeed(dl.getView().getSpeedBps());
        }
        if (queryParams.isJobUUID()) {
            dls.setJobUUID(dl.getJobID());
        }
        if (queryParams.isEta()) {
            PluginProgress plg = dl.getPluginProgress();
            if (plg != null) {
                dls.setEta(plg.getETA());
            } else {
                dls.setEta(-1L);
            }
        }
        if (queryParams.isFinished()) {
            dls.setFinished(FinalLinkState.CheckFinished(dl.getFinalLinkState()));
        }
        if (queryParams.isRunning()) {
            dls.setRunning(dl.getDownloadLinkController() != null);
        }
        if (queryParams.isSkipped()) {
            dls.setSkipped(dl.isSkipped());
        }
        if (queryParams.isUrl()) {
            dls.setUrl(dl.getView().getDisplayUrl());
        }
        if (queryParams.isEnabled()) {
            dls.setEnabled(dl.isEnabled());
        }
        if (queryParams.isExtractionStatus() && (extractionStatus = dl.getExtractionStatus()) != null) {
            dls.setExtractionStatus(extractionStatus.name());
        }
        if (queryParams.isComment()) {
            dls.setComment(dl.getComment());
        }
        if (queryParams.isAddedDate()) {
            dls.setAddedDate(dl.getCreated());
        }
        if (queryParams.isFinishedDate()) {
            dls.setFinishedDate(dl.getFinishedDate());
        }
        dls.setPackageUUID(dl.getParentNode().getUniqueID().getID());
        return dls;
    }

    public static DownloadLinkAPIStorableV2 setStatus(DownloadLinkAPIStorableV2 dls, DownloadLink link, Object caller) {
        FinalLinkState finalLinkState;
        HashMap<String, String> entry;
        String label;
        SkipReason skipReason;
        HashMap<String, Object> entry2;
        ConditionalSkipReason conditionalSkipReason;
        JsonMap advancedStatus = new JsonMap();
        dls.setAdvancedStatus(advancedStatus);
        boolean oldStatusSet = false;
        PluginProgress prog = link.getPluginProgress();
        if (prog != null) {
            String iconKey = RemoteAPIController.getInstance().getContentAPI().getIconKey(prog.getIcon(caller));
            String label2 = prog.getMessage(caller);
            if (!oldStatusSet) {
                oldStatusSet = true;
                dls.setStatusIconKey(iconKey);
                dls.setStatus(label2);
            }
            HashMap<String, Object> entry3 = new HashMap<String, Object>();
            entry3.put("iconKey", iconKey);
            entry3.put("current", prog.getCurrent());
            entry3.put("total", prog.getTotal());
            entry3.put("eta", prog.getETA());
            entry3.put("label", label2);
            entry3.put("id", prog.getID().name());
            advancedStatus.put("PluginProgress", entry3);
        }
        if ((conditionalSkipReason = link.getConditionalSkipReason()) != null && !conditionalSkipReason.isConditionReached()) {
            String iconKey = RemoteAPIController.getInstance().getContentAPI().getIconKey(conditionalSkipReason.getIcon(caller, null));
            String label3 = conditionalSkipReason.getMessage(caller, null);
            if (!oldStatusSet) {
                oldStatusSet = true;
                dls.setStatusIconKey(iconKey);
                dls.setStatus(label3);
            }
            entry2 = new HashMap();
            entry2.put("iconKey", iconKey);
            entry2.put("label", label3);
            if (conditionalSkipReason instanceof TimeOutCondition) {
                TimeOutCondition timeOutCondition = (TimeOutCondition)((Object)conditionalSkipReason);
                entry2.put("id", "TimeOutCondition");
                entry2.put("timeout", timeOutCondition.getTimeOutLeft());
            }
            if (conditionalSkipReason instanceof MirrorLoading) {
                MirrorLoading mirrorLoading = (MirrorLoading)conditionalSkipReason;
                entry2.put("id", "MirrorLoading");
                entry2.put("uuid", mirrorLoading.getDownloadLink().getUniqueID().getID());
            } else if (conditionalSkipReason instanceof WaitingSkipReason) {
                WaitingSkipReason waitingSkipReason = (WaitingSkipReason)conditionalSkipReason;
                entry2.put("id", "WaitingSkipReason");
                entry2.put("cause", waitingSkipReason.getCause().name());
            } else if (conditionalSkipReason instanceof WaitForAccountSkipReason) {
                WaitForAccountSkipReason waitForAccountSkipReason = (WaitForAccountSkipReason)conditionalSkipReason;
                entry2.put("id", "WaitForAccountSkipReason");
                entry2.put("uuid", waitForAccountSkipReason.getAccount().getId().getID());
            } else if (conditionalSkipReason instanceof WaitForAccountTrafficSkipReason) {
                WaitForAccountTrafficSkipReason waitForAccountTrafficSkipReason = (WaitForAccountTrafficSkipReason)conditionalSkipReason;
                entry2.put("id", "WaitForAccountTrafficSkipReason");
                entry2.put("uuid", waitForAccountTrafficSkipReason.getAccount().getId().getID());
                entry2.put("traffic", waitForAccountTrafficSkipReason.getTrafficRequired());
            } else if (conditionalSkipReason instanceof WaitWhileWaitingSkipReasonIsSet) {
                WaitWhileWaitingSkipReasonIsSet waitWhileWaitingSkipReasonIsSet = (WaitWhileWaitingSkipReasonIsSet)conditionalSkipReason;
                entry2.put("id", "WaitWhileWaitingSkipReasonIsSet");
                entry2.put("uuid", waitWhileWaitingSkipReasonIsSet.getDownloadLink().getUniqueID().getID());
                entry2.put("cause", waitWhileWaitingSkipReasonIsSet.getCause().name());
            }
            advancedStatus.put("ConditionalSkipReason", entry2);
        }
        if ((skipReason = link.getSkipReason()) != null) {
            String iconKey = RemoteAPIController.getInstance().getContentAPI().getIconKey(skipReason.getIcon(caller, 18));
            label = skipReason.getExplanation(caller, link);
            if (!oldStatusSet) {
                oldStatusSet = true;
                dls.setStatusIconKey(iconKey);
                dls.setStatus(label);
            }
            entry = new HashMap();
            entry.put("iconKey", iconKey);
            entry.put("label", label);
            entry.put("id", skipReason.name());
            advancedStatus.put("SkipReason", entry);
        }
        if ((finalLinkState = link.getFinalLinkState()) != null) {
            ExtractionStatus extractionStatus;
            entry2 = new HashMap<String, Object>();
            entry2.put("iconKey", finalLinkState.getIconKey());
            entry2.put("label", finalLinkState.getExplanation(caller, link));
            entry2.put("id", finalLinkState.name());
            advancedStatus.put("FinalLinkState", entry2);
            if (FinalLinkState.CheckFailed(finalLinkState)) {
                label = finalLinkState.getExplanation(caller, link);
                if (!oldStatusSet) {
                    oldStatusSet = true;
                    dls.setStatusIconKey("false");
                    dls.setStatus(label);
                }
            }
            if ((extractionStatus = link.getExtractionStatus()) != null) {
                entry = new HashMap();
                entry.put("label", extractionStatus.getExplanation());
                entry.put("id", extractionStatus.name());
                advancedStatus.put("ExtractionStatus", entry);
                switch (extractionStatus) {
                    case ERROR: 
                    case ERROR_PW: 
                    case ERROR_CRC: 
                    case ERROR_NOT_ENOUGH_SPACE: 
                    case ERRROR_FILE_NOT_FOUND: {
                        entry.put("iconKey", "extract_error");
                        if (oldStatusSet) break;
                        String label4 = extractionStatus.getExplanation();
                        oldStatusSet = true;
                        dls.setStatusIconKey("extract_error");
                        dls.setStatus(label4);
                        break;
                    }
                    case SUCCESSFUL: {
                        entry.put("iconKey", "extract_ok");
                        String label5 = extractionStatus.getExplanation();
                        if (oldStatusSet) break;
                        oldStatusSet = true;
                        dls.setStatusIconKey("extract_ok");
                        dls.setStatus(label5);
                        break;
                    }
                    case RUNNING: {
                        entry.put("iconKey", "extract");
                        String label6 = extractionStatus.getExplanation();
                        if (oldStatusSet) break;
                        oldStatusSet = true;
                        dls.setStatusIconKey("extract");
                        dls.setStatus(label6);
                        break;
                    }
                }
            }
            if (!oldStatusSet) {
                String label7 = finalLinkState.getExplanation(caller, link);
                oldStatusSet = true;
                if (FinalLinkState.FINISHED_MIRROR.equals((Object)finalLinkState)) {
                    dls.setStatusIconKey("true-orange");
                } else {
                    dls.setStatusIconKey("true");
                }
                dls.setStatus(label7);
            }
        }
        if (link.getDownloadLinkController() != null) {
            if (!oldStatusSet) {
                oldStatusSet = true;
                dls.setStatusIconKey("run");
                dls.setStatus(_GUI.T.TaskColumn_fillColumnHelper_starting());
            }
            entry2 = new HashMap();
            entry2.put("iconKey", "run");
            entry2.put("label", _GUI.T.TaskColumn_fillColumnHelper_starting());
            advancedStatus.put("SingleDownloadController", entry2);
        }
        DownloadLink.AvailableStatus availableStatus = link.getAvailableStatus();
        entry = new HashMap<String, String>();
        switch (availableStatus) {
            case FALSE: {
                entry.put("iconKey", "error");
                break;
            }
            case TRUE: {
                entry.put("iconKey", "true");
                break;
            }
            case UNCHECKABLE: 
            case UNCHECKED: {
                entry.put("iconKey", "help");
            }
        }
        entry.put("label", availableStatus.getExplanation());
        entry.put("id", availableStatus.name());
        advancedStatus.put("AvailableStatus", entry);
        if ("linkcrawlerretry".equals(link.getHost())) {
            String reason = link.getStringProperty("reason", null);
            entry = new HashMap();
            try {
                if (reason != null) {
                    entry.put("id", reason);
                    entry.put("label", DecrypterRetryException.RetryReason.valueOf(reason).getExplanation(caller));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            advancedStatus.put("LinkCrawlerRetry", entry);
        }
        return dls;
    }

    @Override
    public int packageCount() {
        return DownloadController.getInstance().size();
    }

    @Override
    public void removeLinks(long[] linkIds, long[] packageIds) {
        this.packageControllerUtils.remove(linkIds, packageIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renamePackage(Long packageId, String newName) {
        if (packageId != null && newName != null) {
            DownloadController dlc = DownloadController.getInstance();
            FilePackage fp = null;
            boolean readL = dlc.readLock();
            try {
                for (FilePackage pkg : dlc.getPackages()) {
                    if (packageId.longValue() != pkg.getUniqueID().getID()) continue;
                    fp = pkg;
                    break;
                }
            }
            finally {
                dlc.readUnlock(readL);
            }
            if (fp != null) {
                fp.setName(newName);
            }
        }
    }

    @Override
    public void renameLink(Long linkId, String newName) {
        DownloadController dwd;
        DownloadLink link;
        if (newName != null && linkId != null && (link = (DownloadLink)(dwd = DownloadController.getInstance()).getLinkByID(linkId)) != null) {
            DownloadWatchDog.getInstance().renameLink(link, newName);
        }
    }

    @Override
    public void movePackages(long[] packageIds, long afterDestPackageId) {
        this.packageControllerUtils.movePackages(packageIds, afterDestPackageId);
    }

    @Override
    public void movetoNewPackage(long[] linkIds, long[] pkgIds, String newPkgName, String downloadPath) throws BadParameterException {
        this.packageControllerUtils.movetoNewPackage(linkIds, pkgIds, newPkgName, downloadPath);
    }

    @Override
    public void splitPackageByHoster(long[] linkIds, long[] pkgIds) {
        this.packageControllerUtils.splitPackageByHoster(linkIds, pkgIds);
    }

    @Override
    public void moveLinks(long[] linkIds, long afterLinkID, long destPackageID) {
        this.packageControllerUtils.moveChildren(linkIds, afterLinkID, destPackageID);
    }

    @Override
    public long getStructureChangeCounter(long structureWatermark) {
        return this.packageControllerUtils.getChildrenChanged(structureWatermark);
    }

    @Override
    public long getStopMark() {
        Object mark = DownloadWatchDog.getInstance().getSession().getStopMark();
        if (mark instanceof AbstractNode) {
            return ((AbstractNode)mark).getUniqueID().getID();
        }
        if (mark == DownloadSession.STOPMARK.HIDDEN) {
            return 0L;
        }
        if (mark == DownloadSession.STOPMARK.NONE) {
            return -1L;
        }
        return -1L;
    }

    @Override
    public DownloadLinkAPIStorableV2 getStopMarkedLink() {
        Object mark = DownloadWatchDog.getInstance().getSession().getStopMark();
        if (mark instanceof DownloadLink) {
            DownloadLinkAPIStorableV2 dls = new DownloadLinkAPIStorableV2((DownloadLink)mark);
            dls.setPackageUUID(((DownloadLink)mark).getParentNode().getUniqueID().getID());
            return dls;
        }
        return null;
    }

    @Override
    public void setEnabled(boolean enabled, long[] linkIds, long[] packageIds) {
        this.packageControllerUtils.setEnabled(enabled, linkIds, packageIds);
    }

    @Override
    public void resetLinks(long[] linkIds, long[] packageIds) {
        DownloadWatchDog.getInstance().reset(this.packageControllerUtils.getSelectionInfo(linkIds, packageIds).getChildren());
    }

    @Override
    public void setPriority(PriorityStorable priority, long[] linkIds, long[] packageIds) throws BadParameterException {
        Priority jdPriority = Priority.valueOf(priority.name());
        List<DownloadLink> children = this.packageControllerUtils.getChildren(linkIds);
        List<FilePackage> pkgs = this.packageControllerUtils.getPackages(packageIds);
        for (DownloadLink dl : children) {
            dl.setPriorityEnum(jdPriority);
        }
        for (FilePackage pkg : pkgs) {
            pkg.setPriorityEnum(jdPriority);
        }
    }

    @Override
    public void setStopMark(long linkId, long packageId) {
        block1: {
            block2: {
                block0: {
                    if (linkId != 0L || packageId != 0L) break block0;
                    DownloadWatchDog.getInstance().setStopMark((Object)DownloadSession.STOPMARK.HIDDEN);
                    break block1;
                }
                if (linkId != -1L || packageId != -1L) break block2;
                DownloadWatchDog.getInstance().setStopMark((Object)DownloadSession.STOPMARK.NONE);
                break block1;
            }
            SelectionInfo<FilePackage, DownloadLink> selectionInfo = this.packageControllerUtils.getSelectionInfo(new long[]{linkId}, new long[]{packageId});
            Iterator<DownloadLink> iterator = selectionInfo.getChildren().iterator();
            if (!iterator.hasNext()) break block1;
            DownloadLink dl = iterator.next();
            DownloadWatchDog.getInstance().setStopMark(dl);
        }
    }

    @Override
    public void removeStopMark() {
        DownloadWatchDog.getInstance().setStopMark((Object)DownloadSession.STOPMARK.NONE);
    }

    @Override
    public void resumeLinks(long[] linkIds, long[] packageIds) throws BadParameterException {
        DownloadWatchDog dwd = DownloadWatchDog.getInstance();
        List<DownloadLink> links = this.packageControllerUtils.getSelectionInfo(linkIds, packageIds).getChildren();
        dwd.resume(links);
    }

    @Override
    public void setComment(long[] linkIds, long[] packageIds, boolean allPackageLinks, String comment) throws BadParameterException {
        this.packageControllerUtils.setComment(linkIds, packageIds, allPackageLinks, comment);
    }

    @Override
    public boolean forceDownload(long[] linkIds, long[] packageIds) throws BadParameterException {
        DownloadWatchDog dwd = DownloadWatchDog.getInstance();
        List<DownloadLink> links = this.packageControllerUtils.getSelectionInfo(linkIds, packageIds).getChildren();
        dwd.forceDownload(links);
        return true;
    }

    @Override
    public void setDownloadDirectory(String directory, long[] packageIds) {
        this.packageControllerUtils.setDownloadDirectory(directory, packageIds);
    }

    @Override
    public void startOnlineStatusCheck(long[] linkIds, long[] packageIds) throws BadParameterException {
        SelectionInfo<FilePackage, DownloadLink> selectionInfo = this.packageControllerUtils.getSelectionInfo(linkIds, packageIds);
        SelectionInfoUtils.startOnlineStatusCheck(selectionInfo);
    }

    @Override
    public Map<String, List<Long>> getDownloadUrls(long[] linkIds, long[] packageIds, UrlDisplayTypeStorable[] urlDisplayTypes) throws BadParameterException {
        return SelectionInfoUtils.getURLs(this.packageControllerUtils.getSelectionInfo(linkIds, packageIds), SelectionInfoUtils.parse(urlDisplayTypes));
    }

    @Override
    public boolean setDownloadPassword(long[] linkIds, long[] packageIds, String pass) throws BadParameterException {
        return this.packageControllerUtils.setDownloadPassword(linkIds, packageIds, pass);
    }

    @Override
    public void cleanup(long[] linkIds, long[] packageIds, CleanupActionOptions.Action action, CleanupActionOptions.Mode mode, CleanupActionOptions.SelectionType selectionType) throws BadParameterException {
        this.packageControllerUtils.cleanup(linkIds, packageIds, action, mode, selectionType);
    }

    @Override
    public boolean unskip(long[] linkIds, long[] packageIds, SkipReasonStorable.Reason reason) throws BadParameterException {
        List<DownloadLink> links = this.packageControllerUtils.getSelectionInfo(linkIds, packageIds).getChildren();
        ArrayList<DownloadLink> unskipLinks = new ArrayList();
        if (reason != null) {
            SkipReason checkReason = SkipReason.valueOf(reason.name());
            for (DownloadLink link : links) {
                SkipReason skipReason = link.getSkipReason();
                if (skipReason == null || !checkReason.equals((Object)skipReason)) continue;
                unskipLinks.add(link);
            }
        } else {
            unskipLinks = links;
        }
        DownloadWatchDog.getInstance().unSkip(unskipLinks);
        return true;
    }
}

