/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.extensions;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.appwork.exceptions.WTFException;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.jdownloader.api.extensions.ExtensionAPIStorable;
import org.jdownloader.api.extensions.ExtensionQueryStorable;
import org.jdownloader.api.extensions.ExtensionsAPI;
import org.jdownloader.extensions.ExtensionController;
import org.jdownloader.extensions.LazyExtension;
import org.jdownloader.extensions.OptionalExtension;
import org.jdownloader.updatev2.UpdateController;

public class ExtensionsAPIImpl
implements ExtensionsAPI {
    @Override
    public boolean isInstalled(String id) {
        if (!UpdateController.getInstance().isHandlerSet()) {
            throw new WTFException("UpdateHandler not set");
        }
        return UpdateController.getInstance().isExtensionInstalled(id);
    }

    @Override
    public boolean install(final String id) {
        new Thread("Install Extension"){

            @Override
            public void run() {
                try {
                    UpdateController.getInstance().setGuiVisible(true);
                    UpdateController.getInstance().runExtensionInstallation(id);
                    while (true) {
                        Thread.sleep(500L);
                        if (UpdateController.getInstance().isRunning()) {
                            UpdateController.getInstance().waitForUpdate();
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    LoggerFactory.getDefaultLogger().log((Throwable)e);
                }
            }
        }.start();
        return true;
    }

    @Override
    public boolean isEnabled(String id) {
        LazyExtension lazy = ExtensionController.getInstance().getExtension(id);
        return lazy != null && lazy._isEnabled();
    }

    @Override
    public List<ExtensionAPIStorable> list(ExtensionQueryStorable query) {
        try {
            List<LazyExtension> installedExtensions = ExtensionController.getInstance().getExtensions();
            List<OptionalExtension> optionalExtensions = ExtensionController.getInstance().getOptionalExtensions();
            if (installedExtensions.size() + optionalExtensions.size() > 0) {
                ExtensionAPIStorable extensionStorable;
                ArrayList<ExtensionAPIStorable> result = new ArrayList<ExtensionAPIStorable>(installedExtensions.size() + optionalExtensions.size());
                Pattern cPat = StringUtils.isEmpty((String)query.getPattern()) ? null : Pattern.compile(query.getPattern(), 34);
                for (LazyExtension installedExtension : installedExtensions) {
                    if (cPat != null && !cPat.matcher(installedExtension.getClassname()).matches()) continue;
                    extensionStorable = new ExtensionAPIStorable();
                    extensionStorable.setId(installedExtension.getClassname());
                    if (query.isName()) {
                        extensionStorable.setName(installedExtension.getName());
                    }
                    if (query.isEnabled()) {
                        extensionStorable.setEnabled(installedExtension._isEnabled());
                    }
                    if (query.isInstalled()) {
                        extensionStorable.setInstalled(true);
                    }
                    if (query.isDescription()) {
                        extensionStorable.setDescription(installedExtension.getDescription());
                    }
                    if (query.isConfigInterface()) {
                        extensionStorable.setConfigInterface(installedExtension.getConfigInterface());
                    }
                    if (query.isIconKey()) {
                        extensionStorable.setIconKey(installedExtension.getIconPath());
                    }
                    result.add(extensionStorable);
                }
                for (OptionalExtension uninstalledExtension : optionalExtensions) {
                    if (uninstalledExtension.isInstalled() || cPat != null && !cPat.matcher(uninstalledExtension.getExtensionID()).matches()) continue;
                    extensionStorable = new ExtensionAPIStorable();
                    extensionStorable.setId(uninstalledExtension.getExtensionID());
                    if (query.isName()) {
                        extensionStorable.setName(uninstalledExtension.getName());
                    }
                    if (query.isEnabled()) {
                        extensionStorable.setEnabled(false);
                    }
                    if (query.isInstalled()) {
                        extensionStorable.setInstalled(false);
                    }
                    if (query.isDescription()) {
                        extensionStorable.setDescription(uninstalledExtension.getDescription());
                    }
                    if (query.isConfigInterface()) {
                        extensionStorable.setConfigInterface(null);
                    }
                    if (query.isIconKey()) {
                        extensionStorable.setIconKey(uninstalledExtension.getIconKey());
                    }
                    result.add(extensionStorable);
                }
                return result;
            }
            return new ArrayList<ExtensionAPIStorable>(0);
        }
        catch (Exception e) {
            throw new WTFException((Throwable)e);
        }
    }

    @Override
    public boolean setEnabled(String id, boolean b) {
        LazyExtension lazy = ExtensionController.getInstance().getExtension(id);
        if (lazy == null) {
            return false;
        }
        ExtensionController.getInstance().setEnabled(lazy, b);
        return true;
    }
}

