/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.jdanywhere.api;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.packagecontroller.AbstractPackageChildrenNodeFilter;
import jd.gui.swing.jdgui.components.speedmeter.SpeedMeterPanel;
import jd.gui.swing.jdgui.components.toolbar.MainToolBar;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.appwork.remoteapi.APIQuery;
import org.appwork.remoteapi.RemoteAPI;
import org.appwork.remoteapi.RemoteAPIRequest;
import org.appwork.remoteapi.RemoteAPIResponse;
import org.appwork.remoteapi.exceptions.InternalApiException;
import org.appwork.storage.config.ValidationException;
import org.appwork.utils.ImageProvider.ImageProvider;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.net.HTTPHeader;
import org.appwork.utils.speedmeter.SpeedMeterInterface;
import org.jdownloader.api.jdanywhere.api.interfaces.IDashboardApi;
import org.jdownloader.api.jdanywhere.api.storable.RunningObjectStorable;
import org.jdownloader.api.polling.PollingAPIImpl;
import org.jdownloader.api.polling.PollingResultAPIStorable;
import org.jdownloader.api.toolbar.JDownloaderToolBarAPIImpl;
import org.jdownloader.myjdownloader.client.json.JsonMap;
import org.jdownloader.plugins.FinalLinkState;
import org.jdownloader.settings.staticreferences.CFG_GENERAL;
import org.jdownloader.settings.staticreferences.CFG_GUI;
import org.jdownloader.settings.staticreferences.CFG_RECONNECT;

public class DashboardApi
implements IDashboardApi {
    PollingAPIImpl plAPI = new PollingAPIImpl();
    JDownloaderToolBarAPIImpl tbAPI = new JDownloaderToolBarAPIImpl();
    LinkedList<Integer> _speedList = new LinkedList<Integer>(Arrays.asList(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0));
    Timer timer = new Timer();

    public DashboardApi() {
        this.timer.scheduleAtFixedRate(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int speed = DownloadWatchDog.getInstance().getDownloadSpeedManager().getSpeed();
                LinkedList<Integer> linkedList = DashboardApi.this._speedList;
                synchronized (linkedList) {
                    DashboardApi.this._speedList.addLast(speed);
                    DashboardApi.this._speedList.removeFirst();
                }
            }
        }, 3000L, 3000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Integer> speedList() {
        LinkedList<Integer> linkedList = this._speedList;
        synchronized (linkedList) {
            return new ArrayList<Integer>(this._speedList);
        }
    }

    @Override
    public String apiVersion() {
        return "1.0.20131030";
    }

    @Override
    public boolean start() {
        DownloadWatchDog.getInstance().startDownloads();
        return true;
    }

    @Override
    public boolean stop() {
        DownloadWatchDog.getInstance().stopDownloads();
        return true;
    }

    @Override
    public boolean pause() {
        DownloadWatchDog.getInstance().pauseDownloadWatchDog(!DownloadWatchDog.getInstance().isPaused());
        return true;
    }

    @Override
    public String getState() {
        APIQuery queryParams = new APIQuery();
        queryParams.put((Object)"jdState", (Object)"");
        List<PollingResultAPIStorable> result = this.plAPI.poll(null, queryParams);
        for (PollingResultAPIStorable pr : result) {
            if (pr.getEventName() != "jdState") continue;
            return (String)pr.getEventData().get("data");
        }
        return "";
    }

    @Override
    public synchronized Object getCompleteState() {
        JsonMap ret = new JsonMap();
        int running = DownloadWatchDog.getInstance().getActiveDownloads();
        ret.put("running", running > 0);
        ret.put("limit", CFG_GENERAL.DOWNLOAD_SPEED_LIMIT_ENABLED.isEnabled());
        ret.put("limitspeed", CFG_GENERAL.DOWNLOAD_SPEED_LIMIT.getValue());
        ret.put("reconnect", CFG_RECONNECT.AUTO_RECONNECT_ENABLED.isEnabled());
        ret.put("clipboard", CFG_GUI.CLIPBOARD_MONITORED.isEnabled());
        ret.put("stopafter", DownloadWatchDog.getInstance().getSession().isStopMarkSet());
        ret.put("premium", CFG_GENERAL.USE_AVAILABLE_ACCOUNTS.isEnabled());
        if (running == 0) {
            ret.put("speed", 0);
        } else {
            ret.put("speed", DownloadWatchDog.getInstance().getDownloadSpeedManager().getSpeedMeter().getValue(SpeedMeterInterface.Resolution.SECONDS));
        }
        ret.put("pause", DownloadWatchDog.getInstance().isPaused());
        List<DownloadLink> calc_progress = DownloadController.getInstance().getChildrenByFilter(new AbstractPackageChildrenNodeFilter<DownloadLink>(){

            @Override
            public int returnMaxResults() {
                return 0;
            }

            @Override
            public boolean acceptNode(DownloadLink node) {
                if (!node.isEnabled()) {
                    return false;
                }
                return !FinalLinkState.CheckFailed(node.getFinalLinkState());
            }
        });
        long todo = 0L;
        long done = 0L;
        for (DownloadLink link : calc_progress) {
            done += Math.max(0L, link.getView().getBytesLoaded());
            todo += Math.max(0L, link.getView().getBytesTotalEstimated());
        }
        ret.put("download_current", done);
        ret.put("download_complete", todo);
        ret.put("maxDL", CFG_GENERAL.MAX_SIMULTANE_DOWNLOADS.getValue());
        ret.put("maxConDL", CFG_GENERAL.MAX_CHUNKS_PER_FILE.getValue());
        ret.put("maxConHost", CFG_GENERAL.MAX_SIMULTANE_DOWNLOADS_PER_HOST.getValue());
        ret.put("maxConHostActive", CFG_GENERAL.MAX_DOWNLOADS_PER_HOST_ENABLED.isEnabled());
        return ret;
    }

    @Override
    public int speed() {
        return DownloadWatchDog.getInstance().getDownloadSpeedManager().getSpeed();
    }

    @Override
    public int limit() {
        return DownloadWatchDog.getInstance().getDownloadSpeedManager().getLimit();
    }

    @Override
    public long traffic() {
        return DownloadWatchDog.getInstance().getDownloadSpeedManager().getTraffic();
    }

    @Override
    public boolean setLimitspeed(int speed) {
        boolean returnValue = true;
        try {
            CFG_GENERAL.DOWNLOAD_SPEED_LIMIT.setValue((Object)speed);
        }
        catch (ValidationException e) {
            returnValue = false;
        }
        return returnValue;
    }

    @Override
    public boolean activateLimitspeed(boolean activate) {
        boolean returnValue = true;
        try {
            CFG_GENERAL.DOWNLOAD_SPEED_LIMIT_ENABLED.setValue((Object)activate);
        }
        catch (ValidationException e) {
            returnValue = false;
        }
        return returnValue;
    }

    @Override
    public void speedMeter(RemoteAPIRequest request, RemoteAPIResponse response) throws InternalApiException {
        OutputStream out = null;
        try {
            SpeedMeterPanel speedMeter = MainToolBar.getInstance().getSpeedMeter();
            BufferedImage bufferedImage = new BufferedImage(speedMeter.getWidth(), speedMeter.getHeight(), 1);
            Graphics2D g2d = bufferedImage.createGraphics();
            g2d.setColor(Color.white);
            g2d.fillRect(0, 0, speedMeter.getWidth(), speedMeter.getHeight());
            speedMeter.paintComponent((Graphics)g2d, false);
            g2d.dispose();
            response.getResponseHeaders().add(new HTTPHeader("Content-Type", "image/png", false));
            out = RemoteAPI.getOutputStream((RemoteAPIResponse)response, (RemoteAPIRequest)request, (boolean)RemoteAPI.gzip((RemoteAPIRequest)request), (boolean)false);
            ImageProvider.writeImage((RenderedImage)bufferedImage, (String)"png", (OutputStream)out);
        }
        catch (IOException e) {
            LoggerFactory.getDefaultLogger().log((Throwable)e);
            throw new InternalApiException((Throwable)e);
        }
        finally {
            try {
                out.close();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RunningObjectStorable> runningLinks() {
        DownloadController dlc = DownloadController.getInstance();
        ArrayList<RunningObjectStorable> ret = new ArrayList<RunningObjectStorable>(dlc.getAllChildren().size());
        boolean b = dlc.readLock();
        try {
            for (FilePackage fpkg : dlc.getPackages()) {
                boolean readL = fpkg.getModifyLock().readLock();
                try {
                    for (DownloadLink link : fpkg.getChildren()) {
                        if (link.getView().getSpeedBps() <= 0L) continue;
                        RunningObjectStorable ro = new RunningObjectStorable();
                        ro.setPackageID(fpkg.getUniqueID().getID());
                        ro.setLinkID(link.getUniqueID().getID());
                        ro.setDone(link.getView().getBytesLoaded());
                        ro.setSpeed(link.getView().getSpeedBps());
                        long remainingBytes = link.getView().getBytesTotal() - link.getView().getBytesLoaded();
                        ro.setETA(remainingBytes / link.getView().getSpeedBps());
                        ret.add(ro);
                    }
                }
                finally {
                    fpkg.getModifyLock().readUnlock(readL);
                }
            }
        }
        finally {
            dlc.readUnlock(b);
        }
        return ret;
    }

    @Override
    public boolean setMaxDL(int value) {
        boolean returnValue = true;
        try {
            CFG_GENERAL.MAX_SIMULTANE_DOWNLOADS.setValue((Object)value);
        }
        catch (ValidationException e) {
            returnValue = false;
        }
        return returnValue;
    }

    @Override
    public boolean setMaxConDL(int value) {
        boolean returnValue = true;
        try {
            CFG_GENERAL.MAX_CHUNKS_PER_FILE.setValue((Object)value);
        }
        catch (ValidationException e) {
            returnValue = false;
        }
        return returnValue;
    }

    @Override
    public boolean setMaxConHost(int value) {
        boolean returnValue = true;
        try {
            CFG_GENERAL.MAX_SIMULTANE_DOWNLOADS_PER_HOST.setValue((Object)value);
        }
        catch (ValidationException e) {
            returnValue = false;
        }
        return returnValue;
    }

    @Override
    public boolean activateMaxConHost(boolean value) {
        boolean returnValue = true;
        try {
            CFG_GENERAL.MAX_DOWNLOADS_PER_HOST_ENABLED.setValue((Object)value);
        }
        catch (ValidationException e) {
            returnValue = false;
        }
        return returnValue;
    }

    @Override
    public boolean activateReconnect(boolean value) {
        boolean returnValue = true;
        try {
            CFG_RECONNECT.AUTO_RECONNECT_ENABLED.setValue((Object)value);
        }
        catch (ValidationException e) {
            returnValue = false;
        }
        return returnValue;
    }

    @Override
    public boolean activatePremium(boolean value) {
        boolean returnValue = true;
        try {
            CFG_GENERAL.USE_AVAILABLE_ACCOUNTS.setValue((Object)value);
        }
        catch (ValidationException e) {
            returnValue = false;
        }
        return returnValue;
    }
}

