/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.jdanywhere.api;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.packagecontroller.AbstractPackageChildrenNodeFilter;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.PluginProgress;
import org.jdownloader.extensions.extraction.ExtractionStatus;
import org.jdownloader.plugins.ConditionalSkipReason;
import org.jdownloader.plugins.FinalLinkState;
import org.jdownloader.plugins.SkipReason;

public class Helper {
    public static final Object REQUESTOR = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DownloadLink getDownloadLinkFromID(long ID2) {
        DownloadController dlc = DownloadController.getInstance();
        boolean b = dlc.readLock();
        try {
            for (FilePackage fpkg : dlc.getPackages()) {
                boolean readL = fpkg.getModifyLock().readLock();
                try {
                    for (DownloadLink link : fpkg.getChildren()) {
                        if (link.getUniqueID().getID() != ID2) continue;
                        DownloadLink downloadLink = link;
                        return downloadLink;
                    }
                }
                finally {
                    fpkg.getModifyLock().readUnlock(readL);
                }
            }
        }
        finally {
            dlc.readUnlock(b);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FilePackage getFilePackageFromID(long ID2) {
        DownloadController dlc = DownloadController.getInstance();
        boolean b = dlc.readLock();
        try {
            for (FilePackage fpkg : dlc.getPackages()) {
                if (fpkg.getUniqueID().getID() != ID2) continue;
                FilePackage filePackage = fpkg;
                return filePackage;
            }
        }
        finally {
            dlc.readUnlock(b);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DownloadLink> getFilteredDownloadLinks(final List<Long> linkIds) {
        if (linkIds != null && linkIds.size() > 0) {
            DownloadController dlc = DownloadController.getInstance();
            boolean b = dlc.readLock();
            try {
                List<DownloadLink> sdl;
                final int size = linkIds.size();
                List<DownloadLink> list = sdl = dlc.getChildrenByFilter(new AbstractPackageChildrenNodeFilter<DownloadLink>(){

                    @Override
                    public int returnMaxResults() {
                        return size;
                    }

                    @Override
                    public boolean acceptNode(DownloadLink node) {
                        return linkIds.contains(node.getUniqueID().getID());
                    }
                });
                return list;
            }
            finally {
                dlc.readUnlock(b);
            }
        }
        return null;
    }

    public static byte[] compress(String str) throws IOException {
        if (str == null || str.length() == 0) {
            return new byte[0];
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(out);
        gzip.write(str.getBytes("UTF-8"));
        gzip.close();
        return out.toByteArray();
    }

    public static String getMessage(DownloadLink link) {
        PluginProgress prog = link.getPluginProgress();
        if (prog != null) {
            return prog.getMessage(REQUESTOR);
        }
        ConditionalSkipReason conditionalSkipReason = link.getConditionalSkipReason();
        if (conditionalSkipReason != null && !conditionalSkipReason.isConditionReached()) {
            return conditionalSkipReason.getMessage(null, null);
        }
        SkipReason skipReason = link.getSkipReason();
        if (skipReason != null) {
            return skipReason.getExplanation(null, link);
        }
        FinalLinkState finalLinkState = link.getFinalLinkState();
        if (finalLinkState != null) {
            if (FinalLinkState.CheckFailed(finalLinkState)) {
                return finalLinkState.getExplanation(null, link);
            }
            ExtractionStatus extractionStatus = link.getExtractionStatus();
            if (extractionStatus != null) {
                switch (extractionStatus) {
                    case ERROR: 
                    case ERROR_PW: 
                    case ERROR_CRC: 
                    case ERROR_NOT_ENOUGH_SPACE: 
                    case ERRROR_FILE_NOT_FOUND: {
                        return extractionStatus.getExplanation();
                    }
                    case SUCCESSFUL: {
                        return extractionStatus.getExplanation();
                    }
                    case RUNNING: {
                        return extractionStatus.getExplanation();
                    }
                    case IDLE: {
                        break;
                    }
                }
            }
            return finalLinkState.getExplanation(null, link);
        }
        return "";
    }
}

