/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.jdanywhere.api;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jd.controlling.linkcollector.LinkCollectingJob;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcollector.LinkOrigin;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.controlling.packagecontroller.AbstractPackageChildrenNodeFilter;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.jdownloader.api.jdanywhere.api.interfaces.ILinkCrawlerApi;
import org.jdownloader.api.jdanywhere.api.storable.CrawledLinkStoreable;
import org.jdownloader.api.jdanywhere.api.storable.CrawledPackageStorable;
import org.jdownloader.api.linkcollector.LinkCollectorAPIImpl;
import org.jdownloader.controlling.Priority;
import org.jdownloader.gui.views.SelectionInfo;

public class LinkCrawlerApi
implements ILinkCrawlerApi {
    LinkCollectorAPIImpl lcAPI = new LinkCollectorAPIImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CrawledPackageStorable> list() {
        LinkCollector lc = LinkCollector.getInstance();
        boolean b = lc.readLock();
        try {
            ArrayList<CrawledPackageStorable> ret = new ArrayList<CrawledPackageStorable>(lc.size());
            for (CrawledPackage cpkg : lc.getPackages()) {
                CrawledPackageStorable pkg = new CrawledPackageStorable(cpkg);
                ret.add(pkg);
            }
            ArrayList<CrawledPackageStorable> arrayList = ret;
            return arrayList;
        }
        finally {
            lc.readUnlock(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CrawledLinkStoreable> listLinks(long ID2) {
        LinkCollector lc = LinkCollector.getInstance();
        boolean b = lc.readLock();
        try {
            for (CrawledPackage cpkg : lc.getPackages()) {
                if (cpkg.getUniqueID().getID() != ID2) continue;
                boolean readL = cpkg.getModifyLock().readLock();
                try {
                    ArrayList<CrawledLinkStoreable> links = new ArrayList<CrawledLinkStoreable>(cpkg.getChildren().size());
                    for (CrawledLink link : cpkg.getChildren()) {
                        links.add(new CrawledLinkStoreable(link));
                    }
                    ArrayList<CrawledLinkStoreable> arrayList = links;
                    return arrayList;
                }
                finally {
                    cpkg.getModifyLock().readUnlock(readL);
                }
            }
            Iterator iterator = null;
            return iterator;
        }
        finally {
            lc.readUnlock(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CrawledPackageStorable getCrawledPackage(long crawledPackageID) {
        CrawledPackage cpkg = this.getCrawledPackageFromID(crawledPackageID);
        if (cpkg != null) {
            boolean readL = cpkg.getModifyLock().readLock();
            try {
                CrawledPackageStorable pkg = new CrawledPackageStorable(cpkg);
                ArrayList<CrawledLinkStoreable> links = new ArrayList<CrawledLinkStoreable>(cpkg.getChildren().size());
                for (CrawledLink link : cpkg.getChildren()) {
                    links.add(new CrawledLinkStoreable(link));
                }
                pkg._setLinks(links);
                CrawledPackageStorable crawledPackageStorable = pkg;
                return crawledPackageStorable;
            }
            finally {
                cpkg.getModifyLock().readUnlock(readL);
            }
        }
        return null;
    }

    @Override
    public String getPackageIDFromLinkID(long ID2) {
        CrawledPackage fpk;
        CrawledLink dl = this.getCrawledLinkFromID(ID2);
        if (dl != null && (fpk = dl.getParentNode()) != null) {
            return fpk.getUniqueID().toString();
        }
        return null;
    }

    @Override
    public CrawledLinkStoreable getCrawledLink(long crawledLinkID) {
        CrawledLink link = this.getCrawledLinkFromID(crawledLinkID);
        if (link != null) {
            return new CrawledLinkStoreable(link);
        }
        return null;
    }

    @Override
    public boolean AddCrawledPackageToDownloads(long crawledPackageID) {
        CrawledPackage cp = this.getCrawledPackageFromID(crawledPackageID);
        if (cp != null) {
            LinkCollector.getInstance().moveLinksToDownloadList(new SelectionInfo<CrawledPackage, CrawledLink>(cp), new LinkCollector.ConfirmLinksSettings(LinkCollector.MoveLinksMode.MANUAL));
            return true;
        }
        return false;
    }

    @Override
    public boolean addCrawledLinkToDownloads(List<Long> linkIds) {
        return this.lcAPI.startDownloads(linkIds);
    }

    @Override
    public boolean addDLC(String dlcContent) {
        try {
            if (dlcContent == null) {
                throw new IllegalArgumentException("no DLC Content available");
            }
            String dlc = dlcContent.trim().replace(" ", "+");
            File tmp = Application.getTempResource((String)("jd_" + System.currentTimeMillis() + ".dlc"));
            IO.writeToFile((File)tmp, (byte[])dlc.getBytes("UTF-8"));
            String url = tmp.toURI().toString();
            LinkCollectingJob job = new LinkCollectingJob(LinkOrigin.MYJD.getLinkOriginDetails(), url);
            LinkCollector.getInstance().addCrawlerJob(job);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    @Override
    public boolean removeCrawledLink(List<Long> linkIds) {
        return this.lcAPI.removeLinks(linkIds);
    }

    @Override
    public boolean removeCrawledPackage(String ID2) {
        long id = Long.valueOf(ID2);
        CrawledPackage cpkg = this.getCrawledPackageFromID(id);
        if (cpkg != null) {
            LinkCollector.getInstance().removePackage(cpkg);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CrawledPackage getCrawledPackageFromID(long ID2) {
        LinkCollector lc = LinkCollector.getInstance();
        boolean b = lc.readLock();
        try {
            for (CrawledPackage cpkg : lc.getPackages()) {
                if (cpkg.getUniqueID().getID() != ID2) continue;
                CrawledPackage crawledPackage = cpkg;
                return crawledPackage;
            }
            Iterator iterator = null;
            return iterator;
        }
        finally {
            lc.readUnlock(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CrawledLink getCrawledLinkFromID(long ID2) {
        LinkCollector lc = LinkCollector.getInstance();
        boolean b = lc.readLock();
        try {
            for (CrawledPackage cpkg : lc.getPackages()) {
                boolean readL = cpkg.getModifyLock().readLock();
                try {
                    for (CrawledLink link : cpkg.getChildren()) {
                        if (link.getDownloadLink().getUniqueID().getID() != ID2) continue;
                        CrawledLink crawledLink = link;
                        return crawledLink;
                    }
                }
                finally {
                    cpkg.getModifyLock().readUnlock(readL);
                }
            }
            Iterator iterator = null;
            return iterator;
        }
        finally {
            lc.readUnlock(b);
        }
    }

    @Override
    public boolean setCrawledLinkPriority(final List<Long> linkIds, int priority) {
        if (linkIds == null || linkIds.size() == 0) {
            return false;
        }
        final int size = linkIds.size();
        List<CrawledLink> lks = LinkCollector.getInstance().getChildrenByFilter(new AbstractPackageChildrenNodeFilter<CrawledLink>(){

            @Override
            public int returnMaxResults() {
                return size;
            }

            @Override
            public boolean acceptNode(CrawledLink node) {
                return linkIds.contains(node.getUniqueID().getID());
            }
        });
        if (lks.size() > 0) {
            for (CrawledLink cl : lks) {
                this.setPriority(priority, cl);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean setCrawledPackagePriority(long ID2, final int priority) {
        final CrawledPackage cp = this.getCrawledPackageFromID(ID2);
        if (cp != null) {
            cp.getModifyLock().runReadLock(new Runnable(){

                @Override
                public void run() {
                    for (CrawledLink link : cp.getChildren()) {
                        LinkCrawlerApi.this.setPriority(priority, link);
                    }
                }
            });
            return true;
        }
        return false;
    }

    @Override
    public boolean setCrawledLinkEnabled(final List<Long> linkIds, boolean enabled) {
        if (linkIds == null || linkIds.size() == 0) {
            return false;
        }
        final int size = linkIds.size();
        List<CrawledLink> lks = LinkCollector.getInstance().getChildrenByFilter(new AbstractPackageChildrenNodeFilter<CrawledLink>(){

            @Override
            public int returnMaxResults() {
                return size;
            }

            @Override
            public boolean acceptNode(CrawledLink node) {
                return linkIds.contains(node.getUniqueID().getID());
            }
        });
        if (lks.size() > 0) {
            for (CrawledLink cl : lks) {
                cl.setEnabled(enabled);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean setCrawledPackageEnabled(long ID2, final boolean enabled) {
        final CrawledPackage cp = this.getCrawledPackageFromID(ID2);
        if (cp == null) {
            return true;
        }
        cp.getModifyLock().runReadLock(new Runnable(){

            @Override
            public void run() {
                for (CrawledLink link : cp.getChildren()) {
                    link.setEnabled(enabled);
                }
            }
        });
        return true;
    }

    private void setPriority(int priority, CrawledLink cl) {
        cl.setPriority(Priority.getPriority(priority));
    }

    @Override
    public boolean CrawlLink(String URL2) {
        return this.lcAPI.addLinks(URL2, "", "", "");
    }

    @Override
    public boolean enableCrawledLink(final List<Long> linkIds, boolean enabled) {
        if (linkIds == null || linkIds.size() == 0) {
            return false;
        }
        final int size = linkIds.size();
        List<CrawledLink> lks = LinkCollector.getInstance().getChildrenByFilter(new AbstractPackageChildrenNodeFilter<CrawledLink>(){

            @Override
            public int returnMaxResults() {
                return size;
            }

            @Override
            public boolean acceptNode(CrawledLink node) {
                return linkIds.contains(node.getUniqueID().getID());
            }
        });
        if (lks.size() > 0) {
            for (CrawledLink cl : lks) {
                cl.setEnabled(enabled);
            }
            return true;
        }
        return false;
    }
}

