/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.linkcollector;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.controlling.linkcrawler.CrawledPackageView;
import jd.controlling.packagecontroller.AbstractNodeVisitor;
import jd.controlling.packagecontroller.AbstractPackageChildrenNodeFilter;
import org.appwork.remoteapi.APIQuery;
import org.appwork.storage.config.JsonConfig;
import org.jdownloader.api.linkcollector.CrawledLinkAPIStorable;
import org.jdownloader.api.linkcollector.CrawledPackageAPIStorable;
import org.jdownloader.api.linkcollector.LinkCollectorAPI;
import org.jdownloader.api.linkcollector.v2.AddLinksQueryStorable;
import org.jdownloader.api.linkcollector.v2.LinkCollectorAPIImplV2;
import org.jdownloader.gui.packagehistorycontroller.DownloadPathHistoryManager;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.components.packagetable.LinkTreeUtils;
import org.jdownloader.myjdownloader.client.json.AvailableLinkState;
import org.jdownloader.myjdownloader.client.json.JsonMap;
import org.jdownloader.settings.GeneralSettings;

@Deprecated
public class LinkCollectorAPIImpl
implements LinkCollectorAPI {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CrawledPackageAPIStorable> queryPackages(APIQuery queryParams) {
        ArrayList<CrawledPackageAPIStorable> result = new ArrayList<CrawledPackageAPIStorable>();
        LinkCollector lc = LinkCollector.getInstance();
        int startWith = queryParams._getStartAt();
        int maxResults = queryParams._getMaxResults();
        ArrayList<Object> packages = lc.getPackagesCopy();
        if (!((ArrayList)queryParams._getQueryParam("packageUUIDs", ArrayList.class, new ArrayList())).isEmpty()) {
            List requestedIds = (List)queryParams._getQueryParam("packageUUIDs", ArrayList.class, new ArrayList());
            ArrayList<CrawledPackage> toKeep = new ArrayList<CrawledPackage>();
            for (CrawledPackage crawledPackage : packages) {
                for (Long uuid : requestedIds) {
                    if (!uuid.equals(crawledPackage.getUniqueID().getID())) continue;
                    toKeep.add(crawledPackage);
                }
            }
            packages = toKeep;
        }
        if (startWith > packages.size() - 1) {
            return result;
        }
        if (startWith < 0) {
            startWith = 0;
        }
        if (maxResults < 0) {
            maxResults = packages.size();
        }
        for (int i = startWith; i < startWith + maxResults; ++i) {
            CrawledPackage pkg = (CrawledPackage)packages.get(i);
            boolean readL = pkg.getModifyLock().readLock();
            try {
                CrawledPackageAPIStorable crawledPackageAPIStorable = new CrawledPackageAPIStorable(pkg);
                CrawledPackageView view = new CrawledPackageView(pkg);
                view.aggregate();
                JsonMap infomap = new JsonMap();
                if (((Boolean)queryParams._getQueryParam("saveTo", Boolean.class, (Object)false)).booleanValue()) {
                    infomap.put("saveTo", LinkTreeUtils.getDownloadDirectory(pkg).toString());
                }
                if (((Boolean)queryParams._getQueryParam("size", Boolean.class, (Object)false)).booleanValue()) {
                    infomap.put("size", view.getFileSize());
                }
                if (((Boolean)queryParams._getQueryParam("childCount", Boolean.class, (Object)false)).booleanValue()) {
                    infomap.put("childCount", view.size());
                }
                if (((Boolean)queryParams._getQueryParam("hosts", Boolean.class, (Object)false)).booleanValue()) {
                    HashSet<String> hosts = new HashSet<String>();
                    for (CrawledLink crawledLink : pkg.getChildren()) {
                        hosts.add(crawledLink.getHost());
                    }
                    infomap.put("hosts", hosts);
                }
                if (((Boolean)queryParams._getQueryParam("availability", Boolean.class, (Object)false)).booleanValue()) {
                    String availabilityString = "";
                    int onlineCount = 0;
                    for (CrawledLink cl2 : pkg.getChildren()) {
                        if (!AvailableLinkState.ONLINE.equals((Object)cl2.getLinkState())) continue;
                        ++onlineCount;
                    }
                    availabilityString = onlineCount == pkg.getChildren().size() ? "ONLINE" : "UNKNOWN";
                    infomap.put("availability", availabilityString);
                }
                if (((Boolean)queryParams._getQueryParam("availabilityCount", Boolean.class, (Object)false)).booleanValue()) {
                    int onlineCount = 0;
                    for (CrawledLink crawledLink : pkg.getChildren()) {
                        if (AvailableLinkState.ONLINE.equals((Object)crawledLink.getLinkState())) {
                            ++onlineCount;
                        }
                        infomap.put("availabilityCount", onlineCount);
                    }
                }
                if (queryParams.fieldRequested("enabled").booleanValue()) {
                    boolean enabled = false;
                    for (CrawledLink crawledLink : pkg.getChildren()) {
                        if (!crawledLink.isEnabled()) continue;
                        enabled = true;
                        break;
                    }
                    infomap.put("enabled", enabled);
                }
                crawledPackageAPIStorable.setInfoMap(infomap);
                result.add(crawledPackageAPIStorable);
                if (i != packages.size() - 1) continue;
                break;
            }
            finally {
                pkg.getModifyLock().readUnlock(readL);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CrawledLinkAPIStorable> queryLinks(APIQuery queryParams) {
        int n;
        ArrayList<Object> matched;
        ArrayList<CrawledLinkAPIStorable> result = new ArrayList<CrawledLinkAPIStorable>();
        LinkCollector lc = LinkCollector.getInstance();
        HashSet<Long> packageUUIDs = new HashSet<Long>();
        if (!((List)queryParams._getQueryParam("packageUUIDs", List.class, new ArrayList())).isEmpty()) {
            List uuidsFromQuery = (List)queryParams._getQueryParam("packageUUIDs", List.class, new ArrayList());
            for (Iterator<Object> o : uuidsFromQuery) {
                try {
                    packageUUIDs.add((Long)((Object)o));
                }
                catch (ClassCastException classCastException) {}
            }
        }
        if (packageUUIDs.isEmpty()) {
            matched = lc.getPackagesCopy();
        } else {
            boolean b = lc.readLock();
            try {
                matched = new ArrayList();
                for (CrawledPackage crawledPackage : lc.getPackages()) {
                    if (!packageUUIDs.remove(crawledPackage.getUniqueID().getID())) continue;
                    matched.add(crawledPackage);
                    if (packageUUIDs.size() != 0) continue;
                    break;
                }
            }
            finally {
                lc.readUnlock(b);
            }
        }
        ArrayList<CrawledLink> links = new ArrayList<CrawledLink>();
        for (CrawledPackage crawledPackage : matched) {
            boolean readL = crawledPackage.getModifyLock().readLock();
            try {
                links.addAll(crawledPackage.getChildren());
            }
            finally {
                crawledPackage.getModifyLock().readUnlock(readL);
            }
        }
        if (links.isEmpty()) {
            return result;
        }
        int startWith = queryParams._getStartAt();
        int n2 = queryParams._getMaxResults();
        if (startWith > links.size() - 1) {
            return result;
        }
        if (startWith < 0) {
            startWith = 0;
        }
        if (n2 < 0) {
            n = links.size();
        }
        for (int i = startWith; i < Math.min(startWith + n, links.size()); ++i) {
            CrawledLink cl = (CrawledLink)links.get(i);
            CrawledLinkAPIStorable cls = new CrawledLinkAPIStorable(cl);
            JsonMap infomap = new JsonMap();
            if (((Boolean)queryParams._getQueryParam("size", Boolean.class, (Object)false)).booleanValue()) {
                infomap.put("size", cl.getSize());
            }
            if (((Boolean)queryParams._getQueryParam("host", Boolean.class, (Object)false)).booleanValue()) {
                infomap.put("host", cl.getHost());
            }
            if (((Boolean)queryParams._getQueryParam("availability", Boolean.class, (Object)false)).booleanValue()) {
                infomap.put("availability", cl.getLinkState().toString());
            }
            if (((Boolean)queryParams._getQueryParam("url", Boolean.class, (Object)false)).booleanValue()) {
                infomap.put("url", cl.getURL());
            }
            if (queryParams.fieldRequested("enabled").booleanValue()) {
                infomap.put("enabled", cl.isEnabled());
            }
            infomap.put("packageUUID", cl.getParentNode().getUniqueID().getID());
            cls.setInfoMap(infomap);
            result.add(cls);
        }
        return result;
    }

    @Override
    public int packageCount() {
        return LinkCollector.getInstance().getPackages().size();
    }

    @Override
    public Boolean addLinks(String links, String packageName, String extractPassword, String downloadPassword, String destinationFolder) {
        return this.addLinks(links, packageName, extractPassword, downloadPassword, destinationFolder, false);
    }

    @Override
    public Boolean addLinks(String links, String packageName, String extractPassword, String downloadPassword) {
        return this.addLinks(links, packageName, extractPassword, downloadPassword, null, false);
    }

    @Override
    public Boolean addLinksAndStartDownload(String links, String packageName, String extractPassword, String downloadPassword) {
        return this.addLinks(links, packageName, extractPassword, downloadPassword, null, true);
    }

    private Boolean addLinks(String links, String finalPackageName, String extractPassword, String downloadPassword, String destinationFolder, boolean autostart) {
        AddLinksQueryStorable query = new AddLinksQueryStorable();
        query.setAutostart(autostart);
        query.setDestinationFolder(destinationFolder);
        query.setDownloadPassword(downloadPassword);
        query.setLinks(links);
        query.setPackageName(finalPackageName);
        query.setExtractPassword(extractPassword);
        LinkCollectorAPIImplV2.add(query);
        return true;
    }

    @Override
    public Long getChildrenChanged(Long structureWatermark) {
        LinkCollector lc = LinkCollector.getInstance();
        if (lc.getChildrenChanges() != structureWatermark.longValue()) {
            return lc.getChildrenChanges();
        }
        return -1L;
    }

    @Override
    public Boolean startDownloads(List<Long> linkIds) {
        return this.startDownloads(linkIds, null);
    }

    @Override
    public Boolean startDownloads(List<Long> linkIds, List<Long> packageIds) {
        List<CrawledLink> lks = this.getAllTheLinks(linkIds, packageIds);
        if (lks.size() > 0) {
            LinkCollector.getInstance().moveLinksToDownloadList(new SelectionInfo<CrawledPackage, CrawledLink>(null, lks), new LinkCollector.ConfirmLinksSettings(LinkCollector.MoveLinksMode.MANUAL));
            return true;
        }
        return false;
    }

    @Override
    public Boolean removeLinks(List<Long> linkIds) {
        return this.removeLinks(linkIds, null);
    }

    @Override
    public Boolean removeLinks(List<Long> linkIds, List<Long> packageIds) {
        LinkCollector lc = LinkCollector.getInstance();
        lc.removeChildren(this.getAllTheLinks(linkIds, packageIds));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean renameLink(Long packageId, Long linkId, String newName) {
        LinkCollector lc = LinkCollector.getInstance();
        CrawledLink crawledLink = null;
        boolean readL = lc.readLock();
        try {
            for (CrawledPackage fp : lc.getPackages()) {
                if (packageId != null && !packageId.equals(fp.getUniqueID().getID())) continue;
                for (CrawledLink cl : fp.getChildren()) {
                    if (!linkId.equals(cl.getUniqueID().getID())) continue;
                    crawledLink = cl;
                    break;
                }
                if (packageId == null) {
                    if (crawledLink == null) continue;
                }
                break;
            }
        }
        finally {
            lc.readUnlock(readL);
        }
        if (crawledLink != null) {
            crawledLink.setName(newName);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean renamePackage(Long packageId, String newName) {
        LinkCollector lc = LinkCollector.getInstance();
        CrawledPackage pkg = null;
        boolean readL = lc.readLock();
        try {
            for (CrawledPackage fp : lc.getPackages()) {
                if (!packageId.equals(fp.getUniqueID().getID())) continue;
                pkg = fp;
                break;
            }
        }
        finally {
            lc.readUnlock(readL);
        }
        if (pkg != null) {
            pkg.setName(newName);
            return true;
        }
        return false;
    }

    @Override
    public boolean enableLinks(List<Long> linkIds) {
        if (linkIds == null) {
            return true;
        }
        return this.enableLinks(linkIds, null);
    }

    @Override
    public boolean enableLinks(List<Long> linkIds, List<Long> packageIds) {
        List<CrawledLink> sdl = this.getAllTheLinks(linkIds, packageIds);
        for (CrawledLink dl : sdl) {
            dl.setEnabled(true);
        }
        return true;
    }

    @Override
    public boolean disableLinks(List<Long> linkIds) {
        if (linkIds == null) {
            return true;
        }
        return this.disableLinks(linkIds, null);
    }

    @Override
    public boolean disableLinks(List<Long> linkIds, List<Long> packageIds) {
        List<CrawledLink> sdl = this.getAllTheLinks(linkIds, packageIds);
        for (CrawledLink dl : sdl) {
            dl.setEnabled(false);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean movePackages(APIQuery query) {
        List packageUUIDs = (List)query._getQueryParam("packageUUIDs", List.class, new ArrayList());
        Long afterDestPackageUUID = (Long)query._getQueryParam("afterDestPackageUUID", Long.class, null);
        LinkCollector dlc = LinkCollector.getInstance();
        ArrayList<CrawledPackage> selectedPackages = new ArrayList<CrawledPackage>();
        CrawledPackage afterDestPackage = null;
        boolean b = dlc.readLock();
        try {
            for (CrawledPackage fp : dlc.getPackages()) {
                if (packageUUIDs.contains(fp.getUniqueID().getID())) {
                    selectedPackages.add(fp);
                }
                if (afterDestPackageUUID == null || !afterDestPackageUUID.equals(fp.getUniqueID().getID())) continue;
                afterDestPackage = fp;
            }
        }
        finally {
            dlc.readUnlock(b);
        }
        dlc.move(selectedPackages, afterDestPackage);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean moveLinks(APIQuery query) {
        List selectedUUIDs = (List)query._getQueryParam("linkUUIDs", List.class, new ArrayList());
        Long afterDestLinkUUID = (Long)query._getQueryParam("afterDestLinkUUID", Long.class, (Object)-1L);
        Long targetPackageUUID = (Long)query._getQueryParam("destPackageUUID", Long.class, (Object)-1L);
        LinkCollector dlc = LinkCollector.getInstance();
        ArrayList<CrawledLink> selectedLinks = new ArrayList<CrawledLink>();
        CrawledLink afterDestLink = null;
        CrawledPackage destPackage = null;
        final ArrayList allLinks = new ArrayList();
        boolean b = dlc.readLock();
        try {
            for (final CrawledPackage cpkg : dlc.getPackages()) {
                cpkg.getModifyLock().runReadLock(new Runnable(){

                    @Override
                    public void run() {
                        allLinks.addAll(cpkg.getChildren());
                    }
                });
                if (destPackage == null || !targetPackageUUID.equals(cpkg.getUniqueID().getID())) continue;
                destPackage = cpkg;
            }
        }
        finally {
            dlc.readUnlock(b);
        }
        for (CrawledLink dl : allLinks) {
            if (selectedUUIDs.contains(dl.getUniqueID().getID())) {
                selectedLinks.add(dl);
            }
            if (afterDestLink != null || !afterDestLinkUUID.equals(dl.getUniqueID().getID())) continue;
            afterDestLink = dl;
        }
        dlc.move(selectedLinks, destPackage, afterDestLink);
        return true;
    }

    private List<CrawledLink> getAllTheLinks(final List<Long> linkIds, final List<Long> packageIds) {
        LinkCollector lc = LinkCollector.getInstance();
        final ArrayList<CrawledLink> ret = new ArrayList<CrawledLink>();
        if (linkIds != null) {
            final int size = linkIds.size();
            List<CrawledLink> lks = lc.getChildrenByFilter(new AbstractPackageChildrenNodeFilter<CrawledLink>(){

                @Override
                public int returnMaxResults() {
                    return size;
                }

                @Override
                public boolean acceptNode(CrawledLink node) {
                    return linkIds.contains(node.getUniqueID().getID());
                }
            });
            ret.addAll(lks);
        }
        if (packageIds != null) {
            lc.visitNodes(new AbstractNodeVisitor<CrawledLink, CrawledPackage>(){

                @Override
                public Boolean visitPackageNode(CrawledPackage pkg) {
                    return packageIds.contains(pkg.getUniqueID().getID());
                }

                @Override
                public Boolean visitChildrenNode(CrawledLink node) {
                    ret.add(node);
                    return Boolean.TRUE;
                }
            }, true);
        }
        return ret;
    }

    @Override
    public List<String> getDownloadFolderHistorySelectionBase() {
        return DownloadPathHistoryManager.getInstance().listPaths(((GeneralSettings)JsonConfig.create(GeneralSettings.class)).getDefaultDownloadFolder());
    }

    @Override
    public void addContainer(String type, String content) {
        LinkCollectorAPIImplV2.loadContainer(type, content);
    }
}

