/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.linkcollector;

import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import jd.controlling.linkcollector.LinkCollectingJob;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcollector.LinkCollectorCrawler;
import jd.controlling.linkcollector.LinkCollectorEvent;
import jd.controlling.linkcollector.LinkCollectorListener;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledLinkProperty;
import org.appwork.remoteapi.events.EventObject;
import org.appwork.remoteapi.events.EventPublisher;
import org.appwork.remoteapi.events.RemoteAPIEventsSender;
import org.appwork.remoteapi.events.SimpleEventObject;
import org.jdownloader.myjdownloader.client.bindings.PriorityStorable;

public class LinkCollectorEventPublisher
implements EventPublisher,
LinkCollectorListener {
    private final CopyOnWriteArraySet<RemoteAPIEventsSender> eventSenders = new CopyOnWriteArraySet();
    private final String[] eventIDs = new String[]{EVENTID.CONTENT_REMOVED.name(), EVENTID.DUPE_ADDED.name(), EVENTID.ABORT.name(), EVENTID.CONTENT_ADDED.name(), EVENTID.LINK_ADDED.name(), EVENTID.STRUCTURE_REFRESH.name(), EVENTID.LIST_LOADED.name(), EVENTID.DATA_REFRESH.name(), EVENTID.FILTERED_LINKS_EMPTY.name(), EVENTID.FILTERED_LINKS_AVAILABLE.name()};
    private static final String LINK_UPDATE_name = EVENTID.LINK_UPDATE.name() + ".name";
    private static final String LINK_UPDATE_enabled = EVENTID.LINK_UPDATE.name() + ".enabled";
    private static final String LINK_UPDATE_availability = EVENTID.LINK_UPDATE.name() + ".availability";
    private static final String LINK_UPDATE_priority = EVENTID.LINK_UPDATE.name() + ".priority";

    public String[] getPublisherEventIDs() {
        return this.eventIDs;
    }

    public String getPublisherName() {
        return "linkcollector";
    }

    private final boolean hasSubscriptionFor(String eventID) {
        if (this.eventSenders.size() > 0) {
            for (RemoteAPIEventsSender eventSender : this.eventSenders) {
                if (!eventSender.hasSubscriptionFor((EventPublisher)this, eventID)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void onLinkCollectorAbort(LinkCollectorEvent event) {
        this.sendEventID(EVENTID.ABORT);
    }

    private final void sendEventID(EVENTID eventid) {
        if (eventid != null && this.hasSubscriptionFor(eventid.name())) {
            SimpleEventObject eventObject = new SimpleEventObject((EventPublisher)this, eventid.name(), eventid.name());
            for (RemoteAPIEventsSender eventSender : this.eventSenders) {
                eventSender.publishEvent((EventObject)eventObject, null);
            }
        }
    }

    private void fire(String eventID, Object dls, String collapseKey) {
        if (eventID != null && this.hasSubscriptionFor(eventID)) {
            SimpleEventObject eventObject = new SimpleEventObject((EventPublisher)this, eventID, dls, collapseKey);
            for (RemoteAPIEventsSender eventSender : this.eventSenders) {
                eventSender.publishEvent((EventObject)eventObject, null);
            }
        }
    }

    @Override
    public void onLinkCollectorFilteredLinksAvailable(LinkCollectorEvent event) {
        this.sendEventID(EVENTID.FILTERED_LINKS_AVAILABLE);
    }

    @Override
    public void onLinkCollectorFilteredLinksEmpty(LinkCollectorEvent event) {
        this.sendEventID(EVENTID.FILTERED_LINKS_EMPTY);
    }

    @Override
    public void onLinkCollectorDataRefresh(LinkCollectorEvent event) {
        this.sendEventID(EVENTID.DATA_REFRESH);
        Object param = event.getParameter(1);
        if (param instanceof CrawledLinkProperty) {
            CrawledLinkProperty property = (CrawledLinkProperty)param;
            CrawledLink cl = property.getCrawledLink();
            switch (property.getProperty()) {
                case ENABLED: {
                    if (!this.hasSubscriptionFor(LINK_UPDATE_enabled)) break;
                    HashMap<String, Constable> dls = new HashMap<String, Constable>();
                    dls.put("uuid", Long.valueOf(cl.getUniqueID().getID()));
                    dls.put("enabled", Boolean.valueOf(cl.isEnabled()));
                    this.fire(LINK_UPDATE_enabled, dls, LINK_UPDATE_enabled + "." + cl.getUniqueID().getID());
                    break;
                }
                case NAME: {
                    if (!this.hasSubscriptionFor(LINK_UPDATE_name)) break;
                    HashMap<String, Object> dls = new HashMap<String, Object>();
                    dls.put("uuid", cl.getUniqueID().getID());
                    dls.put("name", cl.getName());
                    this.fire(LINK_UPDATE_name, dls, LINK_UPDATE_name + "." + cl.getUniqueID().getID());
                    break;
                }
                case AVAILABILITY: {
                    if (!this.hasSubscriptionFor(LINK_UPDATE_availability)) break;
                    HashMap<String, Object> dls = new HashMap<String, Object>();
                    dls.put("uuid", cl.getUniqueID().getID());
                    dls.put("availability", property.getValue());
                    this.fire(LINK_UPDATE_availability, dls, LINK_UPDATE_availability + "." + cl.getUniqueID().getID());
                    break;
                }
                case PRIORITY: {
                    if (!this.hasSubscriptionFor(LINK_UPDATE_priority)) break;
                    HashMap<String, Object> dls = new HashMap<String, Object>();
                    dls.put("uuid", cl.getUniqueID().getID());
                    dls.put("priority", (Object)PriorityStorable.get(cl.getPriorityEnum().name()));
                    this.fire(LINK_UPDATE_priority, dls, LINK_UPDATE_priority + "." + cl.getUniqueID().getID());
                    break;
                }
            }
        }
    }

    @Override
    public void onLinkCollectorStructureRefresh(LinkCollectorEvent event) {
        this.sendEventID(EVENTID.STRUCTURE_REFRESH);
    }

    @Override
    public void onLinkCollectorContentRemoved(LinkCollectorEvent event) {
        this.sendEventID(EVENTID.CONTENT_REMOVED);
    }

    @Override
    public void onLinkCollectorContentAdded(LinkCollectorEvent event) {
        this.sendEventID(EVENTID.CONTENT_ADDED);
    }

    @Override
    public void onLinkCollectorLinkAdded(LinkCollectorEvent event, CrawledLink parameter) {
        this.sendEventID(EVENTID.LINK_ADDED);
    }

    @Override
    public void onLinkCollectorDupeAdded(LinkCollectorEvent event, CrawledLink parameter) {
        this.sendEventID(EVENTID.DUPE_ADDED);
    }

    public synchronized void register(RemoteAPIEventsSender eventsAPI) {
        boolean wasEmpty = this.eventSenders.isEmpty();
        this.eventSenders.add(eventsAPI);
        if (wasEmpty && !this.eventSenders.isEmpty()) {
            LinkCollector.getInstance().getEventsender().addListener(this, true);
        }
    }

    public synchronized void unregister(RemoteAPIEventsSender eventsAPI) {
        this.eventSenders.remove(eventsAPI);
        if (this.eventSenders.isEmpty()) {
            LinkCollector.getInstance().getEventsender().removeListener(this);
        }
    }

    @Override
    public void onLinkCrawlerAdded(LinkCollectorCrawler parameter) {
    }

    @Override
    public void onLinkCrawlerStarted(LinkCollectorCrawler parameter) {
    }

    @Override
    public void onLinkCrawlerStopped(LinkCollectorCrawler parameter) {
    }

    @Override
    public void onLinkCrawlerNewJob(LinkCollectingJob job) {
    }

    @Override
    public void onLinkCrawlerFinished() {
    }

    private static enum EVENTID {
        CONTENT_ADDED,
        LINK_ADDED,
        LINK_UPDATE,
        STRUCTURE_REFRESH,
        LIST_LOADED,
        DATA_REFRESH,
        FILTERED_LINKS_EMPTY,
        FILTERED_LINKS_AVAILABLE,
        ABORT,
        DUPE_ADDED,
        CONTENT_REMOVED;

    }
}

