/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.linkcrawler;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import jd.controlling.linkcollector.LinkCollectingJob;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.controlling.linkcrawler.LinkCrawler;
import jd.controlling.linkcrawler.LinkCrawlerEvent;
import jd.controlling.linkcrawler.LinkCrawlerListener;
import org.appwork.remoteapi.events.EventObject;
import org.appwork.remoteapi.events.EventPublisher;
import org.appwork.remoteapi.events.RemoteAPIEventsSender;
import org.appwork.remoteapi.events.SimpleEventObject;
import org.appwork.utils.event.queue.Queue;
import org.appwork.utils.event.queue.QueueAction;

public class LinkCrawlerEventPublisher
implements EventPublisher,
LinkCrawlerListener {
    private final CopyOnWriteArraySet<RemoteAPIEventsSender> eventSenders = new CopyOnWriteArraySet();
    private final String[] eventIDs;
    private final Queue queue = new Queue("LinkCrawlerEventPublisher"){

        public void killQueue() {
        }
    };

    public LinkCrawlerEventPublisher() {
        this.eventIDs = new String[]{EVENTID.STARTED.name(), EVENTID.STOPPED.name(), EVENTID.FINISHED.name()};
    }

    private final boolean hasSubscriptionFor(String eventID) {
        if (this.eventSenders.size() > 0) {
            for (RemoteAPIEventsSender eventSender : this.eventSenders) {
                if (!eventSender.hasSubscriptionFor((EventPublisher)this, eventID)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void onLinkCrawlerEvent(final LinkCrawlerEvent event) {
        if (this.hasSubscriptionFor(((LinkCrawlerEvent.Type)((Object)event.getType())).name())) {
            this.queue.add((QueueAction)new QueueAction<Void, RuntimeException>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected Void run() throws RuntimeException {
                    HashMap<String, Number> dls = new HashMap<String, Number>();
                    LinkCrawler crawler = (LinkCrawler)event.getCaller();
                    dls.put("crawlerId", crawler.getUniqueAlltimeID().getID());
                    if (event.getCaller() instanceof LinkCollector.JobLinkCrawler) {
                        LinkCollector.JobLinkCrawler jobCrawler = (LinkCollector.JobLinkCrawler)crawler;
                        LinkCollectingJob job = ((LinkCollector.JobLinkCrawler)crawler).getJob();
                        if (job != null) {
                            dls.put("jobId", job.getUniqueAlltimeID().getID());
                            if (LinkCrawlerEvent.Type.STOPPED.equals(event.getType())) {
                                List<CrawledLink> linklist = jobCrawler.getCrawledLinks();
                                HashSet<CrawledPackage> dupe = new HashSet<CrawledPackage>();
                                int offlineCnt = 0;
                                int onlineCnt = 0;
                                List<CrawledLink> list = linklist;
                                synchronized (list) {
                                    for (CrawledLink cl : linklist) {
                                        dupe.add(cl.getParentNode());
                                        switch (cl.getLinkState()) {
                                            case OFFLINE: {
                                                ++offlineCnt;
                                                break;
                                            }
                                            case ONLINE: {
                                                ++onlineCnt;
                                            }
                                        }
                                    }
                                }
                                dls.put("packages", dupe.size());
                                dls.put("links", jobCrawler.getCrawledLinksFoundCounter());
                                dls.put("online", onlineCnt);
                                dls.put("offline", offlineCnt);
                            }
                        }
                    }
                    SimpleEventObject eventObject = new SimpleEventObject((EventPublisher)LinkCrawlerEventPublisher.this, ((LinkCrawlerEvent.Type)((Object)event.getType())).name(), dls);
                    for (RemoteAPIEventsSender eventSender : LinkCrawlerEventPublisher.this.eventSenders) {
                        eventSender.publishEvent((EventObject)eventObject, null);
                    }
                    return null;
                }
            });
        }
    }

    public String[] getPublisherEventIDs() {
        return this.eventIDs;
    }

    public String getPublisherName() {
        return "linkcrawler";
    }

    public void register(RemoteAPIEventsSender eventsAPI) {
        boolean wasEmpty = this.eventSenders.isEmpty();
        this.eventSenders.add(eventsAPI);
        if (wasEmpty && !this.eventSenders.isEmpty()) {
            LinkCrawler.getGlobalEventSender().addListener(this, true);
        }
    }

    public void unregister(RemoteAPIEventsSender eventsAPI) {
        this.eventSenders.remove(eventsAPI);
        if (this.eventSenders.isEmpty()) {
            LinkCrawler.getGlobalEventSender().removeListener(this);
        }
    }

    private static enum EVENTID {
        STARTED,
        STOPPED,
        FINISHED;

    }
}

