/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.logs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import org.appwork.exceptions.WTFException;
import org.appwork.remoteapi.exceptions.BadParameterException;
import org.appwork.utils.Application;
import org.appwork.utils.Files;
import org.appwork.utils.IO;
import org.appwork.utils.logging2.LogSink;
import org.appwork.utils.logging2.LogSourceProvider;
import org.appwork.utils.logging2.sendlogs.AbstractLogAction;
import org.appwork.utils.logging2.sendlogs.LogFolder;
import org.appwork.utils.zip.ZipIOException;
import org.appwork.utils.zip.ZipIOWriter;
import org.jdownloader.api.logs.LogAPI;
import org.jdownloader.api.logs.LogFolderStorable;
import org.jdownloader.jdserv.JDServUtils;
import org.jdownloader.logging.LogController;
import org.jdownloader.startup.commands.ThreadDump;

public class LogAPIImpl
implements LogAPI {
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd.MM.yy HH.mm.ss", Locale.GERMANY);

    @Override
    public List<LogFolderStorable> getAvailableLogs() {
        new ThreadDump().run(null, new String[0]);
        ArrayList folders = AbstractLogAction.getLogFolders();
        ArrayList<LogFolderStorable> result = new ArrayList<LogFolderStorable>();
        for (LogFolder folder : folders) {
            if (this.isCurrentLogFolder(folder.getCreated())) {
                folder.setCurrent(true);
                folder.setNeedsFlush(true);
                result.add(0, new LogFolderStorable(folder));
                continue;
            }
            result.add(new LogFolderStorable(folder));
        }
        return result;
    }

    private boolean isCurrentLogFolder(long timestamp) {
        long startup = LogController.getInstance().getInitTime();
        return startup == timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String sendLogFile(LogFolderStorable[] selectedFolders) throws BadParameterException {
        if (selectedFolders == null || selectedFolders.length == 0) {
            throw new BadParameterException("selection empty or null");
        }
        ArrayList availableLogFolders = AbstractLogAction.getLogFolders();
        final ArrayList<LogFolder> logFoldersToSend = new ArrayList<LogFolder>();
        block5: for (LogFolderStorable selectedFolder : selectedFolders) {
            for (LogFolder availableLogFolder : availableLogFolders) {
                if (!this.isCurrentLogFolder(availableLogFolder.getCreated()) && (availableLogFolder.getCreated() != selectedFolder.getCreated() || availableLogFolder.getLastModified() < selectedFolder.getLastModified())) continue;
                logFoldersToSend.add(availableLogFolder);
                continue block5;
            }
        }
        if (!logFoldersToSend.isEmpty()) {
            LogSourceProvider.flushAllSinks((LogSink.FLUSH)LogSink.FLUSH.FORCE);
            final AtomicReference<Object> logIDRef = new AtomicReference<Object>(null);
            Thread uploadThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    Object object;
                    String logID = null;
                    File zip = null;
                    try {
                        object = logFoldersToSend.iterator();
                        while (object.hasNext()) {
                            LogFolder logFolder = (LogFolder)object.next();
                            if (zip != null) {
                                zip.delete();
                            }
                            if ((logID = JDServUtils.uploadLog(zip = LogAPIImpl.this.createPackage(logFolder), logID)) == null || logIDRef.get() != null) continue;
                            AtomicReference atomicReference = logIDRef;
                            // MONITORENTER : atomicReference
                            logIDRef.set(logID);
                            logIDRef.notify();
                            // MONITOREXIT : atomicReference
                        }
                        return;
                    }
                    catch (Throwable th) {
                        LogController.CL().log(th);
                        return;
                    }
                    finally {
                        object = logIDRef;
                    }
                }
            }, "LogAPIImpl:sendLogFile");
            uploadThread.setDaemon(true);
            uploadThread.start();
            AtomicReference<Object> atomicReference = logIDRef;
            synchronized (atomicReference) {
                if (uploadThread.isAlive() && logIDRef.get() == null) {
                    try {
                        logIDRef.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                return logIDRef.get();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createPackage(LogFolder lf) throws Exception {
        File zip = Application.getTempResource((String)("logs/logPackage" + System.currentTimeMillis() + ".zip"));
        zip.delete();
        zip.getParentFile().mkdirs();
        ZipIOWriter writer = null;
        try {
            writer = new ZipIOWriter(zip){

                public void addFile(File addFile, boolean compress, String fullPath) throws FileNotFoundException, ZipIOException, IOException {
                    if (addFile.getName().endsWith(".lck") || addFile.isFile() && addFile.length() == 0L) {
                        return;
                    }
                    if (Thread.currentThread().isInterrupted()) {
                        throw new WTFException("INterrupted");
                    }
                    super.addFile(addFile, compress, fullPath);
                }
            };
            String name = lf.getFolder().getName() + "-" + DATE_FORMAT.format(lf.getCreated()) + " to " + DATE_FORMAT.format(lf.getLastModified());
            File folder = Application.getTempResource((String)("logs/" + name));
            if (lf.isNeedsFlush()) {
                LogController.getInstance().flushSinks(LogSink.FLUSH.FORCE);
            }
            if (folder.exists()) {
                Files.deleteRecursiv((File)folder);
            }
            IO.copyFolderRecursive((File)lf.getFolder(), (File)folder, (boolean)true);
            writer.addDirectory(folder, true, null);
        }
        finally {
            try {
                writer.close();
            }
            catch (Throwable throwable) {}
        }
        return zip;
    }
}

