/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.myjdownloader;

import java.io.File;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.LogRecord;
import jd.controlling.reconnect.Reconnecter;
import jd.controlling.reconnect.ReconnecterEvent;
import jd.controlling.reconnect.ReconnecterListener;
import jd.controlling.reconnect.ipcheck.BalancedWebIPCheck;
import jd.controlling.reconnect.ipcheck.IPCheckException;
import jd.controlling.reconnect.ipcheck.OfflineException;
import org.appwork.exceptions.WTFException;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.storage.config.handler.StorageHandler;
import org.appwork.utils.Application;
import org.appwork.utils.Hash;
import org.appwork.utils.NullsafeAtomicReference;
import org.appwork.utils.StringUtils;
import org.appwork.utils.formatter.HexFormatter;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.net.httpconnection.SocketStreamInterface;
import org.appwork.utils.net.httpserver.requests.HTTPBridge;
import org.appwork.utils.net.httpserver.requests.HttpRequest;
import org.appwork.utils.net.httpserver.responses.HttpResponse;
import org.appwork.utils.os.ContainerRuntime;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.api.myjdownloader.MyJDownloaderConnectionStatus;
import org.jdownloader.api.myjdownloader.MyJDownloaderController;
import org.jdownloader.api.myjdownloader.MyJDownloaderDirectServer;
import org.jdownloader.api.myjdownloader.MyJDownloaderHttpConnection;
import org.jdownloader.api.myjdownloader.MyJDownloaderSettings;
import org.jdownloader.api.myjdownloader.MyJDownloaderWaitingConnectionThread;
import org.jdownloader.api.myjdownloader.SessionInfoStorable;
import org.jdownloader.api.myjdownloader.api.MyJDownloaderAPI;
import org.jdownloader.myjdownloader.client.MyJDCaptchasClient;
import org.jdownloader.myjdownloader.client.SessionInfo;
import org.jdownloader.myjdownloader.client.exceptions.AuthException;
import org.jdownloader.myjdownloader.client.exceptions.MyJDownloaderException;
import org.jdownloader.myjdownloader.client.exceptions.TokenException;
import org.jdownloader.myjdownloader.client.exceptions.UnconnectedException;
import org.jdownloader.myjdownloader.client.json.DeviceConnectionStatus;
import org.jdownloader.myjdownloader.client.json.DeviceData;
import org.jdownloader.myjdownloader.client.json.MyCaptchaChallenge;
import org.jdownloader.myjdownloader.client.json.MyCaptchaSolution;
import org.jdownloader.myjdownloader.client.json.NotificationRequestMessage;
import org.jdownloader.myjdownloader.client.json.SessionInfoResponse;
import org.jdownloader.settings.staticreferences.CFG_MYJD;

public class MyJDownloaderConnectThread
extends Thread
implements HTTPBridge,
ReconnecterListener {
    protected final AtomicLong THREADCOUNTER = new AtomicLong(0L);
    private final MyJDownloaderController myJDownloaderController;
    private volatile MyJDownloaderAPI api = null;
    private final LogSource logger;
    private final AtomicLong syncMark = new AtomicLong(Integer.MIN_VALUE);
    private ScheduledExecutorService THREADQUEUE = DelayedRunnable.getNewScheduledExecutorService();
    private final DeviceConnectionHelper[] deviceConnectionHelper;
    private int helperIndex = 0;
    private final NullsafeAtomicReference<MyJDownloaderConnectionStatus> connected = new NullsafeAtomicReference((Object)MyJDownloaderConnectionStatus.UNCONNECTED);
    private String password;
    private String email;
    private String deviceName;
    private final Set<NotificationRequestMessage.TYPE> notifyInterests = new CopyOnWriteArraySet<NotificationRequestMessage.TYPE>();
    private static final HashMap<Thread, SocketStreamInterface> openConnections = new HashMap();
    private static final HashMap<String, AtomicLong> KNOWNSESSIONS = new HashMap();
    private final ArrayDeque<MyJDownloaderWaitingConnectionThread.MyJDownloaderConnectionResponse> responses = new ArrayDeque();
    private final ArrayList<MyJDownloaderWaitingConnectionThread> waitingConnections = new ArrayList();
    private final int minimumWaitingConnections = 1;
    private final int maximumWaitingConnections = 4;
    private final File sessionInfoCache = Application.getTempResource((String)"myjd.session");
    private final MyJDownloaderDirectServer directServer;
    private final AtomicBoolean challengeExchangeEnabled = new AtomicBoolean(false);
    private final boolean debugEnabled;
    private static final long SESSION_REVALIDATE_TIMEOUT = 1800000L;
    private static final Object SESSIONLOCK = new Object();
    private final HashMap<NotificationRequestMessage.TYPE, AtomicLong> notificationMarks = new HashMap();

    public LogSource getLogger() {
        return this.logger;
    }

    public MyJDownloaderDirectServer getDirectServer() {
        return this.directServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSessionValid(String sessionToken) {
        long currentTimeMillis = System.currentTimeMillis();
        HashMap<String, AtomicLong> hashMap = KNOWNSESSIONS;
        synchronized (hashMap) {
            AtomicLong validUntil = KNOWNSESSIONS.get(sessionToken);
            if (validUntil == null || currentTimeMillis > Math.abs(validUntil.get())) {
                Boolean valid = this.validateSession(sessionToken);
                if (validUntil == null) {
                    validUntil = new AtomicLong(-1L);
                    KNOWNSESSIONS.put(sessionToken, validUntil);
                }
                if (valid == null) {
                    validUntil.set(currentTimeMillis + 60000L);
                } else if (Boolean.TRUE.equals(valid)) {
                    validUntil.set(currentTimeMillis + 1800000L);
                } else {
                    validUntil.set(-(currentTimeMillis + 60000L));
                }
            }
            if (validUntil.get() > currentTimeMillis) {
                if (validUntil.get() - currentTimeMillis > 60000L) {
                    validUntil.set(currentTimeMillis + 1800000L);
                }
                return true;
            }
            return false;
        }
    }

    protected static HashMap<Thread, SocketStreamInterface> getOpenconnections() {
        return openConnections;
    }

    public long getRetryTimeStamp() {
        long ret = -1L;
        for (DeviceConnectionHelper helper : this.deviceConnectionHelper) {
            long retry = helper.getRetryTimeStamp();
            if (retry > 0L) {
                if (ret != -1L && retry >= ret) continue;
                ret = retry;
                continue;
            }
            if (!helper.isMarked()) continue;
            return -1L;
        }
        return ret;
    }

    public MyJDownloaderConnectThread(MyJDownloaderController myJDownloaderExtension) {
        this.setName("MyJDownloaderConnectThread");
        this.setDaemon(true);
        this.myJDownloaderController = myJDownloaderExtension;
        this.debugEnabled = CFG_MYJD.CFG.isDebugEnabled();
        this.logger = this.debugEnabled ? myJDownloaderExtension.getLogger() : new LogSource("Dummy"){

            public synchronized void clear() {
            }

            public synchronized void log(LogRecord record) {
            }
        };
        this.api = new MyJDownloaderAPI(){

            @Override
            protected SessionInfo createSessionInfo(byte[] deviceSecret, byte[] serverEncryptionToken, byte[] deviceEncryptionToken, String sessionToken, String regainToken) {
                return new SessionInfoWrapper(deviceSecret, serverEncryptionToken, deviceEncryptionToken, sessionToken, regainToken);
            }

            @Override
            public LogSource getLogger() {
                return MyJDownloaderConnectThread.this.getLogger();
            }
        };
        ArrayList<DeviceConnectionHelper> helper = new ArrayList<DeviceConnectionHelper>();
        for (int port : CFG_MYJD.CFG.getDeviceConnectPorts()) {
            helper.add(new DeviceConnectionHelper(this, port, CFG_MYJD.CFG.getServerHost()));
        }
        Reconnecter.getInstance().getEventSender().addListener(this, true);
        this.deviceConnectionHelper = helper.toArray(new DeviceConnectionHelper[helper.size()]);
        this.loadSessionInfo();
        MyJDownloaderSettings.DIRECTMODE mode = CFG_MYJD.CFG.getDirectConnectMode();
        if (mode == null) {
            mode = MyJDownloaderSettings.DIRECTMODE.NONE;
        }
        switch (CFG_MYJD.CFG.getDirectConnectMode()) {
            case LAN: 
            case LAN_WAN_MANUAL: 
            case LAN_WAN_UPNP: {
                this.directServer = new MyJDownloaderDirectServer(this, mode);
                break;
            }
            default: {
                this.directServer = null;
            }
        }
    }

    public MyJDownloaderController getMyJDownloaderController() {
        return this.myJDownloaderController;
    }

    public MyJDownloaderAPI getApi() {
        return this.api;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putResponse(MyJDownloaderWaitingConnectionThread.MyJDownloaderConnectionResponse response) {
        AbstractCollection abstractCollection = this.waitingConnections;
        synchronized (abstractCollection) {
            if (this.waitingConnections.size() == 0) {
                return false;
            }
        }
        abstractCollection = this.responses;
        synchronized (abstractCollection) {
            if (response != null) {
                this.responses.add(response);
            }
            this.responses.notify();
        }
        return true;
    }

    protected void log(String message) {
        if (this.debugEnabled) {
            this.logger.info(message);
        }
    }

    protected void log(String message, Throwable throwable) {
        if (this.debugEnabled) {
            this.logger.info(message);
            this.logger.log(throwable);
        }
    }

    protected void log(Throwable throwable) {
        if (this.debugEnabled) {
            this.logger.log(throwable);
        }
    }

    private synchronized DeviceConnectionHelper getNextDeviceConnectionHelper() {
        DeviceConnectionHelper ret2;
        DeviceConnectionHelper ret = this.deviceConnectionHelper[this.helperIndex];
        this.helperIndex = (this.helperIndex + 1) % this.deviceConnectionHelper.length;
        if (ret.backoffrequested() && !(ret2 = this.deviceConnectionHelper[this.helperIndex]).backoffrequested()) {
            return ret2;
        }
        return ret;
    }

    public boolean isConnected() {
        return this.connected.get() == MyJDownloaderConnectionStatus.CONNECTED && this.isAlive();
    }

    private boolean isConnectionOffline(DeviceConnectionHelper connectionHelper) {
        BalancedWebIPCheck onlineCheck = new BalancedWebIPCheck();
        try {
            onlineCheck.getExternalIP();
        }
        catch (OfflineException e2) {
            this.log("Could not connect! NO Internet!");
            return true;
        }
        catch (IPCheckException iPCheckException) {
            // empty catch block
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private DeviceConnectionStatus handleResponse(MyJDownloaderWaitingConnectionThread.MyJDownloaderConnectionResponse response, SessionInfoWrapper currentSession) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 35[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setConnectionStatus(DeviceConnectionHelper connection, MyJDownloaderConnectionStatus status, MyJDownloaderSettings.MyJDownloaderError error) {
        if (status != null && this.connected.getAndSet((Object)status) != status) {
            this.myJDownloaderController.fireConnectionStatusChanged(status, this.getEstablishedConnections());
        }
        if (error != null) {
            if (connection != null) {
                switch (error) {
                    case NO_INTERNET_CONNECTION: {
                        connection.requestbackoff(10);
                        break;
                    }
                    case SERVER_MAINTENANCE: 
                    case SERVER_DOWN: {
                        connection.requestbackoff(5);
                        break;
                    }
                    case SERVER_OVERLOAD: {
                        connection.requestbackoff(2);
                        break;
                    }
                    default: {
                        connection.requestbackoff();
                    }
                }
            }
            this.myJDownloaderController.onError(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MyJDownloaderWaitingConnectionThread.MyJDownloaderConnectionResponse pollResponse(boolean wait) throws InterruptedException {
        ArrayDeque<MyJDownloaderWaitingConnectionThread.MyJDownloaderConnectionResponse> arrayDeque = this.responses;
        synchronized (arrayDeque) {
            MyJDownloaderWaitingConnectionThread.MyJDownloaderConnectionResponse response = this.responses.poll();
            if (response == null && wait) {
                this.responses.wait();
                return this.responses.poll();
            }
            return response;
        }
    }

    private final boolean isEstablishingConnection() {
        return this.myJDownloaderController.getConnectThread() == this && this.getApi() != null;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void setEstablishedConnections(int connections) {
        this.myJDownloaderController.fireConnectionStatusChanged((MyJDownloaderConnectionStatus)((Object)this.connected.get()), connections);
    }

    private void sync(final long nextSyncMark, final SessionInfoWrapper session) {
        if (this.syncMark.getAndSet(nextSyncMark) == nextSyncMark) {
            return;
        }
        ScheduledExecutorService lTHREADQUEUE = this.THREADQUEUE;
        if (lTHREADQUEUE != null) {
            lTHREADQUEUE.execute(new Runnable(){

                @Override
                public void run() {
                    boolean failed = true;
                    try {
                        MyJDownloaderAPI lapi = MyJDownloaderConnectThread.this.getApi();
                        if (lapi == null) {
                            return;
                        }
                        if (lapi.getSessionInfo() != session) {
                            return;
                        }
                        if (!SessionInfoWrapper.STATE.VALID.equals((Object)session.getState())) {
                            return;
                        }
                        if (MyJDownloaderConnectThread.this.syncMark.get() != nextSyncMark) {
                            return;
                        }
                        MyJDCaptchasClient<Type> captchaClient = new MyJDCaptchasClient<Type>(lapi);
                        MyJDownloaderConnectThread.this.challengeExchangeEnabled.set(captchaClient.isEnabled());
                        NotificationRequestMessage.TYPE[] deviceNotifications = lapi.listrequesteddevicesnotifications();
                        HashSet<NotificationRequestMessage.TYPE> notifyTypes = deviceNotifications != null ? new HashSet<NotificationRequestMessage.TYPE>(Arrays.asList(deviceNotifications)) : new HashSet();
                        MyJDownloaderConnectThread.this.setNotifyTypes(notifyTypes);
                        failed = false;
                    }
                    catch (TokenException e) {
                        session.compareAndSetState(SessionInfoWrapper.STATE.VALID, SessionInfoWrapper.STATE.RECONNECT);
                    }
                    catch (UnconnectedException e) {
                    }
                    catch (Throwable e) {
                        MyJDownloaderConnectThread.this.log(e);
                    }
                    if (failed) {
                        MyJDownloaderConnectThread.this.syncMark.compareAndSet(nextSyncMark, Integer.MIN_VALUE);
                    }
                }
            });
        }
    }

    protected void setNotifyTypes(HashSet<NotificationRequestMessage.TYPE> notifyTypes) {
        this.notifyInterests.clear();
        if (notifyTypes != null) {
            this.notifyInterests.addAll(notifyTypes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNotificationMark(NotificationRequestMessage.TYPE type) {
        HashMap<NotificationRequestMessage.TYPE, AtomicLong> hashMap = this.notificationMarks;
        synchronized (hashMap) {
            AtomicLong mark = this.notificationMarks.get((Object)type);
            if (mark == null) {
                mark = new AtomicLong();
                this.notificationMarks.put(type, mark);
            }
            return mark.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkNotificationMark(NotificationRequestMessage.TYPE type, long notificationMark) {
        HashMap<NotificationRequestMessage.TYPE, AtomicLong> hashMap = this.notificationMarks;
        synchronized (hashMap) {
            AtomicLong mark = this.notificationMarks.get((Object)type);
            if (mark != null) {
                return notificationMark == mark.get();
            }
            return false;
        }
    }

    protected void pushNotification(final NotificationRequestMessage.TYPE type, final boolean requested) {
        if (!this.notifyInterests.contains((Object)type) || this.getApi() == null) {
            return;
        }
        final long currentMark = this.getNotificationMark(type);
        ScheduledExecutorService lTHREADQUEUE = this.THREADQUEUE;
        if (lTHREADQUEUE != null) {
            lTHREADQUEUE.execute(new Runnable(){

                @Override
                public void run() {
                    SessionInfoWrapper session = null;
                    try {
                        MyJDownloaderAPI lapi = MyJDownloaderConnectThread.this.getApi();
                        if (lapi == null) {
                            return;
                        }
                        if (!MyJDownloaderConnectThread.this.notifyInterests.contains((Object)type)) {
                            return;
                        }
                        session = (SessionInfoWrapper)lapi.getSessionInfo();
                        if (!SessionInfoWrapper.STATE.VALID.equals((Object)session.getState())) {
                            return;
                        }
                        if (!MyJDownloaderConnectThread.this.checkNotificationMark(type, currentMark)) {
                            return;
                        }
                        NotificationRequestMessage message = new NotificationRequestMessage();
                        message.setType(type);
                        message.setRequested(requested);
                        if (!lapi.pushNotification(message)) {
                            MyJDownloaderConnectThread.this.removeInterest(type);
                        }
                    }
                    catch (TokenException e) {
                        if (session != null) {
                            session.compareAndSetState(SessionInfoWrapper.STATE.VALID, SessionInfoWrapper.STATE.RECONNECT);
                        }
                    }
                    catch (UnconnectedException e) {
                    }
                    catch (Throwable e) {
                        MyJDownloaderConnectThread.this.log(e);
                    }
                }
            });
        }
    }

    protected void pushCaptchaNotification(boolean requested) {
        this.pushNotification(NotificationRequestMessage.TYPE.CAPTCHA, requested);
    }

    protected void removeInterest(NotificationRequestMessage.TYPE captcha) {
        this.notifyInterests.remove((Object)captcha);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleConnection(final SocketStreamInterface clientSocket) {
        long requestNumber = this.THREADCOUNTER.incrementAndGet();
        Thread connectionThread = new Thread("MyJDownloaderConnection:" + requestNumber){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object httpConnection2;
                try {
                    httpConnection2 = new MyJDownloaderHttpConnection(clientSocket, MyJDownloaderConnectThread.this.getApi());
                    httpConnection2.run();
                }
                catch (Throwable e) {
                    MyJDownloaderConnectThread.this.log(e);
                }
                finally {
                    try {
                        clientSocket.close();
                    }
                    catch (Throwable httpConnection2) {}
                    httpConnection2 = openConnections;
                    synchronized (httpConnection2) {
                        openConnections.remove(Thread.currentThread());
                    }
                    MyJDownloaderConnectThread.this.setEstablishedConnections(MyJDownloaderConnectThread.this.getEstablishedConnections());
                }
            }
        };
        HashMap<Thread, SocketStreamInterface> hashMap = openConnections;
        synchronized (hashMap) {
            openConnections.put(connectionThread, clientSocket);
        }
        this.setEstablishedConnections(this.getEstablishedConnections());
        connectionThread.setDaemon(true);
        connectionThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminateWaitingConnections() {
        ArrayList<MyJDownloaderWaitingConnectionThread> copy = null;
        ArrayDeque<MyJDownloaderWaitingConnectionThread.MyJDownloaderConnectionResponse> arrayDeque = this.waitingConnections;
        synchronized (arrayDeque) {
            copy = new ArrayList<MyJDownloaderWaitingConnectionThread>(this.waitingConnections);
            this.waitingConnections.clear();
        }
        for (MyJDownloaderWaitingConnectionThread thread : copy) {
            thread.abort();
        }
        arrayDeque = this.responses;
        synchronized (arrayDeque) {
            MyJDownloaderWaitingConnectionThread.MyJDownloaderConnectionResponse next = null;
            while ((next = this.responses.poll()) != null) {
                try {
                    SocketStreamInterface socket = next.getSocketStream();
                    if (socket == null) continue;
                    socket.close();
                }
                catch (Throwable throwable) {}
            }
            this.responses.notifyAll();
        }
    }

    private void disconnectSession(MyJDownloaderAPI api, SessionInfoWrapper session) {
        if (api != null) {
            try {
                if (session == null) {
                    session = (SessionInfoWrapper)api.getSessionInfo();
                }
                session.setState(SessionInfoWrapper.STATE.INVALID);
                if (api.getSessionInfo() == session) {
                    this.terminateSession(session);
                }
            }
            catch (UnconnectedException e) {
                return;
            }
            catch (MyJDownloaderException e1) {
                this.log(e1);
            }
        }
    }

    private void setApi(MyJDownloaderAPI api) {
        this.api = api;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Reconnecter.getInstance().getEventSender().removeListener(this);
        this.notifyInterests.clear();
        this.challengeExchangeEnabled.set(false);
        try {
            MyJDownloaderAPI lapi = this.getApi();
            this.setApi(null);
            Cloneable cloneable = this.responses;
            synchronized (cloneable) {
                this.responses.notifyAll();
            }
            this.terminateWaitingConnections();
            this.disconnectSession(lapi, null);
            cloneable = openConnections;
            synchronized (cloneable) {
                for (Map.Entry<Thread, SocketStreamInterface> next : openConnections.entrySet()) {
                    try {
                        next.getValue().close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            this.setConnectionStatus(null, MyJDownloaderConnectionStatus.UNCONNECTED, MyJDownloaderSettings.MyJDownloaderError.NONE);
            ScheduledExecutorService lTHREADQUEUE = this.THREADQUEUE;
            this.THREADQUEUE = null;
            if (lTHREADQUEUE != null) {
                lTHREADQUEUE.shutdownNow();
            }
        }
        finally {
            this.notifyInterests.clear();
            this.challengeExchangeEnabled.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startWaitingConnections(boolean minimumORmaximum) {
        int max = 1;
        if (minimumORmaximum) {
            max = 4;
        }
        ArrayList<MyJDownloaderWaitingConnectionThread> arrayList = this.waitingConnections;
        synchronized (arrayList) {
            int index;
            for (index = this.waitingConnections.size() - 1; index >= 0; --index) {
                MyJDownloaderWaitingConnectionThread thread = this.waitingConnections.get(index);
                if (!thread.isRunning()) {
                    this.waitingConnections.remove(index);
                    continue;
                }
                thread.abort();
            }
            for (index = this.waitingConnections.size(); index < max; ++index) {
                this.startWaitingConnectionThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startWaitingConnectionThread() {
        ArrayList<MyJDownloaderWaitingConnectionThread> arrayList = this.waitingConnections;
        synchronized (arrayList) {
            MyJDownloaderWaitingConnectionThread thread = new MyJDownloaderWaitingConnectionThread(this);
            this.waitingConnections.add(thread);
            thread.start();
        }
    }

    private SessionInfoWrapper validateSession(SessionInfoWrapper session) {
        this.saveSessionInfo(session);
        this.startWaitingConnections(false);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSessionInfo(SessionInfoWrapper session) {
        Object object = SESSIONLOCK;
        synchronized (object) {
            try {
                if ((session == null || SessionInfoWrapper.STATE.INVALID.equals((Object)session.getState())) && this.sessionInfoCache.exists()) {
                    this.sessionInfoCache.delete();
                }
                session.setState(SessionInfoWrapper.STATE.VALID);
                final byte[] key = this.getKey();
                final byte[] json = JSonStorage.getMapper().objectToByteArray((Object)new SessionInfoStorable(session));
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        JSonStorage.saveTo((File)MyJDownloaderConnectThread.this.sessionInfoCache, (boolean)false, (byte[])key, (byte[])json);
                    }
                };
                StorageHandler.enqueueWrite((Runnable)run, (String)this.sessionInfoCache.getAbsolutePath(), (boolean)true);
            }
            catch (Throwable e) {
                this.log(e);
            }
        }
    }

    private final byte[] getKey() {
        return HexFormatter.hexToByteArray((String)Hash.getMD5((String)(Hash.getMD5((String)CFG_MYJD.EMAIL.getValue()) + "LOCALECACHE" + Hash.getMD5((String)CFG_MYJD.PASSWORD.getValue()))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSessionInfo() {
        Object object = SESSIONLOCK;
        synchronized (object) {
            try {
                if (!this.sessionInfoCache.exists()) {
                    return;
                }
                SessionInfoStorable sessionInfoStorable = (SessionInfoStorable)JSonStorage.restoreFrom((File)this.sessionInfoCache, (boolean)false, (byte[])this.getKey(), (TypeRef)new TypeRef<SessionInfoStorable>(){}, null);
                if (sessionInfoStorable == null) {
                    return;
                }
                SessionInfoWrapper sessionInfo = sessionInfoStorable._getSessionInfoWrapper();
                if (sessionInfo == null) {
                    return;
                }
                sessionInfo.setState(SessionInfoWrapper.STATE.RECONNECT);
                this.getApi().setSessionInfo(sessionInfo);
            }
            catch (Throwable e) {
                this.log(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SessionInfoWrapper bindDevice(SessionInfoWrapper session, DeviceConnectionHelper connectionHelper) throws MyJDownloaderException, InterruptedException {
        MyJDownloaderAPI lapi = this.getApi();
        if (lapi == null) {
            throw new WTFException("api is null, disconnected?!");
        }
        boolean deviceBound = false;
        try {
            connectionHelper.mark();
            try {
                String uniqueID = this.getUniqueDeviceID();
                DeviceData device = lapi.bindDevice(new DeviceData(uniqueID, "jd", this.getDeviceName()));
                if (StringUtils.isNotEmpty((String)device.getId())) {
                    if (!device.getId().equals(uniqueID)) {
                        this.setUniqueDeviceID(device.getId());
                    }
                    CFG_MYJD.DEVICE_NAME.setValue((Object)device.getName());
                    deviceBound = true;
                }
                SessionInfoWrapper sessionInfoWrapper = session;
                connectionHelper.unmark();
                return sessionInfoWrapper;
            }
            catch (Throwable throwable) {
                connectionHelper.unmark();
                throw throwable;
            }
        }
        finally {
            if (!deviceBound) {
                this.disconnectSession(lapi, session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SessionInfoWrapper ensureValidSession(DeviceConnectionHelper connectionHelper) throws MyJDownloaderException, InterruptedException {
        MyJDownloaderAPI lapi = this.getApi();
        if (lapi == null) {
            throw new WTFException("api is null, disconnected?!");
        }
        SessionInfoWrapper session = null;
        try {
            session = (SessionInfoWrapper)lapi.getSessionInfo();
            if (session != null && SessionInfoWrapper.STATE.VALID.equals((Object)session.getState())) {
                return session;
            }
        }
        catch (UnconnectedException unconnectedException) {
            // empty catch block
        }
        connectionHelper.backoff();
        try {
            connectionHelper.mark();
            try {
                if (session != null && SessionInfoWrapper.STATE.RECONNECT.equals((Object)session.getState())) {
                    session = (SessionInfoWrapper)lapi.reconnect();
                    lapi.keepalive();
                    if (session != null) {
                        SessionInfoWrapper sessionInfoWrapper = this.validateSession(this.bindDevice(session, connectionHelper));
                        return sessionInfoWrapper;
                    }
                }
            }
            finally {
                connectionHelper.unmark();
            }
        }
        catch (UnconnectedException unconnectedException) {
        }
        catch (MyJDownloaderException e) {
            if (session != null) {
                session.setState(SessionInfoWrapper.STATE.INVALID);
            }
            if (!(e instanceof AuthException)) throw e;
            return this.ensureValidSession(connectionHelper);
        }
        connectionHelper.mark();
        try {
            session = (SessionInfoWrapper)lapi.connect(this.getEmail(), this.getPassword());
            SessionInfoWrapper sessionInfoWrapper = this.validateSession(this.bindDevice(session, connectionHelper));
            return sessionInfoWrapper;
        }
        finally {
            connectionHelper.unmark();
        }
    }

    protected String getUniqueDeviceIDSalt() {
        String idSalt = CFG_MYJD.CFG._getStorageHandler().getPath().getAbsolutePath() + CrossSystem.getOS().name() + CrossSystem.getARCHFamily().name() + CrossSystem.is64BitArch() + CrossSystem.is64BitOperatingSystem() + System.getProperty("user.name");
        try {
            if (ContainerRuntime.isInsideDocker()) {
                idSalt = idSalt + ContainerRuntime.getID();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Hash.getSHA256((String)idSalt);
    }

    protected String getUniqueDeviceID() {
        String uuid = CFG_MYJD.CFG.getUniqueDeviceID();
        if (StringUtils.isNotEmpty((String)uuid)) {
            CFG_MYJD.CFG.setUniqueDeviceID(null);
            CFG_MYJD.CFG.setUniqueDeviceIDV2(uuid);
            CFG_MYJD.CFG.setUniqueDeviceIDSaltV2(this.getUniqueDeviceIDSalt());
            return uuid;
        }
        if (this.getUniqueDeviceIDSalt().equals(CFG_MYJD.CFG.getUniqueDeviceIDSaltV2())) {
            return CFG_MYJD.CFG.getUniqueDeviceIDV2();
        }
        return null;
    }

    private void setUniqueDeviceID(String uniqueID) {
        CFG_MYJD.CFG.setUniqueDeviceIDSaltV2(this.getUniqueDeviceIDSalt());
        CFG_MYJD.CFG.setUniqueDeviceIDV2(uniqueID);
        CFG_MYJD.CFG._getStorageHandler().write();
    }

    protected String getDeviceName() {
        String ret = this.deviceName;
        if (StringUtils.isEmpty((String)ret)) {
            return (String)CFG_MYJD.DEVICE_NAME.getDefaultValue();
        }
        return ret;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    protected String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    protected String getEmail() {
        return this.email;
    }

    public MyJDownloaderConnectionStatus getConnectionStatus() {
        return (MyJDownloaderConnectionStatus)((Object)this.connected.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getEstablishedConnections() {
        HashMap<Thread, SocketStreamInterface> hashMap = openConnections;
        synchronized (hashMap) {
            return openConnections.size();
        }
    }

    public boolean isChallengeExchangeEnabled() {
        MyJDownloaderAPI lapi = this.getApi();
        if (lapi != null && this.challengeExchangeEnabled.get()) {
            try {
                SessionInfoWrapper session = (SessionInfoWrapper)lapi.getSessionInfo();
                return SessionInfoWrapper.STATE.VALID.equals((Object)session.getState());
            }
            catch (UnconnectedException unconnectedException) {
                // empty catch block
            }
        }
        return false;
    }

    public MyCaptchaSolution pushChallenge(MyCaptchaChallenge ch) throws MyJDownloaderException {
        block4: {
            MyJDownloaderAPI lapi = this.getApi();
            if (lapi != null) {
                SessionInfoWrapper session = null;
                try {
                    session = (SessionInfoWrapper)lapi.getSessionInfo();
                    if (SessionInfoWrapper.STATE.VALID.equals((Object)session.getState())) {
                        MyJDCaptchasClient<Type> captchaClient = new MyJDCaptchasClient<Type>(lapi);
                        return captchaClient.solve(ch);
                    }
                }
                catch (TokenException e) {
                    if (session == null) break block4;
                    session.compareAndSetState(SessionInfoWrapper.STATE.VALID, SessionInfoWrapper.STATE.RECONNECT);
                }
            }
        }
        return null;
    }

    public MyCaptchaSolution getChallengeResponse(String id) throws MyJDownloaderException {
        block4: {
            MyJDownloaderAPI lapi = this.getApi();
            if (lapi != null) {
                SessionInfoWrapper session = null;
                try {
                    session = (SessionInfoWrapper)lapi.getSessionInfo();
                    if (SessionInfoWrapper.STATE.VALID.equals((Object)session.getState())) {
                        MyJDCaptchasClient<Type> captchaClient = new MyJDCaptchasClient<Type>(lapi);
                        return captchaClient.get(id);
                    }
                }
                catch (TokenException e) {
                    if (session == null) break block4;
                    session.compareAndSetState(SessionInfoWrapper.STATE.VALID, SessionInfoWrapper.STATE.RECONNECT);
                }
            }
        }
        return null;
    }

    public Boolean validateSession(String queryToken) {
        MyJDownloaderAPI lapi = this.getApi();
        if (lapi != null) {
            SessionInfoWrapper session = null;
            try {
                session = (SessionInfoWrapper)lapi.getSessionInfo();
                if (SessionInfoWrapper.STATE.VALID.equals((Object)session.getState())) {
                    SessionInfoResponse ret = lapi.getSessionInfo(queryToken);
                    return ret != null;
                }
            }
            catch (TokenException e) {
                if (session != null) {
                    session.compareAndSetState(SessionInfoWrapper.STATE.VALID, SessionInfoWrapper.STATE.RECONNECT);
                }
            }
            catch (MyJDownloaderException e) {
                this.log(e);
            }
        }
        return null;
    }

    public boolean sendChallengeFeedback(String id, MyCaptchaSolution.RESULT correct) throws MyJDownloaderException {
        block4: {
            MyJDownloaderAPI lapi = this.getApi();
            if (lapi != null) {
                SessionInfoWrapper session = null;
                try {
                    session = (SessionInfoWrapper)lapi.getSessionInfo();
                    if (SessionInfoWrapper.STATE.VALID.equals((Object)session.getState())) {
                        MyJDCaptchasClient<Type> captchaClient = new MyJDCaptchasClient<Type>(lapi);
                        return captchaClient.remove(id, correct);
                    }
                }
                catch (TokenException e) {
                    if (session == null) break block4;
                    session.compareAndSetState(SessionInfoWrapper.STATE.VALID, SessionInfoWrapper.STATE.RECONNECT);
                }
            }
        }
        return false;
    }

    public void terminateSession(SessionInfo session) throws MyJDownloaderException {
        this.terminateSession(session.getSessionToken());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateSession(String sessionToken) throws MyJDownloaderException {
        MyJDownloaderAPI api = this.getApi();
        if (api != null && sessionToken != null) {
            try {
                api.kill(this.getEmail(), this.getPassword(), sessionToken);
            }
            catch (TokenException tokenException) {
                HashMap<String, AtomicLong> hashMap = KNOWNSESSIONS;
                synchronized (hashMap) {
                    KNOWNSESSIONS.put(sessionToken, new AtomicLong(-(System.currentTimeMillis() + 1800000L)));
                }
            }
            finally {
                HashMap<String, AtomicLong> hashMap = KNOWNSESSIONS;
                synchronized (hashMap) {
                    KNOWNSESSIONS.put(sessionToken, new AtomicLong(-(System.currentTimeMillis() + 1800000L)));
                }
            }
        }
    }

    public boolean canHandleChunkedEncoding(HttpRequest request, HttpResponse response) {
        return true;
    }

    @Override
    public void onAfterReconnect(ReconnecterEvent event) {
        if (event != null && Reconnecter.ReconnectResult.SUCCESSFUL.equals((Object)event.getResult()) && this.isEstablishingConnection()) {
            this.startWaitingConnectionThread();
            this.putResponse(null);
        }
    }

    @Override
    public void onBeforeReconnect(ReconnecterEvent event) {
    }

    public static class DeviceConnectionHelper {
        private final AtomicInteger requested = new AtomicInteger(0);
        private final AtomicBoolean backOff = new AtomicBoolean(false);
        private final String host;
        private final int port;
        private volatile InetSocketAddress addr;
        private volatile long retryTimeStamp = -1L;
        private final AtomicInteger mark = new AtomicInteger(0);
        private final MyJDownloaderConnectThread thread;

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public InetSocketAddress getAddr() {
            return this.addr;
        }

        public String toString() {
            return "Addr:" + this.getAddr() + "|Mark:" + this.isMarked();
        }

        protected void refresh() {
            this.addr = new InetSocketAddress(this.host, this.port);
        }

        private DeviceConnectionHelper(MyJDownloaderConnectThread thread, int port, String host) {
            this.thread = thread;
            this.host = host;
            this.port = port;
            this.refresh();
        }

        public void requestbackoff() {
            this.backOff.set(true);
            this.requested.incrementAndGet();
        }

        public boolean isMarked() {
            return this.mark.get() > 0;
        }

        public void requestbackoff(int requested) {
            this.backOff.set(true);
            this.requested.set(Math.max(1, requested));
        }

        public long getRetryTimeStamp() {
            return this.retryTimeStamp;
        }

        public void mark() {
            this.mark.getAndIncrement();
        }

        public void unmark() {
            int mark;
            while ((mark = this.mark.get()) > 0 && !this.mark.compareAndSet(mark, mark - 1)) {
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void backoff() throws InterruptedException {
            if (this.thread.getApi() != null && this.backOff.get()) {
                AtomicBoolean atomicBoolean = this.backOff;
                synchronized (atomicBoolean) {
                    if (this.backOff.get()) {
                        int currentBackOff = this.requested.get();
                        try {
                            long timeout;
                            switch (currentBackOff) {
                                case 0: 
                                case 1: 
                                case 2: {
                                    timeout = 1000L;
                                    break;
                                }
                                case 3: 
                                case 4: {
                                    timeout = 1500L;
                                    break;
                                }
                                case 5: 
                                case 6: {
                                    timeout = 2000L;
                                    break;
                                }
                                case 7: 
                                case 8: {
                                    timeout = 3000L;
                                    break;
                                }
                                case 9: 
                                case 10: {
                                    timeout = 5000L;
                                    break;
                                }
                                case 11: 
                                case 12: {
                                    timeout = 10000L;
                                    break;
                                }
                                case 13: 
                                case 14: {
                                    timeout = 15000L;
                                    break;
                                }
                                default: {
                                    timeout = 20000L;
                                }
                            }
                            this.thread.log("Error #:" + currentBackOff + " next retry: " + timeout);
                            this.retryTimeStamp = System.currentTimeMillis() + timeout;
                            Thread.sleep(timeout);
                            if (currentBackOff > 10) {
                                this.refresh();
                            }
                        }
                        finally {
                            this.retryTimeStamp = -1L;
                            this.requested.compareAndSet(currentBackOff, currentBackOff + 1);
                            this.backOff.compareAndSet(true, false);
                        }
                    }
                }
            }
        }

        public boolean backoffrequested() {
            return this.backOff.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            AtomicBoolean atomicBoolean = this.backOff;
            synchronized (atomicBoolean) {
                this.requested.set(0);
                this.backOff.set(false);
            }
        }
    }

    public static class SessionInfoWrapper
    extends SessionInfo {
        private volatile NullsafeAtomicReference<STATE> state = new NullsafeAtomicReference((Object)STATE.RECONNECT);

        public SessionInfoWrapper(byte[] deviceSecret, byte[] serverEncryptionToken, byte[] deviceEncryptionToken, String sessionToken, String regainToken) {
            super(deviceSecret, serverEncryptionToken, deviceEncryptionToken, sessionToken, regainToken);
        }

        public final STATE getState() {
            return (STATE)((Object)this.state.get());
        }

        public final void setState(STATE set) {
            this.state.set((Object)set);
        }

        public final boolean compareAndSetState(STATE expect, STATE set) {
            return this.state.compareAndSet((Object)expect, (Object)set);
        }

        public static enum STATE {
            VALID,
            INVALID,
            RECONNECT;

        }
    }
}

