/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.myjdownloader;

import java.util.EventListener;
import java.util.concurrent.atomic.AtomicBoolean;
import org.appwork.console.AbstractConsole;
import org.appwork.console.ConsoleDialog;
import org.appwork.shutdown.ExceptionShutdownRequest;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownRequest;
import org.appwork.shutdown.ShutdownVetoException;
import org.appwork.shutdown.ShutdownVetoListener;
import org.appwork.storage.config.JsonConfig;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.uio.UIOManager;
import org.appwork.utils.Application;
import org.appwork.utils.NullsafeAtomicReference;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.event.DefaultEvent;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.swing.dialog.DialogNoAnswerException;
import org.jdownloader.api.RemoteAPIConfig;
import org.jdownloader.api.myjdownloader.MyJDownloaderConnectThread;
import org.jdownloader.api.myjdownloader.MyJDownloaderConnectionStatus;
import org.jdownloader.api.myjdownloader.MyJDownloaderSettings;
import org.jdownloader.api.myjdownloader.api.MyJDownloaderAPI;
import org.jdownloader.api.myjdownloader.event.MyJDownloaderEvent;
import org.jdownloader.api.myjdownloader.event.MyJDownloaderEventSender;
import org.jdownloader.logging.LogController;
import org.jdownloader.myjdownloader.client.exceptions.MyJDownloaderException;
import org.jdownloader.myjdownloader.client.exceptions.UnconnectedException;
import org.jdownloader.myjdownloader.client.json.MyCaptchaChallenge;
import org.jdownloader.myjdownloader.client.json.MyCaptchaSolution;
import org.jdownloader.settings.staticreferences.CFG_MYJD;
import org.jdownloader.translate._JDT;

public class MyJDownloaderController
implements ShutdownVetoListener,
GenericConfigEventListener<Boolean> {
    private static final MyJDownloaderController INSTANCE = new MyJDownloaderController();
    private final NullsafeAtomicReference<MyJDownloaderConnectThread> thread = new NullsafeAtomicReference(null);
    private final LogSource logger = LogController.getInstance().getLogger(MyJDownloaderController.class.getName());
    private final MyJDownloaderEventSender eventSender = new MyJDownloaderEventSender();

    public static MyJDownloaderController getInstance() {
        return INSTANCE;
    }

    public MyJDownloaderEventSender getEventSender() {
        return this.eventSender;
    }

    public boolean isConnected() {
        MyJDownloaderConnectThread lThread = this.getConnectThread();
        return lThread != null && lThread.isAlive() && lThread.isConnected();
    }

    public boolean isActive() {
        MyJDownloaderConnectThread lThread = this.getConnectThread();
        return lThread != null && lThread.isAlive();
    }

    public MyJDownloaderConnectionStatus getConnectionStatus() {
        MyJDownloaderConnectThread lThread = this.getConnectThread();
        if (lThread != null) {
            return lThread.getConnectionStatus();
        }
        return MyJDownloaderConnectionStatus.UNCONNECTED;
    }

    public long getRetryTimeStamp() {
        MyJDownloaderConnectThread lThread = this.getConnectThread();
        if (lThread != null) {
            return lThread.getRetryTimeStamp();
        }
        return -1L;
    }

    public int getEstablishedConnections() {
        MyJDownloaderConnectThread lThread = this.getConnectThread();
        if (lThread != null) {
            return lThread.getEstablishedConnections();
        }
        return 0;
    }

    protected void stop() {
        final MyJDownloaderConnectThread lThread = (MyJDownloaderConnectThread)this.thread.getAndSet(null);
        if (lThread != null) {
            ShutdownController.getInstance().removeShutdownVetoListener((ShutdownVetoListener)this);
            new Thread("MyJDownloaderController:Stop:" + lThread){
                {
                    super(x0);
                    this.setDaemon(true);
                }

                @Override
                public void run() {
                    lThread.disconnect();
                }
            }.start();
        }
    }

    public final boolean isAlwaysConnectRequired() {
        RemoteAPIConfig remoteAPIConfig = (RemoteAPIConfig)JsonConfig.create(RemoteAPIConfig.class);
        return Application.isHeadless() && (remoteAPIConfig.isHeadlessMyJDownloaderMandatory() || !remoteAPIConfig.isDeprecatedApiEnabled());
    }

    private MyJDownloaderController() {
        if (this.isAlwaysConnectRequired() || CFG_MYJD.AUTO_CONNECT_ENABLED.isEnabled()) {
            this.start();
        }
        CFG_MYJD.AUTO_CONNECT_ENABLED.getEventSender().addListener((EventListener)((Object)this));
    }

    protected void start() {
        this.stop();
        String email = CFG_MYJD.CFG.getEmail();
        String password = CFG_MYJD.CFG.getPassword();
        boolean validFlag = this.validateAndVerifyLogins(email, password, this.isAlwaysConnectRequired());
        if (!validFlag && this.isAlwaysConnectRequired()) {
            while (true) {
                try {
                    while (!this.askLoginsOnConsole(true)) {
                    }
                    email = CFG_MYJD.CFG.getEmail();
                    password = CFG_MYJD.CFG.getPassword();
                    validFlag = true;
                }
                catch (DialogNoAnswerException e) {
                    ShutdownController.getInstance().requestShutdown((ShutdownRequest)new ExceptionShutdownRequest((Throwable)e, false, false));
                    continue;
                }
                break;
            }
        }
        if (validFlag || this.validateAndVerifyLogins(email, password, false)) {
            MyJDownloaderConnectThread lthread = new MyJDownloaderConnectThread(this);
            lthread.setEmail(email);
            lthread.setPassword(password);
            lthread.setDeviceName(CFG_MYJD.CFG.getDeviceName());
            if (this.thread.compareAndSet(null, (Object)lthread)) {
                ShutdownController.getInstance().addShutdownVetoListener((ShutdownVetoListener)this);
                lthread.start();
            }
        }
    }

    public String getCurrentDeviceName() {
        MyJDownloaderConnectThread th = this.getConnectThread();
        if (th == null || !th.isAlive() || !th.isConnected()) {
            return null;
        }
        return th.getDeviceName();
    }

    public String getCurrentEmail() {
        MyJDownloaderConnectThread th = this.getConnectThread();
        if (th == null || !th.isAlive() || !th.isConnected()) {
            return null;
        }
        return th.getEmail();
    }

    public String getCurrentPassword() {
        MyJDownloaderConnectThread th = this.getConnectThread();
        if (th == null || !th.isAlive() || !th.isConnected()) {
            return null;
        }
        return th.getPassword();
    }

    public MyJDownloaderConnectThread getConnectThread() {
        return (MyJDownloaderConnectThread)this.thread.get();
    }

    public void onShutdown(ShutdownRequest request) {
        try {
            this.stop();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void onShutdownVeto(ShutdownRequest request) {
    }

    public void onShutdownVetoRequest(ShutdownRequest request) throws ShutdownVetoException {
    }

    public long getShutdownVetoPriority() {
        return 0L;
    }

    public LogSource getLogger() {
        return this.logger;
    }

    public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
    }

    public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean newValue) {
        if (this.isAlwaysConnectRequired() || CFG_MYJD.AUTO_CONNECT_ENABLED.isEnabled()) {
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onError(MyJDownloaderSettings.MyJDownloaderError error) {
        if (error == null) {
            error = MyJDownloaderSettings.MyJDownloaderError.NONE;
        }
        CFG_MYJD.CFG.setLatestError(error);
        switch (error) {
            case ACCOUNT_UNCONFIRMED: {
                this.stop();
                if (!this.isAlwaysConnectRequired()) {
                    UIOManager.I().showConfirmDialog(16, "MyJDownloader", _JDT.T.MyJDownloaderController_onError_account_unconfirmed());
                    return;
                }
                Object object = AbstractConsole.LOCK;
                synchronized (object) {
                    ConsoleDialog cd = new ConsoleDialog("MyJDownloader");
                    cd.start();
                    try {
                        cd.printLines(_JDT.T.MyJDownloaderController_onError_account_unconfirmed());
                        cd.waitToContinue();
                        ShutdownController.getInstance().requestShutdown();
                    }
                    finally {
                        cd.end();
                    }
                    return;
                }
            }
            case OUTDATED: {
                this.stop();
                if (!this.isAlwaysConnectRequired()) {
                    UIOManager.I().showConfirmDialog(16, "MyJDownloader", _JDT.T.MyJDownloaderController_onError_outdated());
                    return;
                }
                Object object = AbstractConsole.LOCK;
                synchronized (object) {
                    ConsoleDialog cd = new ConsoleDialog("MyJDownloader");
                    cd.start();
                    try {
                        cd.printLines(_JDT.T.MyJDownloaderController_onError_outdated());
                        cd.waitToContinue();
                        ShutdownController.getInstance().requestShutdown();
                    }
                    finally {
                        cd.end();
                    }
                    return;
                }
            }
            case EMAIL_INVALID: 
            case BAD_LOGINS: {
                this.stop();
                if (this.isAlwaysConnectRequired()) {
                    this.start();
                    return;
                }
                UIOManager.I().showConfirmDialog(16, "MyJDownloader", _JDT.T.MyJDownloaderController_onError_badlogins());
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean askLoginsOnConsole(boolean verifyLogins) throws DialogNoAnswerException {
        Object object = AbstractConsole.LOCK;
        synchronized (object) {
            ConsoleDialog cd = new ConsoleDialog("MyJDownloader");
            cd.start();
            try {
                String password;
                cd.printLines(_JDT.T.MyJDownloaderController_onError_badlogins());
                cd.waitYesOrNo(0, "Enter Logins", "Exit JDownloader");
                String email = cd.ask("Please Enter your MyJDownloader Email:");
                if (new Regex(email, "..*?@.*?\\..+").matches() && this.validateAndVerifyLogins(email, password = cd.askHidden("Please Enter your MyJDownloader Password(not visible):"), verifyLogins)) {
                    CFG_MYJD.EMAIL.setValue((Object)email.trim());
                    CFG_MYJD.PASSWORD.setValue((Object)password);
                    boolean bl = true;
                    return bl;
                }
                cd.println("Invalid Logins");
                boolean bl = false;
                return bl;
            }
            finally {
                cd.end();
            }
        }
    }

    public void fireConnectionStatusChanged(MyJDownloaderConnectionStatus status, int connections) {
        switch (status) {
            case CONNECTED: 
            case PENDING: {
                CFG_MYJD.CFG.setLatestError(MyJDownloaderSettings.MyJDownloaderError.NONE);
                break;
            }
        }
        this.eventSender.fireEvent((DefaultEvent)new MyJDownloaderEvent(this, MyJDownloaderEvent.Type.CONNECTION_STATUS_UPDATE, new Object[]{status, connections}));
    }

    public void disconnect() {
        this.stop();
    }

    public void connect() {
        this.start();
    }

    public boolean validateAndVerifyLogins(final String email, final String password, boolean verifyLogins) {
        if (StringUtils.isEmpty((String)password) || StringUtils.isEmpty((String)email) || !new Regex(email, "..*?@.*?\\..+").matches()) {
            return false;
        }
        if (!verifyLogins) {
            return true;
        }
        final AtomicBoolean validFlag = new AtomicBoolean(false);
        final MyJDownloaderAPI api = new MyJDownloaderAPI(){

            @Override
            public LogSource getLogger() {
                return MyJDownloaderController.this.getLogger();
            }
        };
        Thread validateThread = new Thread("validateLogins"){

            @Override
            public void run() {
                try {
                    api.connect(email, password);
                    validFlag.set(true);
                    api.disconnect();
                }
                catch (Exception e) {
                    api.getLogger().log((Throwable)e);
                }
            }
        };
        validateThread.setDaemon(true);
        validateThread.start();
        try {
            validateThread.join();
        }
        catch (InterruptedException e) {
            api.getLogger().log((Throwable)e);
        }
        return validFlag.get();
    }

    public boolean isLoginValid(boolean verifyLogin) {
        return this.validateAndVerifyLogins(CFG_MYJD.CFG.getEmail(), CFG_MYJD.CFG.getPassword(), verifyLogin);
    }

    public void pushCaptchaFlag(boolean captchasPending) {
        MyJDownloaderConnectThread th;
        if (this.isConnected() && (th = this.getConnectThread()) != null) {
            th.pushCaptchaNotification(captchasPending);
        }
    }

    public MyCaptchaSolution pushChallenge(MyCaptchaChallenge ch) throws MyJDownloaderException {
        MyJDownloaderConnectThread th = this.getConnectThread();
        if (th == null) {
            throw new UnconnectedException();
        }
        if (th.isAlive()) {
            switch (th.getConnectionStatus()) {
                case CONNECTED: 
                case PENDING: {
                    return th.pushChallenge(ch);
                }
            }
            return null;
        }
        return null;
    }

    public boolean isRemoteCaptchaServiceEnabled() {
        MyJDownloaderConnectThread th = this.getConnectThread();
        return th != null && th.isChallengeExchangeEnabled();
    }

    public MyCaptchaSolution getChallengeResponse(String id) throws MyJDownloaderException {
        MyJDownloaderConnectThread th = this.getConnectThread();
        if (th == null) {
            throw new UnconnectedException();
        }
        if (th.isAlive()) {
            switch (th.getConnectionStatus()) {
                case CONNECTED: 
                case PENDING: {
                    return th.getChallengeResponse(id);
                }
            }
            return null;
        }
        return null;
    }

    public boolean isSessionValid(String sessionToken) {
        MyJDownloaderConnectThread ct = this.getConnectThread();
        return ct != null && ct.isSessionValid(sessionToken);
    }

    public boolean sendChallengeFeedback(String id, MyCaptchaSolution.RESULT correct) throws MyJDownloaderException {
        MyJDownloaderConnectThread th = this.getConnectThread();
        if (th == null) {
            throw new UnconnectedException();
        }
        if (th.isAlive()) {
            switch (th.getConnectionStatus()) {
                case CONNECTED: 
                case PENDING: {
                    return th.sendChallengeFeedback(id, correct);
                }
            }
            return false;
        }
        return false;
    }

    public void terminateSession(String connectToken) throws MyJDownloaderException {
        MyJDownloaderConnectThread ct = this.getConnectThread();
        if (ct != null) {
            ct.terminateSession(connectToken);
        }
    }
}

