/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.myjdownloader;

import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.utils.net.Base64InputStream;
import org.appwork.utils.net.CharSequenceInputStream;
import org.appwork.utils.net.httpserver.HttpConnection;
import org.appwork.utils.net.httpserver.RawHttpConnectionInterface;
import org.appwork.utils.net.httpserver.requests.GetRequest;
import org.appwork.utils.net.httpserver.requests.KeyValuePair;
import org.jdownloader.api.myjdownloader.MyJDownloaderHttpConnection;
import org.jdownloader.api.myjdownloader.MyJDownloaderRequestInterface;
import org.jdownloader.myjdownloader.client.json.JSonRequest;

public class MyJDownloaderGetRequest
extends GetRequest
implements MyJDownloaderRequestInterface {
    public static final String API_VERSION = "apiVer";
    public static final String RID = "rid";
    public static final String SIGNATURE = "signature";
    public static final String CALLBACK = "callback";
    public static final String DIFF_KEEPALIVE = "diffKA";
    public static final String DIFF_ID = "diffID";
    private JSonRequest jsonRequest = null;
    private GetData requestProperties = GetData.EMPTY;

    public String toString() {
        if (this.jsonRequest == null) {
            return "Non JSonRequest\r\n" + super.toString();
        }
        return "RID: " + this.jsonRequest.getRid() + "\r\nAPIVersion: " + this.jsonRequest.getApiVer() + "\r\n" + super.toString();
    }

    public static GetData parseGetData(List<KeyValuePair> requestedURLParameters) {
        GetData ret = new GetData();
        if (requestedURLParameters != null) {
            for (KeyValuePair param : requestedURLParameters) {
                if (param.key == null) continue;
                if (CALLBACK.equalsIgnoreCase(param.key)) {
                    ret.callback = param.value;
                    continue;
                }
                if (SIGNATURE.equalsIgnoreCase(param.key)) {
                    ret.signature = param.value;
                    continue;
                }
                if (RID.equalsIgnoreCase(param.key)) {
                    ret.rid = Long.parseLong(param.value);
                    continue;
                }
                if (API_VERSION.equalsIgnoreCase(param.key)) {
                    ret.apiVersion = Integer.parseInt(param.value);
                    continue;
                }
                if (DIFF_KEEPALIVE.equalsIgnoreCase(param.key)) {
                    ret.diffKeepalive = Long.parseLong(param.value);
                    continue;
                }
                if (!DIFF_ID.equalsIgnoreCase(param.key)) continue;
                ret.diffID = param.value;
            }
        }
        return ret;
    }

    public MyJDownloaderGetRequest(HttpConnection connection) {
        super((RawHttpConnectionInterface)connection);
    }

    @Override
    public String getRequestConnectToken() {
        return this.getConnection().getRequestConnectToken();
    }

    @Override
    public MyJDownloaderHttpConnection getConnection() {
        return (MyJDownloaderHttpConnection)super.getConnection();
    }

    public void setRequestedURLParameters(List<KeyValuePair> requestedURLParameters) {
        super.setRequestedURLParameters(requestedURLParameters);
        this.requestProperties = MyJDownloaderGetRequest.parseGetData(requestedURLParameters);
        try {
            this.jsonRequest = this.parseJSonRequest(requestedURLParameters);
            if (this.jsonRequest != null) {
                ArrayList<KeyValuePair> parameters = new ArrayList<KeyValuePair>();
                if (this.jsonRequest.getParams() != null) {
                    for (Object param : this.jsonRequest.getParams()) {
                        if (param == null) {
                            parameters.add(new KeyValuePair("null"));
                            continue;
                        }
                        parameters.add(new KeyValuePair(JSonStorage.toString((Object)param)));
                    }
                }
                super.setRequestedURLParameters(parameters);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected JSonRequest parseJSonRequest(List<KeyValuePair> requestedURLParameters) throws IOException {
        if (requestedURLParameters != null && requestedURLParameters.size() >= 1 && "b64aesjson".equalsIgnoreCase(requestedURLParameters.get((int)0).key)) {
            try {
                IvParameterSpec ivSpec = new IvParameterSpec(this.getConnection().getIv());
                SecretKeySpec skeySpec = new SecretKeySpec(this.getConnection().getKey(), "AES");
                Cipher aesCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
                aesCipher.init(2, (Key)skeySpec, ivSpec);
                String value = requestedURLParameters.get((int)0).value;
                return (JSonRequest)JSonStorage.getMapper().inputStreamToObject((InputStream)new CipherInputStream((InputStream)new Base64InputStream((InputStream)new CharSequenceInputStream((CharSequence)value, MyJDownloaderHttpConnection.UTF8)), aesCipher), (TypeRef)new TypeRef<JSonRequest>(){});
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return null;
    }

    @Override
    public int getApiVersion() {
        if (this.requestProperties.apiVersion >= 0) {
            return this.requestProperties.apiVersion;
        }
        try {
            JSonRequest jsonr = this.getJsonRequest();
            if (jsonr != null) {
                return jsonr.getApiVer();
            }
            return -1;
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Override
    public long getRid() throws IOException {
        if (this.requestProperties.rid >= 0L) {
            return this.requestProperties.rid;
        }
        JSonRequest jsonr = this.getJsonRequest();
        if (jsonr != null) {
            return jsonr.getRid();
        }
        return -1L;
    }

    @Override
    public String getSignature() {
        return this.requestProperties.signature;
    }

    @Override
    public String getJqueryCallback() {
        return this.requestProperties.callback;
    }

    @Override
    public long getDiffKeepAlive() throws IOException {
        if (this.requestProperties.diffKeepalive >= 0L) {
            return this.requestProperties.diffKeepalive;
        }
        JSonRequest jsonr = this.getJsonRequest();
        if (jsonr != null) {
            return jsonr.getDiffKA();
        }
        return 0L;
    }

    @Override
    public String getDiffID() throws IOException {
        if (this.requestProperties.diffID != null) {
            return this.requestProperties.diffID;
        }
        JSonRequest jsonr = this.getJsonRequest();
        if (jsonr != null) {
            return jsonr.getDiffID();
        }
        return null;
    }

    public JSonRequest getJsonRequest() throws IOException {
        return this.jsonRequest;
    }

    @Override
    public String getDiffType() throws IOException {
        if (this.requestProperties.diffType != null) {
            return this.requestProperties.diffType;
        }
        JSonRequest jsonr = this.getJsonRequest();
        if (jsonr != null) {
            return jsonr.getDiffType();
        }
        return null;
    }

    public static class GetData {
        public static final GetData EMPTY = new GetData();
        public long rid = -1L;
        public int apiVersion = -1;
        public String signature = null;
        public String callback = null;
        public long diffKeepalive = -1L;
        public String diffID = null;
        public String diffType = null;
    }
}

